#!/bin/sh

set -e

DEB_VERSION=$(dpkg-parsechangelog -SVersion)
DEB_VERSION_EPOCH_UPSTREAM=$(echo "$DEB_VERSION" | sed -e 's/-[^-]*$//')
DEB_VERSION_UPSTREAM=$(echo "$DEB_VERSION_EPOCH_UPSTREAM" | sed -e 's/^[0-9]*://')

VERSION="$DEB_VERSION_UPSTREAM"
URL="https://github.com/Genymobile/scrcpy/releases/download/v$VERSION/scrcpy-server-v$VERSION"
TIMEOUT=10
MAXTIME=30

FILENAME=scrcpy-server-v$VERSION

curl --connect-timeout "$TIMEOUT" --max-time "$MAXTIME" -L -o "$FILENAME" "$URL"
file "$FILENAME"

SHA256="$(sha256sum "$FILENAME" | cut -d' ' -f1)"

echo "$SHA256"

sed -i "s/VERSION=.*$/VERSION=$VERSION/
s/SHA256=.*$/SHA256=$SHA256/" debian/scrcpy-update-server
