# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.domain import Domain
from twilio.rest.conversations.v1 import V1


class Conversations(Domain):

    def __init__(self, twilio):
        """
        Initialize the Conversations Domain

        :returns: Domain for Conversations
        :rtype: twilio.rest.conversations.Conversations
        """
        super(Conversations, self).__init__(twilio)

        self.base_url = 'https://conversations.twilio.com'

        # Versions
        self._v1 = None

    @property
    def v1(self):
        """
        :returns: Version v1 of conversations
        :rtype: twilio.rest.conversations.v1.V1
        """
        if self._v1 is None:
            self._v1 = V1(self)
        return self._v1

    @property
    def configuration(self):
        """
        :rtype: twilio.rest.conversations.v1.configuration.ConfigurationList
        """
        return self.v1.configuration

    @property
    def conversations(self):
        """
        :rtype: twilio.rest.conversations.v1.conversation.ConversationList
        """
        return self.v1.conversations

    @property
    def credentials(self):
        """
        :rtype: twilio.rest.conversations.v1.credential.CredentialList
        """
        return self.v1.credentials

    @property
    def participant_conversations(self):
        """
        :rtype: twilio.rest.conversations.v1.participant_conversation.ParticipantConversationList
        """
        return self.v1.participant_conversations

    @property
    def roles(self):
        """
        :rtype: twilio.rest.conversations.v1.role.RoleList
        """
        return self.v1.roles

    @property
    def services(self):
        """
        :rtype: twilio.rest.conversations.v1.service.ServiceList
        """
        return self.v1.services

    @property
    def users(self):
        """
        :rtype: twilio.rest.conversations.v1.user.UserList
        """
        return self.v1.users

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Conversations>'
