# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class Address(_Model):
    """Address details.

    :ivar address_line1: Address line 1. Required.
    :vartype address_line1: str
    :ivar address_line2: Address line 2.
    :vartype address_line2: str
    :ivar city: Name of the city. Required.
    :vartype city: str
    :ivar state: State (if any). Required.
    :vartype state: str
    :ivar country: Name of the country. Required.
    :vartype country: str
    :ivar postal_code: Postal code. Required.
    :vartype postal_code: str
    """

    address_line1: str = rest_field(name="addressLine1", visibility=["read", "create", "update", "delete", "query"])
    """Address line 1. Required."""
    address_line2: Optional[str] = rest_field(
        name="addressLine2", visibility=["read", "create", "update", "delete", "query"]
    )
    """Address line 2."""
    city: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the city. Required."""
    state: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """State (if any). Required."""
    country: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the country. Required."""
    postal_code: str = rest_field(name="postalCode", visibility=["read", "create", "update", "delete", "query"])
    """Postal code. Required."""

    @overload
    def __init__(
        self,
        *,
        address_line1: str,
        city: str,
        state: str,
        country: str,
        postal_code: str,
        address_line2: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Alert(_Model):
    """Health alerts.

    :ivar level: Severity level. Required. Known values are: "info", "warning", and "error".
    :vartype level: str or ~azure.mgmt.purestorageblock.models.AlertLevel
    :ivar message: A short description of the alert. Required.
    :vartype message: str
    """

    level: Union[str, "_models.AlertLevel"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Severity level. Required. Known values are: \"info\", \"warning\", and \"error\"."""
    message: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A short description of the alert. Required."""

    @overload
    def __init__(
        self,
        *,
        level: Union[str, "_models.AlertLevel"],
        message: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AvsConnection(_Model):
    """Transient information about an on-going connection to an AVS instance.

    :ivar service_initialization_completed: Indicates whether service initialization is complete.
     Required.
    :vartype service_initialization_completed: bool
    :ivar service_initialization_handle_enc: Encoded service account credentials alongside
     connection information.
    :vartype service_initialization_handle_enc: str
    :ivar service_initialization_handle: Explicit service account credentials.
    :vartype service_initialization_handle:
     ~azure.mgmt.purestorageblock.models.ServiceInitializationHandle
    """

    service_initialization_completed: bool = rest_field(
        name="serviceInitializationCompleted", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether service initialization is complete. Required."""
    service_initialization_handle_enc: Optional[str] = rest_field(
        name="serviceInitializationHandleEnc", visibility=["read", "create", "update", "delete", "query"]
    )
    """Encoded service account credentials alongside connection information."""
    service_initialization_handle: Optional["_models.ServiceInitializationHandle"] = rest_field(
        name="serviceInitializationHandle", visibility=["read", "create", "update", "delete", "query"]
    )
    """Explicit service account credentials."""

    @overload
    def __init__(
        self,
        *,
        service_initialization_completed: bool,
        service_initialization_handle_enc: Optional[str] = None,
        service_initialization_handle: Optional["_models.ServiceInitializationHandle"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AvsDiskDetails(_Model):
    """AVS disk/volume information.

    :ivar disk_id: VMware ID of the disk/volume. Required.
    :vartype disk_id: str
    :ivar disk_name: VMware name of the disk/volume. Required.
    :vartype disk_name: str
    :ivar folder: Name of the top-level folder in the datastore that contains the disk/volume.
     Required.
    :vartype folder: str
    :ivar avs_vm_internal_id: VMware ID assigned to the disk/volume. Required.
    :vartype avs_vm_internal_id: str
    :ivar avs_vm_resource_id: Azure resource ID of the AVS VM connected to this disk/volume.
     Required.
    :vartype avs_vm_resource_id: str
    :ivar avs_vm_name: Name of the AVS VM connected to this disk/volume. Required.
    :vartype avs_vm_name: str
    :ivar avs_storage_container_resource_id: Azure resource ID of the AVS storage container
     containing this disk/volume. Required.
    :vartype avs_storage_container_resource_id: str
    """

    disk_id: str = rest_field(name="diskId", visibility=["read", "create", "update", "delete", "query"])
    """VMware ID of the disk/volume. Required."""
    disk_name: str = rest_field(name="diskName", visibility=["read", "create", "update", "delete", "query"])
    """VMware name of the disk/volume. Required."""
    folder: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the top-level folder in the datastore that contains the disk/volume. Required."""
    avs_vm_internal_id: str = rest_field(
        name="avsVmInternalId", visibility=["read", "create", "update", "delete", "query"]
    )
    """VMware ID assigned to the disk/volume. Required."""
    avs_vm_resource_id: str = rest_field(
        name="avsVmResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure resource ID of the AVS VM connected to this disk/volume. Required."""
    avs_vm_name: str = rest_field(name="avsVmName", visibility=["read", "create", "update", "delete", "query"])
    """Name of the AVS VM connected to this disk/volume. Required."""
    avs_storage_container_resource_id: str = rest_field(
        name="avsStorageContainerResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure resource ID of the AVS storage container containing this disk/volume. Required."""

    @overload
    def __init__(
        self,
        *,
        disk_id: str,
        disk_name: str,
        folder: str,
        avs_vm_internal_id: str,
        avs_vm_resource_id: str,
        avs_vm_name: str,
        avs_storage_container_resource_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AvsStatus(_Model):
    """Status of storage pool / AVS connection.

    :ivar avs_enabled: If true, an AVS connection has been successfully completed. Required.
    :vartype avs_enabled: bool
    :ivar current_connection_status: Human-readable current AVS connection status. Required.
    :vartype current_connection_status: str
    :ivar cluster_resource_id: Azure resource ID of the AVS SDDC the pool is connected to.
    :vartype cluster_resource_id: str
    """

    avs_enabled: bool = rest_field(name="avsEnabled", visibility=["read", "create", "update", "delete", "query"])
    """If true, an AVS connection has been successfully completed. Required."""
    current_connection_status: str = rest_field(
        name="currentConnectionStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """Human-readable current AVS connection status. Required."""
    cluster_resource_id: Optional[str] = rest_field(
        name="sddcResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure resource ID of the AVS SDDC the pool is connected to."""

    @overload
    def __init__(
        self,
        *,
        avs_enabled: bool,
        current_connection_status: str,
        cluster_resource_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.purestorageblock.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.purestorageblock.models.SystemData
    """


class AvsStorageContainer(ProxyResource):
    """AVS storage container resource type, representing a VMware storage container in a storage pool,
    which can be associated to and mounted as a datastore.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.purestorageblock.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.purestorageblock.models.AvsStorageContainerProperties
    """

    properties: Optional["_models.AvsStorageContainerProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.AvsStorageContainerProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AvsStorageContainerProperties(_Model):
    """AVS storage container properties.

    :ivar space: Storage space usage.
    :vartype space: ~azure.mgmt.purestorageblock.models.Space
    :ivar resource_name: Name of the storage container. Required.
    :vartype resource_name: str
    :ivar provisioned_limit: Maximum amount of bytes that can be provisioned in this storage
     container; it must be a multiple of 512; each time a volume is provisioned in this container,
     its provisionedSize will be counted against the provisionLimit and the provisioning will fail
     if it goes over (minimum: 1048576 (1MiB), maximum: 4503599627370496 (4PiB)); by default it is
     unrestricted.
    :vartype provisioned_limit: int
    :ivar datastore: VMware datastore associated with this storage container (if any).
    :vartype datastore: str
    :ivar mounted: Whether the datastore is mounted in VMware or not.
    :vartype mounted: bool
    """

    space: Optional["_models.Space"] = rest_field(visibility=["read"])
    """Storage space usage."""
    resource_name: str = rest_field(name="resourceName", visibility=["read"])
    """Name of the storage container. Required."""
    provisioned_limit: Optional[int] = rest_field(name="provisionedLimit", visibility=["read", "create", "update"])
    """Maximum amount of bytes that can be provisioned in this storage container; it must be a
     multiple of 512; each time a volume is provisioned in this container, its provisionedSize will
     be counted against the provisionLimit and the provisioning will fail if it goes over (minimum:
     1048576 (1MiB), maximum: 4503599627370496 (4PiB)); by default it is unrestricted."""
    datastore: Optional[str] = rest_field(visibility=["read"])
    """VMware datastore associated with this storage container (if any)."""
    mounted: Optional[bool] = rest_field(visibility=["read"])
    """Whether the datastore is mounted in VMware or not."""

    @overload
    def __init__(
        self,
        *,
        provisioned_limit: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AvsStorageContainerVolume(ProxyResource):
    """A volume contained in an AVS storage container.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.purestorageblock.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.purestorageblock.models.VolumeProperties
    """

    properties: Optional["_models.VolumeProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.VolumeProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AvsStorageContainerVolumeUpdate(_Model):
    """The type used for update operations of the AvsStorageContainerVolume.

    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.purestorageblock.models.AvsStorageContainerVolumeUpdateProperties
    """

    properties: Optional["_models.AvsStorageContainerVolumeUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.AvsStorageContainerVolumeUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AvsStorageContainerVolumeUpdateProperties(_Model):  # pylint: disable=name-too-long
    """The updatable properties of the AvsStorageContainerVolume.

    :ivar soft_deletion: Volume's soft-deletion state.
    :vartype soft_deletion: ~azure.mgmt.purestorageblock.models.SoftDeletion
    """

    soft_deletion: Optional["_models.SoftDeletion"] = rest_field(name="softDeletion", visibility=["read", "update"])
    """Volume's soft-deletion state."""

    @overload
    def __init__(
        self,
        *,
        soft_deletion: Optional["_models.SoftDeletion"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AvsVm(ProxyResource):
    """AVS VM resource type, representing all the volumes associated to an AVS VM as defined by
    VMware.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.purestorageblock.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.purestorageblock.models.AvsVmProperties
    """

    properties: Optional["_models.AvsVmProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.AvsVmProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AvsVmDetails(_Model):
    """AVS VM details.

    :ivar vm_id: ID of the AVS VM using this set of volumes. Required.
    :vartype vm_id: str
    :ivar vm_name: Name of the VMware VM using this set of volumes. Required.
    :vartype vm_name: str
    :ivar vm_type: Type of the VMware VM using this set of volumes. Required. "vvol"
    :vartype vm_type: str or ~azure.mgmt.purestorageblock.models.VmType
    :ivar avs_vm_internal_id: Pure Storage's internal ID for this AVS VM. Required.
    :vartype avs_vm_internal_id: str
    """

    vm_id: str = rest_field(name="vmId", visibility=["read", "create", "update", "delete", "query"])
    """ID of the AVS VM using this set of volumes. Required."""
    vm_name: str = rest_field(name="vmName", visibility=["read", "create", "update", "delete", "query"])
    """Name of the VMware VM using this set of volumes. Required."""
    vm_type: Union[str, "_models.VmType"] = rest_field(
        name="vmType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of the VMware VM using this set of volumes. Required. \"vvol\""""
    avs_vm_internal_id: str = rest_field(
        name="avsVmInternalId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Pure Storage's internal ID for this AVS VM. Required."""

    @overload
    def __init__(
        self,
        *,
        vm_id: str,
        vm_name: str,
        vm_type: Union[str, "_models.VmType"],
        avs_vm_internal_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AvsVmProperties(_Model):
    """AVS VM properties.

    :ivar storage_pool_internal_id: Pure Storage's internal ID for the storage pool.
    :vartype storage_pool_internal_id: str
    :ivar storage_pool_resource_id: Azure resource ID of the storage pool.
    :vartype storage_pool_resource_id: str
    :ivar display_name: Human-readable name of the AVS VM.
    :vartype display_name: str
    :ivar created_timestamp: Date at which the AVS VM was created, as an RFC 3339 timestamp.
    :vartype created_timestamp: str
    :ivar soft_deletion: AVS VM's soft-deletion state.
    :vartype soft_deletion: ~azure.mgmt.purestorageblock.models.SoftDeletion
    :ivar volume_container_type: Specify which control plane handles the lifecycle of the volume
     container. "avs"
    :vartype volume_container_type: str or ~azure.mgmt.purestorageblock.models.VolumeContainerType
    :ivar avs: AVS VM details.
    :vartype avs: ~azure.mgmt.purestorageblock.models.AvsVmDetails
    :ivar space: Contains properties related to used Flash space.
    :vartype space: ~azure.mgmt.purestorageblock.models.Space
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.purestorageblock.models.ResourceProvisioningState
    """

    storage_pool_internal_id: Optional[str] = rest_field(name="storagePoolInternalId", visibility=["read"])
    """Pure Storage's internal ID for the storage pool."""
    storage_pool_resource_id: Optional[str] = rest_field(name="storagePoolResourceId", visibility=["read"])
    """Azure resource ID of the storage pool."""
    display_name: Optional[str] = rest_field(name="displayName", visibility=["read"])
    """Human-readable name of the AVS VM."""
    created_timestamp: Optional[str] = rest_field(name="createdTimestamp", visibility=["read"])
    """Date at which the AVS VM was created, as an RFC 3339 timestamp."""
    soft_deletion: Optional["_models.SoftDeletion"] = rest_field(name="softDeletion", visibility=["read", "update"])
    """AVS VM's soft-deletion state."""
    volume_container_type: Optional[Union[str, "_models.VolumeContainerType"]] = rest_field(
        name="volumeContainerType", visibility=["read"]
    )
    """Specify which control plane handles the lifecycle of the volume container. \"avs\""""
    avs: Optional["_models.AvsVmDetails"] = rest_field(visibility=["read"])
    """AVS VM details."""
    space: Optional["_models.Space"] = rest_field(visibility=["read"])
    """Contains properties related to used Flash space."""
    provisioning_state: Optional[Union[str, "_models.ResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the resource. Known values are: \"Succeeded\", \"Failed\", and
     \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        soft_deletion: Optional["_models.SoftDeletion"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AvsVmUpdate(_Model):
    """The type used for update operations of the AvsVm.

    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.purestorageblock.models.AvsVmUpdateProperties
    """

    properties: Optional["_models.AvsVmUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.AvsVmUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AvsVmUpdateProperties(_Model):
    """The updatable properties of the AvsVm.

    :ivar soft_deletion: AVS VM's soft-deletion state.
    :vartype soft_deletion: ~azure.mgmt.purestorageblock.models.SoftDeletion
    """

    soft_deletion: Optional["_models.SoftDeletion"] = rest_field(name="softDeletion", visibility=["read", "update"])
    """AVS VM's soft-deletion state."""

    @overload
    def __init__(
        self,
        *,
        soft_deletion: Optional["_models.SoftDeletion"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AvsVmVolume(ProxyResource):
    """Any volume associated to a particular AVS VM.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.purestorageblock.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.purestorageblock.models.VolumeProperties
    """

    properties: Optional["_models.VolumeProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.VolumeProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AvsVmVolumeUpdate(_Model):
    """The type used for update operations of the AvsVmVolume.

    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.purestorageblock.models.AvsVmVolumeUpdateProperties
    """

    properties: Optional["_models.AvsVmVolumeUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.AvsVmVolumeUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AvsVmVolumeUpdateProperties(_Model):
    """The updatable properties of the AvsVmVolume.

    :ivar soft_deletion: Volume's soft-deletion state.
    :vartype soft_deletion: ~azure.mgmt.purestorageblock.models.SoftDeletion
    """

    soft_deletion: Optional["_models.SoftDeletion"] = rest_field(name="softDeletion", visibility=["read", "update"])
    """Volume's soft-deletion state."""

    @overload
    def __init__(
        self,
        *,
        soft_deletion: Optional["_models.SoftDeletion"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureVmwareService(_Model):
    """Connected AVS status.

    :ivar avs_enabled: If true, an AVS SDDC is successfully connected to the storage pool.
     Required.
    :vartype avs_enabled: bool
    :ivar cluster_resource_id: Azure resource ID of the AVS SDDC the storage pool is connected to.
    :vartype cluster_resource_id: str
    """

    avs_enabled: bool = rest_field(name="avsEnabled", visibility=["read", "create", "update", "delete", "query"])
    """If true, an AVS SDDC is successfully connected to the storage pool. Required."""
    cluster_resource_id: Optional[str] = rest_field(
        name="sddcResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure resource ID of the AVS SDDC the storage pool is connected to."""

    @overload
    def __init__(
        self,
        *,
        avs_enabled: bool,
        cluster_resource_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BandwidthUsage(_Model):
    """Bandwidth usage metrics.

    :ivar current: Number of bytes written and read per second (maximum value over the last 10
     minutes). Required.
    :vartype current: int
    :ivar provisioned: Bandwidth value currently provisioned for the storage pool, in MB/s.
     Required.
    :vartype provisioned: int
    :ivar max: Maximum bandwidth value that can be provisioned for the storage pool. Required.
    :vartype max: int
    """

    current: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Number of bytes written and read per second (maximum value over the last 10 minutes). Required."""
    provisioned: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Bandwidth value currently provisioned for the storage pool, in MB/s. Required."""
    max: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Maximum bandwidth value that can be provisioned for the storage pool. Required."""

    @overload
    def __init__(
        self,
        *,
        current: int,
        provisioned: int,
        max: int,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BillingUsageProperty(_Model):
    """Represents an individual billing usage property.

    :ivar property_id: Unique identifier for the billing usage property. Required.
    :vartype property_id: str
    :ivar property_name: Name of the billing usage property. Required.
    :vartype property_name: str
    :ivar current_value: Current value of the billing usage property. Required.
    :vartype current_value: str
    :ivar previous_value: Previous value of the billing usage property.
    :vartype previous_value: str
    :ivar severity: Severity level of the usage. Required. Known values are: "alert",
     "information", "warning", and "none".
    :vartype severity: str or ~azure.mgmt.purestorageblock.models.UsageSeverity
    :ivar status_message: Status message for the billing usage against a property.
    :vartype status_message: str
    :ivar sub_properties: Optional list of sub-properties providing additional details.
    :vartype sub_properties: list[~azure.mgmt.purestorageblock.models.BillingUsageProperty]
    """

    property_id: str = rest_field(name="propertyId", visibility=["read", "create", "update", "delete", "query"])
    """Unique identifier for the billing usage property. Required."""
    property_name: str = rest_field(name="propertyName", visibility=["read", "create", "update", "delete", "query"])
    """Name of the billing usage property. Required."""
    current_value: str = rest_field(name="currentValue", visibility=["read", "create", "update", "delete", "query"])
    """Current value of the billing usage property. Required."""
    previous_value: Optional[str] = rest_field(
        name="previousValue", visibility=["read", "create", "update", "delete", "query"]
    )
    """Previous value of the billing usage property."""
    severity: Union[str, "_models.UsageSeverity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Severity level of the usage. Required. Known values are: \"alert\", \"information\",
     \"warning\", and \"none\"."""
    status_message: Optional[str] = rest_field(
        name="statusMessage", visibility=["read", "create", "update", "delete", "query"]
    )
    """Status message for the billing usage against a property."""
    sub_properties: Optional[List["_models.BillingUsageProperty"]] = rest_field(
        name="subProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional list of sub-properties providing additional details."""

    @overload
    def __init__(
        self,
        *,
        property_id: str,
        property_name: str,
        current_value: str,
        severity: Union[str, "_models.UsageSeverity"],
        previous_value: Optional[str] = None,
        status_message: Optional[str] = None,
        sub_properties: Optional[List["_models.BillingUsageProperty"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CompanyDetails(_Model):
    """Company details.

    :ivar company_name: Company name. Required.
    :vartype company_name: str
    :ivar address: Company address.
    :vartype address: ~azure.mgmt.purestorageblock.models.Address
    """

    company_name: str = rest_field(name="companyName", visibility=["read", "create", "update", "delete", "query"])
    """Company name. Required."""
    address: Optional["_models.Address"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Company address."""

    @overload
    def __init__(
        self,
        *,
        company_name: str,
        address: Optional["_models.Address"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.purestorageblock.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.purestorageblock.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.purestorageblock.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HealthDetails(_Model):
    """Health metrics for a storage pool.

    :ivar used_capacity_percentage: How full the pool is right now, in %, compared to the maximum
     size it can grow to; estimated based on current usage and data reduction ratio. Required.
    :vartype used_capacity_percentage: float
    :ivar bandwidth_usage: Bandwidth usage metrics. Required.
    :vartype bandwidth_usage: ~azure.mgmt.purestorageblock.models.BandwidthUsage
    :ivar iops_usage: IOPS usage metrics. Required.
    :vartype iops_usage: ~azure.mgmt.purestorageblock.models.IopsUsage
    :ivar space: Storage space usage. Required.
    :vartype space: ~azure.mgmt.purestorageblock.models.Space
    :ivar data_reduction_ratio: Data reduction ratio achieved on this pool. Required.
    :vartype data_reduction_ratio: float
    :ivar estimated_max_capacity: Estimated maximum capacity of the pool, in bytes, based on
     current usage and data reduction ratio. Required.
    :vartype estimated_max_capacity: int
    """

    used_capacity_percentage: float = rest_field(
        name="usedCapacityPercentage", visibility=["read", "create", "update", "delete", "query"]
    )
    """How full the pool is right now, in %, compared to the maximum size it can grow to; estimated
     based on current usage and data reduction ratio. Required."""
    bandwidth_usage: "_models.BandwidthUsage" = rest_field(
        name="bandwidthUsage", visibility=["read", "create", "update", "delete", "query"]
    )
    """Bandwidth usage metrics. Required."""
    iops_usage: "_models.IopsUsage" = rest_field(
        name="iopsUsage", visibility=["read", "create", "update", "delete", "query"]
    )
    """IOPS usage metrics. Required."""
    space: "_models.Space" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Storage space usage. Required."""
    data_reduction_ratio: float = rest_field(
        name="dataReductionRatio", visibility=["read", "create", "update", "delete", "query"]
    )
    """Data reduction ratio achieved on this pool. Required."""
    estimated_max_capacity: int = rest_field(
        name="estimatedMaxCapacity", visibility=["read", "create", "update", "delete", "query"]
    )
    """Estimated maximum capacity of the pool, in bytes, based on current usage and data reduction
     ratio. Required."""

    @overload
    def __init__(
        self,
        *,
        used_capacity_percentage: float,
        bandwidth_usage: "_models.BandwidthUsage",
        iops_usage: "_models.IopsUsage",
        space: "_models.Space",
        data_reduction_ratio: float,
        estimated_max_capacity: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IopsUsage(_Model):
    """IOPS usage metrics.

    :ivar current: Current number of IOPS (maximum value over the last 10 minutes). Required.
    :vartype current: int
    :ivar provisioned: IOPS value currently provisioned for the storage pool. Required.
    :vartype provisioned: int
    :ivar max: Maximum IOPS value that can be provisioned for the storage pool. Required.
    :vartype max: int
    """

    current: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Current number of IOPS (maximum value over the last 10 minutes). Required."""
    provisioned: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """IOPS value currently provisioned for the storage pool. Required."""
    max: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Maximum IOPS value that can be provisioned for the storage pool. Required."""

    @overload
    def __init__(
        self,
        *,
        current: int,
        provisioned: int,
        max: int,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LimitDetails(_Model):
    """Limits constraining certain resource properties.

    :ivar storage_pool: Limits used for storage pool resources. Required.
    :vartype storage_pool: ~azure.mgmt.purestorageblock.models.StoragePoolLimits
    :ivar volume: Limits used for volume resources. Required.
    :vartype volume: ~azure.mgmt.purestorageblock.models.VolumeLimits
    :ivar protection_policy: internal. Required.
    :vartype protection_policy: ~azure.mgmt.purestorageblock.models.ProtectionPolicyLimits
    :ivar performance_policy: internal. Required.
    :vartype performance_policy: ~azure.mgmt.purestorageblock.models.PerformancePolicyLimits
    """

    storage_pool: "_models.StoragePoolLimits" = rest_field(
        name="storagePool", visibility=["read", "create", "update", "delete", "query"]
    )
    """Limits used for storage pool resources. Required."""
    volume: "_models.VolumeLimits" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Limits used for volume resources. Required."""
    protection_policy: "_models.ProtectionPolicyLimits" = rest_field(
        name="protectionPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """internal. Required."""
    performance_policy: "_models.PerformancePolicyLimits" = rest_field(
        name="performancePolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """internal. Required."""

    @overload
    def __init__(
        self,
        *,
        storage_pool: "_models.StoragePoolLimits",
        volume: "_models.VolumeLimits",
        protection_policy: "_models.ProtectionPolicyLimits",
        performance_policy: "_models.PerformancePolicyLimits",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedServiceIdentity(_Model):
    """Managed service identity (system assigned and/or user assigned identities).

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of managed identity assigned to this resource. Required. Known values are:
     "None", "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.purestorageblock.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The identities assigned to this resource by the user.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.purestorageblock.models.UserAssignedIdentity]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The service principal ID of the system assigned identity. This property will only be provided
     for a system assigned identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of the system assigned identity. This property will only be provided for a system
     assigned identity."""
    type: Union[str, "_models.ManagedServiceIdentityType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of managed identity assigned to this resource. Required. Known values are: \"None\",
     \"SystemAssigned\", \"UserAssigned\", and \"SystemAssigned,UserAssigned\"."""
    user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identities assigned to this resource by the user."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MarketplaceDetails(_Model):
    """Marketplace details.

    :ivar subscription_id: Marketplace subscription ID.
    :vartype subscription_id: str
    :ivar subscription_status: Marketplace subscription status. Known values are:
     "PendingFulfillmentStart", "Subscribed", "Suspended", and "Unsubscribed".
    :vartype subscription_status: str or
     ~azure.mgmt.purestorageblock.models.MarketplaceSubscriptionStatus
    :ivar offer_details: Offer details of the marketplace subscription. Required.
    :vartype offer_details: ~azure.mgmt.purestorageblock.models.OfferDetails
    """

    subscription_id: Optional[str] = rest_field(name="subscriptionId", visibility=["read"])
    """Marketplace subscription ID."""
    subscription_status: Optional[Union[str, "_models.MarketplaceSubscriptionStatus"]] = rest_field(
        name="subscriptionStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """Marketplace subscription status. Known values are: \"PendingFulfillmentStart\", \"Subscribed\",
     \"Suspended\", and \"Unsubscribed\"."""
    offer_details: "_models.OfferDetails" = rest_field(
        name="offerDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Offer details of the marketplace subscription. Required."""

    @overload
    def __init__(
        self,
        *,
        offer_details: "_models.OfferDetails",
        subscription_status: Optional[Union[str, "_models.MarketplaceSubscriptionStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OfferDetails(_Model):
    """Offer details for the marketplace that is selected by the user.

    :ivar publisher_id: Publisher ID for the marketplace offer. Required.
    :vartype publisher_id: str
    :ivar offer_id: Offer ID for the marketplace offer. Required.
    :vartype offer_id: str
    :ivar plan_id: Plan ID for the marketplace offer. Required.
    :vartype plan_id: str
    :ivar plan_name: Plan Name for the marketplace offer.
    :vartype plan_name: str
    :ivar term_unit: Term Unit for the marketplace offer.
    :vartype term_unit: str
    :ivar term_id: Term ID for the marketplace offer.
    :vartype term_id: str
    """

    publisher_id: str = rest_field(name="publisherId", visibility=["read", "create", "update", "delete", "query"])
    """Publisher ID for the marketplace offer. Required."""
    offer_id: str = rest_field(name="offerId", visibility=["read", "create", "update", "delete", "query"])
    """Offer ID for the marketplace offer. Required."""
    plan_id: str = rest_field(name="planId", visibility=["read", "create", "update", "delete", "query"])
    """Plan ID for the marketplace offer. Required."""
    plan_name: Optional[str] = rest_field(name="planName", visibility=["read", "create", "update", "delete", "query"])
    """Plan Name for the marketplace offer."""
    term_unit: Optional[str] = rest_field(name="termUnit", visibility=["read", "create", "update", "delete", "query"])
    """Term Unit for the marketplace offer."""
    term_id: Optional[str] = rest_field(name="termId", visibility=["read", "create", "update", "delete", "query"])
    """Term ID for the marketplace offer."""

    @overload
    def __init__(
        self,
        *,
        publisher_id: str,
        offer_id: str,
        plan_id: str,
        plan_name: Optional[str] = None,
        term_unit: Optional[str] = None,
        term_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_Model):
    """REST API Operation.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.purestorageblock.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.purestorageblock.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.purestorageblock.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_Model):
    """Localized display information for and operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class PerformancePolicyLimits(_Model):
    """internal.

    :ivar iops_limit: internal. Required.
    :vartype iops_limit: ~azure.mgmt.purestorageblock.models.RangeLimits
    :ivar bandwidth_limit: internal. Required.
    :vartype bandwidth_limit: ~azure.mgmt.purestorageblock.models.RangeLimits
    """

    iops_limit: "_models.RangeLimits" = rest_field(
        name="iopsLimit", visibility=["read", "create", "update", "delete", "query"]
    )
    """internal. Required."""
    bandwidth_limit: "_models.RangeLimits" = rest_field(
        name="bandwidthLimit", visibility=["read", "create", "update", "delete", "query"]
    )
    """internal. Required."""

    @overload
    def __init__(
        self,
        *,
        iops_limit: "_models.RangeLimits",
        bandwidth_limit: "_models.RangeLimits",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProtectionPolicyLimits(_Model):
    """internal.

    :ivar frequency: internal. Required.
    :vartype frequency: ~azure.mgmt.purestorageblock.models.RangeLimits
    :ivar retention: internal. Required.
    :vartype retention: ~azure.mgmt.purestorageblock.models.RangeLimits
    """

    frequency: "_models.RangeLimits" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """internal. Required."""
    retention: "_models.RangeLimits" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """internal. Required."""

    @overload
    def __init__(
        self,
        *,
        frequency: "_models.RangeLimits",
        retention: "_models.RangeLimits",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RangeLimits(_Model):
    """Minimum and maximum values for a property.

    :ivar min: Minimum value of the property. Required.
    :vartype min: int
    :ivar max: Maximum value of the property. Required.
    :vartype max: int
    """

    min: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Minimum value of the property. Required."""
    max: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Maximum value of the property. Required."""

    @overload
    def __init__(
        self,
        *,
        min: int,  # pylint: disable=redefined-builtin
        max: int,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.purestorageblock.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Reservation(TrackedResource):
    """Pure Storage cloud service resource type, also called reservation.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.purestorageblock.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.purestorageblock.models.ReservationPropertiesBaseResourceProperties
    """

    properties: Optional["_models.ReservationPropertiesBaseResourceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.ReservationPropertiesBaseResourceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ReservationBillingStatus(_Model):
    """Latest billing status for this reservation.

    :ivar timestamp: Timestamp for the latest update of this billing status, in RFC 3339 format.
     Required.
    :vartype timestamp: str
    :ivar total_used_capacity_reported: Total used capacity as reported by associated storage
     pools. In bytes. Required.
    :vartype total_used_capacity_reported: int
    :ivar low_drr_pool_count: How many associated storage pools reported low data reduction ratio
     (DRR). Required.
    :vartype low_drr_pool_count: int
    :ivar drr_weighted_average: Weighted average of the data-reduction ratio for all associated
     pools. Required.
    :vartype drr_weighted_average: float
    :ivar total_non_reducible_reported: The sum of total used capacity for all pools with low DRR,
     if the DRR penalty applies. In bytes. Required.
    :vartype total_non_reducible_reported: int
    :ivar extra_used_capacity_non_reducible: Extra capacity added because of low DRR storage pools;
     In bytes. Required.
    :vartype extra_used_capacity_non_reducible: int
    :ivar extra_used_capacity_low_usage_rounding: Extra capacity added when rounding up low-usage
     pools to 30TiB. In bytes. Required.
    :vartype extra_used_capacity_low_usage_rounding: int
    :ivar extra_used_capacity_non_reducible_plan_discount: Extra capacity discounted due to plan
     forgiving some low-DRR usage. In bytes. Required.
    :vartype extra_used_capacity_non_reducible_plan_discount: int
    :ivar total_used_capacity_billed: Total used capacity actually billed. In bytes. Required.
    :vartype total_used_capacity_billed: int
    :ivar total_used_capacity_included_plan: Total used capacity included in plan. In bytes.
     Required.
    :vartype total_used_capacity_included_plan: int
    :ivar total_used_capacity_overage: Total used capacity reported at on-demand price. In bytes.
     Required.
    :vartype total_used_capacity_overage: int
    :ivar total_performance_reported: The sum of all performance settings across the pools under
     this reservation. In MB per second. Required.
    :vartype total_performance_reported: int
    :ivar total_performance_included_plan: Total performance amount included in plan. In bytes per
     second. Required.
    :vartype total_performance_included_plan: int
    :ivar total_performance_overage: Total performance amount reported at on-demand price. In MB
     per second. Required.
    :vartype total_performance_overage: int
    """

    timestamp: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Timestamp for the latest update of this billing status, in RFC 3339 format. Required."""
    total_used_capacity_reported: int = rest_field(
        name="totalUsedCapacityReported", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total used capacity as reported by associated storage pools. In bytes. Required."""
    low_drr_pool_count: int = rest_field(
        name="lowDrrPoolCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """How many associated storage pools reported low data reduction ratio (DRR). Required."""
    drr_weighted_average: float = rest_field(
        name="drrWeightedAverage", visibility=["read", "create", "update", "delete", "query"]
    )
    """Weighted average of the data-reduction ratio for all associated pools. Required."""
    total_non_reducible_reported: int = rest_field(
        name="totalNonReducibleReported", visibility=["read", "create", "update", "delete", "query"]
    )
    """The sum of total used capacity for all pools with low DRR, if the DRR penalty applies. In
     bytes. Required."""
    extra_used_capacity_non_reducible: int = rest_field(
        name="extraUsedCapacityNonReducible", visibility=["read", "create", "update", "delete", "query"]
    )
    """Extra capacity added because of low DRR storage pools; In bytes. Required."""
    extra_used_capacity_low_usage_rounding: int = rest_field(
        name="extraUsedCapacityLowUsageRounding", visibility=["read", "create", "update", "delete", "query"]
    )
    """Extra capacity added when rounding up low-usage pools to 30TiB. In bytes. Required."""
    extra_used_capacity_non_reducible_plan_discount: int = rest_field(
        name="extraUsedCapacityNonReduciblePlanDiscount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Extra capacity discounted due to plan forgiving some low-DRR usage. In bytes. Required."""
    total_used_capacity_billed: int = rest_field(
        name="totalUsedCapacityBilled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total used capacity actually billed. In bytes. Required."""
    total_used_capacity_included_plan: int = rest_field(
        name="totalUsedCapacityIncludedPlan", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total used capacity included in plan. In bytes. Required."""
    total_used_capacity_overage: int = rest_field(
        name="totalUsedCapacityOverage", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total used capacity reported at on-demand price. In bytes. Required."""
    total_performance_reported: int = rest_field(
        name="totalPerformanceReported", visibility=["read", "create", "update", "delete", "query"]
    )
    """The sum of all performance settings across the pools under this reservation. In MB per second.
     Required."""
    total_performance_included_plan: int = rest_field(
        name="totalPerformanceIncludedPlan", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total performance amount included in plan. In bytes per second. Required."""
    total_performance_overage: int = rest_field(
        name="totalPerformanceOverage", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total performance amount reported at on-demand price. In MB per second. Required."""

    @overload
    def __init__(
        self,
        *,
        timestamp: str,
        total_used_capacity_reported: int,
        low_drr_pool_count: int,
        drr_weighted_average: float,
        total_non_reducible_reported: int,
        extra_used_capacity_non_reducible: int,
        extra_used_capacity_low_usage_rounding: int,
        extra_used_capacity_non_reducible_plan_discount: int,
        total_used_capacity_billed: int,
        total_used_capacity_included_plan: int,
        total_used_capacity_overage: int,
        total_performance_reported: int,
        total_performance_included_plan: int,
        total_performance_overage: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ReservationBillingUsageReport(_Model):
    """Represents a billing usage report, including overall status and detailed properties.

    :ivar timestamp: Latest formatted billing report for this reservation. Required.
    :vartype timestamp: str
    :ivar billing_usage_properties: A list of detailed billing usage properties. Required.
    :vartype billing_usage_properties:
     list[~azure.mgmt.purestorageblock.models.BillingUsageProperty]
    :ivar overall_status_message: Overall status message of the billing usage report. Required.
    :vartype overall_status_message: str
    """

    timestamp: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Latest formatted billing report for this reservation. Required."""
    billing_usage_properties: List["_models.BillingUsageProperty"] = rest_field(
        name="billingUsageProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of detailed billing usage properties. Required."""
    overall_status_message: str = rest_field(
        name="overallStatusMessage", visibility=["read", "create", "update", "delete", "query"]
    )
    """Overall status message of the billing usage report. Required."""

    @overload
    def __init__(
        self,
        *,
        timestamp: str,
        billing_usage_properties: List["_models.BillingUsageProperty"],
        overall_status_message: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ReservationPropertiesBaseResourceProperties(_Model):  # pylint: disable=name-too-long
    """Properties of a Reservation resource.

    :ivar reservation_internal_id: Pure Storage's internal ID for the reservation.
    :vartype reservation_internal_id: str
    :ivar marketplace: Marketplace details. Required.
    :vartype marketplace: ~azure.mgmt.purestorageblock.models.MarketplaceDetails
    :ivar user: User details. Required.
    :vartype user: ~azure.mgmt.purestorageblock.models.UserDetails
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.purestorageblock.models.ProvisioningState
    """

    reservation_internal_id: Optional[str] = rest_field(name="reservationInternalId", visibility=["read"])
    """Pure Storage's internal ID for the reservation."""
    marketplace: "_models.MarketplaceDetails" = rest_field(visibility=["read", "create"])
    """Marketplace details. Required."""
    user: "_models.UserDetails" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """User details. Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the resource. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Deleting\", and \"Accepted\"."""

    @overload
    def __init__(
        self,
        *,
        marketplace: "_models.MarketplaceDetails",
        user: "_models.UserDetails",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ReservationUpdate(_Model):
    """The type used for update operations of the Reservation.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.purestorageblock.models.ReservationUpdateProperties
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.ReservationUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.ReservationUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ReservationUpdateProperties(_Model):
    """The updatable properties of the Reservation.

    :ivar user: User details.
    :vartype user: ~azure.mgmt.purestorageblock.models.UserDetails
    """

    user: Optional["_models.UserDetails"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """User details."""

    @overload
    def __init__(
        self,
        *,
        user: Optional["_models.UserDetails"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ServiceInitializationHandle(_Model):
    """Initialization handle used to configure the AVS SDDC to communicate with the storage pool.

    :ivar cluster_resource_id: Azure resource ID of the AVS SDDC the pool is connecting to.
    :vartype cluster_resource_id: str
    :ivar service_account_username: Requested service account username.
    :vartype service_account_username: str
    """

    cluster_resource_id: Optional[str] = rest_field(
        name="sddcResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure resource ID of the AVS SDDC the pool is connecting to."""
    service_account_username: Optional[str] = rest_field(
        name="serviceAccountUsername", visibility=["read", "create", "update", "delete", "query"]
    )
    """Requested service account username."""

    @overload
    def __init__(
        self,
        *,
        cluster_resource_id: Optional[str] = None,
        service_account_username: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ServiceInitializationInfo(_Model):
    """Explicit service initialization data.

    :ivar service_account_username: Service account username.
    :vartype service_account_username: str
    :ivar service_account_password: Service account password.
    :vartype service_account_password: str
    :ivar v_sphere_ip: AVS instance's vSphere IP address.
    :vartype v_sphere_ip: str
    :ivar v_sphere_certificate: AVS instance's vSphere certificate.
    :vartype v_sphere_certificate: str
    """

    service_account_username: Optional[str] = rest_field(
        name="serviceAccountUsername", visibility=["read", "create", "update", "delete", "query"]
    )
    """Service account username."""
    service_account_password: Optional[str] = rest_field(
        name="serviceAccountPassword", visibility=["read", "create", "update", "delete", "query"]
    )
    """Service account password."""
    v_sphere_ip: Optional[str] = rest_field(
        name="vSphereIp", visibility=["read", "create", "update", "delete", "query"]
    )
    """AVS instance's vSphere IP address."""
    v_sphere_certificate: Optional[str] = rest_field(
        name="vSphereCertificate", visibility=["read", "create", "update", "delete", "query"]
    )
    """AVS instance's vSphere certificate."""

    @overload
    def __init__(
        self,
        *,
        service_account_username: Optional[str] = None,
        service_account_password: Optional[str] = None,
        v_sphere_ip: Optional[str] = None,
        v_sphere_certificate: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SoftDeletion(_Model):
    """Soft-deletion state.

    :ivar destroyed: If false, the resource is active; if true, the resource has been destroyed;
     resources can be soft-deleted by setting destroyed to true, and recovered by setting it to
     false. Required.
    :vartype destroyed: bool
    :ivar eradication_timestamp: Date at which the resource will be eradicated and impossible to
     recover, as an RFC 3339 timestamp; invalid if destroyed is false;.
    :vartype eradication_timestamp: str
    """

    destroyed: bool = rest_field(visibility=["read", "update"])
    """If false, the resource is active; if true, the resource has been destroyed; resources can be
     soft-deleted by setting destroyed to true, and recovered by setting it to false. Required."""
    eradication_timestamp: Optional[str] = rest_field(name="eradicationTimestamp", visibility=["read"])
    """Date at which the resource will be eradicated and impossible to recover, as an RFC 3339
     timestamp; invalid if destroyed is false;."""

    @overload
    def __init__(
        self,
        *,
        destroyed: bool,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Space(_Model):
    """Storage space usage.

    :ivar total_used: Total space occupied by customer data (i.e., being billed for), in bytes.
     Required.
    :vartype total_used: int
    :ivar unique: Unique space occupied by customer data, in bytes; for a volume, this is the
     amount of storage that would be freed by deleting the volume, since snapshot and shared data
     would be kept. Required.
    :vartype unique: int
    :ivar snapshots: Space occupied by data unique to one or more snapshots, in bytes. Required.
    :vartype snapshots: int
    :ivar shared: Space occupied by duplicated data, meaning data shared with other volumes and
     snapshots as a result of data deduplication, in bytes. Required.
    :vartype shared: int
    """

    total_used: int = rest_field(name="totalUsed", visibility=["read", "create", "update", "delete", "query"])
    """Total space occupied by customer data (i.e., being billed for), in bytes. Required."""
    unique: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique space occupied by customer data, in bytes; for a volume, this is the amount of storage
     that would be freed by deleting the volume, since snapshot and shared data would be kept.
     Required."""
    snapshots: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Space occupied by data unique to one or more snapshots, in bytes. Required."""
    shared: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Space occupied by duplicated data, meaning data shared with other volumes and snapshots as a
     result of data deduplication, in bytes. Required."""

    @overload
    def __init__(
        self,
        *,
        total_used: int,
        unique: int,
        snapshots: int,
        shared: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StoragePool(TrackedResource):
    """Storage pool resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.purestorageblock.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.purestorageblock.models.StoragePoolProperties
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.purestorageblock.models.ManagedServiceIdentity
    """

    properties: Optional["_models.StoragePoolProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed service identities assigned to this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.StoragePoolProperties"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StoragePoolEnableAvsConnectionPost(_Model):
    """EnableAvsConnection payload information.

    :ivar cluster_resource_id: Azure resource ID of the AVS SDDC to connect to. Required.
    :vartype cluster_resource_id: str
    """

    cluster_resource_id: str = rest_field(
        name="sddcResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure resource ID of the AVS SDDC to connect to. Required."""

    @overload
    def __init__(
        self,
        *,
        cluster_resource_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StoragePoolFinalizeAvsConnectionPost(_Model):
    """FinalizeAvsConnection payload information, either encoded or explicit.

    :ivar service_initialization_data_enc: Encoded AVS connection information.
    :vartype service_initialization_data_enc: str
    :ivar service_initialization_data: Explicit AVS connection information.
    :vartype service_initialization_data:
     ~azure.mgmt.purestorageblock.models.ServiceInitializationInfo
    """

    service_initialization_data_enc: Optional[str] = rest_field(
        name="serviceInitializationDataEnc", visibility=["read", "create", "update", "delete", "query"]
    )
    """Encoded AVS connection information."""
    service_initialization_data: Optional["_models.ServiceInitializationInfo"] = rest_field(
        name="serviceInitializationData", visibility=["read", "create", "update", "delete", "query"]
    )
    """Explicit AVS connection information."""

    @overload
    def __init__(
        self,
        *,
        service_initialization_data_enc: Optional[str] = None,
        service_initialization_data: Optional["_models.ServiceInitializationInfo"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StoragePoolHealthInfo(_Model):
    """Health information for a storage pool.

    :ivar health: Health metrics. Required.
    :vartype health: ~azure.mgmt.purestorageblock.models.HealthDetails
    :ivar alerts: List of health alerts. Required.
    :vartype alerts: list[~azure.mgmt.purestorageblock.models.Alert]
    """

    health: "_models.HealthDetails" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Health metrics. Required."""
    alerts: List["_models.Alert"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of health alerts. Required."""

    @overload
    def __init__(
        self,
        *,
        health: "_models.HealthDetails",
        alerts: List["_models.Alert"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StoragePoolLimits(_Model):
    """Limits used for storage pool creation.

    :ivar provisioned_bandwidth_mb_per_sec: Allowed provisioned bandwidth range for a storage pool,
     in MB/s. Required.
    :vartype provisioned_bandwidth_mb_per_sec: ~azure.mgmt.purestorageblock.models.RangeLimits
    :ivar provisioned_iops: Allowed provisioned IOPS range for a storage pool, as a number of
     operations. Required.
    :vartype provisioned_iops: ~azure.mgmt.purestorageblock.models.RangeLimits
    :ivar physical_availability_zones: List of physical availability zones in the region in which
     storage pools can be deployed; some Azure regions do not support the necessary resources in all
     availability zones. Required.
    :vartype physical_availability_zones: list[str]
    """

    provisioned_bandwidth_mb_per_sec: "_models.RangeLimits" = rest_field(
        name="provisionedBandwidthMbPerSec", visibility=["read", "create", "update", "delete", "query"]
    )
    """Allowed provisioned bandwidth range for a storage pool, in MB/s. Required."""
    provisioned_iops: "_models.RangeLimits" = rest_field(
        name="provisionedIops", visibility=["read", "create", "update", "delete", "query"]
    )
    """Allowed provisioned IOPS range for a storage pool, as a number of operations. Required."""
    physical_availability_zones: List[str] = rest_field(
        name="physicalAvailabilityZones", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of physical availability zones in the region in which storage pools can be deployed; some
     Azure regions do not support the necessary resources in all availability zones. Required."""

    @overload
    def __init__(
        self,
        *,
        provisioned_bandwidth_mb_per_sec: "_models.RangeLimits",
        provisioned_iops: "_models.RangeLimits",
        physical_availability_zones: List[str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StoragePoolProperties(_Model):
    """Properties of a storage pool.

    :ivar storage_pool_internal_id: Pure Storage's internal ID of the storage pool.
    :vartype storage_pool_internal_id: str
    :ivar availability_zone: Azure Availability Zone the Pool is located in. Required.
    :vartype availability_zone: str
    :ivar vnet_injection: Network properties of the storage pool. Required.
    :vartype vnet_injection: ~azure.mgmt.purestorageblock.models.VnetInjection
    :ivar data_retention_period: How long a destroyed object is kept before being eradicated, in
     seconds.
    :vartype data_retention_period: int
    :ivar provisioned_bandwidth_mb_per_sec: Total bandwidth provisioned for the pool, in MB/s.
     Required.
    :vartype provisioned_bandwidth_mb_per_sec: int
    :ivar provisioned_iops: Total I/O operations per second (IOPS) provisioned for the pool.
    :vartype provisioned_iops: int
    :ivar avs: AVS connection state summary.
    :vartype avs: ~azure.mgmt.purestorageblock.models.AzureVmwareService
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.purestorageblock.models.ProvisioningState
    :ivar reservation_resource_id: Azure resource ID of the Pure Storage Cloud service (reservation
     resource) this storage pool belongs to. Required.
    :vartype reservation_resource_id: str
    """

    storage_pool_internal_id: Optional[str] = rest_field(name="storagePoolInternalId", visibility=["read"])
    """Pure Storage's internal ID of the storage pool."""
    availability_zone: str = rest_field(name="availabilityZone", visibility=["read", "create"])
    """Azure Availability Zone the Pool is located in. Required."""
    vnet_injection: "_models.VnetInjection" = rest_field(name="vnetInjection", visibility=["read", "create"])
    """Network properties of the storage pool. Required."""
    data_retention_period: Optional[int] = rest_field(name="dataRetentionPeriod", visibility=["read"])
    """How long a destroyed object is kept before being eradicated, in seconds."""
    provisioned_bandwidth_mb_per_sec: int = rest_field(
        name="provisionedBandwidthMbPerSec", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total bandwidth provisioned for the pool, in MB/s. Required."""
    provisioned_iops: Optional[int] = rest_field(name="provisionedIops", visibility=["read"])
    """Total I/O operations per second (IOPS) provisioned for the pool."""
    avs: Optional["_models.AzureVmwareService"] = rest_field(visibility=["read"])
    """AVS connection state summary."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the resource. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Deleting\", and \"Accepted\"."""
    reservation_resource_id: str = rest_field(name="reservationResourceId", visibility=["read", "create"])
    """Azure resource ID of the Pure Storage Cloud service (reservation resource) this storage pool
     belongs to. Required."""

    @overload
    def __init__(
        self,
        *,
        availability_zone: str,
        vnet_injection: "_models.VnetInjection",
        provisioned_bandwidth_mb_per_sec: int,
        reservation_resource_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StoragePoolUpdate(_Model):
    """The type used for update operations of the StoragePool.

    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.purestorageblock.models.ManagedServiceIdentity
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.purestorageblock.models.StoragePoolUpdateProperties
    """

    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed service identities assigned to this resource."""
    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.StoragePoolUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.StoragePoolUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StoragePoolUpdateProperties(_Model):
    """The updatable properties of the StoragePool.

    :ivar provisioned_bandwidth_mb_per_sec: Total bandwidth provisioned for the pool, in MB/s.
    :vartype provisioned_bandwidth_mb_per_sec: int
    """

    provisioned_bandwidth_mb_per_sec: Optional[int] = rest_field(
        name="provisionedBandwidthMbPerSec", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total bandwidth provisioned for the pool, in MB/s."""

    @overload
    def __init__(
        self,
        *,
        provisioned_bandwidth_mb_per_sec: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.purestorageblock.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.purestorageblock.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserAssignedIdentity(_Model):
    """User assigned identity properties.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of the assigned identity."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client ID of the assigned identity."""


class UserDetails(_Model):
    """User details.

    :ivar first_name: First name. Required.
    :vartype first_name: str
    :ivar last_name: Last name. Required.
    :vartype last_name: str
    :ivar email_address: Email address. Required.
    :vartype email_address: str
    :ivar upn: Principal name.
    :vartype upn: str
    :ivar phone_number: Phone number.
    :vartype phone_number: str
    :ivar company_details: Company details.
    :vartype company_details: ~azure.mgmt.purestorageblock.models.CompanyDetails
    """

    first_name: str = rest_field(name="firstName", visibility=["read", "create", "update", "delete", "query"])
    """First name. Required."""
    last_name: str = rest_field(name="lastName", visibility=["read", "create", "update", "delete", "query"])
    """Last name. Required."""
    email_address: str = rest_field(name="emailAddress", visibility=["read", "create", "update", "delete", "query"])
    """Email address. Required."""
    upn: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Principal name."""
    phone_number: Optional[str] = rest_field(
        name="phoneNumber", visibility=["read", "create", "update", "delete", "query"]
    )
    """Phone number."""
    company_details: Optional["_models.CompanyDetails"] = rest_field(
        name="companyDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Company details."""

    @overload
    def __init__(
        self,
        *,
        first_name: str,
        last_name: str,
        email_address: str,
        upn: Optional[str] = None,
        phone_number: Optional[str] = None,
        company_details: Optional["_models.CompanyDetails"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VnetInjection(_Model):
    """Network in which the storage pool will be made available.

    :ivar subnet_id: Azure resource ID of the Virtual Network subnet where the storage pool will be
     connected. Required.
    :vartype subnet_id: str
    :ivar vnet_id: Azure resource ID of the Virtual Network in which the subnet is located.
     Required.
    :vartype vnet_id: str
    """

    subnet_id: str = rest_field(name="subnetId", visibility=["read", "create", "update", "delete", "query"])
    """Azure resource ID of the Virtual Network subnet where the storage pool will be connected.
     Required."""
    vnet_id: str = rest_field(name="vnetId", visibility=["read", "create", "update", "delete", "query"])
    """Azure resource ID of the Virtual Network in which the subnet is located. Required."""

    @overload
    def __init__(
        self,
        *,
        subnet_id: str,
        vnet_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VolumeLimits(_Model):
    """Limits used for volumes.

    :ivar provisioned_size: Provisioned size limits for a volume, in bytes. Required.
    :vartype provisioned_size: ~azure.mgmt.purestorageblock.models.RangeLimits
    """

    provisioned_size: "_models.RangeLimits" = rest_field(
        name="provisionedSize", visibility=["read", "create", "update", "delete", "query"]
    )
    """Provisioned size limits for a volume, in bytes. Required."""

    @overload
    def __init__(
        self,
        *,
        provisioned_size: "_models.RangeLimits",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VolumeProperties(_Model):
    """Volume properties.

    :ivar storage_pool_internal_id: Pure Storage's internal ID for the storage pool containing the
     volume.
    :vartype storage_pool_internal_id: str
    :ivar storage_pool_resource_id: Azure Resource ID of the storage pool containing this volume.
    :vartype storage_pool_resource_id: str
    :ivar volume_internal_id: Pure Storage's internal ID for the volume.
    :vartype volume_internal_id: str
    :ivar display_name: Human-readable name of the volume.
    :vartype display_name: str
    :ivar space: Storage space usage.
    :vartype space: ~azure.mgmt.purestorageblock.models.Space
    :ivar soft_deletion: Volume's soft-deletion state. Required.
    :vartype soft_deletion: ~azure.mgmt.purestorageblock.models.SoftDeletion
    :ivar created_timestamp: Volume creation date, as an RFC 3339 timestamp.
    :vartype created_timestamp: str
    :ivar provisioned_size: Currently provisioned size of the volume, in bytes.
    :vartype provisioned_size: int
    :ivar volume_type: Specify which control plane handles the lifecycle of the volume. "avs"
    :vartype volume_type: str or ~azure.mgmt.purestorageblock.models.VolumeType
    :ivar avs: AVS-specific volume information.
    :vartype avs: ~azure.mgmt.purestorageblock.models.AvsDiskDetails
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.purestorageblock.models.ResourceProvisioningState
    """

    storage_pool_internal_id: Optional[str] = rest_field(name="storagePoolInternalId", visibility=["read"])
    """Pure Storage's internal ID for the storage pool containing the volume."""
    storage_pool_resource_id: Optional[str] = rest_field(name="storagePoolResourceId", visibility=["read"])
    """Azure Resource ID of the storage pool containing this volume."""
    volume_internal_id: Optional[str] = rest_field(name="volumeInternalId", visibility=["read"])
    """Pure Storage's internal ID for the volume."""
    display_name: Optional[str] = rest_field(name="displayName", visibility=["read"])
    """Human-readable name of the volume."""
    space: Optional["_models.Space"] = rest_field(visibility=["read"])
    """Storage space usage."""
    soft_deletion: "_models.SoftDeletion" = rest_field(name="softDeletion", visibility=["read", "update"])
    """Volume's soft-deletion state. Required."""
    created_timestamp: Optional[str] = rest_field(name="createdTimestamp", visibility=["read"])
    """Volume creation date, as an RFC 3339 timestamp."""
    provisioned_size: Optional[int] = rest_field(name="provisionedSize", visibility=["read"])
    """Currently provisioned size of the volume, in bytes."""
    volume_type: Optional[Union[str, "_models.VolumeType"]] = rest_field(name="volumeType", visibility=["read"])
    """Specify which control plane handles the lifecycle of the volume. \"avs\""""
    avs: Optional["_models.AvsDiskDetails"] = rest_field(visibility=["read"])
    """AVS-specific volume information."""
    provisioning_state: Optional[Union[str, "_models.ResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the resource. Known values are: \"Succeeded\", \"Failed\", and
     \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        soft_deletion: "_models.SoftDeletion",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
