# SPDX-License-Identifier: AGPL-3.0-or-later
"""
Forms for configuring unattended-upgrades.
"""

from django import forms
from django.utils.translation import ugettext_lazy as _


class ConfigureForm(forms.Form):
    """Configuration form to enable/disable automatic upgrades."""
    auto_upgrades_enabled = forms.BooleanField(
        label=_('Enable auto-update'), required=False, help_text=_(
            'When enabled, FreedomBox automatically updates once a day.'))
