/*	Value_View

PIRL CVS ID: Value_View.java,v 1.13 2012/04/16 06:22:59 castalia Exp

Copyright (C) 2001-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

package	PIRL.Viewers;

import	PIRL.PVL.*;

import	javax.swing.JTree;
import	javax.swing.event.TreeSelectionListener;
import	javax.swing.event.TreeSelectionEvent;
import	javax.swing.tree.*;
import	javax.swing.JScrollPane;
import	javax.swing.JFrame;
import	java.awt.*;
import	java.awt.event.*;
import	java.io.File;
import	java.io.IOException;
import	java.awt.event.WindowAdapter;
import	java.awt.event.WindowEvent;

/**
A <I>Value_View</I> provides a view of an array <I>Value</I>.

The display uses a JTree to represent the array of Values. Any Value in
the array that is itself an array may be expanded to display its
contents. Each Value is shown as the String provided by the Value's
<CODE>toString</CODE> method.
<P>
This Swing GUI can be employed whenever the display of a Value array is
needed by an application. A <CODE>main</CODE> method is provided using
this class as an application for viewing the array Values from a
file containing PVL statements.
<P>
@see		Value
@see		JTree

@author		Bradford Castalia, UA/PIRL
@version	1.13
*/
public class Value_View
	extends JFrame
{
private static final String
	ID = "PIRL.Viewers.Value_View (1.13 2012/04/16 06:22:59)";

//	Is this an application (started from main)?
private static boolean		_Application_ = false;

//	The initial screen location when used as an application.
private static final Point	DEFAULT_INITIAL_LOCATION
								= new Point (175, 75);

//	Total number of displays created by the application.
private static int			_Total_Displays_ = 0;

private Parameter_Pane Enclosing_Parameter_Pane;

/**	The scroll pane containing the JTable.
*/
private Value_Pane			The_Value_Pane;

/*==============================================================================
	Constructors
*/

/**	Creates a Value_View from the specified Value and
	gives it the specified title. This constructor should be used when
	this class is being used as a stand-alone application
<P>
	@param	title	The window title String. If null, then
		the default title "Value Array" will be used.
	@param	value	The Value to be displayed.
	@throws	PVL_Exception	If the Value is not an <CODE>ARRAY</CODE>
		type. The message is <CODE>BAD_ARGUMENT</CODE>.
*/
public Value_View
   (
	String title,
	Value value
	)
throws	PVL_Exception	
{
this(title, value, (Parameter_Pane)null);
}
	

/**	Creates a Value_View from the specified Value and
	gives it the specified title. This constructor should be used when
	this class is being used as part of a larger application
<P>
	@param	title	The window title String. If null, then
		the default title "Value Array" will be used.
	@param	value	The Value to be displayed.
	@param   enclosing_parameter_pane The Parameter_Pane that created this value
	         view. If no Parameter_Pane created this Value_View, set this to
				null or use the other constructor.
	@throws	PVL_Exception	If the Value is not an <CODE>ARRAY</CODE>
		type. The message is <CODE>BAD_ARGUMENT</CODE>.
*/
public Value_View
	(
	String		title,
	Value		value,
	Parameter_Pane enclosing_parameter_pane
	)
throws	PVL_Exception
{
if (title == null)
	title = "Value_View";
setTitle (title);

The_Value_Pane = new Value_Pane (value, enclosing_parameter_pane);
The_Value_Pane.setMinimumSize (new Dimension (50, 40));
int
	height = 25 * value.getChildCount ();
if (height < 40)
	height = 40;
if (height > 200)
	height = 200;
The_Value_Pane.setPreferredSize (new Dimension (100, height));

//	Add the tree view pane to this frame.
getContentPane ().add (The_Value_Pane, BorderLayout.CENTER);

//	On window close...
addWindowListener (new WindowAdapter ()
	{
	public void windowClosing (WindowEvent event)
	{
	if (--_Total_Displays_ == 0 && _Application_)
		System.exit (0);
	}
	});

pack ();
_Total_Displays_++;
}

/**	Creates a Value_View from the specified Value.
<P>
	@param	value	The Value to be displayed.
	@throws	PVL_Exception	If the Value is not an <CODE>ARRAY</CODE>
		type. The message is <CODE>BAD_ARGUMENT</CODE>.
*/
public Value_View
	(
	Value		value
	)
throws	PVL_Exception
{this (null, value);}

/*==============================================================================
	Accessors
*/
/**	Gets the Value_Pane used by this Value_View.
<P>
	@return	The Value_Pane used by this Value_View.
*/
public Value_Pane Value_Pane ()
{return The_Value_Pane;}

/**	Gets the JTree being used to represent the Values in the display.
<P>
	@return	The JTreeTable representing this Parameter_View.
*/
public JTree Tree ()
{return The_Value_Pane.Tree ();}

/*==============================================================================
	Application
*/
/**	Creates a Value_View displaying each of the array Values found
	in the file listed on the command line.
*/
public static void main (String[] arguments) 
{
if (arguments.length == 0)
	{
	System.err.println ("Usage: java Value_View <PVL_filename>");
	System.exit (1);
	}

_Application_ = true;

try
	{
	Parameter
		parameters =
			new Parameter (arguments[0], new Parser (new File (arguments[0]))),
		parameter = null,
		test_parameter =
			new Parameter ()
				.Classification (Parameter.ASSIGNMENT);
				/*
				.Value
					(
					new Value ()
						.Type (Value.SET)
					);
				*/
	Selector
		criteria =
			new Selection ()
				.Classification (true)
				.Specific (false);
				/*
				.Value (true)
				.Type (true)
				.And (true);
				*/
	Value_View
		view,
		previous_view = null;
	View_Locator
		locator = new View_Locator ();

	while ((parameter = parameters.Find
			(test_parameter, criteria, parameter))
			!= null)
		{
		view = new Value_View (parameter.Path_Name (), parameter.Value ());

		//	Set the new screen location.
		if (previous_view == null)
			view.setLocation (DEFAULT_INITIAL_LOCATION);
		else
			locator.Relocate (view, previous_view);
		view.setVisible (true);
		previous_view = view;
		}

	if (_Total_Displays_ == 0)
		{
		System.out.println ("No Array Value found.");
		System.exit (1);
		}
	}
catch (Exception exception)
	{
	System.err.println (exception.getMessage ());
	System.exit (-1);
	}
}


}
