/*
 * Picviz - Parallel coordinates ploter
 * Copyright (C) 2008 Sebastien Tricaud <toady@gscore.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $Id$
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <picviz.h>
#include <cairo.h>

#include "../props/color.h"


void output(PicvizImage *image, char *arg _U_)
{
	PicvizAxis *axis;
	PicvizAxisPlot *axisplot;
	PicvizLine *line;
	PcvCounter axisnb = 0;

	printf("header {\n    Title=\"Picviz autogenerated graph\";\n}\n\n");

	printf("axis {\n");
	/* Draw each axis and header titles */
	llist_for_each_entry(axis, &image->axes, list) {
		char *buf = picviz_properties_get(axis->props, "label");
		if (!strcmp(buf,"")) {
			printf("    %s axis%llu;\n", picviz_axis_get_string_from_type(axis), axis->id);
		} else {
			printf("    %s axis%llu [label=\"%s\"];\n", picviz_axis_get_string_from_type(axis), axis->id, buf);
		}
		axisnb++;
	}
	printf("}\n\n");

	printf("data {\n");
	llist_for_each_entry(line, &image->lines, list) {
		if ( ! line->hidden ) {
			char *color;
			char *penwidth;
			PcvCounter counter = 0;
			int first = 1;

			color = picviz_properties_get(line->props, "color");
			penwidth = picviz_properties_get(line->props, "penwidth");

			llist_for_each_entry(axisplot, &line->axisplot, list) {
				counter++;
				if (axisnb == counter) {
					printf("axis%llu=\"%s\";", counter, axisplot->strval);
				}
				else {
					if (first) {
						printf("    axis%llu=\"%s\", ", counter, axisplot->strval);
						first = 0;
					} else {
						printf("axis%llu=\"%s\", ", counter, axisplot->strval);
					}
				}
			}
			printf("\n");

		}
	}
	printf("}\n");

}


