/*
 * window_main_bgst.h
 * Copyright (C) Martin Singer 2009-2013 <m_power3@users.sourceforge.net>
 * 
 * pdfchain is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * pdfchain is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __PDFCHAIN_WINDOW_MAIN_BGST_H__
#define __PDFCHAIN_WINDOW_MAIN_BGST_H__

#include "pdfchain.h"
#include "dialog_filechooser.h"


/*** Section : Background / Stamp *********************************************/

class
cSection_BgSt : public Gtk::Table
{
	public:
		         cSection_BgSt( Gtk::Window& );
		virtual ~cSection_BgSt();

		void clear();
		std::string createCommand();
		
	private:

//		guint vPageNumbers_SourceFile,
		guint vPageNumbers_BgStFile;

		Gtk::HBox             mHBox_Insert;
		Gtk::Label            mLabel_SourceFile,
		                      mLabel_BgStFile,
		                      mLabel_Insert,
		                      mLabel_Multiple;
		cFCButton_Pdf         mFCButton_SourceFile,
		                      mFCButton_BgStFile;
		Gtk::RadioButton      mRButton_Background,
		                      mRButton_Stamp;
		Gtk::RadioButtonGroup mRBGroup_BgSt;
		Gtk::Switch           mSwitch_Multiple;
//		cFCDialog_SaveAs      mFCDialog_SaveAs;
		cFCDialog_SaveAs_Pdf  mFCDialog_SaveAs;


		void init();

//		void onFCButton_SourceFile_file_set() {
//			vPageNumbers_SourceFile = Pdfchain::count_page_numbers(
//				mFCButton_SourceFile.get_filename() );
//			return;
//		}

		void onFCButton_BgStFile_file_set()
		{
			vPageNumbers_BgStFile =
				Pdfchain::count_page_numbers( mFCButton_BgStFile.get_filename() );

			if ( 1 < vPageNumbers_BgStFile )
				mSwitch_Multiple.set_active( true );
			else
				mSwitch_Multiple.set_active( false );
				
			return;
		}
};


#endif
