/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.input.dis;

import javax.vecmath.Vector3d;
import org.web3d.vrml.renderer.common.input.dis.Solver;
import org.web3d.vrml.renderer.common.input.dis.Vector3dVariable;

public class OrderNVector3dConverger {
    private int convergenceInterval;
    private Solver solver;
    private Vector3dVariable primaryVariable;
    private Vector3dVariable secondaryVariable;
    private Vector3dVariable tertiaryVariable;
    private boolean converging;
    private long convergenceStartTime;

    public OrderNVector3dConverger(int n, int n2, Solver solver) {
        this.convergenceInterval = n2;
        this.solver = solver;
        this.primaryVariable = new Vector3dVariable(n, this.solver);
        this.secondaryVariable = new Vector3dVariable(n, this.solver);
        this.tertiaryVariable = new Vector3dVariable(n, this.solver);
    }

    public void setValueAndDerivatives(Vector3d vector3d, Vector3d[] vector3dArray, long l) {
        this.primaryVariable.set(vector3d, vector3dArray, l);
        this.converging = false;
    }

    private void makeCurrent(long l) {
        if (!this.converging) {
            this.primaryVariable.makeCurrent(l);
        } else if (l - this.convergenceStartTime > (long)this.convergenceInterval) {
            this.converging = false;
            this.primaryVariable.set(this.tertiaryVariable);
            this.primaryVariable.makeCurrent(l);
        } else {
            double d = (double)(l - this.convergenceStartTime) / (double)this.convergenceInterval;
            double d2 = -2.0 * d * d * d + 3.0 * d * d;
            this.primaryVariable.interpolate(this.secondaryVariable, this.tertiaryVariable, d2, l);
        }
    }

    public void getValue(long l, Vector3d vector3d) {
        this.makeCurrent(l);
        this.primaryVariable.getValue(vector3d);
    }

    public void getDerivatives(long l, Vector3d[] vector3dArray) {
        this.makeCurrent(l);
        this.primaryVariable.getDerivatives(vector3dArray);
    }

    public void convergeTo(Vector3d vector3d, Vector3d[] vector3dArray, long l, long l2) {
        this.makeCurrent(l2);
        this.secondaryVariable.set(this.primaryVariable);
        this.tertiaryVariable.set(vector3d, vector3dArray, l);
        this.converging = true;
        this.convergenceStartTime = l2;
    }

    public boolean isConverging() {
        return this.converging;
    }
}

