/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.eventutils;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLChildNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public class BaseBooleanToggle
extends AbstractNode
implements VRMLChildNodeType {
    protected static final int FIELD_SET_BOOLEAN = 1;
    protected static final int FIELD_TOGGLE = 2;
    protected static final int LAST_BOOLEAN_TOGGLE_INDEX = 2;
    protected static final int NUM_FIELDS = 3;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    private boolean vfToggle;

    public BaseBooleanToggle() {
        super("BooleanToggle");
        this.hasChanged = new boolean[3];
        this.vfToggle = false;
    }

    public BaseBooleanToggle(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("toggle");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfToggle = vRMLFieldData.booleanValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 2) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 7;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfToggle;
                vRMLFieldData.dataType = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfToggle);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseBooleanToggle.sendRoute: InvalidField: " + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("BaseBooleanToggle.sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.setBoolean(bl);
                break;
            }
            case 2: {
                this.setToggle(bl);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    private void setBoolean(boolean bl) {
        if (bl) {
            boolean bl2 = this.vfToggle = !this.vfToggle;
            if (!this.inSetup) {
                this.hasChanged[2] = true;
                this.fireFieldChanged(2);
            }
        }
    }

    private void setToggle(boolean bl) {
        this.vfToggle = bl;
        if (!this.inSetup) {
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[3];
        fieldMap = new HashMap(9);
        BaseBooleanToggle.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseBooleanToggle.fieldDecl[1] = new VRMLFieldDeclaration(1, "SFBool", "set_boolean");
        BaseBooleanToggle.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFBool", "toggle");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("set_boolean", n);
        n = new Integer(2);
        fieldMap.put("toggle", n);
        fieldMap.put("set_toggle", n);
        fieldMap.put("toggle_changed", n);
    }
}

