/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.extensions;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLChildNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public class BaseClipPlane
extends AbstractNode
implements VRMLChildNodeType {
    private static final int FIELD_ENABLED = 1;
    private static final int FIELD_PLANE = 2;
    private static final int LAST_CLIPPLANE_INDEX = 2;
    private static final int NUM_FIELDS = 3;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected boolean vfEnabled;
    protected double[] vfPlane;

    public BaseClipPlane() {
        super("ClipPlane");
        this.hasChanged = new boolean[3];
        this.vfPlane = new double[]{0.0, 1.0, 0.0, 0.0};
        this.vfEnabled = true;
    }

    public BaseClipPlane(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("plane");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfPlane[0] = vRMLFieldData.doubleArrayValue[0];
            this.vfPlane[1] = vRMLFieldData.doubleArrayValue[1];
            this.vfPlane[2] = vRMLFieldData.doubleArrayValue[2];
            this.vfPlane[3] = vRMLFieldData.doubleArrayValue[3];
            n = vRMLNodeType.getFieldIndex("enabled");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEnabled = vRMLFieldData.booleanValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 2) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 67;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.doubleArrayValue = this.vfPlane;
                vRMLFieldData.dataType = (short)12;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfEnabled;
                vRMLFieldData.dataType = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfEnabled);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfPlane, 4);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field! " + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.setEnabled(bl);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, double[] dArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 2: {
                this.setPlane(dArray);
                break;
            }
            default: {
                super.setValue(n, dArray, n2);
            }
        }
    }

    protected void setEnabled(boolean bl) {
        if (bl != this.vfEnabled) {
            this.vfEnabled = bl;
            if (!this.inSetup) {
                this.hasChanged[1] = true;
                this.fireFieldChanged(1);
            }
        }
    }

    protected void setPlane(double[] dArray) throws InvalidFieldValueException {
        this.vfPlane[0] = dArray[0];
        this.vfPlane[1] = dArray[1];
        this.vfPlane[2] = dArray[2];
        this.vfPlane[3] = dArray[3];
        if (!this.inSetup) {
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[3];
        fieldMap = new HashMap(3);
        BaseClipPlane.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseClipPlane.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BaseClipPlane.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFVec4d", "plane");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        n = new Integer(2);
        fieldMap.put("plane", n);
        fieldMap.put("set_plane", n);
        fieldMap.put("plane_changed", n);
    }
}

