/*
  Copyright (C) 2008 André Gaul, Jan Friederich, Steffen Basting, Kai Hertel

        This file is part of mmpong.

        mmpong is free software: you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version.

        mmpong is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with mmpong.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __RESOURCE_H__
#define __RESOURCE_H__

#include "config.h"

#if defined(__APPLE__)
	// Mac OS X: resources are located in app bundle 
	// (create path from argv[0])
#	define RESOURCE_MAXLEN 256
	const char * get_resource(const char *name);
# undef RESOURCE_MAXLEN
#	define RESOURCE(res) get_resource(res)

#elif defined(WIN32)
	// Windows: resources are located in same dir as EXE
#	define RESOURCE(res) res

#else
	// UNIX: resource dir is defined by build system flag RESPATH
#	define RESOURCE(res) (RESPATH res)
#endif

#endif
