#ifndef SLIST_H
#define SLIST_H

/*
 * SList.h
 *
 * SOFTWARE RIGHTS
 *
 * We reserve no LEGAL rights to SORCERER -- SORCERER is in the public
 * domain.  An individual or company may do whatever they wish with
 * source code distributed with SORCERER or the code generated by
 * SORCERER, including the incorporation of SORCERER, or its output, into
 * commerical software.
 *
 * We encourage users to develop software with SORCERER.  However, we do
 * ask that credit is given to us for developing SORCERER.  By "credit",
 * we mean that if you incorporate our source code into one of your
 * programs (commercial product, research project, or otherwise) that you
 * acknowledge this fact somewhere in the documentation, research report,
 * etc...  If you like SORCERER and have developed a nice tool with the
 * output, please mention that you developed it using SORCERER.  In
 * addition, we ask that this header remain intact in our source code.
 * As long as these guidelines are kept, we expect to continue enhancing
 * this system and expect to make other tools available as they are
 * completed.
 *
 * SORCERER 1.00B
 * Terence Parr
 * AHPCRC, University of Minnesota
 * 1992-1994
 */

#include "sorcerer.h"

typedef struct _SList {
			void *elem;			/* pointer to any kind of element */
			struct _SList *next;
		} SList;

#define newSList	(SList *) calloc(1, sizeof(SList));

#ifdef __USE_PROTOS
extern void *slist_iterate(SList *list, SList **);
extern void slist_add( SList **list, void *e );
extern void slist_free(SList *list);
#else
extern void *slist_iterate();
extern void slist_add();
extern void slist_free();
#endif

#endif
