/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
/************ Begin %include sections from the grammar ************************/
#line 4 "grn_ecmascript.lemon"

#ifdef assert
#  undef assert
#endif
#define assert GRN_ASSERT
#line 34 "grn_ecmascript.c"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    grn_expr_parserTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is grn_expr_parserTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    grn_expr_parserARG_SDECL     A static variable declaration for the %extra_argument
**    grn_expr_parserARG_PDECL     A parameter declaration for the %extra_argument
**    grn_expr_parserARG_STORE     Code to store %extra_argument into yypParser
**    grn_expr_parserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned char
#define YYNOCODE 116
#define YYACTIONTYPE unsigned short int
#define grn_expr_parserTOKENTYPE  int 
typedef union {
  int yyinit;
  grn_expr_parserTOKENTYPE yy0;
  void * yy165;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define grn_expr_parserARG_SDECL  efs_info *efsi ;
#define grn_expr_parserARG_PDECL , efs_info *efsi 
#define grn_expr_parserARG_FETCH  efs_info *efsi  = yypParser->efsi 
#define grn_expr_parserARG_STORE yypParser->efsi  = efsi 
#define YYNSTATE             147
#define YYNRULE              137
#define YY_MAX_SHIFT         146
#define YY_MIN_SHIFTREDUCE   234
#define YY_MAX_SHIFTREDUCE   370
#define YY_MIN_REDUCE        371
#define YY_MAX_REDUCE        507
#define YY_ERROR_ACTION      508
#define YY_ACCEPT_ACTION     509
#define YY_NO_ACTION         510
/************* End control #defines *******************************************/

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if:
**    (1)  The yy_shift_ofst[S]+X value is out of range, or
**    (2)  yy_lookahead[yy_shift_ofst[S]+X] is not equal to X, or
**    (3)  yy_shift_ofst[S] equal YY_SHIFT_USE_DFLT.
** (Implementation note: YY_SHIFT_USE_DFLT is chosen so that
** YY_SHIFT_USE_DFLT+X will be out of range for all possible lookaheads X.
** Hence only tests (1) and (2) need to be evaluated.)
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (1807)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */     3,   73,  117,  117,  138,  133,  326,    2,  366,   55,
 /*    10 */    84,  131,    1,  371,   72,  509,   80,  114,   10,  380,
 /*    20 */    80,   76,  114,  114,   92,  128,  127,  141,  140,  139,
 /*    30 */   122,   89,  105,  118,  106,  106,  106,   92,   76,  380,
 /*    40 */   380,   76,   76,  326,   75,  461,   85,   84,  146,    9,
 /*    50 */   375,   72,  374,   67,   66,   54,   53,   52,   70,   69,
 /*    60 */    68,   65,   64,   62,   61,   60,  351,  352,  353,  354,
 /*    70 */   355,    4,  129,   71,   59,   58,   76,  129,  129,   92,
 /*    80 */   128,  127,  141,  140,  139,  122,   89,  105,  118,  106,
 /*    90 */   106,  106,   92,   76,   79,  460,   76,   76,   79,   77,
 /*   100 */   117,  117,  138,  378,  326,    2,  503,   55,   84,  131,
 /*   110 */     1,    5,   72,   79,  120,  112,   83,   79,   76,  120,
 /*   120 */   120,   92,  128,  127,  141,  140,  139,  122,   89,  105,
 /*   130 */   118,  106,  106,  106,   92,   76,  455,  135,   76,   76,
 /*   140 */     7,  303,   63,   78,  349,   74,  112,  135,  307,  439,
 /*   150 */   483,   67,   66,  502,  138,   23,   70,   69,   68,   65,
 /*   160 */    64,   62,   61,   60,  351,  352,  353,  354,  355,    4,
 /*   170 */    51,   50,   49,   48,   47,   46,   45,   44,   43,   42,
 /*   180 */    41,   40,   39,   38,   37,  377,   67,   66,  315,   57,
 /*   190 */    56,   70,   69,   68,   65,   64,   62,   61,   60,  351,
 /*   200 */   352,  353,  354,  355,    4,  113,  376,  316,   76,  454,
 /*   210 */   454,   92,  128,  127,  141,  140,  139,  122,   89,  105,
 /*   220 */   118,  106,  106,  106,   92,   76,   31,   30,   76,   76,
 /*   230 */     6,  373,  359,   36,   35,  372,  449,   76,   88,   88,
 /*   240 */    92,  128,  127,  141,  140,  139,  122,   89,  105,  118,
 /*   250 */   106,  106,  106,   92,   76,  348,  132,   76,   76,   11,
 /*   260 */    88,    7,   28,   63,  320,  349,   74,  319,  242,  360,
 /*   270 */    28,   76,  454,  454,   92,  128,  127,  141,  140,  139,
 /*   280 */   122,   89,  105,  118,  106,  106,  106,   92,   76,  358,
 /*   290 */   459,   76,   76,  134,    8,   32,  137,   28,  367,  451,
 /*   300 */   300,  301,   24,   34,   25,   33,   28,   67,   66,  373,
 /*   310 */   373,  373,   70,   69,   68,   65,   64,   62,   61,   60,
 /*   320 */   351,  352,  353,  354,  355,    4,  357,    7,  373,   63,
 /*   330 */   373,  349,   74,  373,  373,  360,   76,  446,  446,   92,
 /*   340 */   128,  127,  141,  140,  139,  122,   89,  105,  118,  106,
 /*   350 */   106,  106,   92,   76,  306,  373,   76,   76,  373,  373,
 /*   360 */   373,  373,  373,  116,  373,  373,  373,  373,  373,  373,
 /*   370 */   373,  373,    7,   67,   66,  373,  349,   74,   70,   69,
 /*   380 */    68,   65,   64,   62,   61,   60,  351,  352,  353,  354,
 /*   390 */   355,    4,  356,    7,  373,   63,  373,  349,   74,   29,
 /*   400 */   120,  359,  373,  373,   76,  120,  120,   92,  128,  127,
 /*   410 */   141,  140,  139,  122,   89,  105,  118,  106,  106,  106,
 /*   420 */    92,   76,  373,   26,   76,   76,  373,  373,  373,  373,
 /*   430 */   373,  351,  352,  353,  354,  355,    4,  373,  373,   67,
 /*   440 */    66,  373,  373,  373,   70,   69,   68,   65,   64,   62,
 /*   450 */    61,   60,  351,  352,  353,  354,  355,    4,  373,  123,
 /*   460 */   373,  373,  373,   76,  123,  123,   92,  128,  127,  141,
 /*   470 */   140,  139,  122,   89,  105,  118,  106,  106,  106,   92,
 /*   480 */    76,  129,  373,   76,   76,   76,  129,  129,   92,  128,
 /*   490 */   127,  141,  140,  139,  122,   89,  105,  118,  106,  106,
 /*   500 */   106,   92,   76,  373,  373,   76,   76,    7,  373,   63,
 /*   510 */   373,  349,   74,  373,  373,  373,  373,  373,  373,  373,
 /*   520 */   373,  373,  373,  373,   76,  500,  500,   92,  128,  127,
 /*   530 */   141,  140,  139,  122,   89,  105,  118,  106,  106,  106,
 /*   540 */    92,   76,  373,  373,   76,   76,  373,  373,  373,  373,
 /*   550 */   373,  373,  373,   67,   66,  373,  373,  373,   70,   69,
 /*   560 */    68,   65,   64,   62,   61,   60,  351,  352,  130,  354,
 /*   570 */   355,    4,    7,  373,   63,  373,  349,   74,   76,  499,
 /*   580 */   499,   92,  128,  127,  141,  140,  139,  122,   89,  105,
 /*   590 */   118,  106,  106,  106,   92,   76,  373,  373,   76,   76,
 /*   600 */   373,  373,  373,   87,   86,   82,   81,  326,   75,  327,
 /*   610 */    85,   84,  146,    9,  373,   72,  373,  373,   67,   66,
 /*   620 */   373,  373,  373,   70,   69,   68,   65,   64,   62,   61,
 /*   630 */    60,  351,  352,  353,  354,  355,    4,  373,   76,  393,
 /*   640 */   393,   92,  128,  127,  141,  140,  139,  122,   89,  105,
 /*   650 */   118,  106,  106,  106,   92,   76,  373,  373,   76,   76,
 /*   660 */   373,   76,  392,  392,   92,  128,  127,  141,  140,  139,
 /*   670 */   122,   89,  105,  118,  106,  106,  106,   92,   76,  373,
 /*   680 */   373,   76,   76,   76,  391,  391,   92,  128,  127,  141,
 /*   690 */   140,  139,  122,   89,  105,  118,  106,  106,  106,   92,
 /*   700 */    76,  373,  373,   76,   76,  373,  373,  373,   76,  390,
 /*   710 */   390,   92,  128,  127,  141,  140,  139,  122,   89,  105,
 /*   720 */   118,  106,  106,  106,   92,   76,  373,  373,   76,   76,
 /*   730 */    76,  389,  389,   92,  128,  127,  141,  140,  139,  122,
 /*   740 */    89,  105,  118,  106,  106,  106,   92,   76,  373,  373,
 /*   750 */    76,   76,   76,  388,  388,   92,  128,  127,  141,  140,
 /*   760 */   139,  122,   89,  105,  118,  106,  106,  106,   92,   76,
 /*   770 */   373,  373,   76,   76,   76,  387,  387,   92,  128,  127,
 /*   780 */   141,  140,  139,  122,   89,  105,  118,  106,  106,  106,
 /*   790 */    92,   76,  373,  373,   76,   76,   76,  386,  386,   92,
 /*   800 */   128,  127,  141,  140,  139,  122,   89,  105,  118,  106,
 /*   810 */   106,  106,   92,   76,  373,  373,   76,   76,   76,  385,
 /*   820 */   385,   92,  128,  127,  141,  140,  139,  122,   89,  105,
 /*   830 */   118,  106,  106,  106,   92,   76,  373,  373,   76,   76,
 /*   840 */    76,  384,  384,   92,  128,  127,  141,  140,  139,  122,
 /*   850 */    89,  105,  118,  106,  106,  106,   92,   76,  373,  373,
 /*   860 */    76,   76,   76,  383,  383,   92,  128,  127,  141,  140,
 /*   870 */   139,  122,   89,  105,  118,  106,  106,  106,   92,   76,
 /*   880 */   373,  373,   76,   76,   76,  447,  447,   92,  128,  127,
 /*   890 */   141,  140,  139,  122,   89,  105,  118,  106,  106,  106,
 /*   900 */    92,   76,  373,  373,   76,   76,   76,  442,  442,   92,
 /*   910 */   128,  127,  141,  140,  139,  122,   89,  105,  118,  106,
 /*   920 */   106,  106,   92,   76,  373,  373,   76,   76,   76,  394,
 /*   930 */   394,   92,  128,  127,  141,  140,  139,  122,   89,  105,
 /*   940 */   118,  106,  106,  106,   92,   76,  373,  373,   76,   76,
 /*   950 */    76,  145,  145,   92,  128,  127,  141,  140,  139,  122,
 /*   960 */    89,  105,  118,  106,  106,  106,   92,   76,  373,  373,
 /*   970 */    76,   76,   76,  382,  382,   92,  128,  127,  141,  140,
 /*   980 */   139,  122,   89,  105,  118,  106,  106,  106,   92,   76,
 /*   990 */   373,  373,   76,   76,   76,  381,  381,   92,  128,  127,
 /*  1000 */   141,  140,  139,  122,   89,  105,  118,  106,  106,  106,
 /*  1010 */    92,   76,  373,   76,   76,   76,  124,  373,  115,  141,
 /*  1020 */   140,  139,  122,   89,  105,  118,  106,  106,  106,  124,
 /*  1030 */    76,  373,  373,   76,   76,   76,  373,  373,  124,  373,
 /*  1040 */   373,  136,  140,  139,  122,   89,  105,  118,  106,  106,
 /*  1050 */   106,  124,   76,  373,  373,   76,   76,   76,  373,  373,
 /*  1060 */   124,  373,  373,  144,  140,  139,  122,   89,  105,  118,
 /*  1070 */   106,  106,  106,  124,   76,  373,  373,   76,   76,   76,
 /*  1080 */   373,  373,  124,  373,  373,  373,  143,  139,  122,   89,
 /*  1090 */   105,  118,  106,  106,  106,  124,   76,  373,   76,   76,
 /*  1100 */    76,  124,  373,  373,  373,  373,  142,  122,   89,  105,
 /*  1110 */   118,  106,  106,  106,  124,   76,  373,  373,   76,   76,
 /*  1120 */   373,  373,  373,  373,   27,   22,   21,   20,   19,   18,
 /*  1130 */    17,   16,   15,   14,   13,   12,   76,  373,  373,  124,
 /*  1140 */   373,  373,  373,  373,  373,  126,   89,  105,  118,  106,
 /*  1150 */   106,  106,  124,   76,  373,  373,   76,   76,  373,   76,
 /*  1160 */   373,  373,  124,  373,  373,  373,  373,  300,  301,   90,
 /*  1170 */   105,  118,  106,  106,  106,  124,   76,  373,   76,   76,
 /*  1180 */    76,  124,  373,  373,  373,  373,  373,  373,   91,  105,
 /*  1190 */   118,  106,  106,  106,  124,   76,  373,  373,   76,   76,
 /*  1200 */   458,  373,  373,   87,   86,   82,   81,  326,   75,  373,
 /*  1210 */    85,   84,  146,    9,   76,   72,  373,  124,  373,  373,
 /*  1220 */   373,  373,  373,  373,  373,   93,  118,  106,  106,  106,
 /*  1230 */   124,   76,  373,   76,   76,   76,  124,  373,  373,  373,
 /*  1240 */   373,  373,  373,  373,   94,  118,  106,  106,  106,  124,
 /*  1250 */    76,  373,   76,   76,   76,  124,  373,  373,  373,  373,
 /*  1260 */   373,  373,  373,   95,  118,  106,  106,  106,  124,   76,
 /*  1270 */   373,  373,   76,   76,   76,  373,  373,  124,  373,  373,
 /*  1280 */   373,  373,  373,  373,  373,   96,  118,  106,  106,  106,
 /*  1290 */   124,   76,  373,   76,   76,   76,  124,  373,  373,  373,
 /*  1300 */   373,  373,  373,  373,   97,  118,  106,  106,  106,  124,
 /*  1310 */    76,  373,   76,   76,   76,  124,  373,  373,  373,  373,
 /*  1320 */   373,  373,  373,   98,  118,  106,  106,  106,  124,   76,
 /*  1330 */   373,   76,   76,   76,  124,  373,  373,  373,  373,  373,
 /*  1340 */   373,  373,   99,  118,  106,  106,  106,  124,   76,  373,
 /*  1350 */    76,   76,   76,  124,  373,  373,  373,  373,  373,  373,
 /*  1360 */   373,  100,  118,  106,  106,  106,  124,   76,  373,  373,
 /*  1370 */    76,   76,   76,  373,  373,  124,  373,  373,  373,  373,
 /*  1380 */   373,  373,  373,  101,  118,  106,  106,  106,  124,   76,
 /*  1390 */   373,   76,   76,   76,  124,  373,  373,  373,  373,  373,
 /*  1400 */   373,  373,  102,  118,  106,  106,  106,  124,   76,  373,
 /*  1410 */    76,   76,   76,  124,  373,  373,  373,  373,  373,  373,
 /*  1420 */   373,  103,  118,  106,  106,  106,  124,   76,  373,   76,
 /*  1430 */    76,   76,  124,  373,  373,  373,  373,  373,  373,  373,
 /*  1440 */   104,  118,  106,  106,  106,  124,   76,  373,   76,   76,
 /*  1450 */    76,  124,  373,  373,  373,  373,  373,  373,  373,  107,
 /*  1460 */   118,  106,  106,  106,  124,   76,  373,  373,   76,   76,
 /*  1470 */    76,  373,  373,  124,  373,  373,  373,  373,  373,  373,
 /*  1480 */   373,  109,  118,  106,  106,  106,  124,   76,  373,   76,
 /*  1490 */    76,   76,  124,  373,  373,  373,  373,  373,  373,  373,
 /*  1500 */   111,  118,  106,  106,  106,  124,   76,  373,   76,   76,
 /*  1510 */    76,  124,  373,  373,  373,  373,  373,  373,  373,  373,
 /*  1520 */   119,  106,  106,  106,  124,   76,  373,   76,   76,   76,
 /*  1530 */   124,  373,  373,  373,  373,  373,  373,  373,  373,  121,
 /*  1540 */   106,  106,  106,  124,   76,  373,   76,   76,   76,  124,
 /*  1550 */   373,  373,  373,  376,   76,  373,  373,  124,  125,  106,
 /*  1560 */   106,  106,  124,   76,  373,  373,   76,   76,  433,  433,
 /*  1570 */   124,   76,  373,  373,   76,   76,   76,  373,  373,  124,
 /*  1580 */   373,  373,  373,  373,  373,   76,  373,  373,  124,  108,
 /*  1590 */   108,  108,  124,   76,  373,  373,   76,   76,  110,  110,
 /*  1600 */   110,  124,   76,  373,  373,   76,   76,   76,  373,  373,
 /*  1610 */   124,  373,  373,  373,  373,   76,  373,  373,  124,  373,
 /*  1620 */   373,  425,  425,  124,   76,  373,  373,   76,   76,  424,
 /*  1630 */   424,  124,   76,  373,   76,   76,   76,  124,  373,  373,
 /*  1640 */   373,  373,   76,  373,  373,  124,  373,  373,  436,  436,
 /*  1650 */   124,   76,  373,  373,   76,   76,  435,  435,  124,   76,
 /*  1660 */   373,   76,   76,   76,  124,  373,  373,  373,  373,  373,
 /*  1670 */    76,  373,  373,  124,  373,  434,  434,  124,   76,  373,
 /*  1680 */   373,   76,   76,  373,  433,  433,  124,   76,  373,  373,
 /*  1690 */    76,   76,   76,  373,  373,  124,  373,  373,  373,  373,
 /*  1700 */    76,  373,  373,  124,  373,  373,  432,  432,  124,   76,
 /*  1710 */   373,  373,   76,   76,  431,  431,  124,   76,  373,   76,
 /*  1720 */    76,   76,  124,  373,  373,  373,  373,   76,  373,  373,
 /*  1730 */   124,  373,  373,  430,  430,  124,   76,  373,  373,   76,
 /*  1740 */    76,  429,  429,  124,   76,  373,   76,   76,   76,  124,
 /*  1750 */   373,  373,  373,  373,  373,   76,  373,  373,  124,  373,
 /*  1760 */   428,  428,  124,   76,  373,  373,   76,   76,  373,  427,
 /*  1770 */   427,  124,   76,  373,  373,   76,   76,   76,  373,  373,
 /*  1780 */   124,  373,  373,  373,  373,   76,  373,  373,  124,  373,
 /*  1790 */   373,  426,  426,  124,   76,  373,  373,   76,   76,  423,
 /*  1800 */   423,  124,   76,  373,  373,   76,   76,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */     1,    2,  108,  109,  110,   12,    7,    8,   69,   10,
 /*    10 */    11,   12,   13,   83,   15,   78,   79,   80,  106,   84,
 /*    20 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*    30 */    93,   94,   95,   96,   97,   98,   99,  100,  101,  104,
 /*    40 */   105,  104,  105,    7,    8,    0,   10,   11,   12,   13,
 /*    50 */    83,   15,   83,   54,   55,   51,   52,   53,   59,   60,
 /*    60 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*    70 */    71,   72,   80,   56,   57,   58,   84,   85,   86,   87,
 /*    80 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*    90 */    98,   99,  100,  101,   79,    0,  104,  105,   83,   54,
 /*   100 */   108,  109,  110,   83,    7,    8,   30,   10,   11,   12,
 /*   110 */    13,   16,   15,   79,   80,   82,   11,   83,   84,   85,
 /*   120 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*   130 */    96,   97,   98,   99,  100,  101,  113,  114,  104,  105,
 /*   140 */     8,   14,   10,   16,   12,   13,  113,  114,    9,  102,
 /*   150 */   103,   54,   55,  109,  110,   16,   59,   60,   61,   62,
 /*   160 */    63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   170 */    36,   37,   38,   39,   40,   41,   42,   43,   44,   45,
 /*   180 */    46,   47,   48,   49,   50,   83,   54,   55,   56,   54,
 /*   190 */    55,   59,   60,   61,   62,   63,   64,   65,   66,   67,
 /*   200 */    68,   69,   70,   71,   72,   81,   83,   75,   84,   85,
 /*   210 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*   220 */    96,   97,   98,   99,  100,  101,    3,    4,  104,  105,
 /*   230 */     8,   83,   16,   34,   35,   83,  112,   84,   85,   86,
 /*   240 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   250 */    97,   98,   99,  100,  101,    9,   41,  104,  105,  106,
 /*   260 */   107,    8,   16,   10,   69,   12,   13,   67,   14,   16,
 /*   270 */    16,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   280 */    93,   94,   95,   96,   97,   98,   99,  100,  101,   73,
 /*   290 */     0,  104,  105,   56,   72,   31,   74,   16,   12,  112,
 /*   300 */    60,   61,   30,   33,   30,   32,   16,   54,   55,  115,
 /*   310 */   115,  115,   59,   60,   61,   62,   63,   64,   65,   66,
 /*   320 */    67,   68,   69,   70,   71,   72,   73,    8,  115,   10,
 /*   330 */   115,   12,   13,  115,  115,   16,   84,   85,   86,   87,
 /*   340 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*   350 */    98,   99,  100,  101,   73,  115,  104,  105,  115,  115,
 /*   360 */   115,  115,  115,  111,  115,  115,  115,  115,  115,  115,
 /*   370 */   115,  115,    8,   54,   55,  115,   12,   13,   59,   60,
 /*   380 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   390 */    71,   72,   73,    8,  115,   10,  115,   12,   13,    5,
 /*   400 */    80,   16,  115,  115,   84,   85,   86,   87,   88,   89,
 /*   410 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*   420 */   100,  101,  115,   29,  104,  105,  115,  115,  115,  115,
 /*   430 */   115,   67,   68,   69,   70,   71,   72,  115,  115,   54,
 /*   440 */    55,  115,  115,  115,   59,   60,   61,   62,   63,   64,
 /*   450 */    65,   66,   67,   68,   69,   70,   71,   72,  115,   80,
 /*   460 */   115,  115,  115,   84,   85,   86,   87,   88,   89,   90,
 /*   470 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  100,
 /*   480 */   101,   80,  115,  104,  105,   84,   85,   86,   87,   88,
 /*   490 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*   500 */    99,  100,  101,  115,  115,  104,  105,    8,  115,   10,
 /*   510 */   115,   12,   13,  115,  115,  115,  115,  115,  115,  115,
 /*   520 */   115,  115,  115,  115,   84,   85,   86,   87,   88,   89,
 /*   530 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*   540 */   100,  101,  115,  115,  104,  105,  115,  115,  115,  115,
 /*   550 */   115,  115,  115,   54,   55,  115,  115,  115,   59,   60,
 /*   560 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   570 */    71,   72,    8,  115,   10,  115,   12,   13,   84,   85,
 /*   580 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*   590 */    96,   97,   98,   99,  100,  101,  115,  115,  104,  105,
 /*   600 */   115,  115,  115,    3,    4,    5,    6,    7,    8,    9,
 /*   610 */    10,   11,   12,   13,  115,   15,  115,  115,   54,   55,
 /*   620 */   115,  115,  115,   59,   60,   61,   62,   63,   64,   65,
 /*   630 */    66,   67,   68,   69,   70,   71,   72,  115,   84,   85,
 /*   640 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*   650 */    96,   97,   98,   99,  100,  101,  115,  115,  104,  105,
 /*   660 */   115,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   670 */    93,   94,   95,   96,   97,   98,   99,  100,  101,  115,
 /*   680 */   115,  104,  105,   84,   85,   86,   87,   88,   89,   90,
 /*   690 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  100,
 /*   700 */   101,  115,  115,  104,  105,  115,  115,  115,   84,   85,
 /*   710 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*   720 */    96,   97,   98,   99,  100,  101,  115,  115,  104,  105,
 /*   730 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*   740 */    94,   95,   96,   97,   98,   99,  100,  101,  115,  115,
 /*   750 */   104,  105,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   760 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
 /*   770 */   115,  115,  104,  105,   84,   85,   86,   87,   88,   89,
 /*   780 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*   790 */   100,  101,  115,  115,  104,  105,   84,   85,   86,   87,
 /*   800 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*   810 */    98,   99,  100,  101,  115,  115,  104,  105,   84,   85,
 /*   820 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*   830 */    96,   97,   98,   99,  100,  101,  115,  115,  104,  105,
 /*   840 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*   850 */    94,   95,   96,   97,   98,   99,  100,  101,  115,  115,
 /*   860 */   104,  105,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   870 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
 /*   880 */   115,  115,  104,  105,   84,   85,   86,   87,   88,   89,
 /*   890 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*   900 */   100,  101,  115,  115,  104,  105,   84,   85,   86,   87,
 /*   910 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*   920 */    98,   99,  100,  101,  115,  115,  104,  105,   84,   85,
 /*   930 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*   940 */    96,   97,   98,   99,  100,  101,  115,  115,  104,  105,
 /*   950 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*   960 */    94,   95,   96,   97,   98,   99,  100,  101,  115,  115,
 /*   970 */   104,  105,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   980 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
 /*   990 */   115,  115,  104,  105,   84,   85,   86,   87,   88,   89,
 /*  1000 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*  1010 */   100,  101,  115,   84,  104,  105,   87,  115,   89,   90,
 /*  1020 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  100,
 /*  1030 */   101,  115,  115,  104,  105,   84,  115,  115,   87,  115,
 /*  1040 */   115,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*  1050 */    99,  100,  101,  115,  115,  104,  105,   84,  115,  115,
 /*  1060 */    87,  115,  115,   90,   91,   92,   93,   94,   95,   96,
 /*  1070 */    97,   98,   99,  100,  101,  115,  115,  104,  105,   84,
 /*  1080 */   115,  115,   87,  115,  115,  115,   91,   92,   93,   94,
 /*  1090 */    95,   96,   97,   98,   99,  100,  101,  115,   84,  104,
 /*  1100 */   105,   87,  115,  115,  115,  115,   92,   93,   94,   95,
 /*  1110 */    96,   97,   98,   99,  100,  101,  115,  115,  104,  105,
 /*  1120 */   115,  115,  115,  115,   17,   18,   19,   20,   21,   22,
 /*  1130 */    23,   24,   25,   26,   27,   28,   84,  115,  115,   87,
 /*  1140 */   115,  115,  115,  115,  115,   93,   94,   95,   96,   97,
 /*  1150 */    98,   99,  100,  101,  115,  115,  104,  105,  115,   84,
 /*  1160 */   115,  115,   87,  115,  115,  115,  115,   60,   61,   94,
 /*  1170 */    95,   96,   97,   98,   99,  100,  101,  115,   84,  104,
 /*  1180 */   105,   87,  115,  115,  115,  115,  115,  115,   94,   95,
 /*  1190 */    96,   97,   98,   99,  100,  101,  115,  115,  104,  105,
 /*  1200 */     0,  115,  115,    3,    4,    5,    6,    7,    8,  115,
 /*  1210 */    10,   11,   12,   13,   84,   15,  115,   87,  115,  115,
 /*  1220 */   115,  115,  115,  115,  115,   95,   96,   97,   98,   99,
 /*  1230 */   100,  101,  115,   84,  104,  105,   87,  115,  115,  115,
 /*  1240 */   115,  115,  115,  115,   95,   96,   97,   98,   99,  100,
 /*  1250 */   101,  115,   84,  104,  105,   87,  115,  115,  115,  115,
 /*  1260 */   115,  115,  115,   95,   96,   97,   98,   99,  100,  101,
 /*  1270 */   115,  115,  104,  105,   84,  115,  115,   87,  115,  115,
 /*  1280 */   115,  115,  115,  115,  115,   95,   96,   97,   98,   99,
 /*  1290 */   100,  101,  115,   84,  104,  105,   87,  115,  115,  115,
 /*  1300 */   115,  115,  115,  115,   95,   96,   97,   98,   99,  100,
 /*  1310 */   101,  115,   84,  104,  105,   87,  115,  115,  115,  115,
 /*  1320 */   115,  115,  115,   95,   96,   97,   98,   99,  100,  101,
 /*  1330 */   115,   84,  104,  105,   87,  115,  115,  115,  115,  115,
 /*  1340 */   115,  115,   95,   96,   97,   98,   99,  100,  101,  115,
 /*  1350 */    84,  104,  105,   87,  115,  115,  115,  115,  115,  115,
 /*  1360 */   115,   95,   96,   97,   98,   99,  100,  101,  115,  115,
 /*  1370 */   104,  105,   84,  115,  115,   87,  115,  115,  115,  115,
 /*  1380 */   115,  115,  115,   95,   96,   97,   98,   99,  100,  101,
 /*  1390 */   115,   84,  104,  105,   87,  115,  115,  115,  115,  115,
 /*  1400 */   115,  115,   95,   96,   97,   98,   99,  100,  101,  115,
 /*  1410 */    84,  104,  105,   87,  115,  115,  115,  115,  115,  115,
 /*  1420 */   115,   95,   96,   97,   98,   99,  100,  101,  115,   84,
 /*  1430 */   104,  105,   87,  115,  115,  115,  115,  115,  115,  115,
 /*  1440 */    95,   96,   97,   98,   99,  100,  101,  115,   84,  104,
 /*  1450 */   105,   87,  115,  115,  115,  115,  115,  115,  115,   95,
 /*  1460 */    96,   97,   98,   99,  100,  101,  115,  115,  104,  105,
 /*  1470 */    84,  115,  115,   87,  115,  115,  115,  115,  115,  115,
 /*  1480 */   115,   95,   96,   97,   98,   99,  100,  101,  115,   84,
 /*  1490 */   104,  105,   87,  115,  115,  115,  115,  115,  115,  115,
 /*  1500 */    95,   96,   97,   98,   99,  100,  101,  115,   84,  104,
 /*  1510 */   105,   87,  115,  115,  115,  115,  115,  115,  115,  115,
 /*  1520 */    96,   97,   98,   99,  100,  101,  115,   84,  104,  105,
 /*  1530 */    87,  115,  115,  115,  115,  115,  115,  115,  115,   96,
 /*  1540 */    97,   98,   99,  100,  101,  115,   84,  104,  105,   87,
 /*  1550 */   115,  115,  115,   83,   84,  115,  115,   87,   96,   97,
 /*  1560 */    98,   99,  100,  101,  115,  115,  104,  105,   98,   99,
 /*  1570 */   100,  101,  115,  115,  104,  105,   84,  115,  115,   87,
 /*  1580 */   115,  115,  115,  115,  115,   84,  115,  115,   87,   97,
 /*  1590 */    98,   99,  100,  101,  115,  115,  104,  105,   97,   98,
 /*  1600 */    99,  100,  101,  115,  115,  104,  105,   84,  115,  115,
 /*  1610 */    87,  115,  115,  115,  115,   84,  115,  115,   87,  115,
 /*  1620 */   115,   98,   99,  100,  101,  115,  115,  104,  105,   98,
 /*  1630 */    99,  100,  101,  115,   84,  104,  105,   87,  115,  115,
 /*  1640 */   115,  115,   84,  115,  115,   87,  115,  115,   98,   99,
 /*  1650 */   100,  101,  115,  115,  104,  105,   98,   99,  100,  101,
 /*  1660 */   115,   84,  104,  105,   87,  115,  115,  115,  115,  115,
 /*  1670 */    84,  115,  115,   87,  115,   98,   99,  100,  101,  115,
 /*  1680 */   115,  104,  105,  115,   98,   99,  100,  101,  115,  115,
 /*  1690 */   104,  105,   84,  115,  115,   87,  115,  115,  115,  115,
 /*  1700 */    84,  115,  115,   87,  115,  115,   98,   99,  100,  101,
 /*  1710 */   115,  115,  104,  105,   98,   99,  100,  101,  115,   84,
 /*  1720 */   104,  105,   87,  115,  115,  115,  115,   84,  115,  115,
 /*  1730 */    87,  115,  115,   98,   99,  100,  101,  115,  115,  104,
 /*  1740 */   105,   98,   99,  100,  101,  115,   84,  104,  105,   87,
 /*  1750 */   115,  115,  115,  115,  115,   84,  115,  115,   87,  115,
 /*  1760 */    98,   99,  100,  101,  115,  115,  104,  105,  115,   98,
 /*  1770 */    99,  100,  101,  115,  115,  104,  105,   84,  115,  115,
 /*  1780 */    87,  115,  115,  115,  115,   84,  115,  115,   87,  115,
 /*  1790 */   115,   98,   99,  100,  101,  115,  115,  104,  105,   98,
 /*  1800 */    99,  100,  101,  115,  115,  104,  105,
};
#define YY_SHIFT_USE_DFLT (1807)
#define YY_SHIFT_COUNT    (146)
#define YY_SHIFT_MIN      (-61)
#define YY_SHIFT_MAX      (1200)
static const short yy_shift_ofst[] = {
 /*     0 */    -1,  499,   97,  132,  385,  132,  564,  564,  564,  564,
 /*    10 */   253,  319,  564,  564,  564,  564,  564,  564,  564,  564,
 /*    20 */   564,  564,  564,  564,  564,  564,  564,  564,  564,  564,
 /*    30 */   564,  564,  564,  564,  564,  564,  564,  564,  564,  564,
 /*    40 */   564,  564,  564,  564,  564,  564,  564,  564,  564,  564,
 /*    50 */   564,  564,  564,  564,  564,   97,  564,  564,  564,  564,
 /*    60 */   564,  564,  564,  564,  564,  564,  564,  564,  564,  564,
 /*    70 */   564,  564,  364,   -7,  -61,   36,  222,   -7,  -61,  600,
 /*    80 */  1200,   36,   36,   36,   36,   36,   36,   36,  216,  134,
 /*    90 */   134,  134, 1107,    4,    4,    4,    4,    4,    4,    4,
 /*   100 */     4,    4,    4,    4,    4,    4,   17,    4,   17,    4,
 /*   110 */    17,    4,   45,   95,  290,  223,  139,  127,  135,  135,
 /*   120 */   246,  135,  199,  281,  240,  135,  199,  223,  394,  254,
 /*   130 */    76,  105,  195,  215,  200,  237,  264,  286,  272,  270,
 /*   140 */   273,  264,  270,  273,  264,  274,  105,
};
#define YY_REDUCE_USE_DFLT (-107)
#define YY_REDUCE_COUNT (88)
#define YY_REDUCE_MIN   (-106)
#define YY_REDUCE_MAX   (1701)
static const short yy_reduce_ofst[] = {
 /*     0 */   -63,   -8,   34,  124,  153,  187,  252,  320,  379,  401,
 /*    10 */   440,  494,  554,  577,  599,  624,  646,  668,  690,  712,
 /*    20 */   734,  756,  778,  800,  822,  844,  866,  888,  910,  929,
 /*    30 */   951,  973,  995, 1014, 1052, 1075, 1094, 1130, 1149, 1168,
 /*    40 */  1190, 1209, 1228, 1247, 1266, 1288, 1307, 1326, 1345, 1364,
 /*    50 */  1386, 1405, 1424, 1443, 1462, 1470, 1492, 1501, 1523, 1531,
 /*    60 */  1550, 1558, 1577, 1586, 1608, 1616, 1635, 1643, 1662, 1671,
 /*    70 */  1693, 1701,  -65,   33, -106,   15,   47,   23,   44,  -70,
 /*    80 */   -70,  -33,  -31,   20,  102,  123,  148,  152,  -88,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   508,  441,  508,  448,  508,  450,  445,  508,  508,  508,
 /*    10 */   508,  508,  508,  508,  508,  508,  508,  508,  508,  508,
 /*    20 */   508,  508,  508,  508,  508,  508,  508,  508,  508,  508,
 /*    30 */   508,  508,  508,  508,  508,  508,  508,  508,  508,  508,
 /*    40 */   508,  508,  508,  508,  508,  508,  508,  508,  508,  508,
 /*    50 */   508,  508,  508,  508,  508,  508,  508,  508,  508,  508,
 /*    60 */   508,  508,  508,  508,  508,  508,  508,  508,  508,  508,
 /*    70 */   508,  508,  508,  505,  441,  508,  481,  508,  508,  508,
 /*    80 */   508,  508,  508,  508,  508,  508,  508,  508,  508,  473,
 /*    90 */   402,  401,  479,  417,  416,  415,  414,  413,  412,  411,
 /*   100 */   410,  409,  408,  407,  406,  474,  476,  405,  422,  404,
 /*   110 */   421,  403,  508,  508,  508,  395,  508,  508,  475,  420,
 /*   120 */   508,  419,  472,  508,  479,  418,  400,  468,  467,  508,
 /*   130 */   490,  486,  508,  508,  508,  507,  397,  508,  508,  471,
 /*   140 */   470,  469,  399,  398,  396,  508,  508,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  grn_expr_parserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void grn_expr_parserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "START_OUTPUT_COLUMNS",  "START_ADJUSTER",  "LOGICAL_AND", 
  "LOGICAL_AND_NOT",  "LOGICAL_OR",    "NEGATIVE",      "QSTRING",     
  "PARENL",        "PARENR",        "ADJUST",        "RELATIVE_OP", 
  "IDENTIFIER",    "BRACEL",        "BRACER",        "EVAL",        
  "COMMA",         "ASSIGN",        "STAR_ASSIGN",   "SLASH_ASSIGN",
  "MOD_ASSIGN",    "PLUS_ASSIGN",   "MINUS_ASSIGN",  "SHIFTL_ASSIGN",
  "SHIFTR_ASSIGN",  "SHIFTRR_ASSIGN",  "AND_ASSIGN",    "XOR_ASSIGN",  
  "OR_ASSIGN",     "QUESTION",      "COLON",         "BITWISE_OR",  
  "BITWISE_XOR",   "BITWISE_AND",   "EQUAL",         "NOT_EQUAL",   
  "LESS",          "GREATER",       "LESS_EQUAL",    "GREATER_EQUAL",
  "IN",            "MATCH",         "NEAR",          "NEAR2",       
  "SIMILAR",       "TERM_EXTRACT",  "QUORUM",        "LCP",         
  "PREFIX",        "SUFFIX",        "REGEXP",        "SHIFTL",      
  "SHIFTR",        "SHIFTRR",       "PLUS",          "MINUS",       
  "STAR",          "SLASH",         "MOD",           "DELETE",      
  "INCR",          "DECR",          "NOT",           "BITWISE_NOT", 
  "EXACT",         "PARTIAL",       "UNSPLIT",       "DECIMAL",     
  "HEX_INTEGER",   "STRING",        "BOOLEAN",       "NULL",        
  "BRACKETL",      "BRACKETR",      "DOT",           "NONEXISTENT_COLUMN",
  "error",         "suppress_unused_variable_warning",  "input",         "query",       
  "expression",    "output_columns",  "adjuster",      "query_element",
  "primary_expression",  "assignment_expression",  "conditional_expression",  "lefthand_side_expression",
  "logical_or_expression",  "logical_and_expression",  "bitwise_or_expression",  "bitwise_xor_expression",
  "bitwise_and_expression",  "equality_expression",  "relational_expression",  "shift_expression",
  "additive_expression",  "multiplicative_expression",  "unary_expression",  "postfix_expression",
  "call_expression",  "member_expression",  "arguments",     "member_expression_part",
  "object_literal",  "array_literal",  "elision",       "element_list",
  "property_name_and_value_list",  "property_name_and_value",  "property_name",  "argument_list",
  "output_column",  "adjust_expression",  "adjust_match_expression",
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "query ::= query query_element",
 /*   1 */ "query ::= query LOGICAL_AND query_element",
 /*   2 */ "query ::= query LOGICAL_AND_NOT query_element",
 /*   3 */ "query ::= query LOGICAL_OR query_element",
 /*   4 */ "query ::= query NEGATIVE query_element",
 /*   5 */ "query_element ::= ADJUST query_element",
 /*   6 */ "query_element ::= RELATIVE_OP query_element",
 /*   7 */ "query_element ::= IDENTIFIER RELATIVE_OP query_element",
 /*   8 */ "query_element ::= BRACEL expression BRACER",
 /*   9 */ "query_element ::= EVAL primary_expression",
 /*  10 */ "expression ::= expression COMMA assignment_expression",
 /*  11 */ "assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression",
 /*  12 */ "assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression",
 /*  13 */ "assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression",
 /*  14 */ "assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression",
 /*  15 */ "assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression",
 /*  16 */ "assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression",
 /*  17 */ "assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression",
 /*  18 */ "assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression",
 /*  19 */ "assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression",
 /*  20 */ "assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression",
 /*  21 */ "assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression",
 /*  22 */ "assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression",
 /*  23 */ "conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression",
 /*  24 */ "logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression",
 /*  25 */ "logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression",
 /*  26 */ "logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression",
 /*  27 */ "bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression",
 /*  28 */ "bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression",
 /*  29 */ "bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression",
 /*  30 */ "equality_expression ::= equality_expression EQUAL relational_expression",
 /*  31 */ "equality_expression ::= equality_expression NOT_EQUAL relational_expression",
 /*  32 */ "relational_expression ::= relational_expression LESS shift_expression",
 /*  33 */ "relational_expression ::= relational_expression GREATER shift_expression",
 /*  34 */ "relational_expression ::= relational_expression LESS_EQUAL shift_expression",
 /*  35 */ "relational_expression ::= relational_expression GREATER_EQUAL shift_expression",
 /*  36 */ "relational_expression ::= relational_expression IN shift_expression",
 /*  37 */ "relational_expression ::= relational_expression MATCH shift_expression",
 /*  38 */ "relational_expression ::= relational_expression NEAR shift_expression",
 /*  39 */ "relational_expression ::= relational_expression NEAR2 shift_expression",
 /*  40 */ "relational_expression ::= relational_expression SIMILAR shift_expression",
 /*  41 */ "relational_expression ::= relational_expression TERM_EXTRACT shift_expression",
 /*  42 */ "relational_expression ::= relational_expression QUORUM shift_expression",
 /*  43 */ "relational_expression ::= relational_expression LCP shift_expression",
 /*  44 */ "relational_expression ::= relational_expression PREFIX shift_expression",
 /*  45 */ "relational_expression ::= relational_expression SUFFIX shift_expression",
 /*  46 */ "relational_expression ::= relational_expression REGEXP shift_expression",
 /*  47 */ "shift_expression ::= shift_expression SHIFTL additive_expression",
 /*  48 */ "shift_expression ::= shift_expression SHIFTR additive_expression",
 /*  49 */ "shift_expression ::= shift_expression SHIFTRR additive_expression",
 /*  50 */ "additive_expression ::= additive_expression PLUS multiplicative_expression",
 /*  51 */ "additive_expression ::= additive_expression MINUS multiplicative_expression",
 /*  52 */ "multiplicative_expression ::= multiplicative_expression STAR unary_expression",
 /*  53 */ "multiplicative_expression ::= multiplicative_expression SLASH unary_expression",
 /*  54 */ "multiplicative_expression ::= multiplicative_expression MOD unary_expression",
 /*  55 */ "unary_expression ::= DELETE unary_expression",
 /*  56 */ "unary_expression ::= INCR unary_expression",
 /*  57 */ "unary_expression ::= DECR unary_expression",
 /*  58 */ "unary_expression ::= PLUS unary_expression",
 /*  59 */ "unary_expression ::= MINUS unary_expression",
 /*  60 */ "unary_expression ::= NOT unary_expression",
 /*  61 */ "unary_expression ::= BITWISE_NOT unary_expression",
 /*  62 */ "unary_expression ::= ADJUST unary_expression",
 /*  63 */ "unary_expression ::= EXACT unary_expression",
 /*  64 */ "unary_expression ::= PARTIAL unary_expression",
 /*  65 */ "unary_expression ::= UNSPLIT unary_expression",
 /*  66 */ "postfix_expression ::= lefthand_side_expression INCR",
 /*  67 */ "postfix_expression ::= lefthand_side_expression DECR",
 /*  68 */ "call_expression ::= member_expression arguments",
 /*  69 */ "object_literal ::= BRACEL property_name_and_value_list BRACER",
 /*  70 */ "property_name_and_value_list ::=",
 /*  71 */ "property_name_and_value ::= property_name COLON assignment_expression",
 /*  72 */ "member_expression_part ::= BRACKETL expression BRACKETR",
 /*  73 */ "arguments ::= PARENL argument_list PARENR",
 /*  74 */ "argument_list ::=",
 /*  75 */ "argument_list ::= assignment_expression",
 /*  76 */ "argument_list ::= argument_list COMMA assignment_expression",
 /*  77 */ "output_columns ::=",
 /*  78 */ "output_columns ::= output_column",
 /*  79 */ "output_columns ::= output_columns COMMA",
 /*  80 */ "output_columns ::= output_columns COMMA output_column",
 /*  81 */ "output_column ::= STAR",
 /*  82 */ "output_column ::= NONEXISTENT_COLUMN",
 /*  83 */ "output_column ::= assignment_expression",
 /*  84 */ "adjuster ::= adjuster PLUS adjust_expression",
 /*  85 */ "adjust_expression ::= adjust_match_expression STAR DECIMAL",
 /*  86 */ "adjust_match_expression ::= IDENTIFIER MATCH STRING",
 /*  87 */ "input ::= query",
 /*  88 */ "input ::= expression",
 /*  89 */ "input ::= START_OUTPUT_COLUMNS output_columns",
 /*  90 */ "input ::= START_ADJUSTER adjuster",
 /*  91 */ "query ::= query_element",
 /*  92 */ "query_element ::= QSTRING",
 /*  93 */ "query_element ::= PARENL query PARENR",
 /*  94 */ "expression ::= assignment_expression",
 /*  95 */ "assignment_expression ::= conditional_expression",
 /*  96 */ "conditional_expression ::= logical_or_expression",
 /*  97 */ "logical_or_expression ::= logical_and_expression",
 /*  98 */ "logical_and_expression ::= bitwise_or_expression",
 /*  99 */ "bitwise_or_expression ::= bitwise_xor_expression",
 /* 100 */ "bitwise_xor_expression ::= bitwise_and_expression",
 /* 101 */ "bitwise_and_expression ::= equality_expression",
 /* 102 */ "equality_expression ::= relational_expression",
 /* 103 */ "relational_expression ::= shift_expression",
 /* 104 */ "shift_expression ::= additive_expression",
 /* 105 */ "additive_expression ::= multiplicative_expression",
 /* 106 */ "multiplicative_expression ::= unary_expression",
 /* 107 */ "unary_expression ::= postfix_expression",
 /* 108 */ "postfix_expression ::= lefthand_side_expression",
 /* 109 */ "lefthand_side_expression ::= call_expression",
 /* 110 */ "lefthand_side_expression ::= member_expression",
 /* 111 */ "member_expression ::= primary_expression",
 /* 112 */ "member_expression ::= member_expression member_expression_part",
 /* 113 */ "primary_expression ::= object_literal",
 /* 114 */ "primary_expression ::= PARENL expression PARENR",
 /* 115 */ "primary_expression ::= IDENTIFIER",
 /* 116 */ "primary_expression ::= array_literal",
 /* 117 */ "primary_expression ::= DECIMAL",
 /* 118 */ "primary_expression ::= HEX_INTEGER",
 /* 119 */ "primary_expression ::= STRING",
 /* 120 */ "primary_expression ::= BOOLEAN",
 /* 121 */ "primary_expression ::= NULL",
 /* 122 */ "array_literal ::= BRACKETL elision BRACKETR",
 /* 123 */ "array_literal ::= BRACKETL element_list elision BRACKETR",
 /* 124 */ "array_literal ::= BRACKETL element_list BRACKETR",
 /* 125 */ "elision ::= COMMA",
 /* 126 */ "elision ::= elision COMMA",
 /* 127 */ "element_list ::= assignment_expression",
 /* 128 */ "element_list ::= elision assignment_expression",
 /* 129 */ "element_list ::= element_list elision assignment_expression",
 /* 130 */ "property_name_and_value_list ::= property_name_and_value",
 /* 131 */ "property_name_and_value_list ::= property_name_and_value_list COMMA property_name_and_value",
 /* 132 */ "property_name ::= STRING",
 /* 133 */ "member_expression_part ::= DOT IDENTIFIER",
 /* 134 */ "adjuster ::=",
 /* 135 */ "adjuster ::= adjust_expression",
 /* 136 */ "adjust_expression ::= adjust_match_expression",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to grn_expr_parserAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void grn_expr_parserInit(void *yypParser){
  yyParser *pParser = (yyParser*)yypParser;
#ifdef YYTRACKMAXSTACKDEPTH
  pParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  pParser->yytos = NULL;
  pParser->yystack = NULL;
  pParser->yystksz = 0;
  if( yyGrowStack(pParser) ){
    pParser->yystack = &pParser->yystk0;
    pParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  pParser->yyerrcnt = -1;
#endif
  pParser->yytos = pParser->yystack;
  pParser->yystack[0].stateno = 0;
  pParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  pParser->yystackEnd = &pParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef grn_expr_parser_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to grn_expr_parser and grn_expr_parserFree.
*/
void *grn_expr_parserAlloc(void *(*mallocProc)(YYMALLOCARGTYPE)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( pParser ) grn_expr_parserInit(pParser);
  return pParser;
}
#endif /* grn_expr_parser_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  grn_expr_parserARG_FETCH;
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
    case 77: /* suppress_unused_variable_warning */
{
#line 14 "grn_ecmascript.lemon"

  (void)efsi;

#line 1014 "grn_ecmascript.c"
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void grn_expr_parserFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef grn_expr_parser_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void grn_expr_parserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  grn_expr_parserFinalize(p);
  (*freeProc)(p);
}
#endif /* grn_expr_parser_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int grn_expr_parserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static unsigned int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yytos->stateno;
 
  if( stateno>=YY_MIN_REDUCE ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
  do{
    i = yy_shift_ofst[stateno];
    assert( iLookAhead!=YYNOCODE );
    i += iLookAhead;
    if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   grn_expr_parserARG_FETCH;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   grn_expr_parserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%sShift '%s', go to state %d\n",
         yyTracePrompt,yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%sShift '%s'\n",
         yyTracePrompt,yyTokenName[yypParser->yytos->major]);
    }
  }
}
#else
# define yyTraceShift(X,Y)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  grn_expr_parserTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = (YYACTIONTYPE)yyNewState;
  yytos->major = (YYCODETYPE)yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState);
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  { 79, -2 },
  { 79, -3 },
  { 79, -3 },
  { 79, -3 },
  { 79, -3 },
  { 83, -2 },
  { 83, -2 },
  { 83, -3 },
  { 83, -3 },
  { 83, -2 },
  { 80, -3 },
  { 85, -3 },
  { 85, -3 },
  { 85, -3 },
  { 85, -3 },
  { 85, -3 },
  { 85, -3 },
  { 85, -3 },
  { 85, -3 },
  { 85, -3 },
  { 85, -3 },
  { 85, -3 },
  { 85, -3 },
  { 86, -5 },
  { 88, -3 },
  { 89, -3 },
  { 89, -3 },
  { 90, -3 },
  { 91, -3 },
  { 92, -3 },
  { 93, -3 },
  { 93, -3 },
  { 94, -3 },
  { 94, -3 },
  { 94, -3 },
  { 94, -3 },
  { 94, -3 },
  { 94, -3 },
  { 94, -3 },
  { 94, -3 },
  { 94, -3 },
  { 94, -3 },
  { 94, -3 },
  { 94, -3 },
  { 94, -3 },
  { 94, -3 },
  { 94, -3 },
  { 95, -3 },
  { 95, -3 },
  { 95, -3 },
  { 96, -3 },
  { 96, -3 },
  { 97, -3 },
  { 97, -3 },
  { 97, -3 },
  { 98, -2 },
  { 98, -2 },
  { 98, -2 },
  { 98, -2 },
  { 98, -2 },
  { 98, -2 },
  { 98, -2 },
  { 98, -2 },
  { 98, -2 },
  { 98, -2 },
  { 98, -2 },
  { 99, -2 },
  { 99, -2 },
  { 100, -2 },
  { 104, -3 },
  { 108, 0 },
  { 109, -3 },
  { 103, -3 },
  { 102, -3 },
  { 111, 0 },
  { 111, -1 },
  { 111, -3 },
  { 81, 0 },
  { 81, -1 },
  { 81, -2 },
  { 81, -3 },
  { 112, -1 },
  { 112, -1 },
  { 112, -1 },
  { 82, -3 },
  { 113, -3 },
  { 114, -3 },
  { 78, -1 },
  { 78, -1 },
  { 78, -2 },
  { 78, -2 },
  { 79, -1 },
  { 83, -1 },
  { 83, -3 },
  { 80, -1 },
  { 85, -1 },
  { 86, -1 },
  { 88, -1 },
  { 89, -1 },
  { 90, -1 },
  { 91, -1 },
  { 92, -1 },
  { 93, -1 },
  { 94, -1 },
  { 95, -1 },
  { 96, -1 },
  { 97, -1 },
  { 98, -1 },
  { 99, -1 },
  { 87, -1 },
  { 87, -1 },
  { 101, -1 },
  { 101, -2 },
  { 84, -1 },
  { 84, -3 },
  { 84, -1 },
  { 84, -1 },
  { 84, -1 },
  { 84, -1 },
  { 84, -1 },
  { 84, -1 },
  { 84, -1 },
  { 105, -3 },
  { 105, -4 },
  { 105, -3 },
  { 106, -1 },
  { 106, -2 },
  { 107, -1 },
  { 107, -2 },
  { 107, -3 },
  { 108, -1 },
  { 108, -3 },
  { 110, -1 },
  { 103, -2 },
  { 82, 0 },
  { 82, -1 },
  { 113, -1 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno        /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  grn_expr_parserARG_FETCH;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    fprintf(yyTraceFILE, "%sReduce [%s], go to state %d.\n", yyTracePrompt,
      yyRuleName[yyruleno], yymsp[yysize].stateno);
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      return;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        return;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* query ::= query query_element */
#line 53 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, grn_int32_value_at(&efsi->op_stack, -1), 2);
}
#line 1471 "grn_ecmascript.c"
        break;
      case 1: /* query ::= query LOGICAL_AND query_element */
      case 25: /* logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression */ yytestcase(yyruleno==25);
#line 56 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND, 2);
}
#line 1479 "grn_ecmascript.c"
        break;
      case 2: /* query ::= query LOGICAL_AND_NOT query_element */
      case 26: /* logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression */ yytestcase(yyruleno==26);
#line 59 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND_NOT, 2);
}
#line 1487 "grn_ecmascript.c"
        break;
      case 3: /* query ::= query LOGICAL_OR query_element */
      case 24: /* logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression */ yytestcase(yyruleno==24);
#line 62 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_OR, 2);
}
#line 1495 "grn_ecmascript.c"
        break;
      case 4: /* query ::= query NEGATIVE query_element */
#line 65 "grn_ecmascript.lemon"
{
  int weight;
  GRN_INT32_POP(&efsi->weight_stack, weight);
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ADJUST, 2);
}
#line 1504 "grn_ecmascript.c"
        break;
      case 5: /* query_element ::= ADJUST query_element */
#line 74 "grn_ecmascript.lemon"
{
  int weight;
  GRN_INT32_POP(&efsi->weight_stack, weight);
}
#line 1512 "grn_ecmascript.c"
        break;
      case 6: /* query_element ::= RELATIVE_OP query_element */
#line 78 "grn_ecmascript.lemon"
{
  int mode;
  GRN_INT32_POP(&efsi->mode_stack, mode);
}
#line 1520 "grn_ecmascript.c"
        break;
      case 7: /* query_element ::= IDENTIFIER RELATIVE_OP query_element */
#line 82 "grn_ecmascript.lemon"
{
  int mode;
  grn_obj *c;
  GRN_PTR_POP(&efsi->column_stack, c);
  GRN_INT32_POP(&efsi->mode_stack, mode);
  switch (mode) {
  case GRN_OP_NEAR :
  case GRN_OP_NEAR2 :
    {
      int max_interval;
      GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
    }
    break;
  case GRN_OP_SIMILAR :
    {
      int similarity_threshold;
      GRN_INT32_POP(&efsi->similarity_threshold_stack, similarity_threshold);
    }
    break;
  case GRN_OP_QUORUM :
    {
      int quorum_threshold;
      GRN_INT32_POP(&efsi->quorum_threshold_stack, quorum_threshold);
    }
    break;
  default :
    break;
  }
}
#line 1553 "grn_ecmascript.c"
        break;
      case 8: /* query_element ::= BRACEL expression BRACER */
      case 9: /* query_element ::= EVAL primary_expression */ yytestcase(yyruleno==9);
#line 111 "grn_ecmascript.lemon"
{
  efsi->flags = efsi->default_flags;
}
#line 1561 "grn_ecmascript.c"
        break;
      case 10: /* expression ::= expression COMMA assignment_expression */
#line 119 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_COMMA, 2);
}
#line 1568 "grn_ecmascript.c"
        break;
      case 11: /* assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression */
#line 124 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ASSIGN, 2);
}
#line 1575 "grn_ecmascript.c"
        break;
      case 12: /* assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression */
#line 127 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_STAR_ASSIGN, 2);
}
#line 1582 "grn_ecmascript.c"
        break;
      case 13: /* assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression */
#line 130 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SLASH_ASSIGN, 2);
}
#line 1589 "grn_ecmascript.c"
        break;
      case 14: /* assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression */
#line 133 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MOD_ASSIGN, 2);
}
#line 1596 "grn_ecmascript.c"
        break;
      case 15: /* assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression */
#line 136 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS_ASSIGN, 2);
}
#line 1603 "grn_ecmascript.c"
        break;
      case 16: /* assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression */
#line 139 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS_ASSIGN, 2);
}
#line 1610 "grn_ecmascript.c"
        break;
      case 17: /* assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression */
#line 142 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTL_ASSIGN, 2);
}
#line 1617 "grn_ecmascript.c"
        break;
      case 18: /* assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression */
#line 145 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTR_ASSIGN, 2);
}
#line 1624 "grn_ecmascript.c"
        break;
      case 19: /* assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression */
#line 148 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTRR_ASSIGN, 2);
}
#line 1631 "grn_ecmascript.c"
        break;
      case 20: /* assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression */
#line 151 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND_ASSIGN, 2);
}
#line 1638 "grn_ecmascript.c"
        break;
      case 21: /* assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression */
#line 154 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_XOR_ASSIGN, 2);
}
#line 1645 "grn_ecmascript.c"
        break;
      case 22: /* assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression */
#line 157 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_OR_ASSIGN, 2);
}
#line 1652 "grn_ecmascript.c"
        break;
      case 23: /* conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression */
#line 162 "grn_ecmascript.lemon"
{
  grn_expr *e = (grn_expr *)efsi->e;
  e->codes[yymsp[-3].minor.yy0].nargs = yymsp[-1].minor.yy0 - yymsp[-3].minor.yy0;
  e->codes[yymsp[-1].minor.yy0].nargs = e->codes_curr - yymsp[-1].minor.yy0 - 1;
}
#line 1661 "grn_ecmascript.c"
        break;
      case 27: /* bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression */
#line 182 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_OR, 2);
}
#line 1668 "grn_ecmascript.c"
        break;
      case 28: /* bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression */
#line 187 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_XOR, 2);
}
#line 1675 "grn_ecmascript.c"
        break;
      case 29: /* bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression */
#line 192 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_AND, 2);
}
#line 1682 "grn_ecmascript.c"
        break;
      case 30: /* equality_expression ::= equality_expression EQUAL relational_expression */
#line 197 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_EQUAL, 2);
}
#line 1689 "grn_ecmascript.c"
        break;
      case 31: /* equality_expression ::= equality_expression NOT_EQUAL relational_expression */
#line 200 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NOT_EQUAL, 2);
}
#line 1696 "grn_ecmascript.c"
        break;
      case 32: /* relational_expression ::= relational_expression LESS shift_expression */
#line 205 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LESS, 2);
}
#line 1703 "grn_ecmascript.c"
        break;
      case 33: /* relational_expression ::= relational_expression GREATER shift_expression */
#line 208 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GREATER, 2);
}
#line 1710 "grn_ecmascript.c"
        break;
      case 34: /* relational_expression ::= relational_expression LESS_EQUAL shift_expression */
#line 211 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LESS_EQUAL, 2);
}
#line 1717 "grn_ecmascript.c"
        break;
      case 35: /* relational_expression ::= relational_expression GREATER_EQUAL shift_expression */
#line 214 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GREATER_EQUAL, 2);
}
#line 1724 "grn_ecmascript.c"
        break;
      case 36: /* relational_expression ::= relational_expression IN shift_expression */
#line 217 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_IN, 2);
}
#line 1731 "grn_ecmascript.c"
        break;
      case 37: /* relational_expression ::= relational_expression MATCH shift_expression */
      case 86: /* adjust_match_expression ::= IDENTIFIER MATCH STRING */ yytestcase(yyruleno==86);
#line 220 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MATCH, 2);
}
#line 1739 "grn_ecmascript.c"
        break;
      case 38: /* relational_expression ::= relational_expression NEAR shift_expression */
#line 223 "grn_ecmascript.lemon"
{
  {
    int max_interval;
    GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, max_interval,
                              GRN_OP_PUSH, 1);
  }
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR, 3);
}
#line 1752 "grn_ecmascript.c"
        break;
      case 39: /* relational_expression ::= relational_expression NEAR2 shift_expression */
#line 232 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR2, 2);
}
#line 1759 "grn_ecmascript.c"
        break;
      case 40: /* relational_expression ::= relational_expression SIMILAR shift_expression */
#line 235 "grn_ecmascript.lemon"
{
  {
    int similarity_threshold;
    GRN_INT32_POP(&efsi->similarity_threshold_stack, similarity_threshold);
    grn_expr_append_const_int(efsi->ctx, efsi->e, similarity_threshold,
                              GRN_OP_PUSH, 1);
  }
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SIMILAR, 3);
}
#line 1772 "grn_ecmascript.c"
        break;
      case 41: /* relational_expression ::= relational_expression TERM_EXTRACT shift_expression */
#line 244 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_TERM_EXTRACT, 2);
}
#line 1779 "grn_ecmascript.c"
        break;
      case 42: /* relational_expression ::= relational_expression QUORUM shift_expression */
#line 247 "grn_ecmascript.lemon"
{
  {
    int quorum_threshold;
    GRN_INT32_POP(&efsi->quorum_threshold_stack, quorum_threshold);
    grn_expr_append_const_int(efsi->ctx, efsi->e, quorum_threshold,
                              GRN_OP_PUSH, 1);
  }
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_QUORUM, 3);
}
#line 1792 "grn_ecmascript.c"
        break;
      case 43: /* relational_expression ::= relational_expression LCP shift_expression */
#line 256 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LCP, 2);
}
#line 1799 "grn_ecmascript.c"
        break;
      case 44: /* relational_expression ::= relational_expression PREFIX shift_expression */
#line 259 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PREFIX, 2);
}
#line 1806 "grn_ecmascript.c"
        break;
      case 45: /* relational_expression ::= relational_expression SUFFIX shift_expression */
#line 262 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SUFFIX, 2);
}
#line 1813 "grn_ecmascript.c"
        break;
      case 46: /* relational_expression ::= relational_expression REGEXP shift_expression */
#line 265 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_REGEXP, 2);
}
#line 1820 "grn_ecmascript.c"
        break;
      case 47: /* shift_expression ::= shift_expression SHIFTL additive_expression */
#line 270 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTL, 2);
}
#line 1827 "grn_ecmascript.c"
        break;
      case 48: /* shift_expression ::= shift_expression SHIFTR additive_expression */
#line 273 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTR, 2);
}
#line 1834 "grn_ecmascript.c"
        break;
      case 49: /* shift_expression ::= shift_expression SHIFTRR additive_expression */
#line 276 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTRR, 2);
}
#line 1841 "grn_ecmascript.c"
        break;
      case 50: /* additive_expression ::= additive_expression PLUS multiplicative_expression */
      case 84: /* adjuster ::= adjuster PLUS adjust_expression */ yytestcase(yyruleno==84);
#line 281 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS, 2);
}
#line 1849 "grn_ecmascript.c"
        break;
      case 51: /* additive_expression ::= additive_expression MINUS multiplicative_expression */
#line 284 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS, 2);
}
#line 1856 "grn_ecmascript.c"
        break;
      case 52: /* multiplicative_expression ::= multiplicative_expression STAR unary_expression */
      case 85: /* adjust_expression ::= adjust_match_expression STAR DECIMAL */ yytestcase(yyruleno==85);
#line 289 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_STAR, 2);
}
#line 1864 "grn_ecmascript.c"
        break;
      case 53: /* multiplicative_expression ::= multiplicative_expression SLASH unary_expression */
#line 292 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SLASH, 2);
}
#line 1871 "grn_ecmascript.c"
        break;
      case 54: /* multiplicative_expression ::= multiplicative_expression MOD unary_expression */
#line 295 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MOD, 2);
}
#line 1878 "grn_ecmascript.c"
        break;
      case 55: /* unary_expression ::= DELETE unary_expression */
#line 300 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DELETE, 1);
}
#line 1885 "grn_ecmascript.c"
        break;
      case 56: /* unary_expression ::= INCR unary_expression */
#line 303 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be incremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_INCR, 1);
  }
}
#line 1906 "grn_ecmascript.c"
        break;
      case 57: /* unary_expression ::= DECR unary_expression */
#line 320 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be decremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DECR, 1);
  }
}
#line 1927 "grn_ecmascript.c"
        break;
      case 58: /* unary_expression ::= PLUS unary_expression */
#line 337 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS, 1);
}
#line 1934 "grn_ecmascript.c"
        break;
      case 59: /* unary_expression ::= MINUS unary_expression */
#line 340 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS, 1);
}
#line 1941 "grn_ecmascript.c"
        break;
      case 60: /* unary_expression ::= NOT unary_expression */
#line 343 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NOT, 1);
}
#line 1948 "grn_ecmascript.c"
        break;
      case 61: /* unary_expression ::= BITWISE_NOT unary_expression */
#line 346 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_NOT, 1);
}
#line 1955 "grn_ecmascript.c"
        break;
      case 62: /* unary_expression ::= ADJUST unary_expression */
#line 349 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ADJUST, 1);
}
#line 1962 "grn_ecmascript.c"
        break;
      case 63: /* unary_expression ::= EXACT unary_expression */
#line 352 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_EXACT, 1);
}
#line 1969 "grn_ecmascript.c"
        break;
      case 64: /* unary_expression ::= PARTIAL unary_expression */
#line 355 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PARTIAL, 1);
}
#line 1976 "grn_ecmascript.c"
        break;
      case 65: /* unary_expression ::= UNSPLIT unary_expression */
#line 358 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_UNSPLIT, 1);
}
#line 1983 "grn_ecmascript.c"
        break;
      case 66: /* postfix_expression ::= lefthand_side_expression INCR */
#line 363 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be incremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_INCR_POST, 1);
  }
}
#line 2004 "grn_ecmascript.c"
        break;
      case 67: /* postfix_expression ::= lefthand_side_expression DECR */
#line 380 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be decremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DECR_POST, 1);
  }
}
#line 2025 "grn_ecmascript.c"
        break;
      case 68: /* call_expression ::= member_expression arguments */
#line 401 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_CALL, yymsp[0].minor.yy0);
}
#line 2032 "grn_ecmascript.c"
        break;
      case 69: /* object_literal ::= BRACEL property_name_and_value_list BRACER */
#line 429 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr_take_obj(ctx, efsi->e, (grn_obj *)(efsi->object_literal));
  grn_expr_append_obj(ctx, efsi->e, (grn_obj *)(efsi->object_literal),
                      GRN_OP_PUSH, 1);
  efsi->object_literal = NULL;
}
#line 2043 "grn_ecmascript.c"
        break;
      case 70: /* property_name_and_value_list ::= */
#line 437 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;

  efsi->object_literal =
    grn_hash_create(ctx, NULL, GRN_TABLE_MAX_KEY_SIZE, sizeof(grn_obj),
                    GRN_OBJ_KEY_VAR_SIZE|GRN_OBJ_TEMPORARY|GRN_HASH_TINY);
  if (!efsi->object_literal) {
    ERR(GRN_NO_MEMORY_AVAILABLE,
        "couldn't create hash table for parsing object literal: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  }
}
#line 2059 "grn_ecmascript.c"
        break;
      case 71: /* property_name_and_value ::= property_name COLON assignment_expression */
#line 452 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_obj *property = e->codes[e->codes_curr - 3].value;
  grn_obj *value = e->codes[e->codes_curr - 1].value;

  if (!efsi->object_literal) {
     efsi->object_literal =
       grn_hash_create(ctx, NULL, GRN_TABLE_MAX_KEY_SIZE, sizeof(grn_obj),
                       GRN_OBJ_KEY_VAR_SIZE|GRN_OBJ_TEMPORARY|GRN_HASH_TINY);
  }

  if (!efsi->object_literal) {
    ERR(GRN_NO_MEMORY_AVAILABLE,
        "couldn't create hash table for parsing object literal: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_obj *buf;
    int added;
    if (grn_hash_add(ctx, (grn_hash *)efsi->object_literal,
                     GRN_TEXT_VALUE(property), GRN_TEXT_LEN(property),
                     (void **)&buf, &added)) {
      if (added) {
        GRN_OBJ_INIT(buf, value->header.type, 0, value->header.domain);
        GRN_TEXT_PUT(ctx, buf, GRN_TEXT_VALUE(value), GRN_TEXT_LEN(value));
        grn_expr_dfi_pop(e);
        e->codes_curr -= 3;
      } else {
        ERR(GRN_INVALID_ARGUMENT,
            "duplicated property name: <%.*s>",
            (int)GRN_TEXT_LEN(property),
            GRN_TEXT_VALUE(property));
      }
    } else {
      ERR(GRN_NO_MEMORY_AVAILABLE,
          "failed to add a property to object literal: <%.*s>",
          (int)GRN_TEXT_LEN(property),
          GRN_TEXT_VALUE(property));
    }
  }
}
#line 2104 "grn_ecmascript.c"
        break;
      case 72: /* member_expression_part ::= BRACKETL expression BRACKETR */
#line 496 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GET_MEMBER, 2);
}
#line 2111 "grn_ecmascript.c"
        break;
      case 73: /* arguments ::= PARENL argument_list PARENR */
#line 501 "grn_ecmascript.lemon"
{ yymsp[-2].minor.yy0 = yymsp[-1].minor.yy0; }
#line 2116 "grn_ecmascript.c"
        break;
      case 74: /* argument_list ::= */
#line 502 "grn_ecmascript.lemon"
{ yymsp[1].minor.yy0 = 0; }
#line 2121 "grn_ecmascript.c"
        break;
      case 75: /* argument_list ::= assignment_expression */
#line 503 "grn_ecmascript.lemon"
{ yymsp[0].minor.yy0 = 1; }
#line 2126 "grn_ecmascript.c"
        break;
      case 76: /* argument_list ::= argument_list COMMA assignment_expression */
#line 504 "grn_ecmascript.lemon"
{ yylhsminor.yy0 = yymsp[-2].minor.yy0 + 1; }
#line 2131 "grn_ecmascript.c"
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 77: /* output_columns ::= */
#line 506 "grn_ecmascript.lemon"
{
  yymsp[1].minor.yy0 = 0;
}
#line 2139 "grn_ecmascript.c"
        break;
      case 78: /* output_columns ::= output_column */
#line 509 "grn_ecmascript.lemon"
{
  yylhsminor.yy0 = yymsp[0].minor.yy0;
}
#line 2146 "grn_ecmascript.c"
  yymsp[0].minor.yy0 = yylhsminor.yy0;
        break;
      case 79: /* output_columns ::= output_columns COMMA */
#line 514 "grn_ecmascript.lemon"
{
  yylhsminor.yy0 = yymsp[-1].minor.yy0;
}
#line 2154 "grn_ecmascript.c"
  yymsp[-1].minor.yy0 = yylhsminor.yy0;
        break;
      case 80: /* output_columns ::= output_columns COMMA output_column */
#line 519 "grn_ecmascript.lemon"
{
  if (yymsp[-2].minor.yy0 == 0) {
    yylhsminor.yy0 = yymsp[0].minor.yy0;
  } else if (yymsp[0].minor.yy0 == 0) {
    yylhsminor.yy0 = yymsp[-2].minor.yy0;
  } else {
    if (yymsp[0].minor.yy0 == 1) {
      grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_COMMA, 2);
    }
    yylhsminor.yy0 = 1;
  }
}
#line 2171 "grn_ecmascript.c"
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 81: /* output_column ::= STAR */
#line 532 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_obj *expr = efsi->e;
  grn_obj *variable = grn_expr_get_var_by_offset(ctx, expr, 0);
  if (variable) {
    grn_id table_id = GRN_OBJ_GET_DOMAIN(variable);
    grn_obj *table = grn_ctx_at(ctx, table_id);
    grn_obj columns_buffer;
    int n_columns;
    grn_obj **columns;

    GRN_PTR_INIT(&columns_buffer, GRN_OBJ_VECTOR, GRN_ID_NIL);
    grn_obj_columns(ctx, table, "*", strlen("*"), &columns_buffer);
    n_columns = GRN_BULK_VSIZE(&columns_buffer) / sizeof(grn_obj *);
    columns = (grn_obj **)GRN_BULK_HEAD(&columns_buffer);

    if (n_columns == 0) {
      /* do nothing */
    } else if (n_columns == 1) {
      grn_obj *column = columns[0];
      grn_expr_append_const(ctx, expr, column, GRN_OP_GET_VALUE, 1);
      if (column->header.type == GRN_ACCESSOR) {
        grn_expr_take_obj(ctx, expr, column);
      }
    } else {
      grn_expr *e = (grn_expr *)expr;
      grn_bool have_column;
      int i;

      have_column = (e->codes_curr > 0);
      for (i = 0; i < n_columns; i++) {
        grn_obj *column = columns[i];
        grn_expr_append_const(ctx, expr, column, GRN_OP_GET_VALUE, 1);
        if (have_column || i > 0) {
          grn_expr_append_op(ctx, expr, GRN_OP_COMMA, 2);
        }
        if (column->header.type == GRN_ACCESSOR) {
          grn_expr_take_obj(ctx, expr, column);
        }
      }
    }

    GRN_OBJ_FIN(ctx, &columns_buffer);

    yymsp[0].minor.yy0 = n_columns;
  } else {
    /* TODO: report error */
    yymsp[0].minor.yy0 = 0;
  }
}
#line 2226 "grn_ecmascript.c"
        break;
      case 82: /* output_column ::= NONEXISTENT_COLUMN */
#line 582 "grn_ecmascript.lemon"
{
  yymsp[0].minor.yy0 = 0;
}
#line 2233 "grn_ecmascript.c"
        break;
      case 83: /* output_column ::= assignment_expression */
#line 585 "grn_ecmascript.lemon"
{
  yymsp[0].minor.yy0 = 1;
}
#line 2240 "grn_ecmascript.c"
        break;
      default:
      /* (87) input ::= query */ yytestcase(yyruleno==87);
      /* (88) input ::= expression */ yytestcase(yyruleno==88);
      /* (89) input ::= START_OUTPUT_COLUMNS output_columns */ yytestcase(yyruleno==89);
      /* (90) input ::= START_ADJUSTER adjuster */ yytestcase(yyruleno==90);
      /* (91) query ::= query_element (OPTIMIZED OUT) */ assert(yyruleno!=91);
      /* (92) query_element ::= QSTRING */ yytestcase(yyruleno==92);
      /* (93) query_element ::= PARENL query PARENR */ yytestcase(yyruleno==93);
      /* (94) expression ::= assignment_expression (OPTIMIZED OUT) */ assert(yyruleno!=94);
      /* (95) assignment_expression ::= conditional_expression (OPTIMIZED OUT) */ assert(yyruleno!=95);
      /* (96) conditional_expression ::= logical_or_expression */ yytestcase(yyruleno==96);
      /* (97) logical_or_expression ::= logical_and_expression */ yytestcase(yyruleno==97);
      /* (98) logical_and_expression ::= bitwise_or_expression */ yytestcase(yyruleno==98);
      /* (99) bitwise_or_expression ::= bitwise_xor_expression */ yytestcase(yyruleno==99);
      /* (100) bitwise_xor_expression ::= bitwise_and_expression */ yytestcase(yyruleno==100);
      /* (101) bitwise_and_expression ::= equality_expression */ yytestcase(yyruleno==101);
      /* (102) equality_expression ::= relational_expression */ yytestcase(yyruleno==102);
      /* (103) relational_expression ::= shift_expression */ yytestcase(yyruleno==103);
      /* (104) shift_expression ::= additive_expression */ yytestcase(yyruleno==104);
      /* (105) additive_expression ::= multiplicative_expression */ yytestcase(yyruleno==105);
      /* (106) multiplicative_expression ::= unary_expression (OPTIMIZED OUT) */ assert(yyruleno!=106);
      /* (107) unary_expression ::= postfix_expression (OPTIMIZED OUT) */ assert(yyruleno!=107);
      /* (108) postfix_expression ::= lefthand_side_expression */ yytestcase(yyruleno==108);
      /* (109) lefthand_side_expression ::= call_expression (OPTIMIZED OUT) */ assert(yyruleno!=109);
      /* (110) lefthand_side_expression ::= member_expression */ yytestcase(yyruleno==110);
      /* (111) member_expression ::= primary_expression (OPTIMIZED OUT) */ assert(yyruleno!=111);
      /* (112) member_expression ::= member_expression member_expression_part */ yytestcase(yyruleno==112);
      /* (113) primary_expression ::= object_literal (OPTIMIZED OUT) */ assert(yyruleno!=113);
      /* (114) primary_expression ::= PARENL expression PARENR */ yytestcase(yyruleno==114);
      /* (115) primary_expression ::= IDENTIFIER */ yytestcase(yyruleno==115);
      /* (116) primary_expression ::= array_literal (OPTIMIZED OUT) */ assert(yyruleno!=116);
      /* (117) primary_expression ::= DECIMAL */ yytestcase(yyruleno==117);
      /* (118) primary_expression ::= HEX_INTEGER */ yytestcase(yyruleno==118);
      /* (119) primary_expression ::= STRING */ yytestcase(yyruleno==119);
      /* (120) primary_expression ::= BOOLEAN */ yytestcase(yyruleno==120);
      /* (121) primary_expression ::= NULL */ yytestcase(yyruleno==121);
      /* (122) array_literal ::= BRACKETL elision BRACKETR */ yytestcase(yyruleno==122);
      /* (123) array_literal ::= BRACKETL element_list elision BRACKETR */ yytestcase(yyruleno==123);
      /* (124) array_literal ::= BRACKETL element_list BRACKETR */ yytestcase(yyruleno==124);
      /* (125) elision ::= COMMA */ yytestcase(yyruleno==125);
      /* (126) elision ::= elision COMMA */ yytestcase(yyruleno==126);
      /* (127) element_list ::= assignment_expression (OPTIMIZED OUT) */ assert(yyruleno!=127);
      /* (128) element_list ::= elision assignment_expression */ yytestcase(yyruleno==128);
      /* (129) element_list ::= element_list elision assignment_expression */ yytestcase(yyruleno==129);
      /* (130) property_name_and_value_list ::= property_name_and_value (OPTIMIZED OUT) */ assert(yyruleno!=130);
      /* (131) property_name_and_value_list ::= property_name_and_value_list COMMA property_name_and_value */ yytestcase(yyruleno==131);
      /* (132) property_name ::= STRING */ yytestcase(yyruleno==132);
      /* (133) member_expression_part ::= DOT IDENTIFIER */ yytestcase(yyruleno==133);
      /* (134) adjuster ::= */ yytestcase(yyruleno==134);
      /* (135) adjuster ::= adjust_expression (OPTIMIZED OUT) */ assert(yyruleno!=135);
      /* (136) adjust_expression ::= adjust_match_expression */ yytestcase(yyruleno==136);
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  if( yyact==YY_ACCEPT_ACTION ){
    yypParser->yytos += yysize;
    yy_accept(yypParser);
  }else{
    yymsp += yysize+1;
    yypParser->yytos = yymsp;
    yymsp->stateno = (YYACTIONTYPE)yyact;
    yymsp->major = (YYCODETYPE)yygoto;
    yyTraceShift(yypParser, yyact);
  }
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  grn_expr_parserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  grn_expr_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  grn_expr_parserTOKENTYPE yyminor         /* The minor type of the error token */
){
  grn_expr_parserARG_FETCH;
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/
#line 20 "grn_ecmascript.lemon"

  {
    grn_ctx *ctx = efsi->ctx;
    grn_obj message;
    GRN_TEXT_INIT(&message, 0);
    GRN_TEXT_PUT(ctx, &message, efsi->str, efsi->cur - efsi->str);
    GRN_TEXT_PUTC(ctx, &message, '|');
    if (efsi->cur < efsi->str_end) {
      GRN_TEXT_PUTC(ctx, &message, efsi->cur[0]);
      GRN_TEXT_PUTC(ctx, &message, '|');
      GRN_TEXT_PUT(ctx, &message,
                   efsi->cur + 1, efsi->str_end - (efsi->cur + 1));
    } else {
      GRN_TEXT_PUTC(ctx, &message, '|');
    }
    if (ctx->rc == GRN_SUCCESS) {
      ERR(GRN_SYNTAX_ERROR, "Syntax error: <%.*s>",
          (int)GRN_TEXT_LEN(&message), GRN_TEXT_VALUE(&message));
    } else {
      ERR(ctx->rc, "Syntax error: <%.*s>: %s",
          (int)GRN_TEXT_LEN(&message), GRN_TEXT_VALUE(&message),
          ctx->errbuf);
    }
    GRN_OBJ_FIN(ctx, &message);
  }
#line 2379 "grn_ecmascript.c"
/************ End %syntax_error code ******************************************/
  grn_expr_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  grn_expr_parserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  grn_expr_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "grn_expr_parserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void grn_expr_parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  grn_expr_parserTOKENTYPE yyminor       /* The value for the token */
  grn_expr_parserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  unsigned int yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  yypParser = (yyParser*)yyp;
  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif
  grn_expr_parserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput '%s'\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,(YYCODETYPE)yymajor);
    if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      yymajor = YYNOCODE;
    }else if( yyact <= YY_MAX_REDUCE ){
      yy_reduce(yypParser,yyact-YY_MIN_REDUCE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && yymx != YYERRORSYMBOL
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) >= YY_MIN_REDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      yymajor = YYNOCODE;
      
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}
