/*
 * Copyright 2007-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.gradle.api.publication.maven.internal.ant;

import org.apache.maven.artifact.ant.DeployTask;
import org.apache.maven.artifact.ant.Pom;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.PlexusContainer;

/**
 * We could also use reflection to get hold of the container property. But this would make it harder to use a Mock for this class.
 *
 * @author Hans Dockter
 */
public class CustomDeployTask extends DeployTask implements CustomInstallDeployTaskSupport {
    @Override
    public synchronized Settings getSettings() {
        return super.getSettings();
    }

    @Override
    public synchronized PlexusContainer getContainer() {
        return super.getContainer();
    }

    @Override
    public void doExecute() {
        LoggingHelper.injectLogger(getContainer(), getProject());
        super.doExecute();
    }

    @Override
    public Pom initializePom(ArtifactRepository localArtifactRepository) {
        // Pom initialization is not thread-safe, as it holds static state in the maven classes.
        // This class-level lock means this piece of code will never execute concurrently for a given instance of the maven classes
        synchronized (MavenProjectBuilder.class) {
            return super.initializePom(localArtifactRepository);
        }
    }

    public void clearAttachedArtifactsList() {
        attachedArtifacts.clear();
    }
}
