/* 
 * gpsk31  - PSK31 for Linux with a GTK+ Interface
 * 
 * Copyright (C) 2000 Luc Langehegermann, LX2GT
 * Copyright (C) 2008 Thomas Ries <tries@gmx.net>
 * Copyright (C) 2005,2006,2007,2008 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * The main author can be reached at pg4i@amsat.org or by smail-mail:
 * Joop Stakenborg, Bramengaarde 24, 3992KG Houten, The Netherlands.
 * 
 */

/*
 * globals.h - Definitions of global Variables
 */

struct qsodata			/* The Data of the current QSO */
{
  gchar call[13];
  gchar name[26];
  gchar qth[26];
  gchar rst_s[9];
  gchar rst_r[9];
  gchar notes[41];
  gchar freq[11];
};
extern struct qsodata qsodata;

struct qso_dialog		/* The Text entry widgets for the call entry dialog */
{
  GtkWidget *call_text;
  GtkWidget *name_text;
  GtkWidget *qth_text;
  GtkWidget *notes_text;
  GtkWidget *rst_s_text;
  GtkWidget *rst_r_text;
  GtkWidget *freq_text;
  GtkWidget *window;
};
extern struct qso_dialog qso_dialog;

struct statusbar		/* The Statusbar Widgets */
{
  GtkWidget *logged;
  GtkWidget *mode;
  GtkWidget *txstate;
  GtkWidget *time;
};
extern struct statusbar statusbar;

struct highlight
{
  gchar *tx;
  gchar *rxrx;
  gchar *rxtx;
};
extern struct highlight highlight;

struct main_screen
{
  GdkPixmap *phase_scope;	/* For drawing the phase scope */
  GdkPixmap *spectrum;		/* For drawing the spectrum analizer */
  GtkWidget *rxwindow;		/* RX Window */
  GtkWidget *txwindow;
  GtkWidget *window;		/* The Main Widget */
  GtkWidget *phase_drawing;	/* Phase Scope drawing area */
  GtkWidget *spectrum_drawing;	/* Spectrum drawing area */
  GdkPixbuf *gbl_wfall_pixbuf;	/* Waterfall Pixmap */
  GtkWidget *rx_freq;
  GtkWidget *tx_freq;
  GtkWidget *dcd;
  GtkWidget *cwid;
  GtkWidget *afc;
  GtkWidget *net;
  GtkWidget *mode_qpsk;
  GtkWidget *mode_bpsk;
  GtkWidget *mode_autotx;
  GtkWidget *menu;
  GtkWidget *f_button[8];
  GtkAdjustment *dcd_adj;
};
extern struct main_screen main_screen;

struct ini_settings		/* Settings to be written in config file */
{
  gchar *tx_window_color;
  gchar *tx_window_font;

  gchar *rx_window_color_rx;
  gchar *rx_window_color_tx;
  gchar *rx_window_font;

  gchar *phase_scope_dcd_on_color;
  gchar *phase_scope_dcd_off_color;
  gchar *phase_scope_arc_color;

  gchar *spectrum_color;
  gchar *spectrum_tune_line_color;
  gchar *spectrum_center_line_color;
  gint spectrum_width;
  gint spectrum_speed;

  gchar *ptt_device;
  gchar *audio_device;

  gchar *name;
  gchar *qth;
  gchar *call;
  gchar *cw_string;

  gint freq;
  gint dcd_level;
  gint lsb;

  gint new_rx;
  gchar *log_filename;
  gint xlog_auto_freq;
  gint tcp_listen_port;

  gchar *label[16];
  gchar *text[16];
};
extern struct ini_settings ini_settings;  


#define SPECTRUM_WIDTH	200
#define SPECTRUM_HEIGHT	100

