package servicefabric

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/servicefabric/mgmt/2016-09-01/servicefabric"

// ClusterState enumerates the values for cluster state.
type ClusterState string

const (
	// AutoScale ...
	AutoScale ClusterState = "AutoScale"
	// BaselineUpgrade ...
	BaselineUpgrade ClusterState = "BaselineUpgrade"
	// Deploying ...
	Deploying ClusterState = "Deploying"
	// EnforcingClusterVersion ...
	EnforcingClusterVersion ClusterState = "EnforcingClusterVersion"
	// Ready ...
	Ready ClusterState = "Ready"
	// UpdatingInfrastructure ...
	UpdatingInfrastructure ClusterState = "UpdatingInfrastructure"
	// UpdatingUserCertificate ...
	UpdatingUserCertificate ClusterState = "UpdatingUserCertificate"
	// UpdatingUserConfiguration ...
	UpdatingUserConfiguration ClusterState = "UpdatingUserConfiguration"
	// UpgradeServiceUnreachable ...
	UpgradeServiceUnreachable ClusterState = "UpgradeServiceUnreachable"
	// WaitingForNodes ...
	WaitingForNodes ClusterState = "WaitingForNodes"
)

// PossibleClusterStateValues returns an array of possible values for the ClusterState const type.
func PossibleClusterStateValues() []ClusterState {
	return []ClusterState{AutoScale, BaselineUpgrade, Deploying, EnforcingClusterVersion, Ready, UpdatingInfrastructure, UpdatingUserCertificate, UpdatingUserConfiguration, UpgradeServiceUnreachable, WaitingForNodes}
}

// DurabilityLevel enumerates the values for durability level.
type DurabilityLevel string

const (
	// Bronze ...
	Bronze DurabilityLevel = "Bronze"
	// Gold ...
	Gold DurabilityLevel = "Gold"
	// Silver ...
	Silver DurabilityLevel = "Silver"
)

// PossibleDurabilityLevelValues returns an array of possible values for the DurabilityLevel const type.
func PossibleDurabilityLevelValues() []DurabilityLevel {
	return []DurabilityLevel{Bronze, Gold, Silver}
}

// Environment enumerates the values for environment.
type Environment string

const (
	// Linux ...
	Linux Environment = "Linux"
	// Windows ...
	Windows Environment = "Windows"
)

// PossibleEnvironmentValues returns an array of possible values for the Environment const type.
func PossibleEnvironmentValues() []Environment {
	return []Environment{Linux, Windows}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Canceled ...
	Canceled ProvisioningState = "Canceled"
	// Failed ...
	Failed ProvisioningState = "Failed"
	// Succeeded ...
	Succeeded ProvisioningState = "Succeeded"
	// Updating ...
	Updating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Canceled, Failed, Succeeded, Updating}
}

// ReliabilityLevel enumerates the values for reliability level.
type ReliabilityLevel string

const (
	// ReliabilityLevelBronze ...
	ReliabilityLevelBronze ReliabilityLevel = "Bronze"
	// ReliabilityLevelGold ...
	ReliabilityLevelGold ReliabilityLevel = "Gold"
	// ReliabilityLevelSilver ...
	ReliabilityLevelSilver ReliabilityLevel = "Silver"
)

// PossibleReliabilityLevelValues returns an array of possible values for the ReliabilityLevel const type.
func PossibleReliabilityLevelValues() []ReliabilityLevel {
	return []ReliabilityLevel{ReliabilityLevelBronze, ReliabilityLevelGold, ReliabilityLevelSilver}
}

// ReliabilityLevel1 enumerates the values for reliability level 1.
type ReliabilityLevel1 string

const (
	// ReliabilityLevel1Bronze ...
	ReliabilityLevel1Bronze ReliabilityLevel1 = "Bronze"
	// ReliabilityLevel1Gold ...
	ReliabilityLevel1Gold ReliabilityLevel1 = "Gold"
	// ReliabilityLevel1Platinum ...
	ReliabilityLevel1Platinum ReliabilityLevel1 = "Platinum"
	// ReliabilityLevel1Silver ...
	ReliabilityLevel1Silver ReliabilityLevel1 = "Silver"
)

// PossibleReliabilityLevel1Values returns an array of possible values for the ReliabilityLevel1 const type.
func PossibleReliabilityLevel1Values() []ReliabilityLevel1 {
	return []ReliabilityLevel1{ReliabilityLevel1Bronze, ReliabilityLevel1Gold, ReliabilityLevel1Platinum, ReliabilityLevel1Silver}
}

// UpgradeMode enumerates the values for upgrade mode.
type UpgradeMode string

const (
	// Automatic ...
	Automatic UpgradeMode = "Automatic"
	// Manual ...
	Manual UpgradeMode = "Manual"
)

// PossibleUpgradeModeValues returns an array of possible values for the UpgradeMode const type.
func PossibleUpgradeModeValues() []UpgradeMode {
	return []UpgradeMode{Automatic, Manual}
}

// UpgradeMode1 enumerates the values for upgrade mode 1.
type UpgradeMode1 string

const (
	// UpgradeMode1Automatic ...
	UpgradeMode1Automatic UpgradeMode1 = "Automatic"
	// UpgradeMode1Manual ...
	UpgradeMode1Manual UpgradeMode1 = "Manual"
)

// PossibleUpgradeMode1Values returns an array of possible values for the UpgradeMode1 const type.
func PossibleUpgradeMode1Values() []UpgradeMode1 {
	return []UpgradeMode1{UpgradeMode1Automatic, UpgradeMode1Manual}
}

// X509StoreName enumerates the values for x509 store name.
type X509StoreName string

const (
	// AddressBook ...
	AddressBook X509StoreName = "AddressBook"
	// AuthRoot ...
	AuthRoot X509StoreName = "AuthRoot"
	// CertificateAuthority ...
	CertificateAuthority X509StoreName = "CertificateAuthority"
	// Disallowed ...
	Disallowed X509StoreName = "Disallowed"
	// My ...
	My X509StoreName = "My"
	// Root ...
	Root X509StoreName = "Root"
	// TrustedPeople ...
	TrustedPeople X509StoreName = "TrustedPeople"
	// TrustedPublisher ...
	TrustedPublisher X509StoreName = "TrustedPublisher"
)

// PossibleX509StoreNameValues returns an array of possible values for the X509StoreName const type.
func PossibleX509StoreNameValues() []X509StoreName {
	return []X509StoreName{AddressBook, AuthRoot, CertificateAuthority, Disallowed, My, Root, TrustedPeople, TrustedPublisher}
}

// AvailableOperationDisplay operation supported by ServiceFabric resource provider
type AvailableOperationDisplay struct {
	// Provider - Provider name
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource name
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation name
	Operation *string `json:"operation,omitempty"`
	// Description - Operation description
	Description *string `json:"description,omitempty"`
}

// AzureActiveDirectory the settings to enable AAD authentication on the cluster
type AzureActiveDirectory struct {
	// TenantID - Azure active directory tenant id
	TenantID *string `json:"tenantId,omitempty"`
	// ClusterApplication - Azure active directory cluster application id
	ClusterApplication *string `json:"clusterApplication,omitempty"`
	// ClientApplication - Azure active directory client application id
	ClientApplication *string `json:"clientApplication,omitempty"`
}

// CertificateDescription certificate details
type CertificateDescription struct {
	// Thumbprint - Thumbprint of the primary certificate
	Thumbprint *string `json:"thumbprint,omitempty"`
	// ThumbprintSecondary - Thumbprint of the secondary certificate
	ThumbprintSecondary *string `json:"thumbprintSecondary,omitempty"`
	// X509StoreName - The local certificate store location. Possible values include: 'AddressBook', 'AuthRoot', 'CertificateAuthority', 'Disallowed', 'My', 'Root', 'TrustedPeople', 'TrustedPublisher'
	X509StoreName X509StoreName `json:"x509StoreName,omitempty"`
}

// ClientCertificateCommonName client certificate details using common name
type ClientCertificateCommonName struct {
	// IsAdmin - Is this certificate used for admin access from the client, if false , it is used or query only access
	IsAdmin *bool `json:"isAdmin,omitempty"`
	// CertificateCommonName - Certificate common name to be granted access; be careful using wild card common names
	CertificateCommonName *string `json:"certificateCommonName,omitempty"`
	// CertificateIssuerThumbprint - Certificate issuer thumbprint
	CertificateIssuerThumbprint *string `json:"certificateIssuerThumbprint,omitempty"`
}

// ClientCertificateThumbprint client certificate details using thumbprint
type ClientCertificateThumbprint struct {
	// IsAdmin - Is this certificate used for admin access from the client, if false, it is used or query only access
	IsAdmin *bool `json:"isAdmin,omitempty"`
	// CertificateThumbprint - Certificate thumbprint
	CertificateThumbprint *string `json:"certificateThumbprint,omitempty"`
}

// Cluster the cluster resource
type Cluster struct {
	autorest.Response  `json:"-"`
	*ClusterProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Cluster.
func (c Cluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.ClusterProperties != nil {
		objectMap["properties"] = c.ClusterProperties
	}
	if c.Location != nil {
		objectMap["location"] = c.Location
	}
	if c.Tags != nil {
		objectMap["tags"] = c.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Cluster struct.
func (c *Cluster) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var clusterProperties ClusterProperties
				err = json.Unmarshal(*v, &clusterProperties)
				if err != nil {
					return err
				}
				c.ClusterProperties = &clusterProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				c.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				c.Tags = tags
			}
		}
	}

	return nil
}

// ClusterCodeVersionsListResult the list results of the ServiceFabric runtime versions
type ClusterCodeVersionsListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ClusterCodeVersionsResult `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ClusterCodeVersionsListResultIterator provides access to a complete listing of ClusterCodeVersionsResult
// values.
type ClusterCodeVersionsListResultIterator struct {
	i    int
	page ClusterCodeVersionsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ClusterCodeVersionsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClusterCodeVersionsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ClusterCodeVersionsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ClusterCodeVersionsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ClusterCodeVersionsListResultIterator) Response() ClusterCodeVersionsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ClusterCodeVersionsListResultIterator) Value() ClusterCodeVersionsResult {
	if !iter.page.NotDone() {
		return ClusterCodeVersionsResult{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ClusterCodeVersionsListResultIterator type.
func NewClusterCodeVersionsListResultIterator(page ClusterCodeVersionsListResultPage) ClusterCodeVersionsListResultIterator {
	return ClusterCodeVersionsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ccvlr ClusterCodeVersionsListResult) IsEmpty() bool {
	return ccvlr.Value == nil || len(*ccvlr.Value) == 0
}

// clusterCodeVersionsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ccvlr ClusterCodeVersionsListResult) clusterCodeVersionsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if ccvlr.NextLink == nil || len(to.String(ccvlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ccvlr.NextLink)))
}

// ClusterCodeVersionsListResultPage contains a page of ClusterCodeVersionsResult values.
type ClusterCodeVersionsListResultPage struct {
	fn    func(context.Context, ClusterCodeVersionsListResult) (ClusterCodeVersionsListResult, error)
	ccvlr ClusterCodeVersionsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ClusterCodeVersionsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClusterCodeVersionsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ccvlr)
	if err != nil {
		return err
	}
	page.ccvlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ClusterCodeVersionsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ClusterCodeVersionsListResultPage) NotDone() bool {
	return !page.ccvlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ClusterCodeVersionsListResultPage) Response() ClusterCodeVersionsListResult {
	return page.ccvlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ClusterCodeVersionsListResultPage) Values() []ClusterCodeVersionsResult {
	if page.ccvlr.IsEmpty() {
		return nil
	}
	return *page.ccvlr.Value
}

// Creates a new instance of the ClusterCodeVersionsListResultPage type.
func NewClusterCodeVersionsListResultPage(getNextPage func(context.Context, ClusterCodeVersionsListResult) (ClusterCodeVersionsListResult, error)) ClusterCodeVersionsListResultPage {
	return ClusterCodeVersionsListResultPage{fn: getNextPage}
}

// ClusterCodeVersionsResult the result of the ServiceFabric runtime versions
type ClusterCodeVersionsResult struct {
	autorest.Response `json:"-"`
	// ID - The identification of the result
	ID *string `json:"id,omitempty"`
	// Name - The name of the result
	Name *string `json:"name,omitempty"`
	// Type - The result resource type
	Type                   *string `json:"type,omitempty"`
	*ClusterVersionDetails `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterCodeVersionsResult.
func (ccvr ClusterCodeVersionsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ccvr.ID != nil {
		objectMap["id"] = ccvr.ID
	}
	if ccvr.Name != nil {
		objectMap["name"] = ccvr.Name
	}
	if ccvr.Type != nil {
		objectMap["type"] = ccvr.Type
	}
	if ccvr.ClusterVersionDetails != nil {
		objectMap["properties"] = ccvr.ClusterVersionDetails
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ClusterCodeVersionsResult struct.
func (ccvr *ClusterCodeVersionsResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ccvr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ccvr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ccvr.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var clusterVersionDetails ClusterVersionDetails
				err = json.Unmarshal(*v, &clusterVersionDetails)
				if err != nil {
					return err
				}
				ccvr.ClusterVersionDetails = &clusterVersionDetails
			}
		}
	}

	return nil
}

// ClusterHealthPolicy defines a health policy used to evaluate the health of the cluster or of a cluster
// node.
type ClusterHealthPolicy struct {
	// MaxPercentUnhealthyNodes - The maximum allowed percentage of unhealthy nodes before reporting an error. For example, to allow 10% of nodes to be unhealthy, this value would be 10.
	MaxPercentUnhealthyNodes *int32 `json:"maxPercentUnhealthyNodes,omitempty"`
	// MaxPercentUnhealthyApplications - The maximum allowed percentage of unhealthy applications before reporting an error. For example, to allow 10% of applications to be unhealthy, this value would be 10.
	MaxPercentUnhealthyApplications *int32 `json:"maxPercentUnhealthyApplications,omitempty"`
}

// ClusterListResult cluster list results
type ClusterListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Cluster `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ClusterListResultIterator provides access to a complete listing of Cluster values.
type ClusterListResultIterator struct {
	i    int
	page ClusterListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ClusterListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClusterListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ClusterListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ClusterListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ClusterListResultIterator) Response() ClusterListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ClusterListResultIterator) Value() Cluster {
	if !iter.page.NotDone() {
		return Cluster{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ClusterListResultIterator type.
func NewClusterListResultIterator(page ClusterListResultPage) ClusterListResultIterator {
	return ClusterListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (clr ClusterListResult) IsEmpty() bool {
	return clr.Value == nil || len(*clr.Value) == 0
}

// clusterListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (clr ClusterListResult) clusterListResultPreparer(ctx context.Context) (*http.Request, error) {
	if clr.NextLink == nil || len(to.String(clr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(clr.NextLink)))
}

// ClusterListResultPage contains a page of Cluster values.
type ClusterListResultPage struct {
	fn  func(context.Context, ClusterListResult) (ClusterListResult, error)
	clr ClusterListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ClusterListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClusterListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.clr)
	if err != nil {
		return err
	}
	page.clr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ClusterListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ClusterListResultPage) NotDone() bool {
	return !page.clr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ClusterListResultPage) Response() ClusterListResult {
	return page.clr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ClusterListResultPage) Values() []Cluster {
	if page.clr.IsEmpty() {
		return nil
	}
	return *page.clr.Value
}

// Creates a new instance of the ClusterListResultPage type.
func NewClusterListResultPage(getNextPage func(context.Context, ClusterListResult) (ClusterListResult, error)) ClusterListResultPage {
	return ClusterListResultPage{fn: getNextPage}
}

// ClusterProperties the cluster resource properties
type ClusterProperties struct {
	// AvailableClusterVersions - READ-ONLY; The available cluster code version which the cluster can upgrade to, note that you must choose upgradeMode to manual to upgrade to
	AvailableClusterVersions *[]ClusterVersionDetails `json:"availableClusterVersions,omitempty"`
	// ClusterID - READ-ONLY; The unique identifier for the cluster resource
	ClusterID *string `json:"clusterId,omitempty"`
	// ClusterState - READ-ONLY; The state for the cluster. Possible values include: 'WaitingForNodes', 'Deploying', 'BaselineUpgrade', 'UpdatingUserConfiguration', 'UpdatingUserCertificate', 'UpdatingInfrastructure', 'EnforcingClusterVersion', 'UpgradeServiceUnreachable', 'AutoScale', 'Ready'
	ClusterState ClusterState `json:"clusterState,omitempty"`
	// ClusterEndpoint - READ-ONLY; The endpoint for the cluster connecting to servicefabric resource provider
	ClusterEndpoint *string `json:"clusterEndpoint,omitempty"`
	// ClusterCodeVersion - The ServiceFabric code version running in your cluster
	ClusterCodeVersion *string `json:"clusterCodeVersion,omitempty"`
	// Certificate - This primary certificate will be used as cluster node to node security, SSL certificate for cluster management endpoint and default admin client
	Certificate *CertificateDescription `json:"certificate,omitempty"`
	// ReliabilityLevel - Cluster reliability level indicates replica set size of system service. Possible values include: 'ReliabilityLevel1Bronze', 'ReliabilityLevel1Silver', 'ReliabilityLevel1Gold', 'ReliabilityLevel1Platinum'
	ReliabilityLevel ReliabilityLevel1 `json:"reliabilityLevel,omitempty"`
	// UpgradeMode - Cluster upgrade mode indicates if fabric upgrade is initiated automatically by the system or not. Possible values include: 'UpgradeMode1Automatic', 'UpgradeMode1Manual'
	UpgradeMode UpgradeMode1 `json:"upgradeMode,omitempty"`
	// ClientCertificateThumbprints - The client thumbprint details ,it is used for client access for cluster operation
	ClientCertificateThumbprints *[]ClientCertificateThumbprint `json:"clientCertificateThumbprints,omitempty"`
	// ClientCertificateCommonNames -  List of client certificates to whitelist based on common names
	ClientCertificateCommonNames *[]ClientCertificateCommonName `json:"clientCertificateCommonNames,omitempty"`
	// FabricSettings - List of custom fabric settings to configure the cluster.
	FabricSettings *[]SettingsSectionDescription `json:"fabricSettings,omitempty"`
	// ReverseProxyCertificate - The server certificate used by reverse proxy
	ReverseProxyCertificate *CertificateDescription `json:"reverseProxyCertificate,omitempty"`
	// ManagementEndpoint - The http management endpoint of the cluster
	ManagementEndpoint *string `json:"managementEndpoint,omitempty"`
	// NodeTypes - The list of node types that make up the cluster
	NodeTypes *[]NodeTypeDescription `json:"nodeTypes,omitempty"`
	// AzureActiveDirectory - The settings to enable AAD authentication on the cluster
	AzureActiveDirectory *AzureActiveDirectory `json:"azureActiveDirectory,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the cluster resource. Possible values include: 'Updating', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// VMImage - The name of VM image VMSS has been configured with. Generic names such as Windows or Linux can be used.
	VMImage *string `json:"vmImage,omitempty"`
	// DiagnosticsStorageAccountConfig - The storage diagnostics account configuration details
	DiagnosticsStorageAccountConfig *DiagnosticsStorageAccountConfig `json:"diagnosticsStorageAccountConfig,omitempty"`
	// UpgradeDescription - The policy to use when upgrading the cluster.
	UpgradeDescription *ClusterUpgradePolicy `json:"upgradeDescription,omitempty"`
}

// ClusterPropertiesUpdateParameters the cluster resource properties can be updated
type ClusterPropertiesUpdateParameters struct {
	// ReliabilityLevel - This level is used to set the number of replicas of the system services. Possible values include: 'ReliabilityLevelBronze', 'ReliabilityLevelSilver', 'ReliabilityLevelGold'
	ReliabilityLevel ReliabilityLevel `json:"reliabilityLevel,omitempty"`
	// UpgradeMode - Cluster upgrade mode indicates if fabric upgrade is initiated automatically by the system or not. Possible values include: 'Automatic', 'Manual'
	UpgradeMode UpgradeMode `json:"upgradeMode,omitempty"`
	// ClusterCodeVersion - The ServiceFabric code version, if set it, please make sure you have set upgradeMode to Manual, otherwise ,it will fail, if you are using PUT new cluster, you can get the version by using ClusterVersions_List, if you are updating existing cluster, you can get the availableClusterVersions from Clusters_Get
	ClusterCodeVersion *string `json:"clusterCodeVersion,omitempty"`
	// Certificate - This primary certificate will be used as cluster node to node security, SSL certificate for cluster management endpoint and default admin client, the certificate should exist in the virtual machine scale sets or Azure key vault, before you add it. It will override original value
	Certificate *CertificateDescription `json:"certificate,omitempty"`
	// ClientCertificateThumbprints - The client thumbprint details, it is used for client access for cluster operation, it will override existing collection
	ClientCertificateThumbprints *[]ClientCertificateThumbprint `json:"clientCertificateThumbprints,omitempty"`
	// ClientCertificateCommonNames - List of client certificates to whitelist based on common names.
	ClientCertificateCommonNames *[]ClientCertificateCommonName `json:"clientCertificateCommonNames,omitempty"`
	// FabricSettings - List of custom fabric settings to configure the cluster, Note, it will overwrite existing collection
	FabricSettings *[]SettingsSectionDescription `json:"fabricSettings,omitempty"`
	// ReverseProxyCertificate - Certificate for the reverse proxy
	ReverseProxyCertificate *CertificateDescription `json:"reverseProxyCertificate,omitempty"`
	// NodeTypes - The list of node types that make up the cluster, it will override
	NodeTypes *[]NodeTypeDescription `json:"nodeTypes,omitempty"`
	// UpgradeDescription - The policy to use when upgrading the cluster.
	UpgradeDescription *ClusterUpgradePolicy `json:"upgradeDescription,omitempty"`
}

// ClustersCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ClustersCreateFuture) Result(client ClustersClient) (c Cluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ClustersCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicefabric.ClustersCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.CreateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "servicefabric.ClustersCreateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ClustersUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ClustersUpdateFuture) Result(client ClustersClient) (c Cluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ClustersUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicefabric.ClustersUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.UpdateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "servicefabric.ClustersUpdateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ClusterUpdateParameters cluster update request
type ClusterUpdateParameters struct {
	*ClusterPropertiesUpdateParameters `json:"properties,omitempty"`
	// Tags - Cluster update parameters
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ClusterUpdateParameters.
func (cup ClusterUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cup.ClusterPropertiesUpdateParameters != nil {
		objectMap["properties"] = cup.ClusterPropertiesUpdateParameters
	}
	if cup.Tags != nil {
		objectMap["tags"] = cup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ClusterUpdateParameters struct.
func (cup *ClusterUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var clusterPropertiesUpdateParameters ClusterPropertiesUpdateParameters
				err = json.Unmarshal(*v, &clusterPropertiesUpdateParameters)
				if err != nil {
					return err
				}
				cup.ClusterPropertiesUpdateParameters = &clusterPropertiesUpdateParameters
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cup.Tags = tags
			}
		}
	}

	return nil
}

// ClusterUpgradeDeltaHealthPolicy delta health policy for the cluster
type ClusterUpgradeDeltaHealthPolicy struct {
	// MaxPercentDeltaUnhealthyNodes - Additional unhealthy nodes percentage
	MaxPercentDeltaUnhealthyNodes *int32 `json:"maxPercentDeltaUnhealthyNodes,omitempty"`
	// MaxPercentUpgradeDomainDeltaUnhealthyNodes - Additional unhealthy nodes percentage per upgrade domain
	MaxPercentUpgradeDomainDeltaUnhealthyNodes *int32 `json:"maxPercentUpgradeDomainDeltaUnhealthyNodes,omitempty"`
	// MaxPercentDeltaUnhealthyApplications - Additional unhealthy applications percentage
	MaxPercentDeltaUnhealthyApplications *int32 `json:"maxPercentDeltaUnhealthyApplications,omitempty"`
}

// ClusterUpgradePolicy cluster upgrade policy
type ClusterUpgradePolicy struct {
	// OverrideUserUpgradePolicy - Use the user defined upgrade policy or not
	OverrideUserUpgradePolicy *bool `json:"overrideUserUpgradePolicy,omitempty"`
	// ForceRestart - Force node to restart or not
	ForceRestart *bool `json:"forceRestart,omitempty"`
	// UpgradeReplicaSetCheckTimeout - Timeout for replica set upgrade to complete,it represents .Net TimeSpan
	UpgradeReplicaSetCheckTimeout *string `json:"upgradeReplicaSetCheckTimeout,omitempty"`
	// HealthCheckWaitDuration - The length of time to wait after completing an upgrade domain before performing health checks, it represents .Net TimeSpan
	HealthCheckWaitDuration *string `json:"healthCheckWaitDuration,omitempty"`
	// HealthCheckStableDuration - The length of time that health checks must pass continuously,it represents .Net TimeSpan
	HealthCheckStableDuration *string `json:"healthCheckStableDuration,omitempty"`
	// HealthCheckRetryTimeout - The length of time that health checks can fail continuously,it represents .Net TimeSpan
	HealthCheckRetryTimeout *string `json:"healthCheckRetryTimeout,omitempty"`
	// UpgradeTimeout - The upgrade timeout,it represents .Net TimeSpan
	UpgradeTimeout *string `json:"upgradeTimeout,omitempty"`
	// UpgradeDomainTimeout - The timeout for any upgrade domain,it represents .Net TimeSpan
	UpgradeDomainTimeout *string `json:"upgradeDomainTimeout,omitempty"`
	// HealthPolicy - Cluster health Policy
	HealthPolicy *ClusterHealthPolicy `json:"healthPolicy,omitempty"`
	// DeltaHealthPolicy - Delta health policy
	DeltaHealthPolicy *ClusterUpgradeDeltaHealthPolicy `json:"deltaHealthPolicy,omitempty"`
}

// ClusterVersionDetails the detail of the ServiceFabric runtime version result
type ClusterVersionDetails struct {
	// CodeVersion - The ServiceFabric runtime version of the cluster
	CodeVersion *string `json:"codeVersion,omitempty"`
	// SupportExpiryUtc - The date of expiry of support of the version
	SupportExpiryUtc *string `json:"supportExpiryUtc,omitempty"`
	// Environment - Cluster operating system. Possible values include: 'Windows', 'Linux'
	Environment Environment `json:"environment,omitempty"`
}

// DiagnosticsStorageAccountConfig diagnostics storage account config
type DiagnosticsStorageAccountConfig struct {
	// StorageAccountName - Diagnostics storage account name
	StorageAccountName *string `json:"storageAccountName,omitempty"`
	// ProtectedAccountKeyName - Protected Diagnostics storage key name
	ProtectedAccountKeyName *string `json:"protectedAccountKeyName,omitempty"`
	// BlobEndpoint - Diagnostics storage account blob endpoint
	BlobEndpoint *string `json:"blobEndpoint,omitempty"`
	// QueueEndpoint - Diagnostics storage account queue endpoint
	QueueEndpoint *string `json:"queueEndpoint,omitempty"`
	// TableEndpoint - Diagnostics storage account table endpoint
	TableEndpoint *string `json:"tableEndpoint,omitempty"`
}

// EndpointRangeDescription port range details
type EndpointRangeDescription struct {
	// StartPort - Starting port of a range of ports
	StartPort *int32 `json:"startPort,omitempty"`
	// EndPort - End port of a range of ports
	EndPort *int32 `json:"endPort,omitempty"`
}

// ErrorModel the structure of the error
type ErrorModel struct {
	// Error - The error detail
	Error *ErrorModelError `json:"error,omitempty"`
}

// ErrorModelError the error detail
type ErrorModelError struct {
	// Code - The error code
	Code *string `json:"code,omitempty"`
	// Message - The error message
	Message *string `json:"message,omitempty"`
}

// NodeTypeDescription describes a node type in the cluster, each node type represents sub set of nodes in
// the cluster
type NodeTypeDescription struct {
	// Name - Name of the node type
	Name *string `json:"name,omitempty"`
	// PlacementProperties - The placement tags applied to nodes in the node type, which can be used to indicate where certain services (workload) should run
	PlacementProperties map[string]*string `json:"placementProperties"`
	// Capacities - The capacity tags applied to the nodes in the node type, the cluster resource manager uses these tags to understand how much of a resource a node has
	Capacities map[string]*string `json:"capacities"`
	// ClientConnectionEndpointPort - The TCP cluster management endpoint port
	ClientConnectionEndpointPort *int32 `json:"clientConnectionEndpointPort,omitempty"`
	// HTTPGatewayEndpointPort - The HTTP cluster management endpoint port
	HTTPGatewayEndpointPort *int32 `json:"httpGatewayEndpointPort,omitempty"`
	// DurabilityLevel - Node type durability Level. Possible values include: 'Bronze', 'Silver', 'Gold'
	DurabilityLevel DurabilityLevel `json:"durabilityLevel,omitempty"`
	// ApplicationPorts - Ports used by applications
	ApplicationPorts *EndpointRangeDescription `json:"applicationPorts,omitempty"`
	// EphemeralPorts - System assigned application ports
	EphemeralPorts *EndpointRangeDescription `json:"ephemeralPorts,omitempty"`
	// IsPrimary - Mark this as the primary node type
	IsPrimary *bool `json:"isPrimary,omitempty"`
	// VMInstanceCount - The number of node instances in the node type
	VMInstanceCount *int32 `json:"vmInstanceCount,omitempty"`
	// ReverseProxyEndpointPort - Endpoint used by reverse proxy
	ReverseProxyEndpointPort *int32 `json:"reverseProxyEndpointPort,omitempty"`
}

// MarshalJSON is the custom marshaler for NodeTypeDescription.
func (ntd NodeTypeDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ntd.Name != nil {
		objectMap["name"] = ntd.Name
	}
	if ntd.PlacementProperties != nil {
		objectMap["placementProperties"] = ntd.PlacementProperties
	}
	if ntd.Capacities != nil {
		objectMap["capacities"] = ntd.Capacities
	}
	if ntd.ClientConnectionEndpointPort != nil {
		objectMap["clientConnectionEndpointPort"] = ntd.ClientConnectionEndpointPort
	}
	if ntd.HTTPGatewayEndpointPort != nil {
		objectMap["httpGatewayEndpointPort"] = ntd.HTTPGatewayEndpointPort
	}
	if ntd.DurabilityLevel != "" {
		objectMap["durabilityLevel"] = ntd.DurabilityLevel
	}
	if ntd.ApplicationPorts != nil {
		objectMap["applicationPorts"] = ntd.ApplicationPorts
	}
	if ntd.EphemeralPorts != nil {
		objectMap["ephemeralPorts"] = ntd.EphemeralPorts
	}
	if ntd.IsPrimary != nil {
		objectMap["isPrimary"] = ntd.IsPrimary
	}
	if ntd.VMInstanceCount != nil {
		objectMap["vmInstanceCount"] = ntd.VMInstanceCount
	}
	if ntd.ReverseProxyEndpointPort != nil {
		objectMap["reverseProxyEndpointPort"] = ntd.ReverseProxyEndpointPort
	}
	return json.Marshal(objectMap)
}

// OperationListResult result of the request to list ServiceFabric operations. It contains a list of
// operations and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of ServiceFabric operations supported by the Microsoft.ServiceFabric resource provider.
	Value *[]OperationResult `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of OperationResult values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() OperationResult {
	if !iter.page.NotDone() {
		return OperationResult{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of OperationResult values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []OperationResult {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{fn: getNextPage}
}

// OperationResult available operation list result
type OperationResult struct {
	// Name - Result name
	Name *string `json:"name,omitempty"`
	// Display - Display of the result
	Display *AvailableOperationDisplay `json:"display,omitempty"`
	// Origin - Origin result
	Origin *string `json:"origin,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// Resource the resource model definition.
type Resource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// SettingsParameterDescription serviceFabric settings under sections
type SettingsParameterDescription struct {
	// Name - The name of settings property
	Name *string `json:"name,omitempty"`
	// Value - The value of the property
	Value *string `json:"value,omitempty"`
}

// SettingsSectionDescription serviceFabric section settings
type SettingsSectionDescription struct {
	// Name - The name of settings section
	Name *string `json:"name,omitempty"`
	// Parameters - Collection of settings in the section, each setting is a tuple consisting of setting name and value
	Parameters *[]SettingsParameterDescription `json:"parameters,omitempty"`
}
