// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package launchwizard

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opCreateDeployment = "CreateDeployment"

// CreateDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the CreateDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDeployment for more information on using the CreateDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDeploymentRequest method.
//	req, resp := client.CreateDeploymentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/CreateDeployment
func (c *LaunchWizard) CreateDeploymentRequest(input *CreateDeploymentInput) (req *request.Request, output *CreateDeploymentOutput) {
	op := &request.Operation{
		Name:       opCreateDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/createDeployment",
	}

	if input == nil {
		input = &CreateDeploymentInput{}
	}

	output = &CreateDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDeployment API operation for AWS Launch Wizard.
//
// Creates a deployment for the given workload. Deployments created by this
// operation are not available in the Launch Wizard console to use the Clone
// deployment action on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Launch Wizard's
// API operation CreateDeployment for usage and error information.
//
// Returned Error Types:
//
//   - ResourceLimitException
//     You have exceeded an Launch Wizard resource limit. For example, you might
//     have too many deployments in progress.
//
//   - InternalServerException
//     An internal error has occurred. Retry your request, but if the problem persists,
//     contact us with details by posting a question on re:Post (https://repost.aws/).
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ResourceNotFoundException
//     The specified workload or deployment resource can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/CreateDeployment
func (c *LaunchWizard) CreateDeployment(input *CreateDeploymentInput) (*CreateDeploymentOutput, error) {
	req, out := c.CreateDeploymentRequest(input)
	return out, req.Send()
}

// CreateDeploymentWithContext is the same as CreateDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LaunchWizard) CreateDeploymentWithContext(ctx aws.Context, input *CreateDeploymentInput, opts ...request.Option) (*CreateDeploymentOutput, error) {
	req, out := c.CreateDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDeployment = "DeleteDeployment"

// DeleteDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDeployment for more information on using the DeleteDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDeploymentRequest method.
//	req, resp := client.DeleteDeploymentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/DeleteDeployment
func (c *LaunchWizard) DeleteDeploymentRequest(input *DeleteDeploymentInput) (req *request.Request, output *DeleteDeploymentOutput) {
	op := &request.Operation{
		Name:       opDeleteDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/deleteDeployment",
	}

	if input == nil {
		input = &DeleteDeploymentInput{}
	}

	output = &DeleteDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDeployment API operation for AWS Launch Wizard.
//
// Deletes a deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Launch Wizard's
// API operation DeleteDeployment for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An internal error has occurred. Retry your request, but if the problem persists,
//     contact us with details by posting a question on re:Post (https://repost.aws/).
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ResourceNotFoundException
//     The specified workload or deployment resource can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/DeleteDeployment
func (c *LaunchWizard) DeleteDeployment(input *DeleteDeploymentInput) (*DeleteDeploymentOutput, error) {
	req, out := c.DeleteDeploymentRequest(input)
	return out, req.Send()
}

// DeleteDeploymentWithContext is the same as DeleteDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LaunchWizard) DeleteDeploymentWithContext(ctx aws.Context, input *DeleteDeploymentInput, opts ...request.Option) (*DeleteDeploymentOutput, error) {
	req, out := c.DeleteDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDeployment = "GetDeployment"

// GetDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the GetDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeployment for more information on using the GetDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDeploymentRequest method.
//	req, resp := client.GetDeploymentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/GetDeployment
func (c *LaunchWizard) GetDeploymentRequest(input *GetDeploymentInput) (req *request.Request, output *GetDeploymentOutput) {
	op := &request.Operation{
		Name:       opGetDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/getDeployment",
	}

	if input == nil {
		input = &GetDeploymentInput{}
	}

	output = &GetDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeployment API operation for AWS Launch Wizard.
//
// Returns information about the deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Launch Wizard's
// API operation GetDeployment for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An internal error has occurred. Retry your request, but if the problem persists,
//     contact us with details by posting a question on re:Post (https://repost.aws/).
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ResourceNotFoundException
//     The specified workload or deployment resource can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/GetDeployment
func (c *LaunchWizard) GetDeployment(input *GetDeploymentInput) (*GetDeploymentOutput, error) {
	req, out := c.GetDeploymentRequest(input)
	return out, req.Send()
}

// GetDeploymentWithContext is the same as GetDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LaunchWizard) GetDeploymentWithContext(ctx aws.Context, input *GetDeploymentInput, opts ...request.Option) (*GetDeploymentOutput, error) {
	req, out := c.GetDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWorkload = "GetWorkload"

// GetWorkloadRequest generates a "aws/request.Request" representing the
// client's request for the GetWorkload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWorkload for more information on using the GetWorkload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetWorkloadRequest method.
//	req, resp := client.GetWorkloadRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/GetWorkload
func (c *LaunchWizard) GetWorkloadRequest(input *GetWorkloadInput) (req *request.Request, output *GetWorkloadOutput) {
	op := &request.Operation{
		Name:       opGetWorkload,
		HTTPMethod: "POST",
		HTTPPath:   "/getWorkload",
	}

	if input == nil {
		input = &GetWorkloadInput{}
	}

	output = &GetWorkloadOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWorkload API operation for AWS Launch Wizard.
//
// Returns information about a workload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Launch Wizard's
// API operation GetWorkload for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An internal error has occurred. Retry your request, but if the problem persists,
//     contact us with details by posting a question on re:Post (https://repost.aws/).
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ResourceNotFoundException
//     The specified workload or deployment resource can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/GetWorkload
func (c *LaunchWizard) GetWorkload(input *GetWorkloadInput) (*GetWorkloadOutput, error) {
	req, out := c.GetWorkloadRequest(input)
	return out, req.Send()
}

// GetWorkloadWithContext is the same as GetWorkload with the addition of
// the ability to pass a context and additional request options.
//
// See GetWorkload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LaunchWizard) GetWorkloadWithContext(ctx aws.Context, input *GetWorkloadInput, opts ...request.Option) (*GetWorkloadOutput, error) {
	req, out := c.GetWorkloadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDeploymentEvents = "ListDeploymentEvents"

// ListDeploymentEventsRequest generates a "aws/request.Request" representing the
// client's request for the ListDeploymentEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDeploymentEvents for more information on using the ListDeploymentEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDeploymentEventsRequest method.
//	req, resp := client.ListDeploymentEventsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/ListDeploymentEvents
func (c *LaunchWizard) ListDeploymentEventsRequest(input *ListDeploymentEventsInput) (req *request.Request, output *ListDeploymentEventsOutput) {
	op := &request.Operation{
		Name:       opListDeploymentEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/listDeploymentEvents",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDeploymentEventsInput{}
	}

	output = &ListDeploymentEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDeploymentEvents API operation for AWS Launch Wizard.
//
// Lists the events of a deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Launch Wizard's
// API operation ListDeploymentEvents for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An internal error has occurred. Retry your request, but if the problem persists,
//     contact us with details by posting a question on re:Post (https://repost.aws/).
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ResourceNotFoundException
//     The specified workload or deployment resource can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/ListDeploymentEvents
func (c *LaunchWizard) ListDeploymentEvents(input *ListDeploymentEventsInput) (*ListDeploymentEventsOutput, error) {
	req, out := c.ListDeploymentEventsRequest(input)
	return out, req.Send()
}

// ListDeploymentEventsWithContext is the same as ListDeploymentEvents with the addition of
// the ability to pass a context and additional request options.
//
// See ListDeploymentEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LaunchWizard) ListDeploymentEventsWithContext(ctx aws.Context, input *ListDeploymentEventsInput, opts ...request.Option) (*ListDeploymentEventsOutput, error) {
	req, out := c.ListDeploymentEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDeploymentEventsPages iterates over the pages of a ListDeploymentEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDeploymentEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDeploymentEvents operation.
//	pageNum := 0
//	err := client.ListDeploymentEventsPages(params,
//	    func(page *launchwizard.ListDeploymentEventsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LaunchWizard) ListDeploymentEventsPages(input *ListDeploymentEventsInput, fn func(*ListDeploymentEventsOutput, bool) bool) error {
	return c.ListDeploymentEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDeploymentEventsPagesWithContext same as ListDeploymentEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LaunchWizard) ListDeploymentEventsPagesWithContext(ctx aws.Context, input *ListDeploymentEventsInput, fn func(*ListDeploymentEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDeploymentEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDeploymentEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDeploymentEventsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDeployments = "ListDeployments"

// ListDeploymentsRequest generates a "aws/request.Request" representing the
// client's request for the ListDeployments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDeployments for more information on using the ListDeployments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDeploymentsRequest method.
//	req, resp := client.ListDeploymentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/ListDeployments
func (c *LaunchWizard) ListDeploymentsRequest(input *ListDeploymentsInput) (req *request.Request, output *ListDeploymentsOutput) {
	op := &request.Operation{
		Name:       opListDeployments,
		HTTPMethod: "POST",
		HTTPPath:   "/listDeployments",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDeploymentsInput{}
	}

	output = &ListDeploymentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDeployments API operation for AWS Launch Wizard.
//
// Lists the deployments that have been created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Launch Wizard's
// API operation ListDeployments for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An internal error has occurred. Retry your request, but if the problem persists,
//     contact us with details by posting a question on re:Post (https://repost.aws/).
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/ListDeployments
func (c *LaunchWizard) ListDeployments(input *ListDeploymentsInput) (*ListDeploymentsOutput, error) {
	req, out := c.ListDeploymentsRequest(input)
	return out, req.Send()
}

// ListDeploymentsWithContext is the same as ListDeployments with the addition of
// the ability to pass a context and additional request options.
//
// See ListDeployments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LaunchWizard) ListDeploymentsWithContext(ctx aws.Context, input *ListDeploymentsInput, opts ...request.Option) (*ListDeploymentsOutput, error) {
	req, out := c.ListDeploymentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDeploymentsPages iterates over the pages of a ListDeployments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDeployments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDeployments operation.
//	pageNum := 0
//	err := client.ListDeploymentsPages(params,
//	    func(page *launchwizard.ListDeploymentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LaunchWizard) ListDeploymentsPages(input *ListDeploymentsInput, fn func(*ListDeploymentsOutput, bool) bool) error {
	return c.ListDeploymentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDeploymentsPagesWithContext same as ListDeploymentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LaunchWizard) ListDeploymentsPagesWithContext(ctx aws.Context, input *ListDeploymentsInput, fn func(*ListDeploymentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDeploymentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDeploymentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDeploymentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListWorkloadDeploymentPatterns = "ListWorkloadDeploymentPatterns"

// ListWorkloadDeploymentPatternsRequest generates a "aws/request.Request" representing the
// client's request for the ListWorkloadDeploymentPatterns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorkloadDeploymentPatterns for more information on using the ListWorkloadDeploymentPatterns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListWorkloadDeploymentPatternsRequest method.
//	req, resp := client.ListWorkloadDeploymentPatternsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/ListWorkloadDeploymentPatterns
func (c *LaunchWizard) ListWorkloadDeploymentPatternsRequest(input *ListWorkloadDeploymentPatternsInput) (req *request.Request, output *ListWorkloadDeploymentPatternsOutput) {
	op := &request.Operation{
		Name:       opListWorkloadDeploymentPatterns,
		HTTPMethod: "POST",
		HTTPPath:   "/listWorkloadDeploymentPatterns",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkloadDeploymentPatternsInput{}
	}

	output = &ListWorkloadDeploymentPatternsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorkloadDeploymentPatterns API operation for AWS Launch Wizard.
//
// Lists the workload deployment patterns.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Launch Wizard's
// API operation ListWorkloadDeploymentPatterns for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An internal error has occurred. Retry your request, but if the problem persists,
//     contact us with details by posting a question on re:Post (https://repost.aws/).
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ResourceNotFoundException
//     The specified workload or deployment resource can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/ListWorkloadDeploymentPatterns
func (c *LaunchWizard) ListWorkloadDeploymentPatterns(input *ListWorkloadDeploymentPatternsInput) (*ListWorkloadDeploymentPatternsOutput, error) {
	req, out := c.ListWorkloadDeploymentPatternsRequest(input)
	return out, req.Send()
}

// ListWorkloadDeploymentPatternsWithContext is the same as ListWorkloadDeploymentPatterns with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkloadDeploymentPatterns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LaunchWizard) ListWorkloadDeploymentPatternsWithContext(ctx aws.Context, input *ListWorkloadDeploymentPatternsInput, opts ...request.Option) (*ListWorkloadDeploymentPatternsOutput, error) {
	req, out := c.ListWorkloadDeploymentPatternsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorkloadDeploymentPatternsPages iterates over the pages of a ListWorkloadDeploymentPatterns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorkloadDeploymentPatterns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListWorkloadDeploymentPatterns operation.
//	pageNum := 0
//	err := client.ListWorkloadDeploymentPatternsPages(params,
//	    func(page *launchwizard.ListWorkloadDeploymentPatternsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LaunchWizard) ListWorkloadDeploymentPatternsPages(input *ListWorkloadDeploymentPatternsInput, fn func(*ListWorkloadDeploymentPatternsOutput, bool) bool) error {
	return c.ListWorkloadDeploymentPatternsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorkloadDeploymentPatternsPagesWithContext same as ListWorkloadDeploymentPatternsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LaunchWizard) ListWorkloadDeploymentPatternsPagesWithContext(ctx aws.Context, input *ListWorkloadDeploymentPatternsInput, fn func(*ListWorkloadDeploymentPatternsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorkloadDeploymentPatternsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorkloadDeploymentPatternsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWorkloadDeploymentPatternsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListWorkloads = "ListWorkloads"

// ListWorkloadsRequest generates a "aws/request.Request" representing the
// client's request for the ListWorkloads operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorkloads for more information on using the ListWorkloads
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListWorkloadsRequest method.
//	req, resp := client.ListWorkloadsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/ListWorkloads
func (c *LaunchWizard) ListWorkloadsRequest(input *ListWorkloadsInput) (req *request.Request, output *ListWorkloadsOutput) {
	op := &request.Operation{
		Name:       opListWorkloads,
		HTTPMethod: "POST",
		HTTPPath:   "/listWorkloads",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkloadsInput{}
	}

	output = &ListWorkloadsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorkloads API operation for AWS Launch Wizard.
//
// Lists the workloads.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Launch Wizard's
// API operation ListWorkloads for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An internal error has occurred. Retry your request, but if the problem persists,
//     contact us with details by posting a question on re:Post (https://repost.aws/).
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/ListWorkloads
func (c *LaunchWizard) ListWorkloads(input *ListWorkloadsInput) (*ListWorkloadsOutput, error) {
	req, out := c.ListWorkloadsRequest(input)
	return out, req.Send()
}

// ListWorkloadsWithContext is the same as ListWorkloads with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkloads for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LaunchWizard) ListWorkloadsWithContext(ctx aws.Context, input *ListWorkloadsInput, opts ...request.Option) (*ListWorkloadsOutput, error) {
	req, out := c.ListWorkloadsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorkloadsPages iterates over the pages of a ListWorkloads operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorkloads method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListWorkloads operation.
//	pageNum := 0
//	err := client.ListWorkloadsPages(params,
//	    func(page *launchwizard.ListWorkloadsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LaunchWizard) ListWorkloadsPages(input *ListWorkloadsInput, fn func(*ListWorkloadsOutput, bool) bool) error {
	return c.ListWorkloadsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorkloadsPagesWithContext same as ListWorkloadsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LaunchWizard) ListWorkloadsPagesWithContext(ctx aws.Context, input *ListWorkloadsInput, fn func(*ListWorkloadsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorkloadsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorkloadsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWorkloadsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

type CreateDeploymentInput struct {
	_ struct{} `type:"structure"`

	// The name of the deployment pattern supported by a given workload. You can
	// use the ListWorkloadDeploymentPatterns (https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_ListWorkloadDeploymentPatterns.html)
	// operation to discover supported values for this parameter.
	//
	// DeploymentPatternName is a required field
	DeploymentPatternName *string `locationName:"deploymentPatternName" min:"1" type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The name of the deployment.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The settings specified for the deployment. For more information on the specifications
	// required for creating a deployment, see Workload specifications (https://docs.aws.amazon.com/launchwizard/latest/APIReference/launch-wizard-specifications.html).
	//
	// Specifications is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateDeploymentInput's
	// String and GoString methods.
	//
	// Specifications is a required field
	Specifications map[string]*string `locationName:"specifications" min:"1" type:"map" required:"true" sensitive:"true"`

	// The name of the workload. You can use the ListWorkloadDeploymentPatterns
	// (https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_ListWorkloadDeploymentPatterns.html)
	// operation to discover supported values for this parameter.
	//
	// WorkloadName is a required field
	WorkloadName *string `locationName:"workloadName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDeploymentInput"}
	if s.DeploymentPatternName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentPatternName"))
	}
	if s.DeploymentPatternName != nil && len(*s.DeploymentPatternName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentPatternName", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Specifications == nil {
		invalidParams.Add(request.NewErrParamRequired("Specifications"))
	}
	if s.Specifications != nil && len(s.Specifications) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Specifications", 1))
	}
	if s.WorkloadName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadName"))
	}
	if s.WorkloadName != nil && len(*s.WorkloadName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentPatternName sets the DeploymentPatternName field's value.
func (s *CreateDeploymentInput) SetDeploymentPatternName(v string) *CreateDeploymentInput {
	s.DeploymentPatternName = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *CreateDeploymentInput) SetDryRun(v bool) *CreateDeploymentInput {
	s.DryRun = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDeploymentInput) SetName(v string) *CreateDeploymentInput {
	s.Name = &v
	return s
}

// SetSpecifications sets the Specifications field's value.
func (s *CreateDeploymentInput) SetSpecifications(v map[string]*string) *CreateDeploymentInput {
	s.Specifications = v
	return s
}

// SetWorkloadName sets the WorkloadName field's value.
func (s *CreateDeploymentInput) SetWorkloadName(v string) *CreateDeploymentInput {
	s.WorkloadName = &v
	return s
}

type CreateDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the deployment.
	DeploymentId *string `locationName:"deploymentId" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDeploymentOutput) GoString() string {
	return s.String()
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *CreateDeploymentOutput) SetDeploymentId(v string) *CreateDeploymentOutput {
	s.DeploymentId = &v
	return s
}

type DeleteDeploymentInput struct {
	_ struct{} `type:"structure"`

	// The ID of the deployment.
	//
	// DeploymentId is a required field
	DeploymentId *string `locationName:"deploymentId" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDeploymentInput"}
	if s.DeploymentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentId"))
	}
	if s.DeploymentId != nil && len(*s.DeploymentId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentId", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *DeleteDeploymentInput) SetDeploymentId(v string) *DeleteDeploymentInput {
	s.DeploymentId = &v
	return s
}

type DeleteDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// The status of the deployment.
	Status *string `locationName:"status" type:"string" enum:"DeploymentStatus"`

	// The reason for the deployment status.
	StatusReason *string `locationName:"statusReason" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeploymentOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *DeleteDeploymentOutput) SetStatus(v string) *DeleteDeploymentOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *DeleteDeploymentOutput) SetStatusReason(v string) *DeleteDeploymentOutput {
	s.StatusReason = &v
	return s
}

// The data associated with a deployment.
type DeploymentData struct {
	_ struct{} `type:"structure"`

	// The time the deployment was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The time the deployment was deleted.
	DeletedAt *time.Time `locationName:"deletedAt" type:"timestamp"`

	// The ID of the deployment.
	Id *string `locationName:"id" min:"2" type:"string"`

	// The name of the deployment.
	Name *string `locationName:"name" type:"string"`

	// The pattern name of the deployment.
	PatternName *string `locationName:"patternName" min:"1" type:"string"`

	// The resource group of the deployment.
	ResourceGroup *string `locationName:"resourceGroup" type:"string"`

	// The specifications of the deployment. For more information on specifications
	// for each deployment, see Workload specifications (https://docs.aws.amazon.com/launchwizard/latest/APIReference/launch-wizard-specifications.html).
	//
	// Specifications is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DeploymentData's
	// String and GoString methods.
	Specifications map[string]*string `locationName:"specifications" min:"1" type:"map" sensitive:"true"`

	// The status of the deployment.
	Status *string `locationName:"status" type:"string" enum:"DeploymentStatus"`

	// The name of the workload.
	WorkloadName *string `locationName:"workloadName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentData) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DeploymentData) SetCreatedAt(v time.Time) *DeploymentData {
	s.CreatedAt = &v
	return s
}

// SetDeletedAt sets the DeletedAt field's value.
func (s *DeploymentData) SetDeletedAt(v time.Time) *DeploymentData {
	s.DeletedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeploymentData) SetId(v string) *DeploymentData {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeploymentData) SetName(v string) *DeploymentData {
	s.Name = &v
	return s
}

// SetPatternName sets the PatternName field's value.
func (s *DeploymentData) SetPatternName(v string) *DeploymentData {
	s.PatternName = &v
	return s
}

// SetResourceGroup sets the ResourceGroup field's value.
func (s *DeploymentData) SetResourceGroup(v string) *DeploymentData {
	s.ResourceGroup = &v
	return s
}

// SetSpecifications sets the Specifications field's value.
func (s *DeploymentData) SetSpecifications(v map[string]*string) *DeploymentData {
	s.Specifications = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeploymentData) SetStatus(v string) *DeploymentData {
	s.Status = &v
	return s
}

// SetWorkloadName sets the WorkloadName field's value.
func (s *DeploymentData) SetWorkloadName(v string) *DeploymentData {
	s.WorkloadName = &v
	return s
}

// A summary of the deployment data.
type DeploymentDataSummary struct {
	_ struct{} `type:"structure"`

	// The time the deployment was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The ID of the deployment.
	Id *string `locationName:"id" min:"2" type:"string"`

	// The name of the deployment
	Name *string `locationName:"name" type:"string"`

	// The name of the workload deployment pattern.
	PatternName *string `locationName:"patternName" min:"1" type:"string"`

	// The status of the deployment.
	Status *string `locationName:"status" type:"string" enum:"DeploymentStatus"`

	// The name of the workload.
	WorkloadName *string `locationName:"workloadName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentDataSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentDataSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DeploymentDataSummary) SetCreatedAt(v time.Time) *DeploymentDataSummary {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeploymentDataSummary) SetId(v string) *DeploymentDataSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeploymentDataSummary) SetName(v string) *DeploymentDataSummary {
	s.Name = &v
	return s
}

// SetPatternName sets the PatternName field's value.
func (s *DeploymentDataSummary) SetPatternName(v string) *DeploymentDataSummary {
	s.PatternName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeploymentDataSummary) SetStatus(v string) *DeploymentDataSummary {
	s.Status = &v
	return s
}

// SetWorkloadName sets the WorkloadName field's value.
func (s *DeploymentDataSummary) SetWorkloadName(v string) *DeploymentDataSummary {
	s.WorkloadName = &v
	return s
}

// A summary of the deployment event data.
type DeploymentEventDataSummary struct {
	_ struct{} `type:"structure"`

	// The description of the deployment event.
	Description *string `locationName:"description" type:"string"`

	// The name of the deployment event.
	Name *string `locationName:"name" type:"string"`

	// The status of the deployment event.
	Status *string `locationName:"status" type:"string" enum:"EventStatus"`

	// The reason of the deployment event status.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The timestamp of the deployment event.
	Timestamp *time.Time `locationName:"timestamp" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentEventDataSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentEventDataSummary) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *DeploymentEventDataSummary) SetDescription(v string) *DeploymentEventDataSummary {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeploymentEventDataSummary) SetName(v string) *DeploymentEventDataSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeploymentEventDataSummary) SetStatus(v string) *DeploymentEventDataSummary {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *DeploymentEventDataSummary) SetStatusReason(v string) *DeploymentEventDataSummary {
	s.StatusReason = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *DeploymentEventDataSummary) SetTimestamp(v time.Time) *DeploymentEventDataSummary {
	s.Timestamp = &v
	return s
}

// A filter name and value pair that is used to return more specific results
// from a describe operation. Filters can be used to match a set of resources
// by specific criteria.
type DeploymentFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter. Filter names are case-sensitive.
	Name *string `locationName:"name" type:"string" enum:"DeploymentFilterKey"`

	// The filter values. Filter values are case-sensitive. If you specify multiple
	// values for a filter, the values are joined with an OR, and the request returns
	// all results that match any of the specified values.
	Values []*string `locationName:"values" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentFilter) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *DeploymentFilter) SetName(v string) *DeploymentFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *DeploymentFilter) SetValues(v []*string) *DeploymentFilter {
	s.Values = v
	return s
}

type GetDeploymentInput struct {
	_ struct{} `type:"structure"`

	// The ID of the deployment.
	//
	// DeploymentId is a required field
	DeploymentId *string `locationName:"deploymentId" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeploymentInput"}
	if s.DeploymentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentId"))
	}
	if s.DeploymentId != nil && len(*s.DeploymentId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentId", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *GetDeploymentInput) SetDeploymentId(v string) *GetDeploymentInput {
	s.DeploymentId = &v
	return s
}

type GetDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// An object that details the deployment.
	Deployment *DeploymentData `locationName:"deployment" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentOutput) GoString() string {
	return s.String()
}

// SetDeployment sets the Deployment field's value.
func (s *GetDeploymentOutput) SetDeployment(v *DeploymentData) *GetDeploymentOutput {
	s.Deployment = v
	return s
}

type GetWorkloadInput struct {
	_ struct{} `type:"structure"`

	// The name of the workload.
	//
	// WorkloadName is a required field
	WorkloadName *string `locationName:"workloadName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkloadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkloadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWorkloadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWorkloadInput"}
	if s.WorkloadName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadName"))
	}
	if s.WorkloadName != nil && len(*s.WorkloadName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkloadName sets the WorkloadName field's value.
func (s *GetWorkloadInput) SetWorkloadName(v string) *GetWorkloadInput {
	s.WorkloadName = &v
	return s
}

type GetWorkloadOutput struct {
	_ struct{} `type:"structure"`

	// Information about the workload.
	Workload *WorkloadData `locationName:"workload" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkloadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkloadOutput) GoString() string {
	return s.String()
}

// SetWorkload sets the Workload field's value.
func (s *GetWorkloadOutput) SetWorkload(v *WorkloadData) *GetWorkloadOutput {
	s.Workload = v
	return s
}

// An internal error has occurred. Retry your request, but if the problem persists,
// contact us with details by posting a question on re:Post (https://repost.aws/).
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListDeploymentEventsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the deployment.
	//
	// DeploymentId is a required field
	DeploymentId *string `locationName:"deploymentId" min:"2" type:"string" required:"true"`

	// The maximum number of items to return for this request. To get the next page
	// of items, make another request with the token returned in the output.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token returned from a previous paginated request. Pagination continues
	// from the end of the items returned by the previous request.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeploymentEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeploymentEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeploymentEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDeploymentEventsInput"}
	if s.DeploymentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentId"))
	}
	if s.DeploymentId != nil && len(*s.DeploymentId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentId", 2))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *ListDeploymentEventsInput) SetDeploymentId(v string) *ListDeploymentEventsInput {
	s.DeploymentId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDeploymentEventsInput) SetMaxResults(v int64) *ListDeploymentEventsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeploymentEventsInput) SetNextToken(v string) *ListDeploymentEventsInput {
	s.NextToken = &v
	return s
}

type ListDeploymentEventsOutput struct {
	_ struct{} `type:"structure"`

	// Lists the deployment events.
	DeploymentEvents []*DeploymentEventDataSummary `locationName:"deploymentEvents" type:"list"`

	// The token to include in another request to get the next page of items. This
	// value is null when there are no more items to return.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeploymentEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeploymentEventsOutput) GoString() string {
	return s.String()
}

// SetDeploymentEvents sets the DeploymentEvents field's value.
func (s *ListDeploymentEventsOutput) SetDeploymentEvents(v []*DeploymentEventDataSummary) *ListDeploymentEventsOutput {
	s.DeploymentEvents = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeploymentEventsOutput) SetNextToken(v string) *ListDeploymentEventsOutput {
	s.NextToken = &v
	return s
}

type ListDeploymentsInput struct {
	_ struct{} `type:"structure"`

	// Filters to scope the results. The following filters are supported:
	//
	//    * WORKLOAD_NAME
	//
	//    * DEPLOYMENT_STATUS
	Filters []*DeploymentFilter `locationName:"filters" min:"1" type:"list"`

	// The maximum number of items to return for this request. To get the next page
	// of items, make another request with the token returned in the output.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token returned from a previous paginated request. Pagination continues
	// from the end of the items returned by the previous request.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeploymentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeploymentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeploymentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDeploymentsInput"}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListDeploymentsInput) SetFilters(v []*DeploymentFilter) *ListDeploymentsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDeploymentsInput) SetMaxResults(v int64) *ListDeploymentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeploymentsInput) SetNextToken(v string) *ListDeploymentsInput {
	s.NextToken = &v
	return s
}

type ListDeploymentsOutput struct {
	_ struct{} `type:"structure"`

	// Lists the deployments.
	Deployments []*DeploymentDataSummary `locationName:"deployments" type:"list"`

	// The token to include in another request to get the next page of items. This
	// value is null when there are no more items to return.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeploymentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeploymentsOutput) GoString() string {
	return s.String()
}

// SetDeployments sets the Deployments field's value.
func (s *ListDeploymentsOutput) SetDeployments(v []*DeploymentDataSummary) *ListDeploymentsOutput {
	s.Deployments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeploymentsOutput) SetNextToken(v string) *ListDeploymentsOutput {
	s.NextToken = &v
	return s
}

type ListWorkloadDeploymentPatternsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return for this request. To get the next page
	// of items, make another request with the token returned in the output.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token returned from a previous paginated request. Pagination continues
	// from the end of the items returned by the previous request.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The name of the workload.
	//
	// WorkloadName is a required field
	WorkloadName *string `locationName:"workloadName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkloadDeploymentPatternsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkloadDeploymentPatternsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorkloadDeploymentPatternsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorkloadDeploymentPatternsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.WorkloadName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadName"))
	}
	if s.WorkloadName != nil && len(*s.WorkloadName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWorkloadDeploymentPatternsInput) SetMaxResults(v int64) *ListWorkloadDeploymentPatternsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkloadDeploymentPatternsInput) SetNextToken(v string) *ListWorkloadDeploymentPatternsInput {
	s.NextToken = &v
	return s
}

// SetWorkloadName sets the WorkloadName field's value.
func (s *ListWorkloadDeploymentPatternsInput) SetWorkloadName(v string) *ListWorkloadDeploymentPatternsInput {
	s.WorkloadName = &v
	return s
}

type ListWorkloadDeploymentPatternsOutput struct {
	_ struct{} `type:"structure"`

	// The token to include in another request to get the next page of items. This
	// value is null when there are no more items to return.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Describes the workload deployment patterns.
	WorkloadDeploymentPatterns []*WorkloadDeploymentPatternDataSummary `locationName:"workloadDeploymentPatterns" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkloadDeploymentPatternsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkloadDeploymentPatternsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkloadDeploymentPatternsOutput) SetNextToken(v string) *ListWorkloadDeploymentPatternsOutput {
	s.NextToken = &v
	return s
}

// SetWorkloadDeploymentPatterns sets the WorkloadDeploymentPatterns field's value.
func (s *ListWorkloadDeploymentPatternsOutput) SetWorkloadDeploymentPatterns(v []*WorkloadDeploymentPatternDataSummary) *ListWorkloadDeploymentPatternsOutput {
	s.WorkloadDeploymentPatterns = v
	return s
}

type ListWorkloadsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return for this request. To get the next page
	// of items, make another request with the token returned in the output.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token returned from a previous paginated request. Pagination continues
	// from the end of the items returned by the previous request.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkloadsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkloadsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorkloadsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorkloadsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWorkloadsInput) SetMaxResults(v int64) *ListWorkloadsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkloadsInput) SetNextToken(v string) *ListWorkloadsInput {
	s.NextToken = &v
	return s
}

type ListWorkloadsOutput struct {
	_ struct{} `type:"structure"`

	// The token to include in another request to get the next page of items. This
	// value is null when there are no more items to return.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Information about the workloads.
	Workloads []*WorkloadDataSummary `locationName:"workloads" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkloadsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkloadsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkloadsOutput) SetNextToken(v string) *ListWorkloadsOutput {
	s.NextToken = &v
	return s
}

// SetWorkloads sets the Workloads field's value.
func (s *ListWorkloadsOutput) SetWorkloads(v []*WorkloadDataSummary) *ListWorkloadsOutput {
	s.Workloads = v
	return s
}

// You have exceeded an Launch Wizard resource limit. For example, you might
// have too many deployments in progress.
type ResourceLimitException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceLimitException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceLimitException) GoString() string {
	return s.String()
}

func newErrorResourceLimitException(v protocol.ResponseMetadata) error {
	return &ResourceLimitException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceLimitException) Code() string {
	return "ResourceLimitException"
}

// Message returns the exception's message.
func (s *ResourceLimitException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceLimitException) OrigErr() error {
	return nil
}

func (s *ResourceLimitException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceLimitException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceLimitException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified workload or deployment resource can't be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The input fails to satisfy the constraints specified by an Amazon Web Services
// service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes a workload.
type WorkloadData struct {
	_ struct{} `type:"structure"`

	// The description of a workload.
	Description *string `locationName:"description" type:"string"`

	// The display name of a workload.
	DisplayName *string `locationName:"displayName" type:"string"`

	// The URL of a workload document.
	DocumentationUrl *string `locationName:"documentationUrl" type:"string"`

	// The URL of a workload icon.
	IconUrl *string `locationName:"iconUrl" type:"string"`

	// The status of a workload.
	Status *string `locationName:"status" type:"string" enum:"WorkloadStatus"`

	// The message about a workload's status.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The name of the workload.
	WorkloadName *string `locationName:"workloadName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkloadData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkloadData) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *WorkloadData) SetDescription(v string) *WorkloadData {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *WorkloadData) SetDisplayName(v string) *WorkloadData {
	s.DisplayName = &v
	return s
}

// SetDocumentationUrl sets the DocumentationUrl field's value.
func (s *WorkloadData) SetDocumentationUrl(v string) *WorkloadData {
	s.DocumentationUrl = &v
	return s
}

// SetIconUrl sets the IconUrl field's value.
func (s *WorkloadData) SetIconUrl(v string) *WorkloadData {
	s.IconUrl = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *WorkloadData) SetStatus(v string) *WorkloadData {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *WorkloadData) SetStatusMessage(v string) *WorkloadData {
	s.StatusMessage = &v
	return s
}

// SetWorkloadName sets the WorkloadName field's value.
func (s *WorkloadData) SetWorkloadName(v string) *WorkloadData {
	s.WorkloadName = &v
	return s
}

// Describes workload data.
type WorkloadDataSummary struct {
	_ struct{} `type:"structure"`

	// The display name of the workload data.
	DisplayName *string `locationName:"displayName" type:"string"`

	// The name of the workload.
	WorkloadName *string `locationName:"workloadName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkloadDataSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkloadDataSummary) GoString() string {
	return s.String()
}

// SetDisplayName sets the DisplayName field's value.
func (s *WorkloadDataSummary) SetDisplayName(v string) *WorkloadDataSummary {
	s.DisplayName = &v
	return s
}

// SetWorkloadName sets the WorkloadName field's value.
func (s *WorkloadDataSummary) SetWorkloadName(v string) *WorkloadDataSummary {
	s.WorkloadName = &v
	return s
}

// Describes a workload deployment pattern.
type WorkloadDeploymentPatternDataSummary struct {
	_ struct{} `type:"structure"`

	// The name of a workload deployment pattern.
	DeploymentPatternName *string `locationName:"deploymentPatternName" min:"1" type:"string"`

	// The description of a workload deployment pattern.
	Description *string `locationName:"description" type:"string"`

	// The display name of a workload deployment pattern.
	DisplayName *string `locationName:"displayName" type:"string"`

	// The status of a workload deployment pattern.
	Status *string `locationName:"status" type:"string" enum:"WorkloadDeploymentPatternStatus"`

	// A message about a workload deployment pattern's status.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The name of the workload.
	WorkloadName *string `locationName:"workloadName" min:"1" type:"string"`

	// The name of the workload deployment pattern version.
	WorkloadVersionName *string `locationName:"workloadVersionName" min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkloadDeploymentPatternDataSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkloadDeploymentPatternDataSummary) GoString() string {
	return s.String()
}

// SetDeploymentPatternName sets the DeploymentPatternName field's value.
func (s *WorkloadDeploymentPatternDataSummary) SetDeploymentPatternName(v string) *WorkloadDeploymentPatternDataSummary {
	s.DeploymentPatternName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *WorkloadDeploymentPatternDataSummary) SetDescription(v string) *WorkloadDeploymentPatternDataSummary {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *WorkloadDeploymentPatternDataSummary) SetDisplayName(v string) *WorkloadDeploymentPatternDataSummary {
	s.DisplayName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *WorkloadDeploymentPatternDataSummary) SetStatus(v string) *WorkloadDeploymentPatternDataSummary {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *WorkloadDeploymentPatternDataSummary) SetStatusMessage(v string) *WorkloadDeploymentPatternDataSummary {
	s.StatusMessage = &v
	return s
}

// SetWorkloadName sets the WorkloadName field's value.
func (s *WorkloadDeploymentPatternDataSummary) SetWorkloadName(v string) *WorkloadDeploymentPatternDataSummary {
	s.WorkloadName = &v
	return s
}

// SetWorkloadVersionName sets the WorkloadVersionName field's value.
func (s *WorkloadDeploymentPatternDataSummary) SetWorkloadVersionName(v string) *WorkloadDeploymentPatternDataSummary {
	s.WorkloadVersionName = &v
	return s
}

const (
	// DeploymentFilterKeyWorkloadName is a DeploymentFilterKey enum value
	DeploymentFilterKeyWorkloadName = "WORKLOAD_NAME"

	// DeploymentFilterKeyDeploymentStatus is a DeploymentFilterKey enum value
	DeploymentFilterKeyDeploymentStatus = "DEPLOYMENT_STATUS"
)

// DeploymentFilterKey_Values returns all elements of the DeploymentFilterKey enum
func DeploymentFilterKey_Values() []string {
	return []string{
		DeploymentFilterKeyWorkloadName,
		DeploymentFilterKeyDeploymentStatus,
	}
}

const (
	// DeploymentStatusCompleted is a DeploymentStatus enum value
	DeploymentStatusCompleted = "COMPLETED"

	// DeploymentStatusCreating is a DeploymentStatus enum value
	DeploymentStatusCreating = "CREATING"

	// DeploymentStatusDeleteInProgress is a DeploymentStatus enum value
	DeploymentStatusDeleteInProgress = "DELETE_IN_PROGRESS"

	// DeploymentStatusDeleteInitiating is a DeploymentStatus enum value
	DeploymentStatusDeleteInitiating = "DELETE_INITIATING"

	// DeploymentStatusDeleteFailed is a DeploymentStatus enum value
	DeploymentStatusDeleteFailed = "DELETE_FAILED"

	// DeploymentStatusDeleted is a DeploymentStatus enum value
	DeploymentStatusDeleted = "DELETED"

	// DeploymentStatusFailed is a DeploymentStatus enum value
	DeploymentStatusFailed = "FAILED"

	// DeploymentStatusInProgress is a DeploymentStatus enum value
	DeploymentStatusInProgress = "IN_PROGRESS"

	// DeploymentStatusValidating is a DeploymentStatus enum value
	DeploymentStatusValidating = "VALIDATING"
)

// DeploymentStatus_Values returns all elements of the DeploymentStatus enum
func DeploymentStatus_Values() []string {
	return []string{
		DeploymentStatusCompleted,
		DeploymentStatusCreating,
		DeploymentStatusDeleteInProgress,
		DeploymentStatusDeleteInitiating,
		DeploymentStatusDeleteFailed,
		DeploymentStatusDeleted,
		DeploymentStatusFailed,
		DeploymentStatusInProgress,
		DeploymentStatusValidating,
	}
}

const (
	// EventStatusCanceled is a EventStatus enum value
	EventStatusCanceled = "CANCELED"

	// EventStatusCanceling is a EventStatus enum value
	EventStatusCanceling = "CANCELING"

	// EventStatusCompleted is a EventStatus enum value
	EventStatusCompleted = "COMPLETED"

	// EventStatusCreated is a EventStatus enum value
	EventStatusCreated = "CREATED"

	// EventStatusFailed is a EventStatus enum value
	EventStatusFailed = "FAILED"

	// EventStatusInProgress is a EventStatus enum value
	EventStatusInProgress = "IN_PROGRESS"

	// EventStatusPending is a EventStatus enum value
	EventStatusPending = "PENDING"

	// EventStatusTimedOut is a EventStatus enum value
	EventStatusTimedOut = "TIMED_OUT"
)

// EventStatus_Values returns all elements of the EventStatus enum
func EventStatus_Values() []string {
	return []string{
		EventStatusCanceled,
		EventStatusCanceling,
		EventStatusCompleted,
		EventStatusCreated,
		EventStatusFailed,
		EventStatusInProgress,
		EventStatusPending,
		EventStatusTimedOut,
	}
}

const (
	// WorkloadDeploymentPatternStatusActive is a WorkloadDeploymentPatternStatus enum value
	WorkloadDeploymentPatternStatusActive = "ACTIVE"

	// WorkloadDeploymentPatternStatusInactive is a WorkloadDeploymentPatternStatus enum value
	WorkloadDeploymentPatternStatusInactive = "INACTIVE"

	// WorkloadDeploymentPatternStatusDisabled is a WorkloadDeploymentPatternStatus enum value
	WorkloadDeploymentPatternStatusDisabled = "DISABLED"

	// WorkloadDeploymentPatternStatusDeleted is a WorkloadDeploymentPatternStatus enum value
	WorkloadDeploymentPatternStatusDeleted = "DELETED"
)

// WorkloadDeploymentPatternStatus_Values returns all elements of the WorkloadDeploymentPatternStatus enum
func WorkloadDeploymentPatternStatus_Values() []string {
	return []string{
		WorkloadDeploymentPatternStatusActive,
		WorkloadDeploymentPatternStatusInactive,
		WorkloadDeploymentPatternStatusDisabled,
		WorkloadDeploymentPatternStatusDeleted,
	}
}

const (
	// WorkloadStatusActive is a WorkloadStatus enum value
	WorkloadStatusActive = "ACTIVE"

	// WorkloadStatusInactive is a WorkloadStatus enum value
	WorkloadStatusInactive = "INACTIVE"

	// WorkloadStatusDisabled is a WorkloadStatus enum value
	WorkloadStatusDisabled = "DISABLED"

	// WorkloadStatusDeleted is a WorkloadStatus enum value
	WorkloadStatusDeleted = "DELETED"
)

// WorkloadStatus_Values returns all elements of the WorkloadStatus enum
func WorkloadStatus_Values() []string {
	return []string{
		WorkloadStatusActive,
		WorkloadStatusInactive,
		WorkloadStatusDisabled,
		WorkloadStatusDeleted,
	}
}
