// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// Access denied.
type AccessDenied struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AccessDenied) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AccessDenied) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AccessDenied) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AccessDenied"
	}
	return *e.ErrorCodeOverride
}
func (e *AccessDenied) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Invalidation batch specified is too large.
type BatchTooLarge struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *BatchTooLarge) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *BatchTooLarge) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *BatchTooLarge) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "BatchTooLarge"
	}
	return *e.ErrorCodeOverride
}
func (e *BatchTooLarge) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A cache policy with this name already exists. You must provide a unique name.
// To modify an existing cache policy, use UpdateCachePolicy .
type CachePolicyAlreadyExists struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CachePolicyAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CachePolicyAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CachePolicyAlreadyExists) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CachePolicyAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *CachePolicyAlreadyExists) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Cannot delete the cache policy because it is attached to one or more cache
// behaviors.
type CachePolicyInUse struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CachePolicyInUse) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CachePolicyInUse) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CachePolicyInUse) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CachePolicyInUse"
	}
	return *e.ErrorCodeOverride
}
func (e *CachePolicyInUse) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You can't change the value of a public key.
type CannotChangeImmutablePublicKeyFields struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CannotChangeImmutablePublicKeyFields) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CannotChangeImmutablePublicKeyFields) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CannotChangeImmutablePublicKeyFields) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CannotChangeImmutablePublicKeyFields"
	}
	return *e.ErrorCodeOverride
}
func (e *CannotChangeImmutablePublicKeyFields) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The key value store entity cannot be deleted while it is in use.
type CannotDeleteEntityWhileInUse struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CannotDeleteEntityWhileInUse) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CannotDeleteEntityWhileInUse) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CannotDeleteEntityWhileInUse) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CannotDeleteEntityWhileInUse"
	}
	return *e.ErrorCodeOverride
}
func (e *CannotDeleteEntityWhileInUse) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// If the CallerReference is a value you already sent in a previous request to
// create an identity but the content of the CloudFrontOriginAccessIdentityConfig
// is different from the original request, CloudFront returns a
// CloudFrontOriginAccessIdentityAlreadyExists error.
type CloudFrontOriginAccessIdentityAlreadyExists struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CloudFrontOriginAccessIdentityAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CloudFrontOriginAccessIdentityAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CloudFrontOriginAccessIdentityAlreadyExists) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CloudFrontOriginAccessIdentityAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *CloudFrontOriginAccessIdentityAlreadyExists) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The Origin Access Identity specified is already in use.
type CloudFrontOriginAccessIdentityInUse struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CloudFrontOriginAccessIdentityInUse) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CloudFrontOriginAccessIdentityInUse) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CloudFrontOriginAccessIdentityInUse) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CloudFrontOriginAccessIdentityInUse"
	}
	return *e.ErrorCodeOverride
}
func (e *CloudFrontOriginAccessIdentityInUse) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The CNAME specified is already defined for CloudFront.
type CNAMEAlreadyExists struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CNAMEAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CNAMEAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CNAMEAlreadyExists) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CNAMEAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *CNAMEAlreadyExists) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A continuous deployment policy with this configuration already exists.
type ContinuousDeploymentPolicyAlreadyExists struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ContinuousDeploymentPolicyAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ContinuousDeploymentPolicyAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ContinuousDeploymentPolicyAlreadyExists) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ContinuousDeploymentPolicyAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *ContinuousDeploymentPolicyAlreadyExists) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You cannot delete a continuous deployment policy that is associated with a
// primary distribution.
type ContinuousDeploymentPolicyInUse struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ContinuousDeploymentPolicyInUse) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ContinuousDeploymentPolicyInUse) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ContinuousDeploymentPolicyInUse) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ContinuousDeploymentPolicyInUse"
	}
	return *e.ErrorCodeOverride
}
func (e *ContinuousDeploymentPolicyInUse) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The caller reference you attempted to create the distribution with is
// associated with another distribution.
type DistributionAlreadyExists struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DistributionAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DistributionAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DistributionAlreadyExists) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DistributionAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *DistributionAlreadyExists) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified CloudFront distribution is not disabled. You must disable the
// distribution before you can delete it.
type DistributionNotDisabled struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DistributionNotDisabled) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DistributionNotDisabled) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DistributionNotDisabled) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DistributionNotDisabled"
	}
	return *e.ErrorCodeOverride
}
func (e *DistributionNotDisabled) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The key value store entity already exists. You must provide a unique key value
// store entity.
type EntityAlreadyExists struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EntityAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EntityAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EntityAlreadyExists) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "EntityAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *EntityAlreadyExists) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The key value store entity limit has been exceeded.
type EntityLimitExceeded struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EntityLimitExceeded) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EntityLimitExceeded) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EntityLimitExceeded) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "EntityLimitExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *EntityLimitExceeded) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The key value store entity was not found.
type EntityNotFound struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EntityNotFound) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EntityNotFound) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EntityNotFound) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "EntityNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *EntityNotFound) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The key value store entity size limit was exceeded.
type EntitySizeLimitExceeded struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EntitySizeLimitExceeded) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EntitySizeLimitExceeded) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EntitySizeLimitExceeded) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "EntitySizeLimitExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *EntitySizeLimitExceeded) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified configuration for field-level encryption already exists.
type FieldLevelEncryptionConfigAlreadyExists struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *FieldLevelEncryptionConfigAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FieldLevelEncryptionConfigAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FieldLevelEncryptionConfigAlreadyExists) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "FieldLevelEncryptionConfigAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *FieldLevelEncryptionConfigAlreadyExists) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified configuration for field-level encryption is in use.
type FieldLevelEncryptionConfigInUse struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *FieldLevelEncryptionConfigInUse) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FieldLevelEncryptionConfigInUse) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FieldLevelEncryptionConfigInUse) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "FieldLevelEncryptionConfigInUse"
	}
	return *e.ErrorCodeOverride
}
func (e *FieldLevelEncryptionConfigInUse) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified profile for field-level encryption already exists.
type FieldLevelEncryptionProfileAlreadyExists struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *FieldLevelEncryptionProfileAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FieldLevelEncryptionProfileAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FieldLevelEncryptionProfileAlreadyExists) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "FieldLevelEncryptionProfileAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *FieldLevelEncryptionProfileAlreadyExists) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified profile for field-level encryption is in use.
type FieldLevelEncryptionProfileInUse struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *FieldLevelEncryptionProfileInUse) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FieldLevelEncryptionProfileInUse) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FieldLevelEncryptionProfileInUse) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "FieldLevelEncryptionProfileInUse"
	}
	return *e.ErrorCodeOverride
}
func (e *FieldLevelEncryptionProfileInUse) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The maximum size of a profile for field-level encryption was exceeded.
type FieldLevelEncryptionProfileSizeExceeded struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *FieldLevelEncryptionProfileSizeExceeded) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FieldLevelEncryptionProfileSizeExceeded) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FieldLevelEncryptionProfileSizeExceeded) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "FieldLevelEncryptionProfileSizeExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *FieldLevelEncryptionProfileSizeExceeded) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// A function with the same name already exists in this Amazon Web Services
// account. To create a function, you must provide a unique name. To update an
// existing function, use UpdateFunction .
type FunctionAlreadyExists struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *FunctionAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FunctionAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FunctionAlreadyExists) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "FunctionAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *FunctionAlreadyExists) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Cannot delete the function because it's attached to one or more cache behaviors.
type FunctionInUse struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *FunctionInUse) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FunctionInUse) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FunctionInUse) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "FunctionInUse"
	}
	return *e.ErrorCodeOverride
}
func (e *FunctionInUse) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The function is too large. For more information, see [Quotas] (formerly known as
// limits) in the Amazon CloudFront Developer Guide.
//
// [Quotas]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html
type FunctionSizeLimitExceeded struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *FunctionSizeLimitExceeded) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FunctionSizeLimitExceeded) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FunctionSizeLimitExceeded) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "FunctionSizeLimitExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *FunctionSizeLimitExceeded) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You cannot delete a managed policy.
type IllegalDelete struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *IllegalDelete) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IllegalDelete) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IllegalDelete) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "IllegalDelete"
	}
	return *e.ErrorCodeOverride
}
func (e *IllegalDelete) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified configuration for field-level encryption can't be associated with
// the specified cache behavior.
type IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior"
	}
	return *e.ErrorCodeOverride
}
func (e *IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// An origin cannot contain both an origin access control (OAC) and an origin
// access identity (OAI).
type IllegalOriginAccessConfiguration struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *IllegalOriginAccessConfiguration) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IllegalOriginAccessConfiguration) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IllegalOriginAccessConfiguration) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "IllegalOriginAccessConfiguration"
	}
	return *e.ErrorCodeOverride
}
func (e *IllegalOriginAccessConfiguration) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The update contains modifications that are not allowed.
type IllegalUpdate struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *IllegalUpdate) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IllegalUpdate) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IllegalUpdate) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "IllegalUpdate"
	}
	return *e.ErrorCodeOverride
}
func (e *IllegalUpdate) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The value of Quantity and the size of Items don't match.
type InconsistentQuantities struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InconsistentQuantities) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InconsistentQuantities) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InconsistentQuantities) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InconsistentQuantities"
	}
	return *e.ErrorCodeOverride
}
func (e *InconsistentQuantities) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An argument is invalid.
type InvalidArgument struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidArgument) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidArgument) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidArgument) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidArgument"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidArgument) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The default root object file name is too big or contains an invalid character.
type InvalidDefaultRootObject struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidDefaultRootObject) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDefaultRootObject) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDefaultRootObject) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidDefaultRootObject"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidDefaultRootObject) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An origin access control is associated with an origin whose domain name is not
// supported.
type InvalidDomainNameForOriginAccessControl struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidDomainNameForOriginAccessControl) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDomainNameForOriginAccessControl) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDomainNameForOriginAccessControl) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidDomainNameForOriginAccessControl"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidDomainNameForOriginAccessControl) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// An invalid error code was specified.
type InvalidErrorCode struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidErrorCode) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidErrorCode) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidErrorCode) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidErrorCode"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidErrorCode) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Your request contains forward cookies option which doesn't match with the
// expectation for the whitelisted list of cookie names. Either list of cookie
// names has been specified when not allowed or list of cookie names is missing
// when expected.
type InvalidForwardCookies struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidForwardCookies) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidForwardCookies) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidForwardCookies) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidForwardCookies"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidForwardCookies) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A CloudFront function association is invalid.
type InvalidFunctionAssociation struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidFunctionAssociation) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidFunctionAssociation) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidFunctionAssociation) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidFunctionAssociation"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidFunctionAssociation) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified geo restriction parameter is not valid.
type InvalidGeoRestrictionParameter struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidGeoRestrictionParameter) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidGeoRestrictionParameter) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidGeoRestrictionParameter) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidGeoRestrictionParameter"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidGeoRestrictionParameter) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The headers specified are not valid for an Amazon S3 origin.
type InvalidHeadersForS3Origin struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidHeadersForS3Origin) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidHeadersForS3Origin) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidHeadersForS3Origin) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidHeadersForS3Origin"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidHeadersForS3Origin) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The If-Match version is missing or not valid.
type InvalidIfMatchVersion struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidIfMatchVersion) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidIfMatchVersion) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidIfMatchVersion) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidIfMatchVersion"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidIfMatchVersion) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified Lambda@Edge function association is invalid.
type InvalidLambdaFunctionAssociation struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidLambdaFunctionAssociation) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidLambdaFunctionAssociation) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidLambdaFunctionAssociation) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidLambdaFunctionAssociation"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidLambdaFunctionAssociation) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The location code specified is not valid.
type InvalidLocationCode struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidLocationCode) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidLocationCode) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidLocationCode) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidLocationCode"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidLocationCode) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The minimum protocol version specified is not valid.
type InvalidMinimumProtocolVersion struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidMinimumProtocolVersion) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidMinimumProtocolVersion) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidMinimumProtocolVersion) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidMinimumProtocolVersion"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidMinimumProtocolVersion) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The Amazon S3 origin server specified does not refer to a valid Amazon S3
// bucket.
type InvalidOrigin struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidOrigin) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidOrigin) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidOrigin) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidOrigin"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidOrigin) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The origin access control is not valid.
type InvalidOriginAccessControl struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidOriginAccessControl) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidOriginAccessControl) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidOriginAccessControl) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidOriginAccessControl"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidOriginAccessControl) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The origin access identity is not valid or doesn't exist.
type InvalidOriginAccessIdentity struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidOriginAccessIdentity) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidOriginAccessIdentity) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidOriginAccessIdentity) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidOriginAccessIdentity"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidOriginAccessIdentity) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The keep alive timeout specified for the origin is not valid.
type InvalidOriginKeepaliveTimeout struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidOriginKeepaliveTimeout) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidOriginKeepaliveTimeout) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidOriginKeepaliveTimeout) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidOriginKeepaliveTimeout"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidOriginKeepaliveTimeout) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The read timeout specified for the origin is not valid.
type InvalidOriginReadTimeout struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidOriginReadTimeout) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidOriginReadTimeout) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidOriginReadTimeout) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidOriginReadTimeout"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidOriginReadTimeout) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You cannot specify SSLv3 as the minimum protocol version if you only want to
// support only clients that support Server Name Indication (SNI).
type InvalidProtocolSettings struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidProtocolSettings) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidProtocolSettings) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidProtocolSettings) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidProtocolSettings"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidProtocolSettings) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The query string parameters specified are not valid.
type InvalidQueryStringParameters struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidQueryStringParameters) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidQueryStringParameters) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidQueryStringParameters) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidQueryStringParameters"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidQueryStringParameters) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The relative path is too big, is not URL-encoded, or does not begin with a
// slash (/).
type InvalidRelativePath struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidRelativePath) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidRelativePath) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidRelativePath) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidRelativePath"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidRelativePath) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This operation requires the HTTPS protocol. Ensure that you specify the HTTPS
// protocol in your request, or omit the RequiredProtocols element from your
// distribution configuration.
type InvalidRequiredProtocol struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidRequiredProtocol) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidRequiredProtocol) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidRequiredProtocol) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidRequiredProtocol"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidRequiredProtocol) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A response code is not valid.
type InvalidResponseCode struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidResponseCode) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidResponseCode) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidResponseCode) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidResponseCode"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidResponseCode) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The tagging specified is not valid.
type InvalidTagging struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidTagging) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTagging) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTagging) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidTagging"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidTagging) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The TTL order specified is not valid.
type InvalidTTLOrder struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidTTLOrder) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTTLOrder) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTTLOrder) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidTTLOrder"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidTTLOrder) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A viewer certificate specified is not valid.
type InvalidViewerCertificate struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidViewerCertificate) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidViewerCertificate) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidViewerCertificate) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidViewerCertificate"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidViewerCertificate) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A web ACL ID specified is not valid. To specify a web ACL created using the
// latest version of WAF, use the ACL ARN, for example
// arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a
// . To specify a web ACL created using WAF Classic, use the ACL ID, for example
// 473e64fd-f30b-4765-81a0-62ad96dd167a .
type InvalidWebACLId struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidWebACLId) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidWebACLId) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidWebACLId) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidWebACLId"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidWebACLId) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A key group with this name already exists. You must provide a unique name. To
// modify an existing key group, use UpdateKeyGroup .
type KeyGroupAlreadyExists struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *KeyGroupAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *KeyGroupAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *KeyGroupAlreadyExists) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "KeyGroupAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *KeyGroupAlreadyExists) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This operation requires a body. Ensure that the body is present and the
// Content-Type header is set.
type MissingBody struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MissingBody) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MissingBody) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MissingBody) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "MissingBody"
	}
	return *e.ErrorCodeOverride
}
func (e *MissingBody) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A monitoring subscription already exists for the specified distribution.
type MonitoringSubscriptionAlreadyExists struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MonitoringSubscriptionAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MonitoringSubscriptionAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MonitoringSubscriptionAlreadyExists) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "MonitoringSubscriptionAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *MonitoringSubscriptionAlreadyExists) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The cache policy does not exist.
type NoSuchCachePolicy struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoSuchCachePolicy) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchCachePolicy) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchCachePolicy) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoSuchCachePolicy"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchCachePolicy) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified origin access identity does not exist.
type NoSuchCloudFrontOriginAccessIdentity struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoSuchCloudFrontOriginAccessIdentity) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchCloudFrontOriginAccessIdentity) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchCloudFrontOriginAccessIdentity) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoSuchCloudFrontOriginAccessIdentity"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchCloudFrontOriginAccessIdentity) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The continuous deployment policy doesn't exist.
type NoSuchContinuousDeploymentPolicy struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoSuchContinuousDeploymentPolicy) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchContinuousDeploymentPolicy) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchContinuousDeploymentPolicy) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoSuchContinuousDeploymentPolicy"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchContinuousDeploymentPolicy) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified distribution does not exist.
type NoSuchDistribution struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoSuchDistribution) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchDistribution) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchDistribution) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoSuchDistribution"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchDistribution) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified configuration for field-level encryption doesn't exist.
type NoSuchFieldLevelEncryptionConfig struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoSuchFieldLevelEncryptionConfig) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchFieldLevelEncryptionConfig) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchFieldLevelEncryptionConfig) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoSuchFieldLevelEncryptionConfig"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchFieldLevelEncryptionConfig) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified profile for field-level encryption doesn't exist.
type NoSuchFieldLevelEncryptionProfile struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoSuchFieldLevelEncryptionProfile) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchFieldLevelEncryptionProfile) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchFieldLevelEncryptionProfile) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoSuchFieldLevelEncryptionProfile"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchFieldLevelEncryptionProfile) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The function does not exist.
type NoSuchFunctionExists struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoSuchFunctionExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchFunctionExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchFunctionExists) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoSuchFunctionExists"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchFunctionExists) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified invalidation does not exist.
type NoSuchInvalidation struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoSuchInvalidation) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchInvalidation) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchInvalidation) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoSuchInvalidation"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchInvalidation) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A monitoring subscription does not exist for the specified distribution.
type NoSuchMonitoringSubscription struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoSuchMonitoringSubscription) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchMonitoringSubscription) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchMonitoringSubscription) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoSuchMonitoringSubscription"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchMonitoringSubscription) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// No origin exists with the specified Origin Id .
type NoSuchOrigin struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoSuchOrigin) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchOrigin) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchOrigin) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoSuchOrigin"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchOrigin) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The origin access control does not exist.
type NoSuchOriginAccessControl struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoSuchOriginAccessControl) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchOriginAccessControl) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchOriginAccessControl) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoSuchOriginAccessControl"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchOriginAccessControl) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The origin request policy does not exist.
type NoSuchOriginRequestPolicy struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoSuchOriginRequestPolicy) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchOriginRequestPolicy) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchOriginRequestPolicy) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoSuchOriginRequestPolicy"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchOriginRequestPolicy) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified public key doesn't exist.
type NoSuchPublicKey struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoSuchPublicKey) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchPublicKey) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchPublicKey) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoSuchPublicKey"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchPublicKey) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The real-time log configuration does not exist.
type NoSuchRealtimeLogConfig struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoSuchRealtimeLogConfig) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchRealtimeLogConfig) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchRealtimeLogConfig) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoSuchRealtimeLogConfig"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchRealtimeLogConfig) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A resource that was specified is not valid.
type NoSuchResource struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoSuchResource) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchResource) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchResource) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoSuchResource"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchResource) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The response headers policy does not exist.
type NoSuchResponseHeadersPolicy struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoSuchResponseHeadersPolicy) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchResponseHeadersPolicy) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchResponseHeadersPolicy) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoSuchResponseHeadersPolicy"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchResponseHeadersPolicy) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified streaming distribution does not exist.
type NoSuchStreamingDistribution struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoSuchStreamingDistribution) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchStreamingDistribution) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchStreamingDistribution) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoSuchStreamingDistribution"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchStreamingDistribution) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An origin access control with the specified parameters already exists.
type OriginAccessControlAlreadyExists struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OriginAccessControlAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OriginAccessControlAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OriginAccessControlAlreadyExists) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OriginAccessControlAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *OriginAccessControlAlreadyExists) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Cannot delete the origin access control because it's in use by one or more
// distributions.
type OriginAccessControlInUse struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OriginAccessControlInUse) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OriginAccessControlInUse) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OriginAccessControlInUse) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OriginAccessControlInUse"
	}
	return *e.ErrorCodeOverride
}
func (e *OriginAccessControlInUse) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An origin request policy with this name already exists. You must provide a
// unique name. To modify an existing origin request policy, use
// UpdateOriginRequestPolicy .
type OriginRequestPolicyAlreadyExists struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OriginRequestPolicyAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OriginRequestPolicyAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OriginRequestPolicyAlreadyExists) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OriginRequestPolicyAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *OriginRequestPolicyAlreadyExists) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Cannot delete the origin request policy because it is attached to one or more
// cache behaviors.
type OriginRequestPolicyInUse struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OriginRequestPolicyInUse) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OriginRequestPolicyInUse) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OriginRequestPolicyInUse) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OriginRequestPolicyInUse"
	}
	return *e.ErrorCodeOverride
}
func (e *OriginRequestPolicyInUse) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The precondition in one or more of the request fields evaluated to false .
type PreconditionFailed struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PreconditionFailed) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PreconditionFailed) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PreconditionFailed) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "PreconditionFailed"
	}
	return *e.ErrorCodeOverride
}
func (e *PreconditionFailed) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified public key already exists.
type PublicKeyAlreadyExists struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PublicKeyAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PublicKeyAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PublicKeyAlreadyExists) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "PublicKeyAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *PublicKeyAlreadyExists) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified public key is in use.
type PublicKeyInUse struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PublicKeyInUse) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PublicKeyInUse) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PublicKeyInUse) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "PublicKeyInUse"
	}
	return *e.ErrorCodeOverride
}
func (e *PublicKeyInUse) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// No profile specified for the field-level encryption query argument.
type QueryArgProfileEmpty struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *QueryArgProfileEmpty) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *QueryArgProfileEmpty) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *QueryArgProfileEmpty) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "QueryArgProfileEmpty"
	}
	return *e.ErrorCodeOverride
}
func (e *QueryArgProfileEmpty) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A real-time log configuration with this name already exists. You must provide a
// unique name. To modify an existing real-time log configuration, use
// UpdateRealtimeLogConfig .
type RealtimeLogConfigAlreadyExists struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *RealtimeLogConfigAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RealtimeLogConfigAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RealtimeLogConfigAlreadyExists) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "RealtimeLogConfigAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *RealtimeLogConfigAlreadyExists) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Cannot delete the real-time log configuration because it is attached to one or
// more cache behaviors.
type RealtimeLogConfigInUse struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *RealtimeLogConfigInUse) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RealtimeLogConfigInUse) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RealtimeLogConfigInUse) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "RealtimeLogConfigInUse"
	}
	return *e.ErrorCodeOverride
}
func (e *RealtimeLogConfigInUse) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified real-time log configuration belongs to a different Amazon Web
// Services account.
type RealtimeLogConfigOwnerMismatch struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *RealtimeLogConfigOwnerMismatch) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RealtimeLogConfigOwnerMismatch) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RealtimeLogConfigOwnerMismatch) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "RealtimeLogConfigOwnerMismatch"
	}
	return *e.ErrorCodeOverride
}
func (e *RealtimeLogConfigOwnerMismatch) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Cannot delete this resource because it is in use.
type ResourceInUse struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceInUse) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceInUse) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceInUse) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceInUse"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceInUse) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A response headers policy with this name already exists. You must provide a
// unique name. To modify an existing response headers policy, use
// UpdateResponseHeadersPolicy .
type ResponseHeadersPolicyAlreadyExists struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResponseHeadersPolicyAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResponseHeadersPolicyAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResponseHeadersPolicyAlreadyExists) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResponseHeadersPolicyAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *ResponseHeadersPolicyAlreadyExists) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Cannot delete the response headers policy because it is attached to one or more
// cache behaviors in a CloudFront distribution.
type ResponseHeadersPolicyInUse struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResponseHeadersPolicyInUse) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResponseHeadersPolicyInUse) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResponseHeadersPolicyInUse) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResponseHeadersPolicyInUse"
	}
	return *e.ErrorCodeOverride
}
func (e *ResponseHeadersPolicyInUse) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A continuous deployment policy for this staging distribution already exists.
type StagingDistributionInUse struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *StagingDistributionInUse) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *StagingDistributionInUse) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *StagingDistributionInUse) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "StagingDistributionInUse"
	}
	return *e.ErrorCodeOverride
}
func (e *StagingDistributionInUse) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The caller reference you attempted to create the streaming distribution with is
// associated with another distribution
type StreamingDistributionAlreadyExists struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *StreamingDistributionAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *StreamingDistributionAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *StreamingDistributionAlreadyExists) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "StreamingDistributionAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *StreamingDistributionAlreadyExists) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified CloudFront distribution is not disabled. You must disable the
// distribution before you can delete it.
type StreamingDistributionNotDisabled struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *StreamingDistributionNotDisabled) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *StreamingDistributionNotDisabled) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *StreamingDistributionNotDisabled) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "StreamingDistributionNotDisabled"
	}
	return *e.ErrorCodeOverride
}
func (e *StreamingDistributionNotDisabled) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The CloudFront function failed.
type TestFunctionFailed struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TestFunctionFailed) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TestFunctionFailed) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TestFunctionFailed) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TestFunctionFailed"
	}
	return *e.ErrorCodeOverride
}
func (e *TestFunctionFailed) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// The length of the Content-Security-Policy header value in the response headers
// policy exceeds the maximum.
//
// For more information, see [Quotas] (formerly known as limits) in the Amazon CloudFront
// Developer Guide.
//
// [Quotas]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html
type TooLongCSPInResponseHeadersPolicy struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooLongCSPInResponseHeadersPolicy) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooLongCSPInResponseHeadersPolicy) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooLongCSPInResponseHeadersPolicy) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooLongCSPInResponseHeadersPolicy"
	}
	return *e.ErrorCodeOverride
}
func (e *TooLongCSPInResponseHeadersPolicy) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You cannot create more cache behaviors for the distribution.
type TooManyCacheBehaviors struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyCacheBehaviors) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyCacheBehaviors) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyCacheBehaviors) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyCacheBehaviors"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyCacheBehaviors) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You have reached the maximum number of cache policies for this Amazon Web
// Services account. For more information, see [Quotas](formerly known as limits) in the
// Amazon CloudFront Developer Guide.
//
// [Quotas]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html
type TooManyCachePolicies struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyCachePolicies) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyCachePolicies) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyCachePolicies) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyCachePolicies"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyCachePolicies) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You cannot create anymore custom SSL/TLS certificates.
type TooManyCertificates struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyCertificates) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyCertificates) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyCertificates) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyCertificates"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyCertificates) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Processing your request would cause you to exceed the maximum number of origin
// access identities allowed.
type TooManyCloudFrontOriginAccessIdentities struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyCloudFrontOriginAccessIdentities) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyCloudFrontOriginAccessIdentities) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyCloudFrontOriginAccessIdentities) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyCloudFrontOriginAccessIdentities"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyCloudFrontOriginAccessIdentities) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have reached the maximum number of continuous deployment policies for this
// Amazon Web Services account.
type TooManyContinuousDeploymentPolicies struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyContinuousDeploymentPolicies) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyContinuousDeploymentPolicies) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyContinuousDeploymentPolicies) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyContinuousDeploymentPolicies"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyContinuousDeploymentPolicies) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Your request contains more cookie names in the whitelist than are allowed per
// cache behavior.
type TooManyCookieNamesInWhiteList struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyCookieNamesInWhiteList) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyCookieNamesInWhiteList) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyCookieNamesInWhiteList) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyCookieNamesInWhiteList"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyCookieNamesInWhiteList) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of cookies in the cache policy exceeds the maximum. For more
// information, see [Quotas](formerly known as limits) in the Amazon CloudFront Developer
// Guide.
//
// [Quotas]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html
type TooManyCookiesInCachePolicy struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyCookiesInCachePolicy) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyCookiesInCachePolicy) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyCookiesInCachePolicy) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyCookiesInCachePolicy"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyCookiesInCachePolicy) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of cookies in the origin request policy exceeds the maximum. For
// more information, see [Quotas](formerly known as limits) in the Amazon CloudFront
// Developer Guide.
//
// [Quotas]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html
type TooManyCookiesInOriginRequestPolicy struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyCookiesInOriginRequestPolicy) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyCookiesInOriginRequestPolicy) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyCookiesInOriginRequestPolicy) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyCookiesInOriginRequestPolicy"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyCookiesInOriginRequestPolicy) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The number of custom headers in the response headers policy exceeds the maximum.
//
// For more information, see [Quotas] (formerly known as limits) in the Amazon CloudFront
// Developer Guide.
//
// [Quotas]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html
type TooManyCustomHeadersInResponseHeadersPolicy struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyCustomHeadersInResponseHeadersPolicy) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyCustomHeadersInResponseHeadersPolicy) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyCustomHeadersInResponseHeadersPolicy) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyCustomHeadersInResponseHeadersPolicy"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyCustomHeadersInResponseHeadersPolicy) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Your request contains more CNAMEs than are allowed per distribution.
type TooManyDistributionCNAMEs struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyDistributionCNAMEs) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyDistributionCNAMEs) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyDistributionCNAMEs) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyDistributionCNAMEs"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyDistributionCNAMEs) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Processing your request would cause you to exceed the maximum number of
// distributions allowed.
type TooManyDistributions struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyDistributions) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyDistributions) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyDistributions) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyDistributions"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyDistributions) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The maximum number of distributions have been associated with the specified
// cache policy. For more information, see [Quotas](formerly known as limits) in the
// Amazon CloudFront Developer Guide.
//
// [Quotas]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html
type TooManyDistributionsAssociatedToCachePolicy struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyDistributionsAssociatedToCachePolicy) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyDistributionsAssociatedToCachePolicy) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyDistributionsAssociatedToCachePolicy) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyDistributionsAssociatedToCachePolicy"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyDistributionsAssociatedToCachePolicy) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The maximum number of distributions have been associated with the specified
// configuration for field-level encryption.
type TooManyDistributionsAssociatedToFieldLevelEncryptionConfig struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyDistributionsAssociatedToFieldLevelEncryptionConfig) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyDistributionsAssociatedToFieldLevelEncryptionConfig) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyDistributionsAssociatedToFieldLevelEncryptionConfig) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyDistributionsAssociatedToFieldLevelEncryptionConfig"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyDistributionsAssociatedToFieldLevelEncryptionConfig) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The number of distributions that reference this key group is more than the
// maximum allowed. For more information, see [Quotas](formerly known as limits) in the
// Amazon CloudFront Developer Guide.
//
// [Quotas]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html
type TooManyDistributionsAssociatedToKeyGroup struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyDistributionsAssociatedToKeyGroup) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyDistributionsAssociatedToKeyGroup) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyDistributionsAssociatedToKeyGroup) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyDistributionsAssociatedToKeyGroup"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyDistributionsAssociatedToKeyGroup) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The maximum number of distributions have been associated with the specified
// origin access control.
//
// For more information, see [Quotas] (formerly known as limits) in the Amazon CloudFront
// Developer Guide.
//
// [Quotas]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html
type TooManyDistributionsAssociatedToOriginAccessControl struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyDistributionsAssociatedToOriginAccessControl) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyDistributionsAssociatedToOriginAccessControl) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyDistributionsAssociatedToOriginAccessControl) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyDistributionsAssociatedToOriginAccessControl"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyDistributionsAssociatedToOriginAccessControl) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The maximum number of distributions have been associated with the specified
// origin request policy. For more information, see [Quotas](formerly known as limits) in
// the Amazon CloudFront Developer Guide.
//
// [Quotas]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html
type TooManyDistributionsAssociatedToOriginRequestPolicy struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyDistributionsAssociatedToOriginRequestPolicy) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyDistributionsAssociatedToOriginRequestPolicy) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyDistributionsAssociatedToOriginRequestPolicy) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyDistributionsAssociatedToOriginRequestPolicy"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyDistributionsAssociatedToOriginRequestPolicy) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The maximum number of distributions have been associated with the specified
// response headers policy.
//
// For more information, see [Quotas] (formerly known as limits) in the Amazon CloudFront
// Developer Guide.
//
// [Quotas]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html
type TooManyDistributionsAssociatedToResponseHeadersPolicy struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyDistributionsAssociatedToResponseHeadersPolicy) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyDistributionsAssociatedToResponseHeadersPolicy) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyDistributionsAssociatedToResponseHeadersPolicy) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyDistributionsAssociatedToResponseHeadersPolicy"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyDistributionsAssociatedToResponseHeadersPolicy) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have reached the maximum number of distributions that are associated with a
// CloudFront function. For more information, see [Quotas](formerly known as limits) in
// the Amazon CloudFront Developer Guide.
//
// [Quotas]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html
type TooManyDistributionsWithFunctionAssociations struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyDistributionsWithFunctionAssociations) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyDistributionsWithFunctionAssociations) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyDistributionsWithFunctionAssociations) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyDistributionsWithFunctionAssociations"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyDistributionsWithFunctionAssociations) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Processing your request would cause the maximum number of distributions with
// Lambda@Edge function associations per owner to be exceeded.
type TooManyDistributionsWithLambdaAssociations struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyDistributionsWithLambdaAssociations) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyDistributionsWithLambdaAssociations) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyDistributionsWithLambdaAssociations) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyDistributionsWithLambdaAssociations"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyDistributionsWithLambdaAssociations) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The maximum number of distributions have been associated with the specified
// Lambda@Edge function.
type TooManyDistributionsWithSingleFunctionARN struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyDistributionsWithSingleFunctionARN) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyDistributionsWithSingleFunctionARN) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyDistributionsWithSingleFunctionARN) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyDistributionsWithSingleFunctionARN"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyDistributionsWithSingleFunctionARN) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The maximum number of configurations for field-level encryption have been
// created.
type TooManyFieldLevelEncryptionConfigs struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyFieldLevelEncryptionConfigs) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyFieldLevelEncryptionConfigs) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyFieldLevelEncryptionConfigs) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyFieldLevelEncryptionConfigs"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyFieldLevelEncryptionConfigs) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The maximum number of content type profiles for field-level encryption have
// been created.
type TooManyFieldLevelEncryptionContentTypeProfiles struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyFieldLevelEncryptionContentTypeProfiles) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyFieldLevelEncryptionContentTypeProfiles) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyFieldLevelEncryptionContentTypeProfiles) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyFieldLevelEncryptionContentTypeProfiles"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyFieldLevelEncryptionContentTypeProfiles) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The maximum number of encryption entities for field-level encryption have been
// created.
type TooManyFieldLevelEncryptionEncryptionEntities struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyFieldLevelEncryptionEncryptionEntities) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyFieldLevelEncryptionEncryptionEntities) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyFieldLevelEncryptionEncryptionEntities) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyFieldLevelEncryptionEncryptionEntities"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyFieldLevelEncryptionEncryptionEntities) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The maximum number of field patterns for field-level encryption have been
// created.
type TooManyFieldLevelEncryptionFieldPatterns struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyFieldLevelEncryptionFieldPatterns) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyFieldLevelEncryptionFieldPatterns) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyFieldLevelEncryptionFieldPatterns) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyFieldLevelEncryptionFieldPatterns"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyFieldLevelEncryptionFieldPatterns) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The maximum number of profiles for field-level encryption have been created.
type TooManyFieldLevelEncryptionProfiles struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyFieldLevelEncryptionProfiles) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyFieldLevelEncryptionProfiles) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyFieldLevelEncryptionProfiles) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyFieldLevelEncryptionProfiles"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyFieldLevelEncryptionProfiles) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The maximum number of query arg profiles for field-level encryption have been
// created.
type TooManyFieldLevelEncryptionQueryArgProfiles struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyFieldLevelEncryptionQueryArgProfiles) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyFieldLevelEncryptionQueryArgProfiles) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyFieldLevelEncryptionQueryArgProfiles) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyFieldLevelEncryptionQueryArgProfiles"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyFieldLevelEncryptionQueryArgProfiles) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have reached the maximum number of CloudFront function associations for
// this distribution. For more information, see [Quotas](formerly known as limits) in the
// Amazon CloudFront Developer Guide.
//
// [Quotas]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html
type TooManyFunctionAssociations struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyFunctionAssociations) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyFunctionAssociations) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyFunctionAssociations) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyFunctionAssociations"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyFunctionAssociations) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You have reached the maximum number of CloudFront functions for this Amazon Web
// Services account. For more information, see [Quotas](formerly known as limits) in the
// Amazon CloudFront Developer Guide.
//
// [Quotas]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html
type TooManyFunctions struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyFunctions) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyFunctions) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyFunctions) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyFunctions"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyFunctions) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of headers in the cache policy exceeds the maximum. For more
// information, see [Quotas](formerly known as limits) in the Amazon CloudFront Developer
// Guide.
//
// [Quotas]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html
type TooManyHeadersInCachePolicy struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyHeadersInCachePolicy) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyHeadersInCachePolicy) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyHeadersInCachePolicy) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyHeadersInCachePolicy"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyHeadersInCachePolicy) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Your request contains too many headers in forwarded values.
type TooManyHeadersInForwardedValues struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyHeadersInForwardedValues) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyHeadersInForwardedValues) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyHeadersInForwardedValues) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyHeadersInForwardedValues"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyHeadersInForwardedValues) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of headers in the origin request policy exceeds the maximum. For
// more information, see [Quotas](formerly known as limits) in the Amazon CloudFront
// Developer Guide.
//
// [Quotas]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html
type TooManyHeadersInOriginRequestPolicy struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyHeadersInOriginRequestPolicy) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyHeadersInOriginRequestPolicy) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyHeadersInOriginRequestPolicy) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyHeadersInOriginRequestPolicy"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyHeadersInOriginRequestPolicy) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have exceeded the maximum number of allowable InProgress invalidation batch
// requests, or invalidation objects.
type TooManyInvalidationsInProgress struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyInvalidationsInProgress) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyInvalidationsInProgress) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyInvalidationsInProgress) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyInvalidationsInProgress"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyInvalidationsInProgress) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You have reached the maximum number of key groups for this Amazon Web Services
// account. For more information, see [Quotas](formerly known as limits) in the Amazon
// CloudFront Developer Guide.
//
// [Quotas]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html
type TooManyKeyGroups struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyKeyGroups) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyKeyGroups) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyKeyGroups) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyKeyGroups"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyKeyGroups) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of key groups referenced by this distribution is more than the
// maximum allowed. For more information, see [Quotas](formerly known as limits) in the
// Amazon CloudFront Developer Guide.
//
// [Quotas]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html
type TooManyKeyGroupsAssociatedToDistribution struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyKeyGroupsAssociatedToDistribution) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyKeyGroupsAssociatedToDistribution) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyKeyGroupsAssociatedToDistribution) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyKeyGroupsAssociatedToDistribution"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyKeyGroupsAssociatedToDistribution) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Your request contains more Lambda@Edge function associations than are allowed
// per distribution.
type TooManyLambdaFunctionAssociations struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyLambdaFunctionAssociations) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyLambdaFunctionAssociations) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyLambdaFunctionAssociations) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyLambdaFunctionAssociations"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyLambdaFunctionAssociations) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of origin access controls in your Amazon Web Services account
// exceeds the maximum allowed.
//
// For more information, see [Quotas] (formerly known as limits) in the Amazon CloudFront
// Developer Guide.
//
// [Quotas]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html
type TooManyOriginAccessControls struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyOriginAccessControls) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyOriginAccessControls) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyOriginAccessControls) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyOriginAccessControls"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyOriginAccessControls) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Your request contains too many origin custom headers.
type TooManyOriginCustomHeaders struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyOriginCustomHeaders) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyOriginCustomHeaders) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyOriginCustomHeaders) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyOriginCustomHeaders"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyOriginCustomHeaders) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Processing your request would cause you to exceed the maximum number of origin
// groups allowed.
type TooManyOriginGroupsPerDistribution struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyOriginGroupsPerDistribution) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyOriginGroupsPerDistribution) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyOriginGroupsPerDistribution) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyOriginGroupsPerDistribution"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyOriginGroupsPerDistribution) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have reached the maximum number of origin request policies for this Amazon
// Web Services account. For more information, see [Quotas](formerly known as limits) in
// the Amazon CloudFront Developer Guide.
//
// [Quotas]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html
type TooManyOriginRequestPolicies struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyOriginRequestPolicies) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyOriginRequestPolicies) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyOriginRequestPolicies) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyOriginRequestPolicies"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyOriginRequestPolicies) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You cannot create more origins for the distribution.
type TooManyOrigins struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyOrigins) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyOrigins) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyOrigins) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyOrigins"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyOrigins) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The maximum number of public keys for field-level encryption have been created.
// To create a new public key, delete one of the existing keys.
type TooManyPublicKeys struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyPublicKeys) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyPublicKeys) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyPublicKeys) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyPublicKeys"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyPublicKeys) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of public keys in this key group is more than the maximum allowed.
// For more information, see [Quotas](formerly known as limits) in the Amazon CloudFront
// Developer Guide.
//
// [Quotas]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html
type TooManyPublicKeysInKeyGroup struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyPublicKeysInKeyGroup) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyPublicKeysInKeyGroup) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyPublicKeysInKeyGroup) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyPublicKeysInKeyGroup"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyPublicKeysInKeyGroup) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Your request contains too many query string parameters.
type TooManyQueryStringParameters struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyQueryStringParameters) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyQueryStringParameters) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyQueryStringParameters) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyQueryStringParameters"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyQueryStringParameters) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of query strings in the cache policy exceeds the maximum. For more
// information, see [Quotas](formerly known as limits) in the Amazon CloudFront Developer
// Guide.
//
// [Quotas]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html
type TooManyQueryStringsInCachePolicy struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyQueryStringsInCachePolicy) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyQueryStringsInCachePolicy) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyQueryStringsInCachePolicy) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyQueryStringsInCachePolicy"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyQueryStringsInCachePolicy) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of query strings in the origin request policy exceeds the maximum.
// For more information, see [Quotas](formerly known as limits) in the Amazon CloudFront
// Developer Guide.
//
// [Quotas]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html
type TooManyQueryStringsInOriginRequestPolicy struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyQueryStringsInOriginRequestPolicy) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyQueryStringsInOriginRequestPolicy) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyQueryStringsInOriginRequestPolicy) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyQueryStringsInOriginRequestPolicy"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyQueryStringsInOriginRequestPolicy) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have reached the maximum number of real-time log configurations for this
// Amazon Web Services account. For more information, see [Quotas](formerly known as
// limits) in the Amazon CloudFront Developer Guide.
//
// [Quotas]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html
type TooManyRealtimeLogConfigs struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyRealtimeLogConfigs) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyRealtimeLogConfigs) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyRealtimeLogConfigs) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyRealtimeLogConfigs"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyRealtimeLogConfigs) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of headers in RemoveHeadersConfig in the response headers policy
// exceeds the maximum.
//
// For more information, see [Quotas] (formerly known as limits) in the Amazon CloudFront
// Developer Guide.
//
// [Quotas]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html
type TooManyRemoveHeadersInResponseHeadersPolicy struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyRemoveHeadersInResponseHeadersPolicy) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyRemoveHeadersInResponseHeadersPolicy) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyRemoveHeadersInResponseHeadersPolicy) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyRemoveHeadersInResponseHeadersPolicy"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyRemoveHeadersInResponseHeadersPolicy) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have reached the maximum number of response headers policies for this
// Amazon Web Services account.
//
// For more information, see [Quotas] (formerly known as limits) in the Amazon CloudFront
// Developer Guide.
//
// [Quotas]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html
type TooManyResponseHeadersPolicies struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyResponseHeadersPolicies) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyResponseHeadersPolicies) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyResponseHeadersPolicies) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyResponseHeadersPolicies"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyResponseHeadersPolicies) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Your request contains more CNAMEs than are allowed per distribution.
type TooManyStreamingDistributionCNAMEs struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyStreamingDistributionCNAMEs) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyStreamingDistributionCNAMEs) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyStreamingDistributionCNAMEs) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyStreamingDistributionCNAMEs"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyStreamingDistributionCNAMEs) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Processing your request would cause you to exceed the maximum number of
// streaming distributions allowed.
type TooManyStreamingDistributions struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyStreamingDistributions) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyStreamingDistributions) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyStreamingDistributions) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyStreamingDistributions"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyStreamingDistributions) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Your request contains more trusted signers than are allowed per distribution.
type TooManyTrustedSigners struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyTrustedSigners) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyTrustedSigners) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyTrustedSigners) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyTrustedSigners"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyTrustedSigners) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified key group does not exist.
type TrustedKeyGroupDoesNotExist struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TrustedKeyGroupDoesNotExist) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TrustedKeyGroupDoesNotExist) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TrustedKeyGroupDoesNotExist) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TrustedKeyGroupDoesNotExist"
	}
	return *e.ErrorCodeOverride
}
func (e *TrustedKeyGroupDoesNotExist) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// One or more of your trusted signers don't exist.
type TrustedSignerDoesNotExist struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TrustedSignerDoesNotExist) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TrustedSignerDoesNotExist) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TrustedSignerDoesNotExist) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TrustedSignerDoesNotExist"
	}
	return *e.ErrorCodeOverride
}
func (e *TrustedSignerDoesNotExist) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This operation is not supported in this region.
type UnsupportedOperation struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnsupportedOperation) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnsupportedOperation) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnsupportedOperation) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnsupportedOperation"
	}
	return *e.ErrorCodeOverride
}
func (e *UnsupportedOperation) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
