/* Gnome Scan - Scan as easy as you print
 * Copyright © 2007  Étienne Bersac <bersace03@laposte.net>
 *
 * Gnome Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */
 
#ifndef _FLEGITA_PSPEC_H
#define _FLEGITA_PSPEC_H

#include <gnome-scan-param-specs.h>
#include "flegita-types.h"
#include "flegita.h"

G_BEGIN_DECLS

/* COMMON */

/* ACTION */
#define	FLEGITA_TYPE_PARAM_ACTION		(flegita_param_action_get_type ())
#define	FLEGITA_PARAM_SPEC_ACTION(p)		(G_TYPE_CHECK_INSTANCE_CAST ((p), FLEGITA_TYPE_PARAM_ACTION, FlegitaParamSpecAction))
#define	FLEGITA_IS_PARAM_SPEC_ACTION(p)	(G_TYPE_CHECK_INSTANCE_TYPE ((p), FLEGITA_TYPE_PARAM_ACTION))

typedef struct _FlegitaParamSpecAction FlegitaParamSpecAction;
/**
 * FlegitaParamSpecAction:
 *
 **/
struct _FlegitaParamSpecAction
{
  /*< private >*/
  GParamSpec	parent_instance;
  FlegitaAction	default_action;
};

GType		flegita_param_action_get_type	(void)	G_GNUC_CONST;
GParamSpec*	flegita_param_spec_action	(const gchar *name,
						 const gchar *nick,
						 const gchar *blurb,
						 GQuark group,
						 FlegitaAction default_action,
						 GParamFlags flags);


/* OUTPUT_FILENAME */
#define	FLEGITA_TYPE_PARAM_OUTPUT_FILENAME		(flegita_param_output_filename_get_type ())
#define	FLEGITA_PARAM_SPEC_OUTPUT_FILENAME(p)		(G_TYPE_CHECK_INSTANCE_CAST ((p), FLEGITA_TYPE_PARAM_OUTPUT_FILENAME, FlegitaParamSpecOutputFilename))
#define	FLEGITA_IS_PARAM_SPEC_OUTPUT_FILENAME(p)	(G_TYPE_CHECK_INSTANCE_TYPE ((p), FLEGITA_TYPE_PARAM_OUTPUT_FILENAME))

typedef struct _FlegitaParamSpecOutputFilename FlegitaParamSpecOutputFilename;
/**
 * FlegitaParamSpecOutputFilename:
 *
 * This spec is used to select an output filename, this mean that the
 * widget will have a "save as" behaviour.
 **/
struct _FlegitaParamSpecOutputFilename
{
  /*< private >*/
  GParamSpec	parent_instance;
};

GType		flegita_param_output_filename_get_type	(void)	G_GNUC_CONST;
GParamSpec*	flegita_param_spec_output_filename	(const gchar *name,
							 const gchar *nick,
							 const gchar *blurb,
							 GQuark group,
							 GSList *formats,
							 GParamFlags flags);

GSList* flegita_param_output_filename_get_formats	(GParamSpec *pspec);




G_END_DECLS

#endif /* _FLEGITA_PSPEC_H */
