//
// This file comes from the Tomboy project.
// http://www.gnome.org/projects/tomboy/
//
/*
 * Copyright (C) 2004-2007  Alex Graveley
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __DO_KEY_BINDER_H__
#define __DO_KEY_BINDER_H__

#include <glib.h>

G_BEGIN_DECLS

typedef void (* GnomeDoBindkeyHandler) (char *keystring, gpointer user_data);

void gnomedo_keybinder_init   (void);

gboolean gnomedo_keybinder_bind   (const char           *keystring,
			      GnomeDoBindkeyHandler  handler,
			      gpointer              user_data);

gboolean gnomedo_keybinder_unbind (const char           *keystring,
			      GnomeDoBindkeyHandler  handler);

gboolean gnomedo_keybinder_is_modifier (guint keycode);

guint32 gnomedo_keybinder_get_current_event_time (void);

G_END_DECLS

#endif /* __DO_KEY_BINDER_H__ */

