------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2007 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: test.adb,v 1.11 2007/04/13 03:43:57 vagul Exp $

with
   Text_IO,
   Ada.Integer_Text_IO,
   Ada.Long_Float_Text_IO,
   Ada.Strings.Unbounded,
   Ada.Exceptions,
   OCI.Thick.Date,
   OCI.Thick.Integer_Var,
   OCI.Thick.OCIDate_Var,
   OCI.Thick.Long_Float_Var,
   OCI.Thick.OCINumber_Var,
   OCI.Thick.String_Var,
   OCI.Thick.String_Bounded,
   OCI.Thick.Servers,
   OCI.Thick.Connections,
   OCI.Thick.Statements,
   OCI.Thick.Parameters,
   OCI.Thick.Number_Functions,
   OCI.Thick.Debug_Allocation,
   OCI.Environments,
   OCI.Thick.Strings;

procedure Test is
   use Text_IO, OCI.Thick;

   use
      Ada.Integer_Text_IO,
      Ada.Long_Float_Text_IO,
      Ada.Strings.Unbounded,
      Long_Float_Var,
      Integer_Var,
      String_Bounded,
      OCIDate_Var,
      OCINumber_Var,
      String_Var,
      Connections,
      Servers,
      Statements,
      Parameters,
      Strings,
      Number_Functions;

   procedure Main;

   procedure Main is
      Strv  : Strings.Variable;
      Strb  : String_Bounded.Variable (64);
      Int   : Integer_Var.Variable;
      Flt   : Long_Float_Var.Variable;
      Numb  : OCINumber_Var.Variable;
      Date  : OCIDate_Var.Variable;
      Param : Parameter;
      Stmt  : Statement;
      Connect : Connection;
      DB : Server := Attach ("");
      oNumb1, oNumb2 : OCINumber;
      Null_Descr : array (Boolean) of String (1 .. 8)
        := (False => "NOT NULL", True => "    NULL");
   begin

      Connect := Logon (DB, "scott", "tiger");
      Put_Line ("Main");
      Put_Line ("Connected");
      Put_Line (Server_Version (Connect));

      Execute
        (Connect,
         "alter session set nls_date_format='YYYY-MM-DD HH24:MI:SS'");

      Stmt := Prepare (Connect, "select "
          & "object_name, "
          & "timestamp, "
          & "OBJECT_ID, "
          & "sysdate - created, "
          & "sysdate-Last_ddl_Time, "
          & "Last_ddl_Time" & ASCII.Lf
          & "from user_objects "
          & "where object_id > :id " & ASCII.Lf
          & "and object_id < :id + 10000000 and object_name <> :objtype");

      declare
         Names : VStrings := Statements.Bind_Names (Stmt);
      begin
         Put_Line ("---------");
         for i in Names'Range loop
            Put_Line (To_String (Names (i)));
         end loop;
      end;

      Bind (Stmt, Strb, "objtype");
      Set_Value (Strb, "TABLE");
      Bind (Stmt, Int, 1);
      Set_Value (Int, 2);

      Execute (Stmt);

      declare
         Columns : Parameter_Array := Get_Parameters (Stmt);
      begin
         for i in Columns'Range loop
            Set_Col (01); Put (Name (Columns (i)));
            Set_Col (25); Put (SQL_Type'Image (Get_SQL_Type (Columns (i))));
            Set_Col (38); Put (Type_Name (Columns (i)));
            Set_Col (40); Put (Integer'Image (Data_Size (Columns (i))));
            Set_Col (45); Put (Integer'Image (Precision (Columns (i))));
            Set_Col (50); Put (Integer'Image (Scale (Columns (i))));
            Set_Col (55); Put (Null_Descr (Is_Null (Columns (i))));
            Set_Col (65); Put (Schema_Name (Columns (i)));
         end loop;
--        Param := Columns(1);
      end;

      Define (Stmt, Strv, 1);
      Define (Stmt, Strb, 2);
      Define (Stmt, Int, 3);
      Define (Stmt, Flt, 4);
      Define (Stmt, Numb, 5);
      Define (Stmt, Date, 6);

--      Set_Value(Strv,(1..230=> ' '));
      while Fetch (Stmt) loop
         Set_Col (1);  Put (Get_Value (Strv) & ',');
         Set_Col (16); Put (Get_Value (Strb));
         Set_Col (35); Put (Get_Value (Int), Width => 6);
         Set_Col (42); Put (Get_Value (Flt), Aft => 3, Exp => 0);

         Set_Col (50);
         Put (To_String (Get_Value (Numb), "FM999990.99999"));
         Set_Col (60);
         Put (OCI.Thick.Date.To_String (Get_Value (Date),
         "DD Mon RRRR HH24:MI:SS"));
      end loop;

      Set_Col (1);

      Stmt := Prepare
                (Connect,
                 "begin :result := (sysdate - :client_time)*60*60*24; "
                 & "end;");

      Bind (Stmt, Numb, ":result");

      Set_Value (Numb, To_Number (4.0));
      Bind (Stmt, Date, ":client_time");

      Set_Value (Date, OCI.Thick.Date.SysDate); --  client local time

      Put_Line ("Client time : "
                & OCI.Thick.Date.To_String (Get_Value (Date),
                             "Day Ddspth Month Yyyyspth HH24:MI:SS"));
      Execute (Stmt);
      Put_Line ("Time difference : "
                & To_String (Get_Value (Numb), "FM999990.099") & " seconds");

      oNumb1 := Get_Value (Numb);
      oNumb2 := abs (oNumb1);
      Put ("Time difference : ");
      Put_Line (To_String (oNumb1, "FM999990.099") & " seconds");
      Put_Line (To_String
                  (To_Number (To_Long_Float (-oNumb2)), "FM9999999.099999"));
      Put_Line (To_String (oNumb2, "FM999990.099"));

      oNumb1 := To_Number (0.5);
      oNumb2 := oNumb1 + oNumb2;
      oNumb2 := ArcTan2 (oNumb1, oNumb2);
      Put_Line ("Arc");
      Put_Line (To_String (oNumb2, "FM999990.099"));
      Put_Line ("---------------------");

      OCI.Thick.Debug_Allocation.Print_Info;

      Put_Line ("Memory allocation count "
        & Integer'Image (OCI.Environments.Counter.Value) & ASCII.LF
        & "Last allocated size "
        & Integer'Image (OCI.Environments.Last_Size)
         );

   exception
   when E : Lib_Error =>
      Put_Line (Last_Error_Message);
   when E : others =>
      Put_Line (Ada.Exceptions.Exception_Information (E));
   end Main;

   --   remove comments below to check multitasking

   task type Parallel is
      entry Start;
      entry Wait;
   end Parallel;

   task body Parallel is
   begin
      accept Start;
      Main;
      accept Wait;
   end Parallel;

   p : array (1 .. 1) of Parallel;

begin
   Put_Line ("Start");

   OCI.Thick.Debug_Allocation.Start;

   Put_Line ("Started");

   for i in p'Range loop
      p (i).Start;
   end loop;

   Main;

   for i in p'Range loop
      p (i).Wait;
   end loop;
end Test;
