-- ------------------------------------------------------------------------- --
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/objects/cache.ads,v $
--  Description     : Base class for all persistent objects                  --
--  Author          : Michael Erdmann <Michael.Erdmann@snafu.de>             --
--  Created On      : 30-April-2005                                          --
--  Last Modified By: $Author: merdmann $                                    --
--  Last Modified On: $Date: 2007/01/21 20:27:21 $                           --
--  Status          : $State: Exp $                                          --
--                                                                           --
--  Copyright (C) 2006-2007 Michael Erdmann                                  --
--                                                                           --
--  GNADE is copyrighted by the persons and institutions enumerated in the   --
--  AUTHORS file. This file is located in the root directory of the          --
--  GNADE distribution.                                                      --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNADE;  see file COPYING. If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from      --
--  GNADE Ada units, or you link GNADE Ada units or libraries with other     --
--  files  to produce an executable, these  units or libraries do not by     --
--  itself cause the resulting  executable  to  be covered  by the  GNU      --
--  General  Public  License.  This exception does not however invalidate    --
--  any other reasons why  the executable file  might be covered by the      --
--  GNU Public License.                                                      --
--                                                                           --
--  Functional Description                                                   --
--  ======================                                                   --
--  This module implement a simple cache functionality in order to reduce    --
--  the number of database accesses.                                         --
--                                                                           --
--  Read Access                                                              --
--                                                                           --
--  Read access to objects is based on object id's and finger prints. The    --
--  method Get_Object allows to retieve the blob contents.                   --
--  If the Object of the given id or finger print is not already loaded, the --
--  blob representing the object is loaded into the memory.                  --
--                                                                           --
--  Write Access                                                             --
--                                                                           --
--  If and Put_Object is invoked, the object is wirtten back to the data-    --
--  base and the new blob is keept in the cache for retrival.                --
--                                                                           --
--  Invalidation                                                             --
--                                                                           --
--  There is no automatic invalidation. When is client decides not using an  --
--  object any more and explict call to the Invalidate method has to be      --
--  done.                                                                    --
--                                                                           --
--  Restriction                                                              --
--  ===========                                                              --
--  R.1 - Not Tasking save                                                   --
-- ------------------------------------------------------------------------- --
with Ada.Streams;               	use Ada.Streams;
with Ada.Streams.Stream_IO;     	use Ada.Streams.Stream_IO;
with Ada.Text_IO;			use Ada.Text_IO;
use  Ada;

with GNU.DB.SQLCLI;			use GNU.DB.SQLCLI;
with SQL_Standard;      		use SQL_Standard;

with Objects;				use Objects;
with BLOB_Stream;			use BLOB_Stream;
with MD5;				use MD5;

package Cache is

   subtype BLOB_Type is GNADE.BINARY( 1..Blob_Size );
   type BLOB_Access is access BLOB_Type;

   procedure Flush;

   procedure Get_Object(
      Id      : in Integer;
      Version : in out Integer;
      BLOB    : out BLOB_Access;
      Length  : out Natural);

   procedure Get_Object(
      Fprint  : in GNADE.BINARY;
      Version : in out Integer;
      BLOB    : out BLOB_Access;
      Length  : out Natural);

   procedure Put_Object(
      Id         : in Integer;
      Version    : in out Integer;
      Fprint     : in GNADE.BINARY;
      BLOB       : in GNADE.BINARY;
      Class_Name : in String);

   procedure Invalidate(
      Id      : in Integer;
      Version : in Integer );

end Cache;
