-------------------------------------------------------------------------------
--
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/gui_table.ads,v $
--  Description     : GUI for the data base client
--  Author          : Michael Erdmann
--  Created         : 8.8.2001
--  Last Modified By: $Author: me $
--  Last Modified On: $Date: 2001/12/02 20:42:52 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Michael Erdmann
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Strings.Unbounded;               use Ada.Strings.Unbounded;

with Gtk.Box;                             use Gtk.Box;
with Gtk.Event_Box;                       use Gtk.Event_Box;
with Gtk.Label;                           use Gtk.Label;
with Gtk.GEntry;                          use Gtk.GEntry;
with Gtk.Clist;                           use Gtk.Clist;
with Gtk.Text;                            use Gtk.Text;

with GSQL_Types;                          use GSQL_Types;
with GUI_Rowdefinition;                   use GUI_Rowdefinition;
with GUI_Worksheet;                       use GUI_Worksheet;
with GUI_Addrow;                          use GUI_Addrow;

package GUI_Table is

   type Object is new GUI_Worksheet.Object with private;

   type Handle is access all Object;

   procedure Get_Result(
      This   : in Object;
      Text   : out Text_Buffer;
      Last   : out Positive );

   procedure Set_Input(
      This   : in out Object;
      Text   : in Text_Buffer);

   procedure Insert_Row(
      This   : in out Object;
      Def    : in Row_Information_Record );

   function DML_Create_Table_Command(
      Text : in Text_Buffer ) return String;

private

   type Row_Information_Array is array( Positive range <> ) of Row_Information_Record;

   type Object is new GUI_Worksheet.Object with record
         Name         : Gtk_Entry;
         Import_Name  : Gtk_Entry;
         Export_Name  : Gtk_Entry;
         Description  : Gtk_Text;
         Definition   : Gtk_Clist;
         Row_Dialog   : GUI_Addrow.Object;
         Nbr_Of_Rows  : Natural := 0;
         Row_Info     : Row_Information_Array( 1..1024 );
      end record;

   procedure Command(
       This : in out Object;
       Cmd  : in Natural );

   procedure Display(
       This : in out Object;
       Box  : in out Gtk_Box );

end GUI_Table;
