
"Line drawing."

import OpenGL.GL as gl

import glitch

class Lines(glitch.Node):
    def __init__(self, vs, **kw):
       glitch.Node.__init__(self, **kw)
       self.vs = vs

    def draw(self, ctx):
        gl.glBegin(gl.GL_LINES)

        for (x, y, z) in self.vs:
            gl.glVertex(x, y, z)

        gl.glEnd()

class LineStrip(glitch.Node):
    def __init__(self, vs, **kw):
       glitch.Node.__init__(self, **kw)
       self.vs = vs

    def draw(self, ctx):
        gl.glBegin(gl.GL_LINE_STRIP)

        for (x, y, z) in self.vs:
            gl.glVertex(x, y, z)

        gl.glEnd()

