// Code generated by protoc-gen-go. DO NOT EDIT.
// source: blob.proto

package gitalypb

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type GetBlobRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository,proto3" json:"repository,omitempty"`
	// Object ID (SHA1) of the blob we want to get
	Oid string `protobuf:"bytes,2,opt,name=oid,proto3" json:"oid,omitempty"`
	// Maximum number of bytes we want to receive. Use '-1' to get the full blob no matter how big.
	Limit                int64    `protobuf:"varint,3,opt,name=limit,proto3" json:"limit,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetBlobRequest) Reset()         { *m = GetBlobRequest{} }
func (m *GetBlobRequest) String() string { return proto.CompactTextString(m) }
func (*GetBlobRequest) ProtoMessage()    {}
func (*GetBlobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6903d1e8a20272e8, []int{0}
}

func (m *GetBlobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetBlobRequest.Unmarshal(m, b)
}
func (m *GetBlobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetBlobRequest.Marshal(b, m, deterministic)
}
func (m *GetBlobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetBlobRequest.Merge(m, src)
}
func (m *GetBlobRequest) XXX_Size() int {
	return xxx_messageInfo_GetBlobRequest.Size(m)
}
func (m *GetBlobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetBlobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetBlobRequest proto.InternalMessageInfo

func (m *GetBlobRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *GetBlobRequest) GetOid() string {
	if m != nil {
		return m.Oid
	}
	return ""
}

func (m *GetBlobRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

type GetBlobResponse struct {
	// Blob size; present only in first response message
	Size int64 `protobuf:"varint,1,opt,name=size,proto3" json:"size,omitempty"`
	// Chunk of blob data
	Data []byte `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	// Object ID of the actual blob returned. Empty if no blob was found.
	Oid                  string   `protobuf:"bytes,3,opt,name=oid,proto3" json:"oid,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetBlobResponse) Reset()         { *m = GetBlobResponse{} }
func (m *GetBlobResponse) String() string { return proto.CompactTextString(m) }
func (*GetBlobResponse) ProtoMessage()    {}
func (*GetBlobResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6903d1e8a20272e8, []int{1}
}

func (m *GetBlobResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetBlobResponse.Unmarshal(m, b)
}
func (m *GetBlobResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetBlobResponse.Marshal(b, m, deterministic)
}
func (m *GetBlobResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetBlobResponse.Merge(m, src)
}
func (m *GetBlobResponse) XXX_Size() int {
	return xxx_messageInfo_GetBlobResponse.Size(m)
}
func (m *GetBlobResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetBlobResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetBlobResponse proto.InternalMessageInfo

func (m *GetBlobResponse) GetSize() int64 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *GetBlobResponse) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *GetBlobResponse) GetOid() string {
	if m != nil {
		return m.Oid
	}
	return ""
}

type GetBlobsRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository,proto3" json:"repository,omitempty"`
	// Revision/Path pairs of the blobs we want to get.
	RevisionPaths []*GetBlobsRequest_RevisionPath `protobuf:"bytes,2,rep,name=revision_paths,json=revisionPaths,proto3" json:"revision_paths,omitempty"`
	// Maximum number of bytes we want to receive. Use '-1' to get the full blobs no matter how big.
	Limit                int64    `protobuf:"varint,3,opt,name=limit,proto3" json:"limit,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetBlobsRequest) Reset()         { *m = GetBlobsRequest{} }
func (m *GetBlobsRequest) String() string { return proto.CompactTextString(m) }
func (*GetBlobsRequest) ProtoMessage()    {}
func (*GetBlobsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6903d1e8a20272e8, []int{2}
}

func (m *GetBlobsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetBlobsRequest.Unmarshal(m, b)
}
func (m *GetBlobsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetBlobsRequest.Marshal(b, m, deterministic)
}
func (m *GetBlobsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetBlobsRequest.Merge(m, src)
}
func (m *GetBlobsRequest) XXX_Size() int {
	return xxx_messageInfo_GetBlobsRequest.Size(m)
}
func (m *GetBlobsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetBlobsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetBlobsRequest proto.InternalMessageInfo

func (m *GetBlobsRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *GetBlobsRequest) GetRevisionPaths() []*GetBlobsRequest_RevisionPath {
	if m != nil {
		return m.RevisionPaths
	}
	return nil
}

func (m *GetBlobsRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

type GetBlobsRequest_RevisionPath struct {
	Revision             string   `protobuf:"bytes,1,opt,name=revision,proto3" json:"revision,omitempty"`
	Path                 []byte   `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetBlobsRequest_RevisionPath) Reset()         { *m = GetBlobsRequest_RevisionPath{} }
func (m *GetBlobsRequest_RevisionPath) String() string { return proto.CompactTextString(m) }
func (*GetBlobsRequest_RevisionPath) ProtoMessage()    {}
func (*GetBlobsRequest_RevisionPath) Descriptor() ([]byte, []int) {
	return fileDescriptor_6903d1e8a20272e8, []int{2, 0}
}

func (m *GetBlobsRequest_RevisionPath) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetBlobsRequest_RevisionPath.Unmarshal(m, b)
}
func (m *GetBlobsRequest_RevisionPath) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetBlobsRequest_RevisionPath.Marshal(b, m, deterministic)
}
func (m *GetBlobsRequest_RevisionPath) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetBlobsRequest_RevisionPath.Merge(m, src)
}
func (m *GetBlobsRequest_RevisionPath) XXX_Size() int {
	return xxx_messageInfo_GetBlobsRequest_RevisionPath.Size(m)
}
func (m *GetBlobsRequest_RevisionPath) XXX_DiscardUnknown() {
	xxx_messageInfo_GetBlobsRequest_RevisionPath.DiscardUnknown(m)
}

var xxx_messageInfo_GetBlobsRequest_RevisionPath proto.InternalMessageInfo

func (m *GetBlobsRequest_RevisionPath) GetRevision() string {
	if m != nil {
		return m.Revision
	}
	return ""
}

func (m *GetBlobsRequest_RevisionPath) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

type GetBlobsResponse struct {
	// Blob size; present only on the first message per blob
	Size int64 `protobuf:"varint,1,opt,name=size,proto3" json:"size,omitempty"`
	// Chunk of blob data, could span over multiple messages.
	Data []byte `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	// Object ID of the current blob. Only present on the first message per blob. Empty if no blob was found.
	Oid                  string     `protobuf:"bytes,3,opt,name=oid,proto3" json:"oid,omitempty"`
	IsSubmodule          bool       `protobuf:"varint,4,opt,name=is_submodule,json=isSubmodule,proto3" json:"is_submodule,omitempty"`
	Mode                 int32      `protobuf:"varint,5,opt,name=mode,proto3" json:"mode,omitempty"`
	Revision             string     `protobuf:"bytes,6,opt,name=revision,proto3" json:"revision,omitempty"`
	Path                 []byte     `protobuf:"bytes,7,opt,name=path,proto3" json:"path,omitempty"`
	Type                 ObjectType `protobuf:"varint,8,opt,name=type,proto3,enum=gitaly.ObjectType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *GetBlobsResponse) Reset()         { *m = GetBlobsResponse{} }
func (m *GetBlobsResponse) String() string { return proto.CompactTextString(m) }
func (*GetBlobsResponse) ProtoMessage()    {}
func (*GetBlobsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6903d1e8a20272e8, []int{3}
}

func (m *GetBlobsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetBlobsResponse.Unmarshal(m, b)
}
func (m *GetBlobsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetBlobsResponse.Marshal(b, m, deterministic)
}
func (m *GetBlobsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetBlobsResponse.Merge(m, src)
}
func (m *GetBlobsResponse) XXX_Size() int {
	return xxx_messageInfo_GetBlobsResponse.Size(m)
}
func (m *GetBlobsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetBlobsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetBlobsResponse proto.InternalMessageInfo

func (m *GetBlobsResponse) GetSize() int64 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *GetBlobsResponse) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *GetBlobsResponse) GetOid() string {
	if m != nil {
		return m.Oid
	}
	return ""
}

func (m *GetBlobsResponse) GetIsSubmodule() bool {
	if m != nil {
		return m.IsSubmodule
	}
	return false
}

func (m *GetBlobsResponse) GetMode() int32 {
	if m != nil {
		return m.Mode
	}
	return 0
}

func (m *GetBlobsResponse) GetRevision() string {
	if m != nil {
		return m.Revision
	}
	return ""
}

func (m *GetBlobsResponse) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *GetBlobsResponse) GetType() ObjectType {
	if m != nil {
		return m.Type
	}
	return ObjectType_UNKNOWN
}

// LFSPointer is a git blob which points to an LFS object.
type LFSPointer struct {
	// Size is the size of the blob. This is not the size of the LFS object
	// pointed to.
	Size int64 `protobuf:"varint,1,opt,name=size,proto3" json:"size,omitempty"`
	// Data is the bare data of the LFS pointer blob. It contains the pointer to
	// the LFS data in the format specified by the LFS project.
	Data []byte `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	// Oid is the object ID of the blob.
	Oid                  string   `protobuf:"bytes,3,opt,name=oid,proto3" json:"oid,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LFSPointer) Reset()         { *m = LFSPointer{} }
func (m *LFSPointer) String() string { return proto.CompactTextString(m) }
func (*LFSPointer) ProtoMessage()    {}
func (*LFSPointer) Descriptor() ([]byte, []int) {
	return fileDescriptor_6903d1e8a20272e8, []int{4}
}

func (m *LFSPointer) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LFSPointer.Unmarshal(m, b)
}
func (m *LFSPointer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LFSPointer.Marshal(b, m, deterministic)
}
func (m *LFSPointer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LFSPointer.Merge(m, src)
}
func (m *LFSPointer) XXX_Size() int {
	return xxx_messageInfo_LFSPointer.Size(m)
}
func (m *LFSPointer) XXX_DiscardUnknown() {
	xxx_messageInfo_LFSPointer.DiscardUnknown(m)
}

var xxx_messageInfo_LFSPointer proto.InternalMessageInfo

func (m *LFSPointer) GetSize() int64 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *LFSPointer) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *LFSPointer) GetOid() string {
	if m != nil {
		return m.Oid
	}
	return ""
}

type NewBlobObject struct {
	Size                 int64    `protobuf:"varint,1,opt,name=size,proto3" json:"size,omitempty"`
	Oid                  string   `protobuf:"bytes,2,opt,name=oid,proto3" json:"oid,omitempty"`
	Path                 []byte   `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NewBlobObject) Reset()         { *m = NewBlobObject{} }
func (m *NewBlobObject) String() string { return proto.CompactTextString(m) }
func (*NewBlobObject) ProtoMessage()    {}
func (*NewBlobObject) Descriptor() ([]byte, []int) {
	return fileDescriptor_6903d1e8a20272e8, []int{5}
}

func (m *NewBlobObject) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NewBlobObject.Unmarshal(m, b)
}
func (m *NewBlobObject) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NewBlobObject.Marshal(b, m, deterministic)
}
func (m *NewBlobObject) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NewBlobObject.Merge(m, src)
}
func (m *NewBlobObject) XXX_Size() int {
	return xxx_messageInfo_NewBlobObject.Size(m)
}
func (m *NewBlobObject) XXX_DiscardUnknown() {
	xxx_messageInfo_NewBlobObject.DiscardUnknown(m)
}

var xxx_messageInfo_NewBlobObject proto.InternalMessageInfo

func (m *NewBlobObject) GetSize() int64 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *NewBlobObject) GetOid() string {
	if m != nil {
		return m.Oid
	}
	return ""
}

func (m *NewBlobObject) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

// GetLFSPointersRequest is a request for the GetLFSPointers RPC.
type GetLFSPointersRequest struct {
	// Repository is the repository for which LFS pointers should be retrieved
	// from.
	Repository *Repository `protobuf:"bytes,1,opt,name=repository,proto3" json:"repository,omitempty"`
	// BlobIds is the list of blobs to retrieve LFS pointers from. Must be a
	// non-empty list of blobs IDs to fetch.
	BlobIds              []string `protobuf:"bytes,2,rep,name=blob_ids,json=blobIds,proto3" json:"blob_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetLFSPointersRequest) Reset()         { *m = GetLFSPointersRequest{} }
func (m *GetLFSPointersRequest) String() string { return proto.CompactTextString(m) }
func (*GetLFSPointersRequest) ProtoMessage()    {}
func (*GetLFSPointersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6903d1e8a20272e8, []int{6}
}

func (m *GetLFSPointersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetLFSPointersRequest.Unmarshal(m, b)
}
func (m *GetLFSPointersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetLFSPointersRequest.Marshal(b, m, deterministic)
}
func (m *GetLFSPointersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetLFSPointersRequest.Merge(m, src)
}
func (m *GetLFSPointersRequest) XXX_Size() int {
	return xxx_messageInfo_GetLFSPointersRequest.Size(m)
}
func (m *GetLFSPointersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetLFSPointersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetLFSPointersRequest proto.InternalMessageInfo

func (m *GetLFSPointersRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *GetLFSPointersRequest) GetBlobIds() []string {
	if m != nil {
		return m.BlobIds
	}
	return nil
}

// GetLFSPointersResponse is a response for the GetLFSPointers RPC.
type GetLFSPointersResponse struct {
	// LfsPointers is the list of LFS pointers which were requested.
	LfsPointers          []*LFSPointer `protobuf:"bytes,1,rep,name=lfs_pointers,json=lfsPointers,proto3" json:"lfs_pointers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *GetLFSPointersResponse) Reset()         { *m = GetLFSPointersResponse{} }
func (m *GetLFSPointersResponse) String() string { return proto.CompactTextString(m) }
func (*GetLFSPointersResponse) ProtoMessage()    {}
func (*GetLFSPointersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6903d1e8a20272e8, []int{7}
}

func (m *GetLFSPointersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetLFSPointersResponse.Unmarshal(m, b)
}
func (m *GetLFSPointersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetLFSPointersResponse.Marshal(b, m, deterministic)
}
func (m *GetLFSPointersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetLFSPointersResponse.Merge(m, src)
}
func (m *GetLFSPointersResponse) XXX_Size() int {
	return xxx_messageInfo_GetLFSPointersResponse.Size(m)
}
func (m *GetLFSPointersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetLFSPointersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetLFSPointersResponse proto.InternalMessageInfo

func (m *GetLFSPointersResponse) GetLfsPointers() []*LFSPointer {
	if m != nil {
		return m.LfsPointers
	}
	return nil
}

// ListLFSPointersRequest is a request for the ListLFSPointers RPC.
type ListLFSPointersRequest struct {
	// Repository is the repository for which LFS pointers should be retrieved
	// from.
	Repository *Repository `protobuf:"bytes,1,opt,name=repository,proto3" json:"repository,omitempty"`
	// Revisions is the list of revisions to retrieve LFS pointers from. Must be
	// a non-empty list.
	Revisions []string `protobuf:"bytes,2,rep,name=revisions,proto3" json:"revisions,omitempty"`
	// Limit limits the number of LFS pointers returned.
	Limit                int32    `protobuf:"varint,3,opt,name=limit,proto3" json:"limit,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListLFSPointersRequest) Reset()         { *m = ListLFSPointersRequest{} }
func (m *ListLFSPointersRequest) String() string { return proto.CompactTextString(m) }
func (*ListLFSPointersRequest) ProtoMessage()    {}
func (*ListLFSPointersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6903d1e8a20272e8, []int{8}
}

func (m *ListLFSPointersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListLFSPointersRequest.Unmarshal(m, b)
}
func (m *ListLFSPointersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListLFSPointersRequest.Marshal(b, m, deterministic)
}
func (m *ListLFSPointersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListLFSPointersRequest.Merge(m, src)
}
func (m *ListLFSPointersRequest) XXX_Size() int {
	return xxx_messageInfo_ListLFSPointersRequest.Size(m)
}
func (m *ListLFSPointersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListLFSPointersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListLFSPointersRequest proto.InternalMessageInfo

func (m *ListLFSPointersRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *ListLFSPointersRequest) GetRevisions() []string {
	if m != nil {
		return m.Revisions
	}
	return nil
}

func (m *ListLFSPointersRequest) GetLimit() int32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

// ListLFSPointersResponse is a response for the ListLFSPointers RPC.
type ListLFSPointersResponse struct {
	// LfsPointers is the list of LFS pointers which were requested.
	LfsPointers          []*LFSPointer `protobuf:"bytes,1,rep,name=lfs_pointers,json=lfsPointers,proto3" json:"lfs_pointers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ListLFSPointersResponse) Reset()         { *m = ListLFSPointersResponse{} }
func (m *ListLFSPointersResponse) String() string { return proto.CompactTextString(m) }
func (*ListLFSPointersResponse) ProtoMessage()    {}
func (*ListLFSPointersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6903d1e8a20272e8, []int{9}
}

func (m *ListLFSPointersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListLFSPointersResponse.Unmarshal(m, b)
}
func (m *ListLFSPointersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListLFSPointersResponse.Marshal(b, m, deterministic)
}
func (m *ListLFSPointersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListLFSPointersResponse.Merge(m, src)
}
func (m *ListLFSPointersResponse) XXX_Size() int {
	return xxx_messageInfo_ListLFSPointersResponse.Size(m)
}
func (m *ListLFSPointersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListLFSPointersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListLFSPointersResponse proto.InternalMessageInfo

func (m *ListLFSPointersResponse) GetLfsPointers() []*LFSPointer {
	if m != nil {
		return m.LfsPointers
	}
	return nil
}

// ListAllLFSPointersRequest is a request for the ListAllLFSPointers RPC.
type ListAllLFSPointersRequest struct {
	// Repository is the repository for which LFS pointers should be retrieved
	// from.
	Repository *Repository `protobuf:"bytes,1,opt,name=repository,proto3" json:"repository,omitempty"`
	// Limit limits the number of LFS pointers returned.
	Limit                int32    `protobuf:"varint,3,opt,name=limit,proto3" json:"limit,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAllLFSPointersRequest) Reset()         { *m = ListAllLFSPointersRequest{} }
func (m *ListAllLFSPointersRequest) String() string { return proto.CompactTextString(m) }
func (*ListAllLFSPointersRequest) ProtoMessage()    {}
func (*ListAllLFSPointersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6903d1e8a20272e8, []int{10}
}

func (m *ListAllLFSPointersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAllLFSPointersRequest.Unmarshal(m, b)
}
func (m *ListAllLFSPointersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAllLFSPointersRequest.Marshal(b, m, deterministic)
}
func (m *ListAllLFSPointersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAllLFSPointersRequest.Merge(m, src)
}
func (m *ListAllLFSPointersRequest) XXX_Size() int {
	return xxx_messageInfo_ListAllLFSPointersRequest.Size(m)
}
func (m *ListAllLFSPointersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAllLFSPointersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListAllLFSPointersRequest proto.InternalMessageInfo

func (m *ListAllLFSPointersRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *ListAllLFSPointersRequest) GetLimit() int32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

// ListAllLFSPointersResponse is a response for the ListAllLFSPointers RPC.
type ListAllLFSPointersResponse struct {
	// LfsPointers is the list of LFS pointers which were requested.
	LfsPointers          []*LFSPointer `protobuf:"bytes,1,rep,name=lfs_pointers,json=lfsPointers,proto3" json:"lfs_pointers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ListAllLFSPointersResponse) Reset()         { *m = ListAllLFSPointersResponse{} }
func (m *ListAllLFSPointersResponse) String() string { return proto.CompactTextString(m) }
func (*ListAllLFSPointersResponse) ProtoMessage()    {}
func (*ListAllLFSPointersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6903d1e8a20272e8, []int{11}
}

func (m *ListAllLFSPointersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAllLFSPointersResponse.Unmarshal(m, b)
}
func (m *ListAllLFSPointersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAllLFSPointersResponse.Marshal(b, m, deterministic)
}
func (m *ListAllLFSPointersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAllLFSPointersResponse.Merge(m, src)
}
func (m *ListAllLFSPointersResponse) XXX_Size() int {
	return xxx_messageInfo_ListAllLFSPointersResponse.Size(m)
}
func (m *ListAllLFSPointersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAllLFSPointersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListAllLFSPointersResponse proto.InternalMessageInfo

func (m *ListAllLFSPointersResponse) GetLfsPointers() []*LFSPointer {
	if m != nil {
		return m.LfsPointers
	}
	return nil
}

func init() {
	proto.RegisterType((*GetBlobRequest)(nil), "gitaly.GetBlobRequest")
	proto.RegisterType((*GetBlobResponse)(nil), "gitaly.GetBlobResponse")
	proto.RegisterType((*GetBlobsRequest)(nil), "gitaly.GetBlobsRequest")
	proto.RegisterType((*GetBlobsRequest_RevisionPath)(nil), "gitaly.GetBlobsRequest.RevisionPath")
	proto.RegisterType((*GetBlobsResponse)(nil), "gitaly.GetBlobsResponse")
	proto.RegisterType((*LFSPointer)(nil), "gitaly.LFSPointer")
	proto.RegisterType((*NewBlobObject)(nil), "gitaly.NewBlobObject")
	proto.RegisterType((*GetLFSPointersRequest)(nil), "gitaly.GetLFSPointersRequest")
	proto.RegisterType((*GetLFSPointersResponse)(nil), "gitaly.GetLFSPointersResponse")
	proto.RegisterType((*ListLFSPointersRequest)(nil), "gitaly.ListLFSPointersRequest")
	proto.RegisterType((*ListLFSPointersResponse)(nil), "gitaly.ListLFSPointersResponse")
	proto.RegisterType((*ListAllLFSPointersRequest)(nil), "gitaly.ListAllLFSPointersRequest")
	proto.RegisterType((*ListAllLFSPointersResponse)(nil), "gitaly.ListAllLFSPointersResponse")
}

func init() { proto.RegisterFile("blob.proto", fileDescriptor_6903d1e8a20272e8) }

var fileDescriptor_6903d1e8a20272e8 = []byte{
	// 644 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x55, 0xdd, 0x6e, 0xd3, 0x30,
	0x14, 0x96, 0x9b, 0xb6, 0x6b, 0x4f, 0xbb, 0x1f, 0x59, 0xb0, 0x65, 0x11, 0x3f, 0x59, 0x84, 0x50,
	0x2e, 0xa0, 0x85, 0x32, 0x24, 0xae, 0x90, 0x98, 0xd0, 0xa6, 0x69, 0x13, 0x9b, 0x5c, 0x6e, 0x40,
	0x48, 0x55, 0xb2, 0x78, 0x9d, 0xc1, 0xad, 0x43, 0xec, 0x0d, 0x95, 0x07, 0xe0, 0x15, 0xe0, 0x61,
	0xb8, 0xe6, 0x25, 0x78, 0x07, 0x1e, 0x80, 0x2b, 0x94, 0xff, 0xac, 0x49, 0xb9, 0xe9, 0xee, 0x8e,
	0x8f, 0x73, 0xbe, 0xef, 0x3b, 0xc7, 0x9f, 0x1d, 0x00, 0x97, 0x0b, 0xb7, 0xe7, 0x07, 0x42, 0x09,
	0xdc, 0x1c, 0x33, 0xe5, 0xf0, 0x99, 0x01, 0x9c, 0x4d, 0x55, 0x9c, 0x33, 0xba, 0xf2, 0xc2, 0x09,
	0xa8, 0x17, 0xaf, 0xac, 0x00, 0xd6, 0x0e, 0xa8, 0xda, 0xe3, 0xc2, 0x25, 0xf4, 0xf3, 0x25, 0x95,
	0x0a, 0xbf, 0x00, 0x08, 0xa8, 0x2f, 0x24, 0x53, 0x22, 0x98, 0xe9, 0xc8, 0x44, 0x76, 0x67, 0x80,
	0x7b, 0x31, 0x50, 0x8f, 0x64, 0x3b, 0x7b, 0xf5, 0x1f, 0xbf, 0x1e, 0x21, 0x52, 0xf8, 0x16, 0x6f,
	0x80, 0x26, 0x98, 0xa7, 0xd7, 0x4c, 0x64, 0xb7, 0x49, 0x18, 0xe2, 0x5b, 0xd0, 0xe0, 0x6c, 0xc2,
	0x94, 0xae, 0x99, 0xc8, 0xd6, 0x48, 0xbc, 0xb0, 0x8e, 0x60, 0x3d, 0xe3, 0x94, 0xbe, 0x98, 0x4a,
	0x8a, 0x31, 0xd4, 0x25, 0xfb, 0x4a, 0x23, 0x3a, 0x8d, 0x44, 0x71, 0x98, 0xf3, 0x1c, 0xe5, 0x44,
	0x78, 0x5d, 0x12, 0xc5, 0x29, 0x85, 0x96, 0x51, 0x58, 0x7f, 0x50, 0x86, 0x26, 0x97, 0x6f, 0xe1,
	0x08, 0xd6, 0x02, 0x7a, 0xc5, 0x24, 0x13, 0xd3, 0x91, 0xef, 0xa8, 0x0b, 0xa9, 0xd7, 0x4c, 0xcd,
	0xee, 0x0c, 0x1e, 0xa4, 0xd5, 0x73, 0x54, 0x3d, 0x92, 0x7c, 0x7d, 0xea, 0xa8, 0x0b, 0xb2, 0x1a,
	0x14, 0x56, 0xb2, 0xba, 0x7b, 0xe3, 0x25, 0x74, 0x8b, 0x45, 0xd8, 0x80, 0x56, 0x5a, 0x16, 0x49,
	0x6d, 0x93, 0x6c, 0x1d, 0x8e, 0x20, 0x54, 0x91, 0x8e, 0x20, 0x8c, 0xad, 0xdf, 0x08, 0x36, 0x72,
	0x15, 0xcb, 0xce, 0x0f, 0xef, 0x40, 0x97, 0xc9, 0x91, 0xbc, 0x74, 0x27, 0xc2, 0xbb, 0xe4, 0x54,
	0xaf, 0x9b, 0xc8, 0x6e, 0x91, 0x0e, 0x93, 0xc3, 0x34, 0x15, 0x02, 0x4d, 0x84, 0x47, 0xf5, 0x86,
	0x89, 0xec, 0x06, 0x89, 0xe2, 0x6b, 0xaa, 0x9b, 0x0b, 0x54, 0xaf, 0xe4, 0xaa, 0xf1, 0x43, 0xa8,
	0xab, 0x99, 0x4f, 0xf5, 0x96, 0x89, 0xec, 0xb5, 0xfc, 0x30, 0x4e, 0xdc, 0x8f, 0xf4, 0x4c, 0xbd,
	0x9d, 0xf9, 0x94, 0x44, 0xfb, 0xd6, 0x3e, 0xc0, 0xf1, 0xfe, 0xf0, 0x54, 0xb0, 0xa9, 0xa2, 0xc1,
	0x12, 0xb6, 0x38, 0x84, 0xd5, 0x37, 0xf4, 0x4b, 0x38, 0xa4, 0x98, 0xa2, 0x12, 0xaa, 0x6c, 0xd8,
	0x54, 0xba, 0x56, 0x18, 0x38, 0x87, 0xdb, 0x07, 0x54, 0xe5, 0xaa, 0x6e, 0xc0, 0x66, 0xdb, 0xd0,
	0x0a, 0x6f, 0xe9, 0x88, 0x79, 0xb1, 0xc1, 0xda, 0x64, 0x25, 0x5c, 0x1f, 0x7a, 0xd2, 0x3a, 0x81,
	0xcd, 0x79, 0xb6, 0xe4, 0x8c, 0x9f, 0x43, 0x97, 0x9f, 0xcb, 0x91, 0x9f, 0xe4, 0x75, 0x14, 0x39,
	0x33, 0x23, 0xcc, 0x4b, 0x48, 0x87, 0x9f, 0xcb, 0xb4, 0xdc, 0xfa, 0x86, 0x60, 0xf3, 0x98, 0xc9,
	0x9b, 0x6d, 0xe0, 0x0e, 0xb4, 0xd3, 0xe3, 0x4e, 0x3b, 0xc8, 0x13, 0xd7, 0x8d, 0xdf, 0x48, 0xaf,
	0xfd, 0x29, 0x6c, 0x95, 0x74, 0x2c, 0xd7, 0xda, 0x27, 0xd8, 0x0e, 0x11, 0x5f, 0x71, 0x7e, 0xa3,
	0xcd, 0x55, 0xcb, 0x1f, 0x82, 0x51, 0x45, 0xb6, 0x54, 0x07, 0x83, 0x9f, 0x1a, 0x74, 0x42, 0x93,
	0x0e, 0x69, 0x70, 0xc5, 0xce, 0x28, 0x7e, 0x0d, 0x2b, 0xc9, 0xdd, 0xc6, 0x9b, 0x73, 0x4f, 0x4e,
	0xd2, 0x97, 0xb1, 0x55, 0xca, 0xc7, 0x12, 0xac, 0xe6, 0xdf, 0xef, 0x76, 0xad, 0x55, 0x7b, 0x82,
	0xf0, 0x01, 0xb4, 0xd2, 0x17, 0x02, 0x6f, 0x2d, 0x78, 0xb9, 0x0c, 0xbd, 0xbc, 0x51, 0x02, 0x7a,
	0x17, 0xfd, 0x1d, 0x0a, 0xfd, 0xe2, 0xbb, 0x85, 0xaa, 0xf2, 0xd0, 0x8d, 0x7b, 0x8b, 0xb6, 0x4b,
	0xd0, 0x1f, 0x60, 0x7d, 0xce, 0x0d, 0x38, 0x2b, 0xae, 0xb6, 0xab, 0x71, 0x7f, 0xe1, 0x7e, 0x09,
	0x9d, 0x02, 0x2e, 0x1f, 0x16, 0xde, 0x29, 0x02, 0x54, 0xba, 0xc6, 0xb0, 0xfe, 0xf7, 0xc9, 0x3c,
	0xcd, 0xde, 0xee, 0xfb, 0xc1, 0x98, 0x29, 0xee, 0xb8, 0xbd, 0x33, 0x31, 0xe9, 0xc7, 0xe1, 0x63,
	0x11, 0x8c, 0xfb, 0x31, 0x48, 0xff, 0xea, 0xe9, 0x6e, 0x3f, 0xfa, 0xcf, 0xf6, 0xc7, 0x22, 0xc9,
	0xf9, 0xae, 0xdb, 0x8c, 0x52, 0xcf, 0xfe, 0x05, 0x00, 0x00, 0xff, 0xff, 0x33, 0xe5, 0x62, 0xe6,
	0xaa, 0x07, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// BlobServiceClient is the client API for BlobService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BlobServiceClient interface {
	// GetBlob returns the contents of a blob object referenced by its object
	// ID. We use a stream to return a chunked arbitrarily large binary
	// response
	GetBlob(ctx context.Context, in *GetBlobRequest, opts ...grpc.CallOption) (BlobService_GetBlobClient, error)
	GetBlobs(ctx context.Context, in *GetBlobsRequest, opts ...grpc.CallOption) (BlobService_GetBlobsClient, error)
	// GetLFSPointers retrieves LFS pointers from a given set of object IDs.
	// This RPC filters all requested objects and only returns those which refer
	// to a valid LFS pointer.
	GetLFSPointers(ctx context.Context, in *GetLFSPointersRequest, opts ...grpc.CallOption) (BlobService_GetLFSPointersClient, error)
	// ListLFSPointers retrieves LFS pointers reachable from a given set of
	// revisions by doing a graph walk. This includes both normal revisions like
	// an object ID or branch, but also the pseudo-revisions "--all" and "--not"
	// as documented in git-rev-parse(1). Revisions which don't directly or
	// transitively reference any LFS pointers are ignored. It is not valid to
	// pass revisions which do not resolve to an existing object.
	ListLFSPointers(ctx context.Context, in *ListLFSPointersRequest, opts ...grpc.CallOption) (BlobService_ListLFSPointersClient, error)
	// ListAllLFSPointers retrieves all LFS pointers in the repository, including
	// those not reachable by any reference.
	ListAllLFSPointers(ctx context.Context, in *ListAllLFSPointersRequest, opts ...grpc.CallOption) (BlobService_ListAllLFSPointersClient, error)
}

type blobServiceClient struct {
	cc *grpc.ClientConn
}

func NewBlobServiceClient(cc *grpc.ClientConn) BlobServiceClient {
	return &blobServiceClient{cc}
}

func (c *blobServiceClient) GetBlob(ctx context.Context, in *GetBlobRequest, opts ...grpc.CallOption) (BlobService_GetBlobClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BlobService_serviceDesc.Streams[0], "/gitaly.BlobService/GetBlob", opts...)
	if err != nil {
		return nil, err
	}
	x := &blobServiceGetBlobClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type BlobService_GetBlobClient interface {
	Recv() (*GetBlobResponse, error)
	grpc.ClientStream
}

type blobServiceGetBlobClient struct {
	grpc.ClientStream
}

func (x *blobServiceGetBlobClient) Recv() (*GetBlobResponse, error) {
	m := new(GetBlobResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *blobServiceClient) GetBlobs(ctx context.Context, in *GetBlobsRequest, opts ...grpc.CallOption) (BlobService_GetBlobsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BlobService_serviceDesc.Streams[1], "/gitaly.BlobService/GetBlobs", opts...)
	if err != nil {
		return nil, err
	}
	x := &blobServiceGetBlobsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type BlobService_GetBlobsClient interface {
	Recv() (*GetBlobsResponse, error)
	grpc.ClientStream
}

type blobServiceGetBlobsClient struct {
	grpc.ClientStream
}

func (x *blobServiceGetBlobsClient) Recv() (*GetBlobsResponse, error) {
	m := new(GetBlobsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *blobServiceClient) GetLFSPointers(ctx context.Context, in *GetLFSPointersRequest, opts ...grpc.CallOption) (BlobService_GetLFSPointersClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BlobService_serviceDesc.Streams[2], "/gitaly.BlobService/GetLFSPointers", opts...)
	if err != nil {
		return nil, err
	}
	x := &blobServiceGetLFSPointersClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type BlobService_GetLFSPointersClient interface {
	Recv() (*GetLFSPointersResponse, error)
	grpc.ClientStream
}

type blobServiceGetLFSPointersClient struct {
	grpc.ClientStream
}

func (x *blobServiceGetLFSPointersClient) Recv() (*GetLFSPointersResponse, error) {
	m := new(GetLFSPointersResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *blobServiceClient) ListLFSPointers(ctx context.Context, in *ListLFSPointersRequest, opts ...grpc.CallOption) (BlobService_ListLFSPointersClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BlobService_serviceDesc.Streams[3], "/gitaly.BlobService/ListLFSPointers", opts...)
	if err != nil {
		return nil, err
	}
	x := &blobServiceListLFSPointersClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type BlobService_ListLFSPointersClient interface {
	Recv() (*ListLFSPointersResponse, error)
	grpc.ClientStream
}

type blobServiceListLFSPointersClient struct {
	grpc.ClientStream
}

func (x *blobServiceListLFSPointersClient) Recv() (*ListLFSPointersResponse, error) {
	m := new(ListLFSPointersResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *blobServiceClient) ListAllLFSPointers(ctx context.Context, in *ListAllLFSPointersRequest, opts ...grpc.CallOption) (BlobService_ListAllLFSPointersClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BlobService_serviceDesc.Streams[4], "/gitaly.BlobService/ListAllLFSPointers", opts...)
	if err != nil {
		return nil, err
	}
	x := &blobServiceListAllLFSPointersClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type BlobService_ListAllLFSPointersClient interface {
	Recv() (*ListAllLFSPointersResponse, error)
	grpc.ClientStream
}

type blobServiceListAllLFSPointersClient struct {
	grpc.ClientStream
}

func (x *blobServiceListAllLFSPointersClient) Recv() (*ListAllLFSPointersResponse, error) {
	m := new(ListAllLFSPointersResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BlobServiceServer is the server API for BlobService service.
type BlobServiceServer interface {
	// GetBlob returns the contents of a blob object referenced by its object
	// ID. We use a stream to return a chunked arbitrarily large binary
	// response
	GetBlob(*GetBlobRequest, BlobService_GetBlobServer) error
	GetBlobs(*GetBlobsRequest, BlobService_GetBlobsServer) error
	// GetLFSPointers retrieves LFS pointers from a given set of object IDs.
	// This RPC filters all requested objects and only returns those which refer
	// to a valid LFS pointer.
	GetLFSPointers(*GetLFSPointersRequest, BlobService_GetLFSPointersServer) error
	// ListLFSPointers retrieves LFS pointers reachable from a given set of
	// revisions by doing a graph walk. This includes both normal revisions like
	// an object ID or branch, but also the pseudo-revisions "--all" and "--not"
	// as documented in git-rev-parse(1). Revisions which don't directly or
	// transitively reference any LFS pointers are ignored. It is not valid to
	// pass revisions which do not resolve to an existing object.
	ListLFSPointers(*ListLFSPointersRequest, BlobService_ListLFSPointersServer) error
	// ListAllLFSPointers retrieves all LFS pointers in the repository, including
	// those not reachable by any reference.
	ListAllLFSPointers(*ListAllLFSPointersRequest, BlobService_ListAllLFSPointersServer) error
}

// UnimplementedBlobServiceServer can be embedded to have forward compatible implementations.
type UnimplementedBlobServiceServer struct {
}

func (*UnimplementedBlobServiceServer) GetBlob(req *GetBlobRequest, srv BlobService_GetBlobServer) error {
	return status.Errorf(codes.Unimplemented, "method GetBlob not implemented")
}
func (*UnimplementedBlobServiceServer) GetBlobs(req *GetBlobsRequest, srv BlobService_GetBlobsServer) error {
	return status.Errorf(codes.Unimplemented, "method GetBlobs not implemented")
}
func (*UnimplementedBlobServiceServer) GetLFSPointers(req *GetLFSPointersRequest, srv BlobService_GetLFSPointersServer) error {
	return status.Errorf(codes.Unimplemented, "method GetLFSPointers not implemented")
}
func (*UnimplementedBlobServiceServer) ListLFSPointers(req *ListLFSPointersRequest, srv BlobService_ListLFSPointersServer) error {
	return status.Errorf(codes.Unimplemented, "method ListLFSPointers not implemented")
}
func (*UnimplementedBlobServiceServer) ListAllLFSPointers(req *ListAllLFSPointersRequest, srv BlobService_ListAllLFSPointersServer) error {
	return status.Errorf(codes.Unimplemented, "method ListAllLFSPointers not implemented")
}

func RegisterBlobServiceServer(s *grpc.Server, srv BlobServiceServer) {
	s.RegisterService(&_BlobService_serviceDesc, srv)
}

func _BlobService_GetBlob_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetBlobRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BlobServiceServer).GetBlob(m, &blobServiceGetBlobServer{stream})
}

type BlobService_GetBlobServer interface {
	Send(*GetBlobResponse) error
	grpc.ServerStream
}

type blobServiceGetBlobServer struct {
	grpc.ServerStream
}

func (x *blobServiceGetBlobServer) Send(m *GetBlobResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _BlobService_GetBlobs_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetBlobsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BlobServiceServer).GetBlobs(m, &blobServiceGetBlobsServer{stream})
}

type BlobService_GetBlobsServer interface {
	Send(*GetBlobsResponse) error
	grpc.ServerStream
}

type blobServiceGetBlobsServer struct {
	grpc.ServerStream
}

func (x *blobServiceGetBlobsServer) Send(m *GetBlobsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _BlobService_GetLFSPointers_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetLFSPointersRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BlobServiceServer).GetLFSPointers(m, &blobServiceGetLFSPointersServer{stream})
}

type BlobService_GetLFSPointersServer interface {
	Send(*GetLFSPointersResponse) error
	grpc.ServerStream
}

type blobServiceGetLFSPointersServer struct {
	grpc.ServerStream
}

func (x *blobServiceGetLFSPointersServer) Send(m *GetLFSPointersResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _BlobService_ListLFSPointers_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListLFSPointersRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BlobServiceServer).ListLFSPointers(m, &blobServiceListLFSPointersServer{stream})
}

type BlobService_ListLFSPointersServer interface {
	Send(*ListLFSPointersResponse) error
	grpc.ServerStream
}

type blobServiceListLFSPointersServer struct {
	grpc.ServerStream
}

func (x *blobServiceListLFSPointersServer) Send(m *ListLFSPointersResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _BlobService_ListAllLFSPointers_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListAllLFSPointersRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BlobServiceServer).ListAllLFSPointers(m, &blobServiceListAllLFSPointersServer{stream})
}

type BlobService_ListAllLFSPointersServer interface {
	Send(*ListAllLFSPointersResponse) error
	grpc.ServerStream
}

type blobServiceListAllLFSPointersServer struct {
	grpc.ServerStream
}

func (x *blobServiceListAllLFSPointersServer) Send(m *ListAllLFSPointersResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _BlobService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "gitaly.BlobService",
	HandlerType: (*BlobServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetBlob",
			Handler:       _BlobService_GetBlob_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetBlobs",
			Handler:       _BlobService_GetBlobs_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetLFSPointers",
			Handler:       _BlobService_GetLFSPointers_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ListLFSPointers",
			Handler:       _BlobService_ListLFSPointers_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ListAllLFSPointers",
			Handler:       _BlobService_ListAllLFSPointers_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "blob.proto",
}
