// CLASSIFICATION: UNCLASSIFIED

package geotrans3.utility;


/**
 * Stores frequently used constant values.
 * 
 * @author comstam
 */
public class Constants
{
  /** PI VALUE */
  public static final double PI = 3.14159265358979323e0;
  
  /** PI / 2 VALUE */
  public static final double PI_OVER_2 = (PI / 2.0e0);
  
  /** PI / 4 VALUE */
  public static final double PI_OVER_4 = (PI / 4.0e0);
  
  /** 2 * PI VALUE */
  public static final double TWO_PI = (2.0e0 * PI);
  
  /** 180.0 / PI VALUE */
  public static final double _180_OVER_PI = (180.0 / PI);
  
  /** PI / 180.0 VALUE */
  public static final double PI_OVER_180 = (PI / 180.0);
  
  /** PI in degrees */
  public static final double PI_DEGREES = 180.0;
  
  /** 2.0 * PI in degrees */
  public static final double TWO_PI_DEGREES = 360.0;
}

// CLASSIFICATION: UNCLASSIFIED
