#! /usr/bin/env python

# Genetic
# Copyright (C) 2001 Jean-Baptiste LAMY
#
# This program is free software. See README or LICENSE for the license terms.

# This demo is similar to demo_prog_graph, but it use genetic algo and not
# genetic programming.

from __future__ import nested_scopes

import random, string, math, operator, Tkinter
from genetic import organism, lifecycle, prog

SIZE = 250


class Point:
  def __init__(self, x, y):
    self.x = x
    self.y = y
    
  def __repr__(self): return "<Point %s, %s>" % (self.x, self.y)
  
points = []


# square is the function to minimize.
# It takes one arg, an equation, and return the sum of the square distance
# between theoretical y (given by equation) and observed y (the ones from the
# points list).

def equation(a, b, c, d, e, x):
  return (a * (x ** 2) + b * x + c) / (d * x + e)

def square(a, b, c, d, e):
  try:
    return reduce(operator.add, map(
      lambda point : (point.y - equation(a, b, c, d, e, point.x)) ** 2,
      points))
  except TypeError: # error when there is no points.
    return None
  except ZeroDivisionError:
    return None # Non viable phenotype.


class EquationFinder(organism.Organism):
  characteristics = [
    organism.Characteristic("square", square, organism.RECESSIVE_PHENOTYPE)
    ]
  
  def __cmp__(self, other):
    # Say how we compare 2 organisms. Here, the lower the square is, the better the organism is.
    return cmp(self.square, other.square)


class Graph(Tkinter.Canvas):
  def __init__(self, master):
    Tkinter.Canvas.__init__(self, master, bg = "white", width = SIZE, height = SIZE)
    self.bind("<Button-1>", self.leftClick )
    self.line = None
    
    organismA = EquationFinder([
      organism.Chromosom(a = 0.0, b = 1.0, d = 0.0),
      organism.Chromosom(c = -15.0, e = 1.0),
      ])
    organismB = EquationFinder([
      organism.Chromosom(a = 0.1, b = -1.5, d = 0.1),
      organism.Chromosom(c = 50.0, e = 0.9),
      ])
    self.organisms = [organismA, organismB]
    
  def recomputephenotypes(self):
    for organism in self.organisms: organism._compute_phenotypes()
    
  def leftClick (self, event): self.addPoint(Point(event.x, event.y))
  
  def addPoint(self, point):
    points.append(point)
    self.create_text(point.x - 0, point.y - 0, text = "+")
    # Phenotypes have changed, because there is one point more !
    self.recomputephenotypes()
    
  def generation(self, nb = 1):
    self.organisms = lifecycle.run(self.organisms, 1, nb, 40, 15)
    
  def update(self):
    if self.line: self.delete(self.line)
    
    best          = self.organisms[0]
    a, b, c, d, e = best.square_args
    
    # Draw the equation found.
    def y(x):
      return (x, equation(a, b, c, d, e, x))
      try:
        return (x, equation(a, b, c, d, e, x))
      except:
        return None
    xy = map(y, range(0, SIZE, 5))
    xy = filter(None, xy)
    self.line = self.create_line(*xy)
    

class GraphFrame(Tkinter.Tk):
  def __init__(self):
    Tkinter.Tk.__init__(self, className = "genetic graph")
    Tkinter.Label(self, text = "Click some points below, then run 1 or 10 generations !\nI will genetically compute the equation of the curve that pass by your point !", wraplength = SIZE + 30).pack()
    self.graph = Graph(self)
    self.graph.pack()
    Tkinter.Button(self, text = "1   generation" , command = self.generation1  ).pack()
    Tkinter.Button(self, text = "10  generations", command = self.generation10 ).pack()
        
  def generation1(self, event = None):
    self.graph.generation(1)
    self.graph.update()
        
  def generation10(self, event = None):
    self.graph.generation(10)
    self.graph.update()
    

graphframe = GraphFrame()
Tkinter.mainloop()
