static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2010 Michael Muré <batolettre@gmail.com>                        \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_pointer (buffer, _(\"Cache buffer\"),                                \n"
"                  _(\"The GeglBuffer where the caching is done\"))            \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_C_SOURCE buffer-cache.c                                       \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglProperties   *o = GEGL_PROPERTIES (operation);                          \n"
"                                                                              \n"
"  if (o->buffer)                                                              \n"
"    return *gegl_buffer_get_extent (GEGL_BUFFER (o->buffer));                 \n"
"  else                                                                        \n"
"    return *gegl_operation_source_get_bounding_box (operation, \"input\");    \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties           *o = GEGL_PROPERTIES (operation);                  \n"
"                                                                              \n"
"  if (!o->buffer)                                                             \n"
"    {                                                                         \n"
"      o->buffer = gegl_buffer_dup (input);                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  output = gegl_buffer_dup (o->buffer);                                       \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"dispose (GObject *object)                                                     \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (object);                               \n"
"                                                                              \n"
"  if (o->buffer)                                                              \n"
"    {                                                                         \n"
"      g_object_unref (o->buffer);                                             \n"
"      o->buffer = NULL;                                                       \n"
"    }                                                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->dispose (object);                    \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass         *operation_class;                                \n"
"  GeglOperationFilterClass   *filter_class;                                   \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"                                                                              \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"  filter_class->process = process;                                            \n"
"                                                                              \n"
"  G_OBJECT_CLASS (klass)->dispose = dispose;                                  \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\"        , \"gegl:buffer-cache\",                                  \n"
"    \"categories\"  , \"core\",                                               \n"
"    \"description\" , _(\"Cache the input buffer internally, further process take this buffer as input.\"),\n"
"    NULL);                                                                    \n"
"                                                                              \n"
"}                                                                             \n"
"#endif                                                                        \n"
;
