#include <complex.h>

/* Model an issue from the fftw3.h header, seen while compiling ITK: 
 * https://buildd.debian.org/status/fetch.php?pkg=wrapitk-python&arch=i386&ver=3.20.1.2&stamp=1323582679
 *
 * Issue raised on GCCXML mailing list: http://www.gccxml.org/pipermail/gccxml/2011-December/001467.html
 */

int main(int ac, char* av[])
{
    /* Modeled on code in fftw3.h, from about line 370 */

/* __float128 (quad precision) is a gcc extension on i386, x86_64, and ia64
   for gcc >= 4.6 (compiled in FFTW with --enable-quad-precision) */

#if (__GNUC__ > 4 || (__GNUC__ == 4 && __GNUC_MINOR__ >= 6)) \
 && (defined(__i386__) || defined(__x86_64__) || defined(__ia64__))
    typedef __float128 quadcomplex[2];
    //    typedef __float128 _Complex quadcomplexC99;
#endif

    return 0;
}
