/**************************************************************************\
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
	Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#ifndef GATOS_CHANNELS_H
#define GATOS_CHANNELS_H 1

#ifdef __cplusplus
extern "C" { 
#endif

#define MAX_CHANNELS	512
#define MAX_CHANNEL_LEN 64

#define CHANNEL_SKIP	1

struct gatos_ChannelInfo {
  double frequency ;
  char name[MAX_CHANNEL_LEN] ;
  int mod_volume ;
  int mod_brightness ;
  int mod_saturation ;
  int mod_contrast ;
  int mod_hue ;
  int flags ;
} ;

int	chan_init(void) ;
void	chan_clearchans() ;
void	chan_delchan(int c) ;
int	chan_addchan(double, char*) ;
int	chan_setname(int, char *) ;
char*	chan_name(int) ;
double	chan_setfreq(int, double) ;
double	chan_freq(int) ;
int     chan_volume(int) ;
int     chan_setvolume(int, int) ;
int     chan_brightness(int) ;
int     chan_setbrightness(int, int) ;
int     chan_contrast(int) ;
int     chan_setcontrast(int, int) ;
int     chan_hue(int) ;
int     chan_sethue(int, int) ;
int     chan_saturation(int) ;
int     chan_setsaturation(int, int) ;
int	chan_setflag(int, int) ;
int	chan_setflags(int, int) ;
int	chan_clearflag(int, int) ;
int	chan_flag(int, int) ;
int	chan_flags(int) ;

#ifdef __cplusplus
}
#endif

#endif
