/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.modelingwizard.gui;

import com.modeliosoft.modelio.modelingwizard.utils.ModelingWizardDlg;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InputDialog {
    protected String name = "";
    protected Text text;
    protected Shell shell;

    public InputDialog(Shell parent, String label, String title, String value) {
        this.createContents(parent, label, title, value);
    }

    private void createContents(Shell parent, String label, String title, String value) {
        this.shell = new Shell(parent, 2144);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setText(title);
        Label nameLabel = new Label((Composite)this.shell, 0);
        nameLabel.setAlignment(0x1000000);
        FormData fd_nameLabel = new FormData();
        fd_nameLabel.right = new FormAttachment(100, -5);
        fd_nameLabel.left = new FormAttachment(0, 5);
        fd_nameLabel.top = new FormAttachment(0, 5);
        fd_nameLabel.bottom = new FormAttachment(0, 25);
        nameLabel.setLayoutData((Object)fd_nameLabel);
        nameLabel.setText(label);
        Composite buttons = this.createButtons();
        this.text = new Text((Composite)this.shell, 2048);
        FormData fd_text = new FormData();
        fd_text.bottom = new FormAttachment((Control)buttons, 0);
        fd_text.right = new FormAttachment((Control)nameLabel, 0, 131072);
        fd_text.top = new FormAttachment((Control)nameLabel, 0, 1024);
        fd_text.left = new FormAttachment((Control)nameLabel, 0, 16384);
        this.text.setText(value);
        this.text.setLayoutData((Object)fd_text);
        this.shell.pack();
        this.shell.setSize(this.shell.getSize().x + 20, this.shell.getSize().y);
    }

    private Composite createButtons() {
        Composite composite = new Composite((Composite)this.shell, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.justify = true;
        composite.setLayout((Layout)rowLayout);
        FormData fd_composite_1 = new FormData();
        fd_composite_1.left = new FormAttachment(0, 5);
        fd_composite_1.bottom = new FormAttachment(100, 0);
        fd_composite_1.right = new FormAttachment(100, -5);
        composite.setLayoutData((Object)fd_composite_1);
        Composite composite_2 = new Composite(composite, 0);
        composite_2.setLayout((Layout)new FillLayout());
        Button okButton = new Button(composite_2, 0);
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    InputDialog.this.name = InputDialog.this.text.getText();
                }
                catch (Exception e) {
                    InputDialog.this.name = "";
                }
                InputDialog.this.dispose();
            }
        });
        okButton.setText(ModelingWizardDlg.getString("mdac.gui.ok"));
        Button cancelButton = new Button(composite_2, 0);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                InputDialog.this.name = "";
                InputDialog.this.dispose();
            }
        });
        cancelButton.setText(ModelingWizardDlg.getString("mdac.gui.cancel"));
        return composite;
    }

    public static String showInputDialog(Shell parent, String label, String title, String value) {
        InputDialog diag = new InputDialog(parent, label, title, value);
        return diag.choose();
    }

    private String choose() {
        Display display = Display.getDefault();
        this.centerOnPrimaryScreen(this.shell, display);
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.name;
    }

    protected void dispose() {
        this.shell.dispose();
    }

    private void centerOnPrimaryScreen(Shell parentShell, Display display) {
        Monitor primary = display.getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = parentShell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        parentShell.setLocation(x, y);
    }
}

