// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Collections.Generic;

static class SveTests
{
    public static (string templateFileName, Dictionary<string, string> templateData)[] SveInputs =
    {
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_Abs_float",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Abs",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                                                                       ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "-TestLibrary.Generator.GetSingle()",                                                                                                                                                     ["ValidateIterResult"] = "Helpers.Abs(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.Abs(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_Abs_double",                                                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Abs",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                                                                       ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "-TestLibrary.Generator.GetDouble()",                                                                                                                                                     ["ValidateIterResult"] = "Helpers.Abs(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.Abs(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_Abs_sbyte",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Abs",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                                                                        ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "(sbyte)-TestLibrary.Generator.GetSByte()",                                                                                                                                               ["ValidateIterResult"] = "Helpers.Abs(firstOp[i]) != result[i]", ["GetIterResult"] = "(sbyte)Helpers.Abs(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_Abs_short",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Abs",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                                                                        ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "(short)-TestLibrary.Generator.GetInt16()",                                                                                                                                               ["ValidateIterResult"] = "Helpers.Abs(firstOp[i]) != result[i]", ["GetIterResult"] = "(short)Helpers.Abs(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_Abs_int",                                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Abs",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                                                                        ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "-TestLibrary.Generator.GetInt32()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.Abs(firstOp[i]) != result[i]", ["GetIterResult"] = "(int)Helpers.Abs(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_Abs_long",                                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Abs",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                                                                        ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "-TestLibrary.Generator.GetInt64()",                                                                                                                                                      ["ValidateIterResult"] = "(long)Helpers.Abs(firstOp[i]) != (long)result[i]", ["GetIterResult"] = "(long)Helpers.Abs(leftOp[i])"}),

        ("SveVecBinRetMaskOpConvertTest.template",      new Dictionary<string, string> {["TestName"] = "Sve_AbsoluteCompareGreaterThan_float",                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AbsoluteCompareGreaterThan",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "Helpers.SveAbsoluteCompareGreaterThan(left[i], right[i]) != result[i]",                 ["GetIterResult"] = "Helpers.SveAbsoluteCompareGreaterThan(leftOp[i], rightOp[i])", ["ConvertFunc"] = "BitConverter.SingleToInt32Bits"}),
        ("SveVecBinRetMaskOpConvertTest.template",      new Dictionary<string, string> {["TestName"] = "Sve_AbsoluteCompareGreaterThan_double",                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AbsoluteCompareGreaterThan",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                       ["ValidateIterResult"] = "Helpers.SveAbsoluteCompareGreaterThan(left[i], right[i]) != result[i]",                 ["GetIterResult"] = "Helpers.SveAbsoluteCompareGreaterThan(leftOp[i], rightOp[i])", ["ConvertFunc"] = "BitConverter.DoubleToInt64Bits"}),
        ("SveVecBinRetMaskOpConvertTest.template",      new Dictionary<string, string> {["TestName"] = "Sve_AbsoluteCompareGreaterThanOrEqual_float",                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AbsoluteCompareGreaterThanOrEqual",                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "Helpers.SveAbsoluteCompareGreaterThanOrEqual(left[i], right[i]) != result[i]",          ["GetIterResult"] = "Helpers.SveAbsoluteCompareGreaterThanOrEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",      new Dictionary<string, string> {["TestName"] = "Sve_AbsoluteCompareGreaterThanOrEqual_double",                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AbsoluteCompareGreaterThanOrEqual",                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                       ["ValidateIterResult"] = "Helpers.SveAbsoluteCompareGreaterThanOrEqual(left[i], right[i]) != result[i]",          ["GetIterResult"] = "Helpers.SveAbsoluteCompareGreaterThanOrEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",      new Dictionary<string, string> {["TestName"] = "Sve_AbsoluteCompareLessThan_float",                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AbsoluteCompareLessThan",                                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "Helpers.SveAbsoluteCompareLessThan(left[i], right[i]) != result[i]",                    ["GetIterResult"] = "Helpers.SveAbsoluteCompareLessThan(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",      new Dictionary<string, string> {["TestName"] = "Sve_AbsoluteCompareLessThan_double",                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AbsoluteCompareLessThan",                                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                       ["ValidateIterResult"] = "Helpers.SveAbsoluteCompareLessThan(left[i], right[i]) != result[i]",                    ["GetIterResult"] = "Helpers.SveAbsoluteCompareLessThan(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",      new Dictionary<string, string> {["TestName"] = "Sve_AbsoluteCompareLessThanOrEqual_float",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AbsoluteCompareLessThanOrEqual",                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "Helpers.SveAbsoluteCompareLessThanOrEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveAbsoluteCompareLessThanOrEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",      new Dictionary<string, string> {["TestName"] = "Sve_AbsoluteCompareLessThanOrEqual_double",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AbsoluteCompareLessThanOrEqual",                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                       ["ValidateIterResult"] = "Helpers.SveAbsoluteCompareLessThanOrEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveAbsoluteCompareLessThanOrEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),

        ("SveVecBinOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_AbsoluteDifference_float",                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AbsoluteDifference",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",       ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                        ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.AbsoluteDifference(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])",        ["GetIterResult"] = "Helpers.AbsoluteDifference(left[i], right[i])", ["ConvertFunc"] = "BitConverter.SingleToInt32Bits"}),
        ("SveVecBinOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_AbsoluteDifference_double",                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AbsoluteDifference",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",       ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                        ["ValidateIterResult"] = "BitConverter.DoubleToInt64Bits(Helpers.AbsoluteDifference(left[i], right[i])) != BitConverter.DoubleToInt64Bits(result[i])",        ["GetIterResult"] = "Helpers.AbsoluteDifference(left[i], right[i])", ["ConvertFunc"] = "BitConverter.DoubleToInt64Bits"}),
        ("SveVecBinOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_AbsoluteDifference_sbyte",                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AbsoluteDifference",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "(sbyte)TestLibrary.Generator.GetSByte()", ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                         ["ValidateIterResult"] = "Helpers.AbsoluteDifference(left[i], right[i]) != result[i]",        ["GetIterResult"] = "(sbyte)Helpers.AbsoluteDifference(left[i], right[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_AbsoluteDifference_short",                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AbsoluteDifference",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "(short)TestLibrary.Generator.GetInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                         ["ValidateIterResult"] = "Helpers.AbsoluteDifference(left[i], right[i]) != result[i]",        ["GetIterResult"] = "(short)Helpers.AbsoluteDifference(left[i], right[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_AbsoluteDifference_int",                                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AbsoluteDifference",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                         ["ValidateIterResult"] = "Helpers.AbsoluteDifference(left[i], right[i]) != result[i]",        ["GetIterResult"] = "(int)Helpers.AbsoluteDifference(left[i], right[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_AbsoluteDifference_long",                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AbsoluteDifference",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                         ["ValidateIterResult"] = "Helpers.AbsoluteDifference(left[i], right[i]) != result[i]",        ["GetIterResult"] = "(long)Helpers.AbsoluteDifference(left[i], right[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_AbsoluteDifference_byte",                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AbsoluteDifference",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "(byte)TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                          ["ValidateIterResult"] = "Helpers.AbsoluteDifference(left[i], right[i]) != result[i]",        ["GetIterResult"] = "(byte)Helpers.AbsoluteDifference(left[i], right[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_AbsoluteDifference_ushort",                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AbsoluteDifference",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.AbsoluteDifference(left[i], right[i]) != result[i]",        ["GetIterResult"] = "(ushort)Helpers.AbsoluteDifference(left[i], right[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_AbsoluteDifference_uint",                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AbsoluteDifference",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.AbsoluteDifference(left[i], right[i]) != result[i]",        ["GetIterResult"] = "(uint)Helpers.AbsoluteDifference(left[i], right[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_AbsoluteDifference_ulong",                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AbsoluteDifference",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                        ["ValidateIterResult"] = "Helpers.AbsoluteDifference(left[i], right[i]) != result[i]",        ["GetIterResult"] = "(UInt64)Helpers.AbsoluteDifference(left[i], right[i])", ["ConvertFunc"] = ""}),

        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Add_float",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Add",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",       ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                        ["ValidateIterResult"] = "Helpers.Add(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.Add(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Add_double",                                                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Add",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",       ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                        ["ValidateIterResult"] = "Helpers.Add(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.Add(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Add_sbyte",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Add",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "(sbyte)TestLibrary.Generator.GetSByte()", ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                         ["ValidateIterResult"] = "Helpers.Add(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.Add(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Add_short",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Add",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "(short)TestLibrary.Generator.GetInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                         ["ValidateIterResult"] = "Helpers.Add(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.Add(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Add_int",                                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Add",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                         ["ValidateIterResult"] = "Helpers.Add(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.Add(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Add_long",                                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Add",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                         ["ValidateIterResult"] = "Helpers.Add(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.Add(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Add_byte",                                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Add",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "(byte)TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                          ["ValidateIterResult"] = "Helpers.Add(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.Add(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Add_ushort",                                                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Add",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.Add(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.Add(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Add_uint",                                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Add",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.Add(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.Add(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Add_ulong",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Add",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                        ["ValidateIterResult"] = "Helpers.Add(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.Add(left[i], right[i])"}),

        ("SveVecReduceUnOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_AddAcross_float",                                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AddAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateReduceOpResult"] = "Helpers.AddAcrossRecursivePairwise(firstOp) != result[0]",                                                                                                          ["ValidateRemainingResults"] = "result[i] != 0.0"}),
        ("SveVecReduceUnOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_AddAcross_double",                                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AddAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                                                      ["ValidateReduceOpResult"] = "Helpers.AddAcrossRecursivePairwise(firstOp) != result[0]",                                                                                                          ["ValidateRemainingResults"] = "result[i] != 0.0"}),
        ("SveVecReduceUnOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_AddAcross_long_sbyte",                                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AddAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                                                       ["ValidateReduceOpResult"] = "Helpers.AddAcrossWideningLong(firstOp) != result[0]",                                                                                                               ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_AddAcross_long_short",                                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AddAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                       ["ValidateReduceOpResult"] = "Helpers.AddAcrossWideningLong(firstOp) != result[0]",                                                                                                               ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_AddAcross_long_int",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AddAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateReduceOpResult"] = "Helpers.AddAcrossWidening(firstOp) != result[0]",                                                                                                                   ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_AddAcross_long",                                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AddAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                                                       ["ValidateReduceOpResult"] = "Helpers.AddAcross(firstOp) != result[0]",                                                                                                                           ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_AddAcross_ulong_byte",                                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AddAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                                                        ["ValidateReduceOpResult"] = "Helpers.AddAcrossWideningULong(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_AddAcross_ulong_ushort",                                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AddAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                                                      ["ValidateReduceOpResult"] = "Helpers.AddAcrossWideningULong(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_AddAcross_ulong_uint",                                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AddAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                                      ["ValidateReduceOpResult"] = "Helpers.AddAcrossWidening(firstOp) != result[0]",                                                                                                                   ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_AddAcross_ulong",                                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AddAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                                                      ["ValidateReduceOpResult"] = "Helpers.AddAcross(firstOp) != result[0]",                                                                                                                           ["ValidateRemainingResults"] = "result[i] != 0"}),

        ("SveVecImmBinOpVecTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_AddRotateComplex_float_0",                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AddRotateComplex",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm"] = "0", ["InvalidImm"] = "2",                   ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.AddRotateComplex(firstOp, secondOp, Imm))", ["GetVectorResult"] = "Helpers.AddRotateComplex(first, second, Imm)"}),
        ("SveVecImmBinOpVecTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_AddRotateComplex_float_1",                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AddRotateComplex",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm"] = "1", ["InvalidImm"] = "2",                   ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.AddRotateComplex(firstOp, secondOp, Imm))", ["GetVectorResult"] = "Helpers.AddRotateComplex(first, second, Imm)"}),
        ("SveVecImmBinOpVecTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_AddRotateComplex_double_0",                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AddRotateComplex",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueMask"] = "Helpers.getMaskDouble()", ["Imm"] = "0", ["InvalidImm"] = "2",                   ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.AddRotateComplex(firstOp, secondOp, Imm))", ["GetVectorResult"] = "Helpers.AddRotateComplex(first, second, Imm)"}),
        ("SveVecImmBinOpVecTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_AddRotateComplex_double_1",                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AddRotateComplex",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueMask"] = "Helpers.getMaskDouble()", ["Imm"] = "1", ["InvalidImm"] = "2",                   ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.AddRotateComplex(firstOp, secondOp, Imm))", ["GetVectorResult"] = "Helpers.AddRotateComplex(first, second, Imm)"}),

        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_AddSaturate_sbyte",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AddSaturate",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "(sbyte)TestLibrary.Generator.GetSByte()", ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                         ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.AddSaturate(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_AddSaturate_short",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AddSaturate",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "(short)TestLibrary.Generator.GetInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                         ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.AddSaturate(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_AddSaturate_int",                                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AddSaturate",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                         ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.AddSaturate(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_AddSaturate_long",                                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AddSaturate",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                         ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.AddSaturate(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_AddSaturate_byte",                                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AddSaturate",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "(byte)TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                          ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.AddSaturate(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_AddSaturate_ushort",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AddSaturate",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.AddSaturate(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_AddSaturate_uint",                                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AddSaturate",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.AddSaturate(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_AddSaturate_ulong",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AddSaturate",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                        ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.AddSaturate(left[i], right[i])"}),

        ("SveVecBinOpTestScalarRet.template", new Dictionary<string, string> { ["TestName"] = "Sve_AddSequentialAcross_float",                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AddSequentialAcross",                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskSingle()",                  ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                        ["ValidateScalarResult"] = "result[0] != Helpers.AddSequentialAcross(left, right)"}),
        ("SveVecBinOpTestScalarRet.template", new Dictionary<string, string> { ["TestName"] = "Sve_AddSequentialAcross_double",                                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AddSequentialAcross",                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskDouble()",                  ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                        ["ValidateScalarResult"] = "result[0] != Helpers.AddSequentialAcross(left, right)"}),

        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_And_sbyte",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "And",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "(sbyte)TestLibrary.Generator.GetSByte()", ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                         ["ValidateIterResult"] = "Helpers.And(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.And(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_And_short",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "And",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "(short)TestLibrary.Generator.GetInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                         ["ValidateIterResult"] = "Helpers.And(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.And(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_And_int",                                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "And",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                         ["ValidateIterResult"] = "Helpers.And(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.And(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_And_long",                                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "And",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                         ["ValidateIterResult"] = "Helpers.And(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.And(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_And_byte",                                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "And",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "(byte)TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                          ["ValidateIterResult"] = "Helpers.And(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.And(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_And_ushort",                                                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "And",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.And(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.And(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_And_uint",                                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "And",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.And(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.And(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_And_ulong",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "And",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                        ["ValidateIterResult"] = "Helpers.And(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.And(left[i], right[i])"}),

        ("SveVecReduceUnOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_AndAcross_sbyte",                                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AndAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                                                       ["ValidateReduceOpResult"] = "Helpers.AndAcross(firstOp) != result[0]",                                                                                                                           ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_AndAcross_short",                                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AndAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                       ["ValidateReduceOpResult"] = "Helpers.AndAcross(firstOp) != result[0]",                                                                                                                           ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_AndAcross_int",                                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AndAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateReduceOpResult"] = "Helpers.AndAcross(firstOp) != result[0]",                                                                                                                           ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_AndAcross_long",                                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AndAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                                                       ["ValidateReduceOpResult"] = "Helpers.AndAcross(firstOp) != result[0]",                                                                                                                           ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_AndAcross_byte",                                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AndAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                                                        ["ValidateReduceOpResult"] = "Helpers.AndAcross(firstOp) != result[0]",                                                                                                                           ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_AndAcross_ushort",                                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AndAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                                                      ["ValidateReduceOpResult"] = "Helpers.AndAcross(firstOp) != result[0]",                                                                                                                           ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_AndAcross_uint",                                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AndAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                                      ["ValidateReduceOpResult"] = "Helpers.AndAcross(firstOp) != result[0]",                                                                                                                           ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_AndAcross_ulong",                                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "AndAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                                                      ["ValidateReduceOpResult"] = "Helpers.AndAcross(firstOp) != result[0]",                                                                                                                           ["ValidateRemainingResults"] = "result[i] != 0"}),

        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_BitwiseClear_sbyte",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "BitwiseClear",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "(sbyte)TestLibrary.Generator.GetSByte()", ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                         ["ValidateIterResult"] = "Helpers.BitwiseClear(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.BitwiseClear(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_BitwiseClear_short",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "BitwiseClear",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "(short)TestLibrary.Generator.GetInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                         ["ValidateIterResult"] = "Helpers.BitwiseClear(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.BitwiseClear(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_BitwiseClear_int",                                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "BitwiseClear",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                         ["ValidateIterResult"] = "Helpers.BitwiseClear(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.BitwiseClear(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_BitwiseClear_long",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "BitwiseClear",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                         ["ValidateIterResult"] = "Helpers.BitwiseClear(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.BitwiseClear(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_BitwiseClear_byte",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "BitwiseClear",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "(byte)TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                          ["ValidateIterResult"] = "Helpers.BitwiseClear(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.BitwiseClear(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_BitwiseClear_ushort",                                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "BitwiseClear",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.BitwiseClear(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.BitwiseClear(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_BitwiseClear_uint",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "BitwiseClear",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.BitwiseClear(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.BitwiseClear(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_BitwiseClear_ulong",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "BitwiseClear",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                        ["ValidateIterResult"] = "Helpers.BitwiseClear(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.BitwiseClear(left[i], right[i])"}),

        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_BooleanNot_sbyte",                                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "BooleanNot",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.BooleanNot(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.BooleanNot(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_BooleanNot_short",                                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "BooleanNot",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.BooleanNot(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.BooleanNot(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_BooleanNot_int",                                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "BooleanNot",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.BooleanNot(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.BooleanNot(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_BooleanNot_long",                                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "BooleanNot",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                                                                                                            ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.BooleanNot(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.BooleanNot(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_BooleanNot_byte",                                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "BooleanNot",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                                                        ["ValidateIterResult"] = "Helpers.BooleanNot(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.BooleanNot(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_BooleanNot_ushort",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "BooleanNot",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.BooleanNot(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.BooleanNot(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_BooleanNot_uint",                                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "BooleanNot",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.BooleanNot(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.BooleanNot(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_BooleanNot_ulong",                                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "BooleanNot",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                                                                                                           ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.BooleanNot(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.BooleanNot(leftOp[i])"}),

        ("SveVecBinOpVecTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_Compact_float",                                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Compact",                                                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.Compact(left, right))", ["GetVectorResult"] = "Helpers.Compact(left, right)",}),
        ("SveVecBinOpVecTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_Compact_double",                                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Compact",                                                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                       ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.Compact(left, right))", ["GetVectorResult"] = "Helpers.Compact(left, right)",}),
        ("SveVecBinOpVecTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_Compact_int",                                                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Compact",                                                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.Compact(left, right))", ["GetVectorResult"] = "Helpers.Compact(left, right)",}),
        ("SveVecBinOpVecTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_Compact_long",                                                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Compact",                                                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.Compact(left, right))", ["GetVectorResult"] = "Helpers.Compact(left, right)",}),
        ("SveVecBinOpVecTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_Compact_uint",                                                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Compact",                                                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.Compact(left, right))", ["GetVectorResult"] = "Helpers.Compact(left, right)",}),
        ("SveVecBinOpVecTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_Compact_ulong",                                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Compact",                                                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.Compact(left, right))", ["GetVectorResult"] = "Helpers.Compact(left, right)",}),

        ("SveVecBinRetMaskOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CompareEqual_float",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareEqual",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = "BitConverter.SingleToInt32Bits"}),
        ("SveVecBinRetMaskOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CompareEqual_double",                                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareEqual",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = "BitConverter.DoubleToInt64Bits"}),
        ("SveVecBinRetMaskOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CompareEqual_sbyte",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareEqual",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.SveCompareEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CompareEqual_short",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareEqual",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.SveCompareEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CompareEqual_int",                                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareEqual",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.SveCompareEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CompareEqual_long",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareEqual",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ValidateIterResult"] = "Helpers.SveCompareEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CompareEqual_byte",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareEqual",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.SveCompareEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CompareEqual_ushort",                                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareEqual",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CompareEqual_uint",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareEqual",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CompareEqual_ulong",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareEqual",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),

        ("SveVecBinRetMaskOpConvertTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_CompareGreaterThan_float",                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareGreaterThan",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareGreaterThan(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareGreaterThan(leftOp[i], rightOp[i])", ["ConvertFunc"] = "BitConverter.SingleToInt32Bits"}),
        ("SveVecBinRetMaskOpConvertTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_CompareGreaterThan_double",                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareGreaterThan",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareGreaterThan(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareGreaterThan(leftOp[i], rightOp[i])", ["ConvertFunc"] = "BitConverter.DoubleToInt64Bits"}),
        ("SveVecBinRetMaskOpConvertTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_CompareGreaterThan_sbyte",                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareGreaterThan",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.SveCompareGreaterThan(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareGreaterThan(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_CompareGreaterThan_short",                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareGreaterThan",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.SveCompareGreaterThan(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareGreaterThan(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_CompareGreaterThan_int",                                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareGreaterThan",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.SveCompareGreaterThan(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareGreaterThan(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_CompareGreaterThan_long",                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareGreaterThan",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ValidateIterResult"] = "Helpers.SveCompareGreaterThan(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareGreaterThan(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_CompareGreaterThan_byte",                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareGreaterThan",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.SveCompareGreaterThan(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareGreaterThan(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_CompareGreaterThan_ushort",                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareGreaterThan",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareGreaterThan(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareGreaterThan(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_CompareGreaterThan_uint",                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareGreaterThan",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareGreaterThan(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareGreaterThan(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_CompareGreaterThan_ulong",                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareGreaterThan",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareGreaterThan(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareGreaterThan(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),

        ("SveVecBinRetMaskOpConvertTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CompareGreaterThanOrEqual_float",                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareGreaterThanOrEqual",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareGreaterThanOrEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareGreaterThanOrEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = "BitConverter.SingleToInt32Bits"}),
        ("SveVecBinRetMaskOpConvertTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CompareGreaterThanOrEqual_double",                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareGreaterThanOrEqual",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareGreaterThanOrEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareGreaterThanOrEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = "BitConverter.DoubleToInt64Bits"}),
        ("SveVecBinRetMaskOpConvertTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CompareGreaterThanOrEqual_sbyte",                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareGreaterThanOrEqual",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.SveCompareGreaterThanOrEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareGreaterThanOrEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CompareGreaterThanOrEqual_short",                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareGreaterThanOrEqual",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.SveCompareGreaterThanOrEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareGreaterThanOrEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CompareGreaterThanOrEqual_int",                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareGreaterThanOrEqual",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.SveCompareGreaterThanOrEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareGreaterThanOrEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CompareGreaterThanOrEqual_long",                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareGreaterThanOrEqual",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ValidateIterResult"] = "Helpers.SveCompareGreaterThanOrEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareGreaterThanOrEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CompareGreaterThanOrEqual_byte",                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareGreaterThanOrEqual",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.SveCompareGreaterThanOrEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareGreaterThanOrEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CompareGreaterThanOrEqual_ushort",                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareGreaterThanOrEqual",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareGreaterThanOrEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareGreaterThanOrEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CompareGreaterThanOrEqual_uint",                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareGreaterThanOrEqual",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareGreaterThanOrEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareGreaterThanOrEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CompareGreaterThanOrEqual_ulong",                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareGreaterThanOrEqual",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareGreaterThanOrEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareGreaterThanOrEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),

        ("SveVecBinRetMaskOpConvertTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_CompareLessThan_float",                                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareLessThan",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareLessThan(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareLessThan(leftOp[i], rightOp[i])", ["ConvertFunc"] = "BitConverter.SingleToInt32Bits"}),
        ("SveVecBinRetMaskOpConvertTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_CompareLessThan_double",                                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareLessThan",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareLessThan(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareLessThan(leftOp[i], rightOp[i])", ["ConvertFunc"] = "BitConverter.DoubleToInt64Bits"}),
        ("SveVecBinRetMaskOpConvertTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_CompareLessThan_sbyte",                                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareLessThan",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.SveCompareLessThan(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareLessThan(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_CompareLessThan_short",                                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareLessThan",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.SveCompareLessThan(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareLessThan(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_CompareLessThan_int",                                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareLessThan",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.SveCompareLessThan(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareLessThan(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_CompareLessThan_long",                                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareLessThan",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ValidateIterResult"] = "Helpers.SveCompareLessThan(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareLessThan(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_CompareLessThan_byte",                                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareLessThan",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.SveCompareLessThan(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareLessThan(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_CompareLessThan_ushort",                                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareLessThan",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareLessThan(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareLessThan(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_CompareLessThan_uint",                                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareLessThan",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareLessThan(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareLessThan(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_CompareLessThan_ulong",                                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareLessThan",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareLessThan(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareLessThan(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),

        ("SveVecBinRetMaskOpConvertTest.template",new Dictionary<string, string> { ["TestName"] = "Sve_CompareLessThanOrEqual_float",                                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareLessThanOrEqual",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareLessThanOrEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareLessThanOrEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = "BitConverter.SingleToInt32Bits"}),
        ("SveVecBinRetMaskOpConvertTest.template",new Dictionary<string, string> { ["TestName"] = "Sve_CompareLessThanOrEqual_double",                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareLessThanOrEqual",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareLessThanOrEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareLessThanOrEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = "BitConverter.DoubleToInt64Bits"}),
        ("SveVecBinRetMaskOpConvertTest.template",new Dictionary<string, string> { ["TestName"] = "Sve_CompareLessThanOrEqual_sbyte",                                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareLessThanOrEqual",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.SveCompareLessThanOrEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareLessThanOrEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",new Dictionary<string, string> { ["TestName"] = "Sve_CompareLessThanOrEqual_short",                                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareLessThanOrEqual",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.SveCompareLessThanOrEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareLessThanOrEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",new Dictionary<string, string> { ["TestName"] = "Sve_CompareLessThanOrEqual_int",                                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareLessThanOrEqual",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.SveCompareLessThanOrEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareLessThanOrEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",new Dictionary<string, string> { ["TestName"] = "Sve_CompareLessThanOrEqual_long",                                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareLessThanOrEqual",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ValidateIterResult"] = "Helpers.SveCompareLessThanOrEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareLessThanOrEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",new Dictionary<string, string> { ["TestName"] = "Sve_CompareLessThanOrEqual_byte",                                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareLessThanOrEqual",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.SveCompareLessThanOrEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareLessThanOrEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",new Dictionary<string, string> { ["TestName"] = "Sve_CompareLessThanOrEqual_ushort",                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareLessThanOrEqual",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareLessThanOrEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareLessThanOrEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",new Dictionary<string, string> { ["TestName"] = "Sve_CompareLessThanOrEqual_uint",                                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareLessThanOrEqual",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareLessThanOrEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareLessThanOrEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",new Dictionary<string, string> { ["TestName"] = "Sve_CompareLessThanOrEqual_ulong",                                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareLessThanOrEqual",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareLessThanOrEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareLessThanOrEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),

        ("SveVecBinRetMaskOpConvertTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_CompareNotEqualTo_float",                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareNotEqualTo",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareNotEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareNotEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = "BitConverter.SingleToInt32Bits"}),
        ("SveVecBinRetMaskOpConvertTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_CompareNotEqualTo_double",                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareNotEqualTo",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareNotEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareNotEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = "BitConverter.DoubleToInt64Bits"}),
        ("SveVecBinRetMaskOpConvertTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_CompareNotEqualTo_sbyte",                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareNotEqualTo",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.SveCompareNotEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareNotEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_CompareNotEqualTo_short",                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareNotEqualTo",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.SveCompareNotEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareNotEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_CompareNotEqualTo_int",                                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareNotEqualTo",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.SveCompareNotEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareNotEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_CompareNotEqualTo_long",                                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareNotEqualTo",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ValidateIterResult"] = "Helpers.SveCompareNotEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareNotEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_CompareNotEqualTo_byte",                                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareNotEqualTo",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.SveCompareNotEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareNotEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_CompareNotEqualTo_ushort",                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareNotEqualTo",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareNotEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareNotEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_CompareNotEqualTo_uint",                                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareNotEqualTo",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareNotEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareNotEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecBinRetMaskOpConvertTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_CompareNotEqualTo_ulong",                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareNotEqualTo",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareNotEqual(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareNotEqual(leftOp[i], rightOp[i])", ["ConvertFunc"] = ""}),

        ("SveVecBinRetMaskOpConvertTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve_CompareUnordered_float",                                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareUnordered",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareUnordered(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareUnordered(leftOp[i], rightOp[i])", ["ConvertFunc"] = "BitConverter.SingleToInt32Bits"}),
        ("SveVecBinRetMaskOpConvertTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve_CompareUnordered_double",                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CompareUnordered",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                       ["ValidateIterResult"] = "Helpers.SveCompareUnordered(left[i], right[i]) != result[i]",             ["GetIterResult"] = "Helpers.SveCompareUnordered(leftOp[i], rightOp[i])", ["ConvertFunc"] = "BitConverter.DoubleToInt64Bits"}),

        ("SveMaskVecBinOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Compute16BitAddresses_uint_int",                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Compute16BitAddresses",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "(left[i] + ((uint)right[i] * 2)) != result[i]",  ["GetIterResult"] = "(left[i] + ((uint)right[i] * 2))"}),
        ("SveMaskVecBinOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Compute16BitAddresses_uint",                                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Compute16BitAddresses",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "(left[i] + (right[i] * 2)) != result[i]",        ["GetIterResult"] = "(left[i] + (right[i] * 2))"}),
        ("SveMaskVecBinOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Compute16BitAddresses_ulong_long",                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Compute16BitAddresses",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ValidateIterResult"] = "(left[i] + ((ulong)right[i] * 2)) != result[i]", ["GetIterResult"] = "(left[i] + ((ulong)right[i] * 2))"}),
        ("SveMaskVecBinOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Compute16BitAddresses_ulong",                                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Compute16BitAddresses",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ValidateIterResult"] = "(left[i] + (right[i] * 2)) != result[i]",        ["GetIterResult"] = "(left[i] + (right[i] * 2))"}),
        ("SveMaskVecBinOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Compute32BitAddresses_uint_int",                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Compute32BitAddresses",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "(left[i] + ((uint)right[i] * 4)) != result[i]",  ["GetIterResult"] = "(left[i] + ((uint)right[i] * 4))"}),
        ("SveMaskVecBinOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Compute32BitAddresses_uint",                                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Compute32BitAddresses",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "(left[i] + (right[i] * 4)) != result[i]",        ["GetIterResult"] = "(left[i] + (right[i] * 4))"}),
        ("SveMaskVecBinOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Compute32BitAddresses_ulong_long",                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Compute32BitAddresses",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ValidateIterResult"] = "(left[i] + ((ulong)right[i] * 4)) != result[i]", ["GetIterResult"] = "(left[i] + ((ulong)right[i] * 4))"}),
        ("SveMaskVecBinOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Compute32BitAddresses_ulong",                                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Compute32BitAddresses",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ValidateIterResult"] = "(left[i] + (right[i] * 4)) != result[i]",        ["GetIterResult"] = "(left[i] + (right[i] * 4))"}),
        ("SveMaskVecBinOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Compute64BitAddresses_uint_int",                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Compute64BitAddresses",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "(left[i] + ((uint)right[i] * 8)) != result[i]",  ["GetIterResult"] = "(left[i] + ((uint)right[i] * 8))"}),
        ("SveMaskVecBinOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Compute64BitAddresses_uint",                                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Compute64BitAddresses",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "(left[i] + (right[i] * 8)) != result[i]",        ["GetIterResult"] = "(left[i] + (right[i] * 8))"}),
        ("SveMaskVecBinOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Compute64BitAddresses_ulong_long",                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Compute64BitAddresses",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ValidateIterResult"] = "(left[i] + ((ulong)right[i] * 8)) != result[i]", ["GetIterResult"] = "(left[i] + ((ulong)right[i] * 8))"}),
        ("SveMaskVecBinOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Compute64BitAddresses_ulong",                                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Compute64BitAddresses",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ValidateIterResult"] = "(left[i] + (right[i] * 8)) != result[i]",        ["GetIterResult"] = "(left[i] + (right[i] * 8))"}),
        ("SveMaskVecBinOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Compute8BitAddresses_uint_int",                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Compute8BitAddresses",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "(left[i] + ((uint)right[i] * 1)) != result[i]",  ["GetIterResult"] = "(left[i] + ((uint)right[i] * 1))"}),
        ("SveMaskVecBinOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Compute8BitAddresses_uint",                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Compute8BitAddresses",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "(left[i] + (right[i] * 1)) != result[i]",        ["GetIterResult"] = "(left[i] + (right[i] * 1))"}),
        ("SveMaskVecBinOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Compute8BitAddresses_ulong_long",                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Compute8BitAddresses",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ValidateIterResult"] = "(left[i] + ((ulong)right[i] * 1)) != result[i]", ["GetIterResult"] = "(left[i] + ((ulong)right[i] * 1))"}),
        ("SveMaskVecBinOpConvertTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Compute8BitAddresses_ulong",                                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Compute8BitAddresses",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ValidateIterResult"] = "(left[i] + (right[i] * 1)) != result[i]",        ["GetIterResult"] = "(left[i] + (right[i] * 1))"}),

        ("SveConditionalSelect.template",     new Dictionary<string, string> { ["TestName"] = "Sve_ConditionalSelect_float",                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ConditionalSelect",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",       ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",                         ["ValidateIterResult"] = "(firstOp[i] != 0 ? (result[i] != secondOp[i]) : (result[i] != thirdOp[i]))",}),
        ("SveConditionalSelect.template",     new Dictionary<string, string> { ["TestName"] = "Sve_ConditionalSelect_double",                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ConditionalSelect",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Double", ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",       ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()",                         ["ValidateIterResult"] = "(firstOp[i] != 0 ? (result[i] != secondOp[i]) : (result[i] != thirdOp[i]))",}),
        ("SveConditionalSelect.template",     new Dictionary<string, string> { ["TestName"] = "Sve_ConditionalSelect_sbyte",                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ConditionalSelect",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                          ["ValidateIterResult"] = "(firstOp[i] != 0 ? (result[i] != secondOp[i]) : (result[i] != thirdOp[i]))",}),
        ("SveConditionalSelect.template",     new Dictionary<string, string> { ["TestName"] = "Sve_ConditionalSelect_short",                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ConditionalSelect",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                          ["ValidateIterResult"] = "(firstOp[i] != 0 ? (result[i] != secondOp[i]) : (result[i] != thirdOp[i]))",}),
        ("SveConditionalSelect.template",     new Dictionary<string, string> { ["TestName"] = "Sve_ConditionalSelect_int",                                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ConditionalSelect",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                          ["ValidateIterResult"] = "(firstOp[i] != 0 ? (result[i] != secondOp[i]) : (result[i] != thirdOp[i]))",}),
        ("SveConditionalSelect.template",     new Dictionary<string, string> { ["TestName"] = "Sve_ConditionalSelect_long",                                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ConditionalSelect",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                          ["ValidateIterResult"] = "(firstOp[i] != 0 ? (result[i] != secondOp[i]) : (result[i] != thirdOp[i]))",}),
        ("SveConditionalSelect.template",     new Dictionary<string, string> { ["TestName"] = "Sve_ConditionalSelect_byte",                                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ConditionalSelect",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                           ["ValidateIterResult"] = "(firstOp[i] != 0 ? (result[i] != secondOp[i]) : (result[i] != thirdOp[i]))",}),
        ("SveConditionalSelect.template",     new Dictionary<string, string> { ["TestName"] = "Sve_ConditionalSelect_ushort",                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ConditionalSelect",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                         ["ValidateIterResult"] = "(firstOp[i] != 0 ? (result[i] != secondOp[i]) : (result[i] != thirdOp[i]))",}),
        ("SveConditionalSelect.template",     new Dictionary<string, string> { ["TestName"] = "Sve_ConditionalSelect_uint",                                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ConditionalSelect",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                         ["ValidateIterResult"] = "(firstOp[i] != 0 ? (result[i] != secondOp[i]) : (result[i] != thirdOp[i]))",}),
        ("SveConditionalSelect.template",     new Dictionary<string, string> { ["TestName"] = "Sve_ConditionalSelect_ulong",                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ConditionalSelect",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                         ["ValidateIterResult"] = "(firstOp[i] != 0 ? (result[i] != secondOp[i]) : (result[i] != thirdOp[i]))",}),

        ("SveSimpleVecOpDiffRetTypeTestVec.template", new Dictionary<string, string> { ["TestName"] = "Sve_ConvertToDouble_double_float",                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ConvertToDouble",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.ConvertToDouble(firstOp))", ["GetVectorResult"] = "Helpers.ConvertToDouble(left)"}),
        ("SveSimpleVecOpDiffRetTypeTestVec.template", new Dictionary<string, string> { ["TestName"] = "Sve_ConvertToDouble_double_int",                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ConvertToDouble",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.ConvertToDouble(firstOp))", ["GetVectorResult"] = "Helpers.ConvertToDouble(left)"}),
        ("SveSimpleVecOpDiffRetTypeTestVec.template", new Dictionary<string, string> { ["TestName"] = "Sve_ConvertToDouble_double_long",                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ConvertToDouble",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                                                       ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.ConvertToDouble(firstOp))", ["GetVectorResult"] = "Helpers.ConvertToDouble(left)"}),
        ("SveSimpleVecOpDiffRetTypeTestVec.template", new Dictionary<string, string> { ["TestName"] = "Sve_ConvertToDouble_double_uint",                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ConvertToDouble",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                                      ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.ConvertToDouble(firstOp))", ["GetVectorResult"] = "Helpers.ConvertToDouble(left)"}),
        ("SveSimpleVecOpDiffRetTypeTestVec.template", new Dictionary<string, string> { ["TestName"] = "Sve_ConvertToDouble_double_ulong",                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ConvertToDouble",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                                                      ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.ConvertToDouble(firstOp))", ["GetVectorResult"] = "Helpers.ConvertToDouble(left)"}),
        ("SveSimpleVecOpDiffRetTypeTestVec.template", new Dictionary<string, string> { ["TestName"] = "Sve_ConvertToInt32_int_float",                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ConvertToInt32",                                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.ConvertToInt32(firstOp))",  ["GetVectorResult"] = "Helpers.ConvertToInt32(left)"}),
        ("SveSimpleVecOpDiffRetTypeTestVec.template", new Dictionary<string, string> { ["TestName"] = "Sve_ConvertToInt32_int_double",                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ConvertToInt32",                                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                                                      ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.ConvertToInt32(firstOp))",  ["GetVectorResult"] = "Helpers.ConvertToInt32(left)"}),
        ("SveSimpleVecOpDiffRetTypeTestVec.template", new Dictionary<string, string> { ["TestName"] = "Sve_ConvertToInt64_long_float",                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ConvertToInt64",                                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.ConvertToInt64(firstOp))",  ["GetVectorResult"] = "Helpers.ConvertToInt64(left)"}),
        ("SveSimpleVecOpDiffRetTypeTestVec.template", new Dictionary<string, string> { ["TestName"] = "Sve_ConvertToInt64_long_double",                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ConvertToInt64",                                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                                                      ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.ConvertToInt64(firstOp))",  ["GetVectorResult"] = "Helpers.ConvertToInt64(left)"}),
        ("SveSimpleVecOpDiffRetTypeTestVec.template", new Dictionary<string, string> { ["TestName"] = "Sve_ConvertToSingle_float_int",                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ConvertToSingle",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.ConvertToSingle(firstOp))", ["GetVectorResult"] = "Helpers.ConvertToSingle(left)"}),
        ("SveSimpleVecOpDiffRetTypeTestVec.template", new Dictionary<string, string> { ["TestName"] = "Sve_ConvertToSingle_float_double",                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ConvertToSingle",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                                                      ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.ConvertToSingle(firstOp))", ["GetVectorResult"] = "Helpers.ConvertToSingle(left)"}),
        ("SveSimpleVecOpDiffRetTypeTestVec.template", new Dictionary<string, string> { ["TestName"] = "Sve_ConvertToSingle_float_long",                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ConvertToSingle",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                                                       ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.ConvertToSingle(firstOp))", ["GetVectorResult"] = "Helpers.ConvertToSingle(left)"}),
        ("SveSimpleVecOpDiffRetTypeTestVec.template", new Dictionary<string, string> { ["TestName"] = "Sve_ConvertToSingle_float_uint",                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ConvertToSingle",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                                      ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.ConvertToSingle(firstOp))", ["GetVectorResult"] = "Helpers.ConvertToSingle(left)"}),
        ("SveSimpleVecOpDiffRetTypeTestVec.template", new Dictionary<string, string> { ["TestName"] = "Sve_ConvertToSingle_float_ulong",                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ConvertToSingle",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                                                      ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.ConvertToSingle(firstOp))", ["GetVectorResult"] = "Helpers.ConvertToSingle(left)"}),
        ("SveSimpleVecOpDiffRetTypeTestVec.template", new Dictionary<string, string> { ["TestName"] = "Sve_ConvertToUInt32_uint_float",                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ConvertToUInt32",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.ConvertToUInt32(firstOp))", ["GetVectorResult"] = "Helpers.ConvertToUInt32(left)"}),
        ("SveSimpleVecOpDiffRetTypeTestVec.template", new Dictionary<string, string> { ["TestName"] = "Sve_ConvertToUInt32_uint_double",                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ConvertToUInt32",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                                                      ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.ConvertToUInt32(firstOp))", ["GetVectorResult"] = "Helpers.ConvertToUInt32(left)"}),
        ("SveSimpleVecOpDiffRetTypeTestVec.template", new Dictionary<string, string> { ["TestName"] = "Sve_ConvertToUInt64_ulong_float",                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ConvertToUInt64",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.ConvertToUInt64(firstOp))", ["GetVectorResult"] = "Helpers.ConvertToUInt64(left)"}),
        ("SveSimpleVecOpDiffRetTypeTestVec.template", new Dictionary<string, string> { ["TestName"] = "Sve_ConvertToUInt64_ulong_double",                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ConvertToUInt64",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                                                      ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.ConvertToUInt64(firstOp))", ["GetVectorResult"] = "Helpers.ConvertToUInt64(left)"}),

        ("ScalarUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "Sve_Count16BitElements",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Count16BitElements",                                                                                    ["RetBaseType"] = "UInt64",                                   ["Op1BaseType"] = "SveMaskPattern",                                                                                                                   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "SveMaskPattern.All",                                                                                                                                                                     ["ValidateResult"] = "isUnexpectedResult = (result != (UInt64)(Unsafe.SizeOf<Vector<Int16>>() / sizeof(Int16)));",}),
        ("ScalarUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "Sve_Count32BitElements",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Count32BitElements",                                                                                    ["RetBaseType"] = "UInt64",                                   ["Op1BaseType"] = "SveMaskPattern",                                                                                                                   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "SveMaskPattern.All",                                                                                                                                                                     ["ValidateResult"] = "isUnexpectedResult = (result != (UInt64)(Unsafe.SizeOf<Vector<Int32>>() / sizeof(Int32)));",}),
        ("ScalarUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "Sve_Count64BitElements",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Count64BitElements",                                                                                    ["RetBaseType"] = "UInt64",                                   ["Op1BaseType"] = "SveMaskPattern",                                                                                                                   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "SveMaskPattern.All",                                                                                                                                                                     ["ValidateResult"] = "isUnexpectedResult = (result != (UInt64)(Unsafe.SizeOf<Vector<Int64>>() / sizeof(Int64)));",}),
        ("ScalarUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "Sve_Count8BitElements",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Count8BitElements",                                                                                     ["RetBaseType"] = "UInt64",                                   ["Op1BaseType"] = "SveMaskPattern",                                                                                                                   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "SveMaskPattern.All",                                                                                                                                                                     ["ValidateResult"] = "isUnexpectedResult = (result != (UInt64)(Unsafe.SizeOf<Vector<Byte>>() / sizeof(Byte)));",}),

        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakAfterMask_byte",                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakAfterMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",   ["Op1BaseType"] = "Byte",      ["Op2VectorType"] = "Vector",       ["Op2BaseType"] = "Byte",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskByte()",    ["NextValueOp2"] = "Helpers.getMaskByte()",                                                                                          ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakAfterMask(left, right))",        ["GetVectorResult"] = "Helpers.CreateBreakAfterMask(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakAfterMask_ushort",                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakAfterMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",   ["Op1BaseType"] = "UInt16",    ["Op2VectorType"] = "Vector",       ["Op2BaseType"] = "UInt16",                                                             ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskUInt16()",  ["NextValueOp2"] = "Helpers.getMaskUInt16()",                                                                                        ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakAfterMask(left, right))",        ["GetVectorResult"] = "Helpers.CreateBreakAfterMask(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakAfterMask_uint",                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakAfterMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",   ["Op1BaseType"] = "UInt32",    ["Op2VectorType"] = "Vector",       ["Op2BaseType"] = "UInt32",                                                             ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskUInt32()",  ["NextValueOp2"] = "Helpers.getMaskUInt32()",                                                                                        ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakAfterMask(left, right))",        ["GetVectorResult"] = "Helpers.CreateBreakAfterMask(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakAfterMask_ulong",                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakAfterMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",   ["Op1BaseType"] = "UInt64",    ["Op2VectorType"] = "Vector",       ["Op2BaseType"] = "UInt64",                                                             ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskUInt64()",  ["NextValueOp2"] = "Helpers.getMaskUInt64()",                                                                                        ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakAfterMask(left, right))",        ["GetVectorResult"] = "Helpers.CreateBreakAfterMask(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakAfterMask_sbyte",                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakAfterMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",   ["Op1BaseType"] = "SByte",     ["Op2VectorType"] = "Vector",       ["Op2BaseType"] = "SByte",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskSByte()",   ["NextValueOp2"] = "Helpers.getMaskSByte()",                                                                                         ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakAfterMask(left, right))",        ["GetVectorResult"] = "Helpers.CreateBreakAfterMask(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakAfterMask_short",                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakAfterMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",   ["Op1BaseType"] = "Int16",     ["Op2VectorType"] = "Vector",       ["Op2BaseType"] = "Int16",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskInt16()",   ["NextValueOp2"] = "Helpers.getMaskInt16()",                                                                                         ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakAfterMask(left, right))",        ["GetVectorResult"] = "Helpers.CreateBreakAfterMask(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakAfterMask_int",                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakAfterMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",   ["Op1BaseType"] = "Int32",     ["Op2VectorType"] = "Vector",       ["Op2BaseType"] = "Int32",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskInt32()",   ["NextValueOp2"] = "Helpers.getMaskInt32()",                                                                                         ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakAfterMask(left, right))",        ["GetVectorResult"] = "Helpers.CreateBreakAfterMask(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakAfterMask_long",                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakAfterMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",   ["Op1BaseType"] = "Int64",     ["Op2VectorType"] = "Vector",       ["Op2BaseType"] = "Int64",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskInt64()",   ["NextValueOp2"] = "Helpers.getMaskInt64()",                                                                                         ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakAfterMask(left, right))",        ["GetVectorResult"] = "Helpers.CreateBreakAfterMask(left, right)"}),

        ("SveVecTernOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakAfterPropagateMask_byte",                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakAfterPropagateMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",    ["Op2BaseType"] = "Byte",   ["Op3BaseType"] = "Byte",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskByte()",   ["NextValueOp2"] = "Helpers.getMaskByte()",     ["NextValueOp3"] = "Helpers.getMaskByte()",                                              ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakAfterPropagateMask(firstOp, secondOp, thirdOp))",        ["GetVectorResult"] = "Helpers.CreateBreakAfterPropagateMask(first, second, third)"}),
        ("SveVecTernOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakAfterPropagateMask_ushort",                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakAfterPropagateMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",  ["Op2BaseType"] = "UInt16", ["Op3BaseType"] = "UInt16",                                                             ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskUInt16()", ["NextValueOp2"] = "Helpers.getMaskUInt16()",   ["NextValueOp3"] = "Helpers.getMaskUInt16()",                                            ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakAfterPropagateMask(firstOp, secondOp, thirdOp))",        ["GetVectorResult"] = "Helpers.CreateBreakAfterPropagateMask(first, second, third)"}),
        ("SveVecTernOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakAfterPropagateMask_uint",                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakAfterPropagateMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",  ["Op2BaseType"] = "UInt32", ["Op3BaseType"] = "UInt32",                                                             ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskUInt32()", ["NextValueOp2"] = "Helpers.getMaskUInt32()",   ["NextValueOp3"] = "Helpers.getMaskUInt32()",                                            ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakAfterPropagateMask(firstOp, secondOp, thirdOp))",        ["GetVectorResult"] = "Helpers.CreateBreakAfterPropagateMask(first, second, third)"}),
        ("SveVecTernOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakAfterPropagateMask_ulong",                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakAfterPropagateMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",  ["Op2BaseType"] = "UInt64", ["Op3BaseType"] = "UInt64",                                                             ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskUInt64()", ["NextValueOp2"] = "Helpers.getMaskUInt64()",   ["NextValueOp3"] = "Helpers.getMaskUInt64()",                                            ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakAfterPropagateMask(firstOp, secondOp, thirdOp))",        ["GetVectorResult"] = "Helpers.CreateBreakAfterPropagateMask(first, second, third)"}),
        ("SveVecTernOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakAfterPropagateMask_sbyte",                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakAfterPropagateMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",   ["Op2BaseType"] = "SByte",  ["Op3BaseType"] = "SByte",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskSByte()",  ["NextValueOp2"] = "Helpers.getMaskSByte()",    ["NextValueOp3"] = "Helpers.getMaskSByte()",                                             ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakAfterPropagateMask(firstOp, secondOp, thirdOp))",        ["GetVectorResult"] = "Helpers.CreateBreakAfterPropagateMask(first, second, third)"}),
        ("SveVecTernOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakAfterPropagateMask_short",                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakAfterPropagateMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",   ["Op2BaseType"] = "Int16",  ["Op3BaseType"] = "Int16",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskInt16()",  ["NextValueOp2"] = "Helpers.getMaskInt16()",    ["NextValueOp3"] = "Helpers.getMaskInt16()",                                             ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakAfterPropagateMask(firstOp, secondOp, thirdOp))",        ["GetVectorResult"] = "Helpers.CreateBreakAfterPropagateMask(first, second, third)"}),
        ("SveVecTernOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakAfterPropagateMask_int",                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakAfterPropagateMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",   ["Op2BaseType"] = "Int32",  ["Op3BaseType"] = "Int32",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskInt32()",  ["NextValueOp2"] = "Helpers.getMaskInt32()",    ["NextValueOp3"] = "Helpers.getMaskInt32()",                                             ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakAfterPropagateMask(firstOp, secondOp, thirdOp))",        ["GetVectorResult"] = "Helpers.CreateBreakAfterPropagateMask(first, second, third)"}),
        ("SveVecTernOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakAfterPropagateMask_long",                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakAfterPropagateMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",   ["Op2BaseType"] = "Int64",  ["Op3BaseType"] = "Int64",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskInt64()",  ["NextValueOp2"] = "Helpers.getMaskInt64()",    ["NextValueOp3"] = "Helpers.getMaskInt64()",                                             ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakAfterPropagateMask(firstOp, secondOp, thirdOp))",        ["GetVectorResult"] = "Helpers.CreateBreakAfterPropagateMask(first, second, third)"}),

        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakBeforeMask_byte",                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakBeforeMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",   ["Op1BaseType"] = "Byte",      ["Op2VectorType"] = "Vector",       ["Op2BaseType"] = "Byte",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskByte()",    ["NextValueOp2"] = "Helpers.getMaskByte()",                                                                                          ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakBeforeMask(left, right))",        ["GetVectorResult"] = "Helpers.CreateBreakBeforeMask(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakBeforeMask_ushort",                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakBeforeMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",   ["Op1BaseType"] = "UInt16",    ["Op2VectorType"] = "Vector",       ["Op2BaseType"] = "UInt16",                                                             ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskUInt16()",  ["NextValueOp2"] = "Helpers.getMaskUInt16()",                                                                                        ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakBeforeMask(left, right))",        ["GetVectorResult"] = "Helpers.CreateBreakBeforeMask(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakBeforeMask_uint",                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakBeforeMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",   ["Op1BaseType"] = "UInt32",    ["Op2VectorType"] = "Vector",       ["Op2BaseType"] = "UInt32",                                                             ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskUInt32()",  ["NextValueOp2"] = "Helpers.getMaskUInt32()",                                                                                        ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakBeforeMask(left, right))",        ["GetVectorResult"] = "Helpers.CreateBreakBeforeMask(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakBeforeMask_ulong",                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakBeforeMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",   ["Op1BaseType"] = "UInt64",    ["Op2VectorType"] = "Vector",       ["Op2BaseType"] = "UInt64",                                                             ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskUInt64()",  ["NextValueOp2"] = "Helpers.getMaskUInt64()",                                                                                        ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakBeforeMask(left, right))",        ["GetVectorResult"] = "Helpers.CreateBreakBeforeMask(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakBeforeMask_sbyte",                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakBeforeMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",   ["Op1BaseType"] = "SByte",     ["Op2VectorType"] = "Vector",       ["Op2BaseType"] = "SByte",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskSByte()",   ["NextValueOp2"] = "Helpers.getMaskSByte()",                                                                                         ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakBeforeMask(left, right))",        ["GetVectorResult"] = "Helpers.CreateBreakBeforeMask(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakBeforeMask_short",                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakBeforeMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",   ["Op1BaseType"] = "Int16",     ["Op2VectorType"] = "Vector",       ["Op2BaseType"] = "Int16",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskInt16()",   ["NextValueOp2"] = "Helpers.getMaskInt16()",                                                                                         ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakBeforeMask(left, right))",        ["GetVectorResult"] = "Helpers.CreateBreakBeforeMask(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakBeforeMask_int",                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakBeforeMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",   ["Op1BaseType"] = "Int32",     ["Op2VectorType"] = "Vector",       ["Op2BaseType"] = "Int32",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskInt32()",   ["NextValueOp2"] = "Helpers.getMaskInt32()",                                                                                         ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakBeforeMask(left, right))",        ["GetVectorResult"] = "Helpers.CreateBreakBeforeMask(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakBeforeMask_long",                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakBeforeMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",   ["Op1BaseType"] = "Int64",     ["Op2VectorType"] = "Vector",       ["Op2BaseType"] = "Int64",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskInt64()",   ["NextValueOp2"] = "Helpers.getMaskInt64()",                                                                                         ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakBeforeMask(left, right))",        ["GetVectorResult"] = "Helpers.CreateBreakBeforeMask(left, right)"}),

        ("SveVecTernOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakBeforePropagateMask_byte",                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakBeforePropagateMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",    ["Op2BaseType"] = "Byte",   ["Op3BaseType"] = "Byte",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskByte()",   ["NextValueOp2"] = "Helpers.getMaskByte()",     ["NextValueOp3"] = "Helpers.getMaskByte()",                                              ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakBeforePropagateMask(firstOp, secondOp, thirdOp))",        ["GetVectorResult"] = "Helpers.CreateBreakBeforePropagateMask(first, second, third)"}),
        ("SveVecTernOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakBeforePropagateMask_ushort",                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakBeforePropagateMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",  ["Op2BaseType"] = "UInt16", ["Op3BaseType"] = "UInt16",                                                             ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskUInt16()", ["NextValueOp2"] = "Helpers.getMaskUInt16()",   ["NextValueOp3"] = "Helpers.getMaskUInt16()",                                            ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakBeforePropagateMask(firstOp, secondOp, thirdOp))",        ["GetVectorResult"] = "Helpers.CreateBreakBeforePropagateMask(first, second, third)"}),
        ("SveVecTernOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakBeforePropagateMask_uint",                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakBeforePropagateMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",  ["Op2BaseType"] = "UInt32", ["Op3BaseType"] = "UInt32",                                                             ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskUInt32()", ["NextValueOp2"] = "Helpers.getMaskUInt32()",   ["NextValueOp3"] = "Helpers.getMaskUInt32()",                                            ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakBeforePropagateMask(firstOp, secondOp, thirdOp))",        ["GetVectorResult"] = "Helpers.CreateBreakBeforePropagateMask(first, second, third)"}),
        ("SveVecTernOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakBeforePropagateMask_ulong",                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakBeforePropagateMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",  ["Op2BaseType"] = "UInt64", ["Op3BaseType"] = "UInt64",                                                             ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskUInt64()", ["NextValueOp2"] = "Helpers.getMaskUInt64()",   ["NextValueOp3"] = "Helpers.getMaskUInt64()",                                            ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakBeforePropagateMask(firstOp, secondOp, thirdOp))",        ["GetVectorResult"] = "Helpers.CreateBreakBeforePropagateMask(first, second, third)"}),
        ("SveVecTernOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakBeforePropagateMask_sbyte",                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakBeforePropagateMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",   ["Op2BaseType"] = "SByte",  ["Op3BaseType"] = "SByte",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskSByte()",  ["NextValueOp2"] = "Helpers.getMaskSByte()",    ["NextValueOp3"] = "Helpers.getMaskSByte()",                                             ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakBeforePropagateMask(firstOp, secondOp, thirdOp))",        ["GetVectorResult"] = "Helpers.CreateBreakBeforePropagateMask(first, second, third)"}),
        ("SveVecTernOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakBeforePropagateMask_short",                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakBeforePropagateMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",   ["Op2BaseType"] = "Int16",  ["Op3BaseType"] = "Int16",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskInt16()",  ["NextValueOp2"] = "Helpers.getMaskInt16()",    ["NextValueOp3"] = "Helpers.getMaskInt16()",                                             ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakBeforePropagateMask(firstOp, secondOp, thirdOp))",        ["GetVectorResult"] = "Helpers.CreateBreakBeforePropagateMask(first, second, third)"}),
        ("SveVecTernOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakBeforePropagateMask_int",                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakBeforePropagateMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",   ["Op2BaseType"] = "Int32",  ["Op3BaseType"] = "Int32",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskInt32()",  ["NextValueOp2"] = "Helpers.getMaskInt32()",    ["NextValueOp3"] = "Helpers.getMaskInt32()",                                             ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakBeforePropagateMask(firstOp, secondOp, thirdOp))",        ["GetVectorResult"] = "Helpers.CreateBreakBeforePropagateMask(first, second, third)"}),
        ("SveVecTernOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakBeforePropagateMask_long",                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakBeforePropagateMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",   ["Op2BaseType"] = "Int64",  ["Op3BaseType"] = "Int64",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskInt64()",  ["NextValueOp2"] = "Helpers.getMaskInt64()",    ["NextValueOp3"] = "Helpers.getMaskInt64()",                                             ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakBeforePropagateMask(firstOp, secondOp, thirdOp))",        ["GetVectorResult"] = "Helpers.CreateBreakBeforePropagateMask(first, second, third)"}),

        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakPropagateMask_byte",                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakPropagateMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",   ["Op1BaseType"] = "Byte",      ["Op2VectorType"] = "Vector",       ["Op2BaseType"] = "Byte",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskByte()",    ["NextValueOp2"] = "Helpers.getMaskByte()",                                                                                          ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakPropagateMask(left, right))",        ["GetVectorResult"] = "Helpers.CreateBreakPropagateMask(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakPropagateMask_ushort",                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakPropagateMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",   ["Op1BaseType"] = "UInt16",    ["Op2VectorType"] = "Vector",       ["Op2BaseType"] = "UInt16",                                                             ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskUInt16()",  ["NextValueOp2"] = "Helpers.getMaskUInt16()",                                                                                        ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakPropagateMask(left, right))",        ["GetVectorResult"] = "Helpers.CreateBreakPropagateMask(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakPropagateMask_uint",                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakPropagateMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",   ["Op1BaseType"] = "UInt32",    ["Op2VectorType"] = "Vector",       ["Op2BaseType"] = "UInt32",                                                             ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskUInt32()",  ["NextValueOp2"] = "Helpers.getMaskUInt32()",                                                                                        ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakPropagateMask(left, right))",        ["GetVectorResult"] = "Helpers.CreateBreakPropagateMask(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakPropagateMask_ulong",                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakPropagateMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",   ["Op1BaseType"] = "UInt64",    ["Op2VectorType"] = "Vector",       ["Op2BaseType"] = "UInt64",                                                             ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskUInt64()",  ["NextValueOp2"] = "Helpers.getMaskUInt64()",                                                                                        ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakPropagateMask(left, right))",        ["GetVectorResult"] = "Helpers.CreateBreakPropagateMask(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakPropagateMask_sbyte",                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakPropagateMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",   ["Op1BaseType"] = "SByte",     ["Op2VectorType"] = "Vector",       ["Op2BaseType"] = "SByte",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskSByte()",   ["NextValueOp2"] = "Helpers.getMaskSByte()",                                                                                         ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakPropagateMask(left, right))",        ["GetVectorResult"] = "Helpers.CreateBreakPropagateMask(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakPropagateMask_short",                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakPropagateMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",   ["Op1BaseType"] = "Int16",     ["Op2VectorType"] = "Vector",       ["Op2BaseType"] = "Int16",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskInt16()",   ["NextValueOp2"] = "Helpers.getMaskInt16()",                                                                                         ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakPropagateMask(left, right))",        ["GetVectorResult"] = "Helpers.CreateBreakPropagateMask(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakPropagateMask_int",                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakPropagateMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",   ["Op1BaseType"] = "Int32",     ["Op2VectorType"] = "Vector",       ["Op2BaseType"] = "Int32",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskInt32()",   ["NextValueOp2"] = "Helpers.getMaskInt32()",                                                                                         ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakPropagateMask(left, right))",        ["GetVectorResult"] = "Helpers.CreateBreakPropagateMask(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateBreakPropagateMask_long",                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateBreakPropagateMask",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",   ["Op1BaseType"] = "Int64",     ["Op2VectorType"] = "Vector",       ["Op2BaseType"] = "Int64",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskInt64()",   ["NextValueOp2"] = "Helpers.getMaskInt64()",                                                                                         ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateBreakPropagateMask(left, right))",        ["GetVectorResult"] = "Helpers.CreateBreakPropagateMask(left, right)"}),

        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanMask16Bit_Int32",                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanMask16Bit",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",                                   ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                  ["ValidateIterResult"] = "Helpers.WhileLessThanMask(left + (Int32)i, right) != (Int32)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanMask16Bit_Int64",                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanMask16Bit",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",                                   ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                  ["ValidateIterResult"] = "Helpers.WhileLessThanMask(left + (Int64)i, right) != (Int64)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanMask16Bit_UInt32",                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanMask16Bit",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",                                   ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                 ["ValidateIterResult"] = "Helpers.WhileLessThanMask(left + (UInt32)i, right) != (UInt32)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanMask16Bit_UInt64",                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanMask16Bit",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",                                   ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                 ["ValidateIterResult"] = "Helpers.WhileLessThanMask(left + (UInt64)i, right) != (UInt64)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanMask32Bit_Int32",                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanMask32Bit",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",                                   ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                  ["ValidateIterResult"] = "Helpers.WhileLessThanMask(left + (Int32)i, right) != (Int32)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanMask32Bit_Int64",                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanMask32Bit",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",                                   ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                  ["ValidateIterResult"] = "Helpers.WhileLessThanMask(left + (Int64)i, right) != (Int64)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanMask32Bit_UInt32",                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanMask32Bit",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",                                   ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                 ["ValidateIterResult"] = "Helpers.WhileLessThanMask(left + (UInt32)i, right) != (UInt32)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanMask32Bit_UInt64",                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanMask32Bit",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",                                   ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                 ["ValidateIterResult"] = "Helpers.WhileLessThanMask(left + (UInt64)i, right) != (UInt64)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanMask64Bit_Int32",                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanMask64Bit",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",                                   ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                  ["ValidateIterResult"] = "Helpers.WhileLessThanMask(left + (Int32)i, right) != (Int32)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanMask64Bit_Int64",                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanMask64Bit",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",                                   ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                  ["ValidateIterResult"] = "Helpers.WhileLessThanMask(left + (Int64)i, right) != (Int64)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanMask64Bit_UInt32",                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanMask64Bit",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",                                   ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                 ["ValidateIterResult"] = "Helpers.WhileLessThanMask(left + (UInt32)i, right) != (UInt32)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanMask64Bit_UInt64",                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanMask64Bit",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",                                   ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                 ["ValidateIterResult"] = "Helpers.WhileLessThanMask(left + (UInt64)i, right) != (UInt64)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanMask8Bit_Int32",                                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanMask8Bit",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",                                     ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                  ["ValidateIterResult"] = "Helpers.WhileLessThanMask(left + (Int32)i, right) != (Int32)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanMask8Bit_Int64",                                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanMask8Bit",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",                                     ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                  ["ValidateIterResult"] = "Helpers.WhileLessThanMask(left + (Int64)i, right) != (Int64)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanMask8Bit_UInt32",                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanMask8Bit",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",                                     ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                 ["ValidateIterResult"] = "Helpers.WhileLessThanMask(left + (UInt32)i, right) != (UInt32)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanMask8Bit_UInt64",                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanMask8Bit",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",                                     ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                 ["ValidateIterResult"] = "Helpers.WhileLessThanMask(left + (UInt64)i, right) != (UInt64)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanOrEqualMask16Bit_Int32",                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanOrEqualMask16Bit",                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",                                   ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                  ["ValidateIterResult"] = "Helpers.WhileLessThanOrEqualMask(left + (Int32)i, right) != (Int32)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanOrEqualMask16Bit_Int64",                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanOrEqualMask16Bit",                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",                                   ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                  ["ValidateIterResult"] = "Helpers.WhileLessThanOrEqualMask(left + (Int64)i, right) != (Int64)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanOrEqualMask16Bit_UInt32",                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanOrEqualMask16Bit",                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",                                   ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                 ["ValidateIterResult"] = "Helpers.WhileLessThanOrEqualMask(left + (UInt32)i, right) != (UInt32)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanOrEqualMask16Bit_UInt64",                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanOrEqualMask16Bit",                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",                                   ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                 ["ValidateIterResult"] = "Helpers.WhileLessThanOrEqualMask(left + (UInt64)i, right) != (UInt64)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanOrEqualMask32Bit_Int32",                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanOrEqualMask32Bit",                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",                                   ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                  ["ValidateIterResult"] = "Helpers.WhileLessThanOrEqualMask(left + (Int32)i, right) != (Int32)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanOrEqualMask32Bit_Int64",                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanOrEqualMask32Bit",                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",                                   ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                  ["ValidateIterResult"] = "Helpers.WhileLessThanOrEqualMask(left + (Int64)i, right) != (Int64)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanOrEqualMask32Bit_UInt32",                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanOrEqualMask32Bit",                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",                                   ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                 ["ValidateIterResult"] = "Helpers.WhileLessThanOrEqualMask(left + (UInt32)i, right) != (UInt32)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanOrEqualMask32Bit_UInt64",                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanOrEqualMask32Bit",                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",                                   ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                 ["ValidateIterResult"] = "Helpers.WhileLessThanOrEqualMask(left + (UInt64)i, right) != (UInt64)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanOrEqualMask64Bit_Int32",                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanOrEqualMask64Bit",                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",                                   ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                  ["ValidateIterResult"] = "Helpers.WhileLessThanOrEqualMask(left + (Int32)i, right) != (Int32)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanOrEqualMask64Bit_Int64",                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanOrEqualMask64Bit",                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",                                   ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                  ["ValidateIterResult"] = "Helpers.WhileLessThanOrEqualMask(left + (Int64)i, right) != (Int64)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanOrEqualMask64Bit_UInt32",                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanOrEqualMask64Bit",                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",                                   ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                 ["ValidateIterResult"] = "Helpers.WhileLessThanOrEqualMask(left + (UInt32)i, right) != (UInt32)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanOrEqualMask64Bit_UInt64",                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanOrEqualMask64Bit",                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",                                   ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                 ["ValidateIterResult"] = "Helpers.WhileLessThanOrEqualMask(left + (UInt64)i, right) != (UInt64)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanOrEqualMask8Bit_Int32",                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanOrEqualMask8Bit",                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",                                     ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                  ["ValidateIterResult"] = "Helpers.WhileLessThanOrEqualMask(left + (Int32)i, right) != (Int32)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanOrEqualMask8Bit_Int64",                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanOrEqualMask8Bit",                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",                                     ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                  ["ValidateIterResult"] = "Helpers.WhileLessThanOrEqualMask(left + (Int64)i, right) != (Int64)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanOrEqualMask8Bit_UInt32",                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanOrEqualMask8Bit",                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",                                     ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                 ["ValidateIterResult"] = "Helpers.WhileLessThanOrEqualMask(left + (UInt32)i, right) != (UInt32)result[i]",}),
        ("ScalarBinOpRetVecTest.template",new Dictionary<string, string> {["TestName"] = "Sve_CreateWhileLessThanOrEqualMask8Bit_UInt64",                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateWhileLessThanOrEqualMask8Bit",                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",                                     ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64",                 ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                 ["ValidateIterResult"] = "Helpers.WhileLessThanOrEqualMask(left + (UInt64)i, right) != (UInt64)result[i]",}),

        ("SveVecBinOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_Divide_float",                                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Divide",                                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                           ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",       ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                              ["ValidateIterResult"] = "Helpers.Divide(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Divide(left[i], right[i])"}),
        ("SveVecBinOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_Divide_double",                                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Divide",                                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                           ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",       ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                              ["ValidateIterResult"] = "Helpers.Divide(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Divide(left[i], right[i])"}),

        ("SveVecTernOpFirstArgTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_DotProduct_int",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "DotProduct",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "Helpers.DotProduct(first[i], second, 4 * i, third, 4 * i) != result[i]", ["GetIterResult"] = "Helpers.DotProduct(first[i], second, 4 * i, third, 4 * i)", ["ConvertFunc"] = ""}),
        ("SveVecTernOpFirstArgTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_DotProduct_long",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "DotProduct",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.DotProduct(first[i], second, 4 * i, third, 4 * i) != result[i]", ["GetIterResult"] = "Helpers.DotProduct(first[i], second, 4 * i, third, 4 * i)", ["ConvertFunc"] = ""}),
        ("SveVecTernOpFirstArgTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_DotProduct_uint",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "DotProduct",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["ValidateIterResult"] = "Helpers.DotProduct(first[i], second, 4 * i, third, 4 * i) != result[i]", ["GetIterResult"] = "Helpers.DotProduct(first[i], second, 4 * i, third, 4 * i)", ["ConvertFunc"] = ""}),
        ("SveVecTernOpFirstArgTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_DotProduct_ulong",                                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "DotProduct",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ValidateIterResult"] = "Helpers.DotProduct(first[i], second, 4 * i, third, 4 * i) != result[i]", ["GetIterResult"] = "Helpers.DotProduct(first[i], second, 4 * i, third, 4 * i)", ["ConvertFunc"] = ""}),

        ("SveVecImmTernOpFirstArgTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_DotProductBySelectedScalar_int",                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "DotProductBySelectedScalar",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",    ["Imm"] = "2", ["InvalidImm"] = "4",                  ["ValidateIterResult"] = "Helpers.DotProduct(first[i], second, 4 * i, third, 4 * Imm) != result[i]", ["GetIterResult"] = "Helpers.DotProduct(first[i], second, 4 * i, third, 4 * Imm)", ["ConvertFunc"] = ""}),
        ("SveVecImmTernOpFirstArgTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_DotProductBySelectedScalar_long",                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "DotProductBySelectedScalar",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",    ["Imm"] = "1", ["InvalidImm"] = "4",                   ["ValidateIterResult"] = "Helpers.DotProduct(first[i], second, 4 * i, third, 4 * Imm) != result[i]", ["GetIterResult"] = "Helpers.DotProduct(first[i], second, 4 * i, third, 4 * Imm)", ["ConvertFunc"] = ""}),
        ("SveVecImmTernOpFirstArgTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_DotProductBySelectedScalar_uint",                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "DotProductBySelectedScalar",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",     ["Imm"] = "1", ["InvalidImm"] = "4",                   ["ValidateIterResult"] = "Helpers.DotProduct(first[i], second, 4 * i, third, 4 * Imm) != result[i]", ["GetIterResult"] = "Helpers.DotProduct(first[i], second, 4 * i, third, 4 * Imm)", ["ConvertFunc"] = ""}),
        ("SveVecImmTernOpFirstArgTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_DotProductBySelectedScalar_ulong",                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "DotProductBySelectedScalar",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",   ["Imm"] = "1", ["InvalidImm"] = "4",                   ["ValidateIterResult"] = "Helpers.DotProduct(first[i], second, 4 * i, third, 4 * Imm) != result[i]", ["GetIterResult"] = "Helpers.DotProduct(first[i], second, 4 * i, third, 4 * Imm)", ["ConvertFunc"] = ""}),

        ("SveVecTernOpTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_FusedMultiplyAdd_float",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "FusedMultiplyAdd",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",    ["Op2BaseType"] = "Single",    ["Op3BaseType"] = "Single",  ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",  ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",                                 ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.FusedMultiplyAdd(firstOp[i], secondOp[i], thirdOp[i])) != BitConverter.SingleToInt32Bits(result[i])", ["GetIterResult"] = "Helpers.FusedMultiplyAdd(firstOp[i], secondOp[i], thirdOp[i])", ["ConvertFunc"] = "BitConverter.SingleToInt32Bits"}),
        ("SveVecTernOpTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_FusedMultiplyAdd_double",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "FusedMultiplyAdd",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",    ["Op2BaseType"] = "Double",    ["Op3BaseType"] = "Double",  ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",  ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",  ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()",                                 ["ValidateIterResult"] = "BitConverter.DoubleToInt64Bits(Helpers.FusedMultiplyAdd(firstOp[i], secondOp[i], thirdOp[i])) != BitConverter.DoubleToInt64Bits(result[i])", ["GetIterResult"] = "Helpers.FusedMultiplyAdd(firstOp[i], secondOp[i], thirdOp[i])", ["ConvertFunc"] = "BitConverter.DoubleToInt64Bits"}),

        ("SveVecImmTernOpTest.template", new Dictionary<string, string> {["TestName"] = "Sve_FusedMultiplyAddBySelectedScalar_float",                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "FusedMultiplyAddBySelectedScalar",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Single",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm"] = "1", ["InvalidImm"] = "4", ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.FusedMultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm])) != BitConverter.SingleToInt32Bits(result[i])", ["GetIterResult"] = "Helpers.FusedMultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm])", ["ConvertFunc"] = "BitConverter.SingleToInt32Bits"}),
        ("SveVecImmTernOpTest.template", new Dictionary<string, string> {["TestName"] = "Sve_FusedMultiplyAddBySelectedScalar_double",                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "FusedMultiplyAddBySelectedScalar",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Double",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()", ["NextValueMask"] = "Helpers.getMaskDouble()", ["Imm"] = "0", ["InvalidImm"] = "2", ["ValidateIterResult"] = "BitConverter.DoubleToInt64Bits(Helpers.FusedMultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm])) != BitConverter.DoubleToInt64Bits(result[i])", ["GetIterResult"] = "Helpers.FusedMultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm])", ["ConvertFunc"] = "BitConverter.DoubleToInt64Bits"}),

        ("SveVecTernOpTest.template",    new Dictionary<string, string> {["TestName"] = "Sve_FusedMultiplyAddNegated_float",                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "FusedMultiplyAddNegated",                                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",    ["Op2BaseType"] = "Single",    ["Op3BaseType"] = "Single",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",  ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",                                 ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.FusedMultiplyAddNegated(firstOp[i], secondOp[i], thirdOp[i])) != BitConverter.SingleToInt32Bits(result[i])", ["GetIterResult"] = "Helpers.FusedMultiplyAddNegated(firstOp[i], secondOp[i], thirdOp[i])", ["ConvertFunc"] = "BitConverter.SingleToInt32Bits"}),
        ("SveVecTernOpTest.template",    new Dictionary<string, string> {["TestName"] = "Sve_FusedMultiplyAddNegated_double",                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "FusedMultiplyAddNegated",                                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",    ["Op2BaseType"] = "Double",    ["Op3BaseType"] = "Double",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",  ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",  ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",                                 ["ValidateIterResult"] = "BitConverter.DoubleToInt64Bits(Helpers.FusedMultiplyAddNegated(firstOp[i], secondOp[i], thirdOp[i])) != BitConverter.DoubleToInt64Bits(result[i])", ["GetIterResult"] = "Helpers.FusedMultiplyAddNegated(firstOp[i], secondOp[i], thirdOp[i])", ["ConvertFunc"] = "BitConverter.DoubleToInt64Bits"}),

        ("SveVecTernOpTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_FusedMultiplySubtract_float",                                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "FusedMultiplySubtract",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",    ["Op2BaseType"] = "Single",    ["Op3BaseType"] = "Single",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",  ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",                                 ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.FusedMultiplySubtract(firstOp[i], secondOp[i], thirdOp[i])) != BitConverter.SingleToInt32Bits(result[i])", ["GetIterResult"] = "Helpers.FusedMultiplySubtract(firstOp[i], secondOp[i], thirdOp[i])", ["ConvertFunc"] = "BitConverter.SingleToInt32Bits"}),
        ("SveVecTernOpTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_FusedMultiplySubtract_double",                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "FusedMultiplySubtract",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",    ["Op2BaseType"] = "Double",    ["Op3BaseType"] = "Double",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",  ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",  ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()",                                 ["ValidateIterResult"] = "BitConverter.DoubleToInt64Bits(Helpers.FusedMultiplySubtract(firstOp[i], secondOp[i], thirdOp[i])) != BitConverter.DoubleToInt64Bits(result[i])", ["GetIterResult"] = "Helpers.FusedMultiplySubtract(firstOp[i], secondOp[i], thirdOp[i])", ["ConvertFunc"] = "BitConverter.DoubleToInt64Bits"}),

        ("SveVecImmTernOpTest.template", new Dictionary<string, string> {["TestName"] = "Sve_FusedMultiplySubtractBySelectedScalar_float",                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "FusedMultiplySubtractBySelectedScalar",                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Single",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm"] = "1", ["InvalidImm"] = "4", ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.FusedMultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm])) != BitConverter.SingleToInt32Bits(result[i])", ["GetIterResult"] = "Helpers.FusedMultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm])", ["ConvertFunc"] = "BitConverter.SingleToInt32Bits"}),
        ("SveVecImmTernOpTest.template", new Dictionary<string, string> {["TestName"] = "Sve_FusedMultiplySubtractBySelectedScalar_double",                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "FusedMultiplySubtractBySelectedScalar",                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Double", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()", ["NextValueMask"] = "Helpers.getMaskDouble()",  ["Imm"] = "0", ["InvalidImm"] = "2", ["ValidateIterResult"] = "BitConverter.DoubleToInt64Bits(Helpers.FusedMultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm])) != BitConverter.DoubleToInt64Bits(result[i])", ["GetIterResult"] = "Helpers.FusedMultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm])", ["ConvertFunc"] = "BitConverter.DoubleToInt64Bits"}),

        ("SveVecTernOpTest.template",    new Dictionary<string, string> {["TestName"] = "Sve_FusedMultiplySubtractNegated_float",                                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "FusedMultiplySubtractNegated",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",    ["Op2BaseType"] = "Single",    ["Op3BaseType"] = "Single",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",                                 ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.FusedMultiplySubtractNegated(firstOp[i], secondOp[i], thirdOp[i])) != BitConverter.SingleToInt32Bits(result[i])", ["GetIterResult"] = "Helpers.FusedMultiplySubtractNegated(firstOp[i], secondOp[i], thirdOp[i])", ["ConvertFunc"] = "BitConverter.SingleToInt32Bits"}),
        ("SveVecTernOpTest.template",    new Dictionary<string, string> {["TestName"] = "Sve_FusedMultiplySubtractNegated_double",                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "FusedMultiplySubtractNegated",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",    ["Op2BaseType"] = "Double",    ["Op3BaseType"] = "Double",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",   ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()",                               ["ValidateIterResult"] = "BitConverter.DoubleToInt64Bits(Helpers.FusedMultiplySubtractNegated(firstOp[i], secondOp[i], thirdOp[i])) != BitConverter.DoubleToInt64Bits(result[i])", ["GetIterResult"] = "Helpers.FusedMultiplySubtractNegated(firstOp[i], secondOp[i], thirdOp[i])", ["ConvertFunc"] = "BitConverter.DoubleToInt64Bits"}),

        ("SveSimpleNoOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve_CreateFalseMaskByte_byte",                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateFalseMaskByte",                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",                                                                                                                                                                                                                                                                                                                                                                                                                                      ["ValidateIterResult"] = "result[i] != 0",}),
        ("SveSimpleNoOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve_CreateFalseMaskDouble_double",                                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateFalseMaskDouble",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",                                                                                                                                                                                                                                                                                                                                                                                                                                    ["ValidateIterResult"] = "result[i] != 0",}),
        ("SveSimpleNoOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve_CreateFalseMaskInt16_short",                                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateFalseMaskInt16",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",                                                                                                                                                                                                                                                                                                                                                                                                                                     ["ValidateIterResult"] = "result[i] != 0",}),
        ("SveSimpleNoOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve_CreateFalseMaskInt32_int",                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateFalseMaskInt32",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",                                                                                                                                                                                                                                                                                                                                                                                                                                     ["ValidateIterResult"] = "result[i] != 0",}),
        ("SveSimpleNoOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve_CreateFalseMaskInt64_long",                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateFalseMaskInt64",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",                                                                                                                                                                                                                                                                                                                                                                                                                                     ["ValidateIterResult"] = "result[i] != 0",}),
        ("SveSimpleNoOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve_CreateFalseMaskSByte_sbyte",                                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateFalseMaskSByte",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",                                                                                                                                                                                                                                                                                                                                                                                                                                     ["ValidateIterResult"] = "result[i] != 0",}),
        ("SveSimpleNoOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve_CreateFalseMaskSingle_float",                                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateFalseMaskSingle",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",                                                                                                                                                                                                                                                                                                                                                                                                                                    ["ValidateIterResult"] = "result[i] != 0",}),
        ("SveSimpleNoOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve_CreateFalseMaskUInt16_ushort",                                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateFalseMaskUInt16",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",                                                                                                                                                                                                                                                                                                                                                                                                                                    ["ValidateIterResult"] = "result[i] != 0",}),
        ("SveSimpleNoOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve_CreateFalseMaskUInt32_uint",                                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateFalseMaskUInt32",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",                                                                                                                                                                                                                                                                                                                                                                                                                                    ["ValidateIterResult"] = "result[i] != 0",}),
        ("SveSimpleNoOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve_CreateFalseMaskUInt64_ulong",                                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateFalseMaskUInt64",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",                                                                                                                                                                                                                                                                                                                                                                                                                                    ["ValidateIterResult"] = "result[i] != 0",}),
        ("SveCreateTrueMaskTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_CreateTrueMaskByte",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateTrueMaskByte",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",                                     ["Op1Type"] = "SveMaskPattern"}),
        ("SveCreateTrueMaskTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_CreateTrueMaskDouble",                                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateTrueMaskDouble",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",                                   ["Op1Type"] = "SveMaskPattern"}),
        ("SveCreateTrueMaskTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_CreateTrueMaskInt16",                                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateTrueMaskInt16",                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",                                    ["Op1Type"] = "SveMaskPattern"}),
        ("SveCreateTrueMaskTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_CreateTrueMaskInt32",                                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateTrueMaskInt32",                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",                                    ["Op1Type"] = "SveMaskPattern"}),
        ("SveCreateTrueMaskTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_CreateTrueMaskInt64",                                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateTrueMaskInt64",                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",                                    ["Op1Type"] = "SveMaskPattern"}),
        ("SveCreateTrueMaskTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_CreateTrueMaskSByte",                                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateTrueMaskSByte",                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",                                    ["Op1Type"] = "SveMaskPattern"}),
        ("SveCreateTrueMaskTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_CreateTrueMaskSingle",                                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateTrueMaskSingle",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",                                   ["Op1Type"] = "SveMaskPattern"}),
        ("SveCreateTrueMaskTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_CreateTrueMaskUInt16",                                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateTrueMaskUInt16",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",                                   ["Op1Type"] = "SveMaskPattern"}),
        ("SveCreateTrueMaskTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_CreateTrueMaskUInt32",                                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateTrueMaskUInt32",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",                                   ["Op1Type"] = "SveMaskPattern"}),
        ("SveCreateTrueMaskTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_CreateTrueMaskUInt64",                                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateTrueMaskUInt64",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",                                   ["Op1Type"] = "SveMaskPattern"}),

        // ("SveGatherPrefetchVectorBases.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch16Bit_Bases_ushort_uint",                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch16Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                  ["Op3BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",                              ["NextValueOp1"] = "Helpers.getMaskUInt16()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                        ["ValidPrefetch"] = "SvePrefetchType.LoadL1NonTemporal",  ["InvalidPrefetch"] = "(SvePrefetchType)100"}),
        // ("SveGatherPrefetchVectorBases.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch16Bit_Bases_short_uint",                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch16Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                  ["Op3BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",                              ["NextValueOp1"] = "Helpers.getMaskInt16()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                        ["ValidPrefetch"] = "SvePrefetchType.LoadL2NonTemporal",  ["InvalidPrefetch"] = "(SvePrefetchType)16"}),
        ("SveGatherPrefetchVectorBases.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch16Bit_Bases_ushort_ulong",                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch16Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                  ["Op3BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",                              ["NextValueOp1"] = "Helpers.getMaskUInt16()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                        ["ValidPrefetch"] = "SvePrefetchType.StoreL1Temporal",    ["InvalidPrefetch"] = "(SvePrefetchType)58"}),
        ("SveGatherPrefetchVectorBases.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch16Bit_Bases_short_ulong",                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch16Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                  ["Op3BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",                              ["NextValueOp1"] = "Helpers.getMaskInt16()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                        ["ValidPrefetch"] = "SvePrefetchType.StoreL2NonTemporal", ["InvalidPrefetch"] = "(SvePrefetchType)123"}),
        ("SveGatherPrefetchIndices.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch16Bit_Indices_ushort_int",                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch16Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                  ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",    ["NextValueOp1"] = "Helpers.getMaskUInt16()",                                      ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidPrefetch"] = "SvePrefetchType.LoadL1NonTemporal",  ["InvalidPrefetch"] = "(SvePrefetchType)100"}),
        ("SveGatherPrefetchIndices.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch16Bit_Indices_short_int",                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch16Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                   ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",    ["NextValueOp1"] = "Helpers.getMaskInt16()",                                       ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidPrefetch"] = "SvePrefetchType.LoadL1Temporal",     ["InvalidPrefetch"] = "(SvePrefetchType)54"}),
        ("SveGatherPrefetchIndices.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch16Bit_Indices_ushort_uint",                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch16Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                  ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",   ["NextValueOp1"] = "Helpers.getMaskUInt16()",                                      ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidPrefetch"] = "SvePrefetchType.StoreL3NonTemporal", ["InvalidPrefetch"] = "(SvePrefetchType)32"}),
        ("SveGatherPrefetchIndices.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch16Bit_Indices_short_uint",                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch16Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                   ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",   ["NextValueOp1"] = "Helpers.getMaskInt16()",                                       ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidPrefetch"] = "SvePrefetchType.LoadL1Temporal",     ["InvalidPrefetch"] = "(SvePrefetchType)17"}),
        ("SveGatherPrefetchIndices.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch16Bit_Indices_ushort_long",                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch16Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                  ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",    ["NextValueOp1"] = "Helpers.getMaskUInt16()",                                      ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                         ["ValidPrefetch"] = "SvePrefetchType.StoreL1Temporal",    ["InvalidPrefetch"] = "(SvePrefetchType)56"}),
        ("SveGatherPrefetchIndices.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch16Bit_Indices_short_long",                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch16Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                   ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",    ["NextValueOp1"] = "Helpers.getMaskInt16()",                                       ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                         ["ValidPrefetch"] = "SvePrefetchType.StoreL3Temporal",    ["InvalidPrefetch"] = "(SvePrefetchType)123"}),
        ("SveGatherPrefetchIndices.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch16Bit_Indices_ushort_ulong",                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch16Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                  ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",   ["NextValueOp1"] = "Helpers.getMaskUInt16()",                                      ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                        ["ValidPrefetch"] = "SvePrefetchType.LoadL1Temporal",     ["InvalidPrefetch"] = "(SvePrefetchType)99"}),
        ("SveGatherPrefetchIndices.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch16Bit_Indices_short_ulong",                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch16Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                   ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",   ["NextValueOp1"] = "Helpers.getMaskInt16()",                                       ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                        ["ValidPrefetch"] = "SvePrefetchType.LoadL1Temporal",     ["InvalidPrefetch"] = "(SvePrefetchType)254"}),
        // ("SveGatherPrefetchVectorBases.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch32Bit_Bases_uint_uint",                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch32Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                  ["Op3BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",                              ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                        ["ValidPrefetch"] = "SvePrefetchType.LoadL1Temporal",     ["InvalidPrefetch"] = "(SvePrefetchType)230"}),
        // ("SveGatherPrefetchVectorBases.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch32Bit_Bases_int_uint",                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch32Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                  ["Op3BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",                              ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                        ["ValidPrefetch"] = "SvePrefetchType.LoadL2Temporal",     ["InvalidPrefetch"] = "(SvePrefetchType)23"}),
        ("SveGatherPrefetchVectorBases.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch32Bit_Bases_uint_ulong",                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch32Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                  ["Op3BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",                              ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                        ["ValidPrefetch"] = "SvePrefetchType.LoadL3Temporal",     ["InvalidPrefetch"] = "(SvePrefetchType)22"}),
        ("SveGatherPrefetchVectorBases.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch32Bit_Bases_int_ulong",                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch32Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                  ["Op3BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",                              ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                        ["ValidPrefetch"] = "SvePrefetchType.StoreL3Temporal",    ["InvalidPrefetch"] = "(SvePrefetchType)99"}),
        ("SveGatherPrefetchIndices.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch32Bit_Indices_uint_int",                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch32Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",    ["NextValueOp1"] = "Helpers.getMaskUInt32()",                                      ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidPrefetch"] = "SvePrefetchType.StoreL1NonTemporal", ["InvalidPrefetch"] = "(SvePrefetchType)16"}),
        ("SveGatherPrefetchIndices.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch32Bit_Indices_int_int",                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch32Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",    ["NextValueOp1"] = "Helpers.getMaskInt32()",                                       ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidPrefetch"] = "SvePrefetchType.LoadL1Temporal",     ["InvalidPrefetch"] = "(SvePrefetchType)101"}),
        ("SveGatherPrefetchIndices.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch32Bit_Indices_uint_uint",                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch32Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",   ["NextValueOp1"] = "Helpers.getMaskUInt32()",                                      ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidPrefetch"] = "SvePrefetchType.LoadL2NonTemporal",  ["InvalidPrefetch"] = "(SvePrefetchType)165"}),
        ("SveGatherPrefetchIndices.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch32Bit_Indices_int_uint",                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch32Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",   ["NextValueOp1"] = "Helpers.getMaskInt32()",                                       ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidPrefetch"] = "SvePrefetchType.LoadL2NonTemporal",  ["InvalidPrefetch"] = "(SvePrefetchType)82"}),
        ("SveGatherPrefetchIndices.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch32Bit_Indices_uint_long",                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch32Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",    ["NextValueOp1"] = "Helpers.getMaskUInt32()",                                      ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                         ["ValidPrefetch"] = "SvePrefetchType.StoreL3NonTemporal", ["InvalidPrefetch"] = "(SvePrefetchType)35"}),
        ("SveGatherPrefetchIndices.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch32Bit_Indices_int_long",                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch32Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",    ["NextValueOp1"] = "Helpers.getMaskInt32()",                                       ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                         ["ValidPrefetch"] = "SvePrefetchType.LoadL1Temporal",     ["InvalidPrefetch"] = "(SvePrefetchType)134"}),
        ("SveGatherPrefetchIndices.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch32Bit_Indices_uint_ulong",                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch32Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",   ["NextValueOp1"] = "Helpers.getMaskUInt32()",                                      ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                        ["ValidPrefetch"] = "SvePrefetchType.LoadL3NonTemporal",  ["InvalidPrefetch"] = "(SvePrefetchType)35"}),
        ("SveGatherPrefetchIndices.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch32Bit_Indices_int_ulong",                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch32Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",   ["NextValueOp1"] = "Helpers.getMaskInt32()",                                       ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                        ["ValidPrefetch"] = "SvePrefetchType.StoreL3NonTemporal", ["InvalidPrefetch"] = "(SvePrefetchType)153"}),
        // ("SveGatherPrefetchVectorBases.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch64Bit_Bases_ulong_uint",                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch64Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                  ["Op3BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",                              ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                        ["ValidPrefetch"] = "SvePrefetchType.StoreL2NonTemporal", ["InvalidPrefetch"] = "(SvePrefetchType)100"}),
        // ("SveGatherPrefetchVectorBases.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch64Bit_Bases_long_uint",                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch64Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                  ["Op3BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",                              ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                        ["ValidPrefetch"] = "SvePrefetchType.StoreL2Temporal",    ["InvalidPrefetch"] = "(SvePrefetchType)100"}),
        ("SveGatherPrefetchVectorBases.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch64Bit_Bases_ulong_ulong",                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch64Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                  ["Op3BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",                              ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                        ["ValidPrefetch"] = "SvePrefetchType.LoadL3NonTemporal",  ["InvalidPrefetch"] = "(SvePrefetchType)100"}),
        ("SveGatherPrefetchVectorBases.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch64Bit_Bases_long_ulong",                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch64Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                  ["Op3BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",                              ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                        ["ValidPrefetch"] = "SvePrefetchType.LoadL2NonTemporal",  ["InvalidPrefetch"] = "(SvePrefetchType)100"}),
        ("SveGatherPrefetchIndices.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch64Bit_Indices_ulong_int",                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch64Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",    ["NextValueOp1"] = "Helpers.getMaskUInt64()",                                      ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidPrefetch"] = "SvePrefetchType.StoreL3Temporal",    ["InvalidPrefetch"] = "(SvePrefetchType)242"}),
        ("SveGatherPrefetchIndices.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch64Bit_Indices_long_int",                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch64Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",    ["NextValueOp1"] = "Helpers.getMaskInt64()",                                       ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidPrefetch"] = "SvePrefetchType.StoreL1NonTemporal", ["InvalidPrefetch"] = "(SvePrefetchType)232"}),
        ("SveGatherPrefetchIndices.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch64Bit_Indices_ulong_uint",                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch64Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",   ["NextValueOp1"] = "Helpers.getMaskUInt64()",                                      ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidPrefetch"] = "SvePrefetchType.StoreL1NonTemporal", ["InvalidPrefetch"] = "(SvePrefetchType)223"}),
        ("SveGatherPrefetchIndices.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch64Bit_Indices_long_uint",                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch64Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",   ["NextValueOp1"] = "Helpers.getMaskInt64()",                                       ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidPrefetch"] = "SvePrefetchType.LoadL1Temporal",     ["InvalidPrefetch"] = "(SvePrefetchType)62"}),
        ("SveGatherPrefetchIndices.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch64Bit_Indices_ulong_long",                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch64Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",    ["NextValueOp1"] = "Helpers.getMaskUInt64()",                                      ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                         ["ValidPrefetch"] = "SvePrefetchType.StoreL1Temporal",    ["InvalidPrefetch"] = "(SvePrefetchType)43"}),
        ("SveGatherPrefetchIndices.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch64Bit_Indices_long_long",                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch64Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",    ["NextValueOp1"] = "Helpers.getMaskInt64()",                                       ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                         ["ValidPrefetch"] = "SvePrefetchType.LoadL3NonTemporal",  ["InvalidPrefetch"] = "(SvePrefetchType)166"}),
        ("SveGatherPrefetchIndices.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch64Bit_Indices_ulong_ulong",                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch64Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",   ["NextValueOp1"] = "Helpers.getMaskUInt64()",                                      ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                        ["ValidPrefetch"] = "SvePrefetchType.LoadL2NonTemporal",  ["InvalidPrefetch"] = "(SvePrefetchType)234"}),
        ("SveGatherPrefetchIndices.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch64Bit_Indices_long_ulong",                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch64Bit",                                                                                   ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",   ["NextValueOp1"] = "Helpers.getMaskInt64()",                                       ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                        ["ValidPrefetch"] = "SvePrefetchType.StoreL1NonTemporal", ["InvalidPrefetch"] = "(SvePrefetchType)46"}),
        // ("SveGatherPrefetchVectorBases.template",    new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch8Bit_Bases_byte_uint",                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch8Bit",                                                                                    ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                  ["Op3BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",                              ["NextValueOp1"] = "Helpers.getMaskByte()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                        ["ValidPrefetch"] = "SvePrefetchType.StoreL2Temporal",    ["InvalidPrefetch"] = "(SvePrefetchType)100"}),
        // ("SveGatherPrefetchVectorBases.template",    new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch8Bit_Bases_sbyte_uint",                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch8Bit",                                                                                    ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                  ["Op3BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",                              ["NextValueOp1"] = "Helpers.getMaskSByte()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                        ["ValidPrefetch"] = "SvePrefetchType.LoadL3NonTemporal",  ["InvalidPrefetch"] = "(SvePrefetchType)100"}),
        ("SveGatherPrefetchVectorBases.template",    new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch8Bit_Bases_byte_ulong",                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch8Bit",                                                                                    ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                  ["Op3BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",                              ["NextValueOp1"] = "Helpers.getMaskByte()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                        ["ValidPrefetch"] = "SvePrefetchType.LoadL1NonTemporal",  ["InvalidPrefetch"] = "(SvePrefetchType)100"}),
        ("SveGatherPrefetchVectorBases.template",    new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch8Bit_Bases_sbyte_ulong",                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch8Bit",                                                                                    ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                  ["Op3BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",                              ["NextValueOp1"] = "Helpers.getMaskSByte()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                        ["ValidPrefetch"] = "SvePrefetchType.StoreL2NonTemporal", ["InvalidPrefetch"] = "(SvePrefetchType)100"}),
        ("SveGatherPrefetchIndices.template",    new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch8Bit_Indices_byte_int",                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch8Bit",                                                                                    ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",                                    ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",    ["NextValueOp1"] = "Helpers.getMaskByte()",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidPrefetch"] = "SvePrefetchType.StoreL3Temporal",    ["InvalidPrefetch"] = "(SvePrefetchType)51"}),
        ("SveGatherPrefetchIndices.template",    new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch8Bit_Indices_sbyte_int",                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch8Bit",                                                                                    ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                   ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",    ["NextValueOp1"] = "Helpers.getMaskSByte()",                                       ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidPrefetch"] = "SvePrefetchType.StoreL1Temporal",    ["InvalidPrefetch"] = "(SvePrefetchType)82"}),
        ("SveGatherPrefetchIndices.template",    new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch8Bit_Indices_byte_uint",                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch8Bit",                                                                                    ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",                                    ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",   ["NextValueOp1"] = "Helpers.getMaskByte()",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidPrefetch"] = "SvePrefetchType.LoadL2Temporal",     ["InvalidPrefetch"] = "(SvePrefetchType)236"}),
        ("SveGatherPrefetchIndices.template",    new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch8Bit_Indices_sbyte_uint",                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch8Bit",                                                                                    ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                   ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",   ["NextValueOp1"] = "Helpers.getMaskSByte()",                                       ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidPrefetch"] = "SvePrefetchType.LoadL1NonTemporal",  ["InvalidPrefetch"] = "(SvePrefetchType)45"}),
        ("SveGatherPrefetchIndices.template",    new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch8Bit_Indices_byte_long",                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch8Bit",                                                                                    ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",                                    ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",    ["NextValueOp1"] = "Helpers.getMaskByte()",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                         ["ValidPrefetch"] = "SvePrefetchType.LoadL1Temporal",     ["InvalidPrefetch"] = "(SvePrefetchType)34"}),
        ("SveGatherPrefetchIndices.template",    new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch8Bit_Indices_sbyte_long",                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch8Bit",                                                                                    ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                   ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",    ["NextValueOp1"] = "Helpers.getMaskSByte()",                                       ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                         ["ValidPrefetch"] = "SvePrefetchType.StoreL3NonTemporal", ["InvalidPrefetch"] = "(SvePrefetchType)43"}),
        ("SveGatherPrefetchIndices.template",    new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch8Bit_Indices_byte_ulong",                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch8Bit",                                                                                    ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",                                    ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",   ["NextValueOp1"] = "Helpers.getMaskByte()",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                        ["ValidPrefetch"] = "SvePrefetchType.StoreL3Temporal",    ["InvalidPrefetch"] = "(SvePrefetchType)234"}),
        ("SveGatherPrefetchIndices.template",    new Dictionary<string, string> { ["TestName"] = "Sve_GatherPrefetch8Bit_Indices_sbyte_ulong",                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherPrefetch8Bit",                                                                                    ["RetBaseType"] = "void",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                   ["Op2BaseType"] = "void",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64",["Op4BaseType"] = "SvePrefetchType",["LargestVectorSize"] = "64",   ["NextValueOp1"] = "Helpers.getMaskSByte()",                                       ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                        ["ValidPrefetch"] = "SvePrefetchType.StoreL1Temporal",    ["InvalidPrefetch"] = "(SvePrefetchType)86"}),

        ("SveVecImmUnOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve_DuplicateSelectedScalarToVector_float",                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "DuplicateSelectedScalarToVector",                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                              ["InvalidImm"] = "16",   ["Imm"] = "(Byte)11", ["ValidateIterResult"] = "result[i] != (Imm < Op1ElementCount ? firstOp[Imm] : 0)", ["GetIterResult"] = "(Single)(Imm < Op1ElementCount ? firstOp[Imm] : 0)"}),
        ("SveVecImmUnOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve_DuplicateSelectedScalarToVector_double",                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "DuplicateSelectedScalarToVector",                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                              ["InvalidImm"] = "8",    ["Imm"] = "(Byte)2",  ["ValidateIterResult"] = "result[i] != (Imm < Op1ElementCount ? firstOp[Imm] : 0)", ["GetIterResult"] = "(Double)(Imm < Op1ElementCount ? firstOp[Imm] : 0)"}),
        ("SveVecImmUnOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve_DuplicateSelectedScalarToVector_sbyte",                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "DuplicateSelectedScalarToVector",                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                               ["InvalidImm"] = "64",   ["Imm"] = "(Byte)47", ["ValidateIterResult"] = "result[i] != (Imm < Op1ElementCount ? firstOp[Imm] : 0)", ["GetIterResult"] = "(SByte)(Imm < Op1ElementCount ? firstOp[Imm] : 0)"}),
        ("SveVecImmUnOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve_DuplicateSelectedScalarToVector_short",                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "DuplicateSelectedScalarToVector",                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                               ["InvalidImm"] = "32",   ["Imm"] = "(Byte)30", ["ValidateIterResult"] = "result[i] != (Imm < Op1ElementCount ? firstOp[Imm] : 0)", ["GetIterResult"] = "(Int16)(Imm < Op1ElementCount ? firstOp[Imm] : 0)"}),
        ("SveVecImmUnOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve_DuplicateSelectedScalarToVector_int",                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "DuplicateSelectedScalarToVector",                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                               ["InvalidImm"] = "16",   ["Imm"] = "(Byte)4",  ["ValidateIterResult"] = "result[i] != (Imm < Op1ElementCount ? firstOp[Imm] : 0)", ["GetIterResult"] = "(Int32)(Imm < Op1ElementCount ? firstOp[Imm] : 0)"}),
        ("SveVecImmUnOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve_DuplicateSelectedScalarToVector_long",                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "DuplicateSelectedScalarToVector",                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                               ["InvalidImm"] = "8",    ["Imm"] = "(Byte)5",  ["ValidateIterResult"] = "result[i] != (Imm < Op1ElementCount ? firstOp[Imm] : 0)", ["GetIterResult"] = "(Int64)(Imm < Op1ElementCount ? firstOp[Imm] : 0)"}),
        ("SveVecImmUnOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve_DuplicateSelectedScalarToVector_byte",                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "DuplicateSelectedScalarToVector",                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                ["InvalidImm"] = "64",   ["Imm"] = "(Byte)17", ["ValidateIterResult"] = "result[i] != (Imm < Op1ElementCount ? firstOp[Imm] : 0)", ["GetIterResult"] = "(Byte)(Imm < Op1ElementCount ? firstOp[Imm] : 0)"}),
        ("SveVecImmUnOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve_DuplicateSelectedScalarToVector_ushort",                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "DuplicateSelectedScalarToVector",                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                              ["InvalidImm"] = "32",   ["Imm"] = "(Byte)25", ["ValidateIterResult"] = "result[i] != (Imm < Op1ElementCount ? firstOp[Imm] : 0)", ["GetIterResult"] = "(UInt16)(Imm < Op1ElementCount ? firstOp[Imm] : 0)"}),
        ("SveVecImmUnOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve_DuplicateSelectedScalarToVector_uint",                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "DuplicateSelectedScalarToVector",                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                              ["InvalidImm"] = "16",   ["Imm"] = "(Byte)14", ["ValidateIterResult"] = "result[i] != (Imm < Op1ElementCount ? firstOp[Imm] : 0)", ["GetIterResult"] = "(UInt32)(Imm < Op1ElementCount ? firstOp[Imm] : 0)"}),
        ("SveVecImmUnOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve_DuplicateSelectedScalarToVector_ulong",                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "DuplicateSelectedScalarToVector",                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                              ["InvalidImm"] = "8",    ["Imm"] = "(Byte)1",  ["ValidateIterResult"] = "result[i] != (Imm < Op1ElementCount ? firstOp[Imm] : 0)", ["GetIterResult"] = "(UInt64)(Imm < Op1ElementCount ? firstOp[Imm] : 0)"}),

        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateMaskForFirstActiveElement_sbyte",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateMaskForFirstActiveElement",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskSByte()",  ["NextValueOp2"] = "Helpers.getMaskSByte()",                                                                                         ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateMaskForFirstActiveElement(left, right))",        ["GetVectorResult"] = "Helpers.CreateMaskForFirstActiveElement(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateMaskForFirstActiveElement_short",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateMaskForFirstActiveElement",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskInt16()",  ["NextValueOp2"] = "Helpers.getMaskInt16()",                                                                                         ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateMaskForFirstActiveElement(left, right))",        ["GetVectorResult"] = "Helpers.CreateMaskForFirstActiveElement(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateMaskForFirstActiveElement_int",                                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateMaskForFirstActiveElement",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskInt32()",  ["NextValueOp2"] = "Helpers.getMaskInt32()",                                                                                         ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateMaskForFirstActiveElement(left, right))",        ["GetVectorResult"] = "Helpers.CreateMaskForFirstActiveElement(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateMaskForFirstActiveElement_long",                                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateMaskForFirstActiveElement",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskInt64()",  ["NextValueOp2"] = "Helpers.getMaskInt64()",                                                                                         ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateMaskForFirstActiveElement(left, right))",        ["GetVectorResult"] = "Helpers.CreateMaskForFirstActiveElement(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateMaskForFirstActiveElement_byte",                                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateMaskForFirstActiveElement",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskByte()",   ["NextValueOp2"] = "Helpers.getMaskByte()",                                                                                          ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateMaskForFirstActiveElement(left, right))",        ["GetVectorResult"] = "Helpers.CreateMaskForFirstActiveElement(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateMaskForFirstActiveElement_ushort",                                                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateMaskForFirstActiveElement",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskUInt16()", ["NextValueOp2"] = "Helpers.getMaskUInt16()",                                                                                        ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateMaskForFirstActiveElement(left, right))",        ["GetVectorResult"] = "Helpers.CreateMaskForFirstActiveElement(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateMaskForFirstActiveElement_uint",                                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateMaskForFirstActiveElement",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskUInt32()", ["NextValueOp2"] = "Helpers.getMaskUInt32()",                                                                                        ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateMaskForFirstActiveElement(left, right))",        ["GetVectorResult"] = "Helpers.CreateMaskForFirstActiveElement(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateMaskForFirstActiveElement_ulong",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateMaskForFirstActiveElement",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskUInt64()", ["NextValueOp2"] = "Helpers.getMaskUInt64()",                                                                                        ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateMaskForFirstActiveElement(left, right))",        ["GetVectorResult"] = "Helpers.CreateMaskForFirstActiveElement(left, right)"}),

        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateMaskForNextActiveElement_byte",                                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateMaskForNextActiveElement",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskByte()",   ["NextValueOp2"] = "Helpers.getMaskByte()",                                                                                          ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateMaskForNextActiveElement(left, right))",        ["GetVectorResult"] = "Helpers.CreateMaskForNextActiveElement(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateMaskForNextActiveElement_ushort",                                                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateMaskForNextActiveElement",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskUInt16()", ["NextValueOp2"] = "Helpers.getMaskUInt16()",                                                                                        ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateMaskForNextActiveElement(left, right))",        ["GetVectorResult"] = "Helpers.CreateMaskForNextActiveElement(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateMaskForNextActiveElement_uint",                                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateMaskForNextActiveElement",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskUInt32()", ["NextValueOp2"] = "Helpers.getMaskUInt32()",                                                                                        ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateMaskForNextActiveElement(left, right))",        ["GetVectorResult"] = "Helpers.CreateMaskForNextActiveElement(left, right)"}),
        ("SveVecBinOpVecTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_CreateMaskForNextActiveElement_ulong",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "CreateMaskForNextActiveElement",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "Helpers.getMaskUInt64()", ["NextValueOp2"] = "Helpers.getMaskUInt64()",                                                                                        ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.CreateMaskForNextActiveElement(left, right))",        ["GetVectorResult"] = "Helpers.CreateMaskForNextActiveElement(left, right)"}),

        ("SveSimpleVecOpNarrowingTest.template", new Dictionary<string, string> {["TestName"] = "Sve_FloatingPointExponentialAccelerator_float_uint",                                                    ["Isa"] = "Sve",       ["LoadIsa"] = "Sve", ["Method"] = "FloatingPointExponentialAccelerator",                               ["RetVectorType"] = "Vector", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector", ["Op1BaseType"] = "UInt32",                                                                                                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                                      ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.FPExponentialAccelerator(firstOp[i])) != BitConverter.SingleToInt32Bits(result[i])", ["GetIterResult"] = "Helpers.FPExponentialAccelerator(leftOp[i])", ["ConvertFunc"] = "BitConverter.SingleToInt32Bits"}),
        ("SveSimpleVecOpNarrowingTest.template", new Dictionary<string, string> {["TestName"] = "Sve_FloatingPointExponentialAccelerator_double_ulong",                                                  ["Isa"] = "Sve",       ["LoadIsa"] = "Sve", ["Method"] = "FloatingPointExponentialAccelerator",                               ["RetVectorType"] = "Vector", ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector", ["Op1BaseType"] = "UInt64",                                                                                                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                                                      ["ValidateIterResult"] = "BitConverter.DoubleToInt64Bits(Helpers.FPExponentialAccelerator(firstOp[i])) != BitConverter.DoubleToInt64Bits(result[i])", ["GetIterResult"] = "Helpers.FPExponentialAccelerator(leftOp[i])", ["ConvertFunc"] = "BitConverter.DoubleToInt64Bits"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_ExtractAfterLastActiveElement_byte",                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractAfterLastActiveElement",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                          ["ValidateIterResult"] = "Helpers.ExtractAfterLastActiveElement(left, right)[i] != result[i]",               ["GetIterResult"] = "Helpers.ExtractAfterLastActiveElement(left, right)[i]",                                                        ["ConvertFunc"] = " ",}),
        ("SveScalarBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_ExtractAfterLastActiveElement_byte_scalar",                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractAfterLastActiveElementScalar",                                                                   ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateScalarResult"] = "Helpers.ExtractAfterLastActiveElementScalar(left, right) != result",}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_ExtractAfterLastActiveElement_short",                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractAfterLastActiveElement",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                         ["ValidateIterResult"] = "Helpers.ExtractAfterLastActiveElement(left, right)[i] != result[i]",               ["GetIterResult"] = "Helpers.ExtractAfterLastActiveElement(left, right)[i]",                                                        ["ConvertFunc"] = " ",}),
        ("SveScalarBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_ExtractAfterLastActiveElement_short_scalar",                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractAfterLastActiveElementScalar",                                                                   ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateScalarResult"] = "Helpers.ExtractAfterLastActiveElementScalar(left, right) != result",}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_ExtractAfterLastActiveElement_int",                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractAfterLastActiveElement",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                         ["ValidateIterResult"] = "Helpers.ExtractAfterLastActiveElement(left, right)[i] != result[i]",               ["GetIterResult"] = "Helpers.ExtractAfterLastActiveElement(left, right)[i]",                                                        ["ConvertFunc"] = " ",}),
        ("SveScalarBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_ExtractAfterLastActiveElement_int_scalar",                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractAfterLastActiveElementScalar",                                                                   ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateScalarResult"] = "Helpers.ExtractAfterLastActiveElementScalar(left, right) != result",}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_ExtractAfterLastActiveElement_long",                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractAfterLastActiveElement",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                         ["ValidateIterResult"] = "Helpers.ExtractAfterLastActiveElement(left, right)[i] != result[i]",               ["GetIterResult"] = "Helpers.ExtractAfterLastActiveElement(left, right)[i]",                                                        ["ConvertFunc"] = " ",}),
        ("SveScalarBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_ExtractAfterLastActiveElement_long_scalar",                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractAfterLastActiveElementScalar",                                                                   ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ValidateScalarResult"] = "Helpers.ExtractAfterLastActiveElementScalar(left, right) != result",}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_ExtractAfterLastActiveElement_sbyte",                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractAfterLastActiveElement",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                         ["ValidateIterResult"] = "Helpers.ExtractAfterLastActiveElement(left, right)[i] != result[i]",               ["GetIterResult"] = "Helpers.ExtractAfterLastActiveElement(left, right)[i]",                                                        ["ConvertFunc"] = " ",}),
        ("SveScalarBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_ExtractAfterLastActiveElement_sbyte_scalar",                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractAfterLastActiveElementScalar",                                                                   ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateScalarResult"] = "Helpers.ExtractAfterLastActiveElementScalar(left, right) != result",}),
    ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_ExtractAfterLastActiveElement_ushort",                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractAfterLastActiveElement",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.ExtractAfterLastActiveElement(left, right)[i] != result[i]",               ["GetIterResult"] = "Helpers.ExtractAfterLastActiveElement(left, right)[i]",                                                        ["ConvertFunc"] = " ",}),
        ("SveScalarBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_ExtractAfterLastActiveElement_ushort_scalar",                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractAfterLastActiveElementScalar",                                                                   ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateScalarResult"] = "Helpers.ExtractAfterLastActiveElementScalar(left, right) != result",}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_ExtractAfterLastActiveElement_uint",                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractAfterLastActiveElement",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.ExtractAfterLastActiveElement(left, right)[i] != result[i]",               ["GetIterResult"] = "Helpers.ExtractAfterLastActiveElement(left, right)[i]",                                                        ["ConvertFunc"] = " ",}),
        ("SveScalarBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_ExtractAfterLastActiveElement_uint_scalar",                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractAfterLastActiveElementScalar",                                                                   ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateScalarResult"] = "Helpers.ExtractAfterLastActiveElementScalar(left, right) != result",}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_ExtractAfterLastActiveElement_ulong",                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractAfterLastActiveElement",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                        ["ValidateIterResult"] = "Helpers.ExtractAfterLastActiveElement(left, right)[i] != result[i]",               ["GetIterResult"] = "Helpers.ExtractAfterLastActiveElement(left, right)[i]",                                                        ["ConvertFunc"] = " ",}),
        ("SveScalarBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_ExtractAfterLastActiveElement_ulong_scalar",                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractAfterLastActiveElementScalar",                                                                   ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ValidateScalarResult"] = "Helpers.ExtractAfterLastActiveElementScalar(left, right) != result",}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_ExtractAfterLastActiveElement_float",                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractAfterLastActiveElement",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                        ["ValidateIterResult"] = "Helpers.ExtractAfterLastActiveElement(left, right)[i] != result[i]",               ["GetIterResult"] = "Helpers.ExtractAfterLastActiveElement(left, right)[i]",                                                        ["ConvertFunc"] = " ",}),
        ("SveScalarBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_ExtractAfterLastActiveElement_float_scalar",                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractAfterLastActiveElementScalar",                                                                   ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateScalarResult"] = "Helpers.ExtractAfterLastActiveElementScalar(left, right) != result",}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_ExtractAfterLastActiveElement_double",                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractAfterLastActiveElement",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                        ["ValidateIterResult"] = "Helpers.ExtractAfterLastActiveElement(left, right)[i] != result[i]",               ["GetIterResult"] = "Helpers.ExtractAfterLastActiveElement(left, right)[i]",                                                        ["ConvertFunc"] = " ",}),
        ("SveScalarBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_ExtractAfterLastActiveElement_double_scalar",                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractAfterLastActiveElementScalar",                                                                   ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                       ["ValidateScalarResult"] = "Helpers.ExtractAfterLastActiveElementScalar(left, right) != result",}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_ExtractLastActiveElement_byte",                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractLastActiveElement",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                          ["ValidateIterResult"] = "Helpers.ExtractLastActiveElement(left, right)[i] != result[i]",                    ["GetIterResult"] = "Helpers.ExtractLastActiveElement(left, right)[i]",                                                             ["ConvertFunc"] = " ",}),
        ("SveScalarBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_ExtractLastActiveElement_byte_scalar",                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractLastActiveElementScalar",                                                                        ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateScalarResult"] = "Helpers.ExtractLastActiveElementScalar(left, right) != result",}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_ExtractLastActiveElement_short",                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractLastActiveElement",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                         ["ValidateIterResult"] = "Helpers.ExtractLastActiveElement(left, right)[i] != result[i]",                    ["GetIterResult"] = "Helpers.ExtractLastActiveElement(left, right)[i]",                                                             ["ConvertFunc"] = " ",}),
        ("SveScalarBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_ExtractLastActiveElement_short_scalar",                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractLastActiveElementScalar",                                                                        ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateScalarResult"] = "Helpers.ExtractLastActiveElementScalar(left, right) != result",}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_ExtractLastActiveElement_int",                                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractLastActiveElement",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                         ["ValidateIterResult"] = "Helpers.ExtractLastActiveElement(left, right)[i] != result[i]",                    ["GetIterResult"] = "Helpers.ExtractLastActiveElement(left, right)[i]",                                                             ["ConvertFunc"] = " ",}),
        ("SveScalarBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_ExtractLastActiveElement_int_scalar",                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractLastActiveElementScalar",                                                                        ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateScalarResult"] = "Helpers.ExtractLastActiveElementScalar(left, right) != result",}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_ExtractLastActiveElement_long",                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractLastActiveElement",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                         ["ValidateIterResult"] = "Helpers.ExtractLastActiveElement(left, right)[i] != result[i]",                    ["GetIterResult"] = "Helpers.ExtractLastActiveElement(left, right)[i]",                                                             ["ConvertFunc"] = " ",}),
        ("SveScalarBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_ExtractLastActiveElement_long_scalar",                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractLastActiveElementScalar",                                                                        ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ValidateScalarResult"] = "Helpers.ExtractLastActiveElementScalar(left, right) != result",}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_ExtractLastActiveElement_sbyte",                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractLastActiveElement",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                         ["ValidateIterResult"] = "Helpers.ExtractLastActiveElement(left, right)[i] != result[i]",                    ["GetIterResult"] = "Helpers.ExtractLastActiveElement(left, right)[i]",                                                             ["ConvertFunc"] = " ",}),
        ("SveScalarBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_ExtractLastActiveElement_sbyte_scalar",                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractLastActiveElementScalar",                                                                        ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateScalarResult"] = "Helpers.ExtractLastActiveElementScalar(left, right) != result",}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_ExtractLastActiveElement_ushort",                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractLastActiveElement",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.ExtractLastActiveElement(left, right)[i] != result[i]",                    ["GetIterResult"] = "Helpers.ExtractLastActiveElement(left, right)[i]",                                                             ["ConvertFunc"] = " ",}),
        ("SveScalarBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_ExtractLastActiveElement_ushort_scalar",                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractLastActiveElementScalar",                                                                        ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateScalarResult"] = "Helpers.ExtractLastActiveElementScalar(left, right) != result",}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_ExtractLastActiveElement_uint",                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractLastActiveElement",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.ExtractLastActiveElement(left, right)[i] != result[i]",                    ["GetIterResult"] = "Helpers.ExtractLastActiveElement(left, right)[i]",                                                             ["ConvertFunc"] = " ",}),
        ("SveScalarBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_ExtractLastActiveElement_uint_scalar",                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractLastActiveElementScalar",                                                                        ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateScalarResult"] = "Helpers.ExtractLastActiveElementScalar(left, right) != result",}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_ExtractLastActiveElement_ulong",                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractLastActiveElement",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                        ["ValidateIterResult"] = "Helpers.ExtractLastActiveElement(left, right)[i] != result[i]",                    ["GetIterResult"] = "Helpers.ExtractLastActiveElement(left, right)[i]",                                                             ["ConvertFunc"] = " ",}),
        ("SveScalarBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_ExtractLastActiveElement_ulong_scalar",                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractLastActiveElementScalar",                                                                        ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ValidateScalarResult"] = "Helpers.ExtractLastActiveElementScalar(left, right) != result",}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_ExtractLastActiveElement_float",                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractLastActiveElement",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                        ["ValidateIterResult"] = "Helpers.ExtractLastActiveElement(left, right)[i] != result[i]",                    ["GetIterResult"] = "Helpers.ExtractLastActiveElement(left, right)[i]",                                                             ["ConvertFunc"] = " ",}),
        ("SveScalarBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_ExtractLastActiveElement_float_scalar",                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractLastActiveElementScalar",                                                                        ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateScalarResult"] = "Helpers.ExtractLastActiveElementScalar(left, right) != result",}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_ExtractLastActiveElement_double",                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractLastActiveElement",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                        ["ValidateIterResult"] = "Helpers.ExtractLastActiveElement(left, right)[i] != result[i]",                    ["GetIterResult"] = "Helpers.ExtractLastActiveElement(left, right)[i]",                                                             ["ConvertFunc"] = " ",}),
        ("SveScalarBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_ExtractLastActiveElement_double_scalar",                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ExtractLastActiveElementScalar",                                                                        ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                       ["ValidateScalarResult"] = "Helpers.ExtractLastActiveElementScalar(left, right) != result",}),
        ("SveExtractVectorTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve_ExtractVector_Byte_1",                                                                               ["Isa"] = "Sve",       ["LoadIsa"] = "Sve", ["Method"] = "ExtractVector",                                                     ["RetVectorType"] = "Vector", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector", ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["ElementIndex"] = "1",                                                        ["ValidateIterResult"] = "Helpers.ExtractVector(firstOp, secondOp, ElementIndex, i) != result[i]"}),
        ("SveExtractVectorTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve_ExtractVector_Double_1",                                                                             ["Isa"] = "Sve",       ["LoadIsa"] = "Sve", ["Method"] = "ExtractVector",                                                     ["RetVectorType"] = "Vector", ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector", ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",        ["ElementIndex"] = "1",                                                        ["ValidateIterResult"] = "BitConverter.DoubleToInt64Bits(Helpers.ExtractVector(firstOp, secondOp, ElementIndex, i)) != BitConverter.DoubleToInt64Bits(result[i])"}),
        ("SveExtractVectorTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve_ExtractVector_Int16_1",                                                                              ["Isa"] = "Sve",       ["LoadIsa"] = "Sve", ["Method"] = "ExtractVector",                                                     ["RetVectorType"] = "Vector", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["ElementIndex"] = "1",                                                        ["ValidateIterResult"] = "Helpers.ExtractVector(firstOp, secondOp, ElementIndex, i) != result[i]"}),
        ("SveExtractVectorTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve_ExtractVector_Int32_1",                                                                              ["Isa"] = "Sve",       ["LoadIsa"] = "Sve", ["Method"] = "ExtractVector",                                                     ["RetVectorType"] = "Vector", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["ElementIndex"] = "1",                                                        ["ValidateIterResult"] = "Helpers.ExtractVector(firstOp, secondOp, ElementIndex, i) != result[i]"}),
        ("SveExtractVectorTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve_ExtractVector_Int64_1",                                                                              ["Isa"] = "Sve",       ["LoadIsa"] = "Sve", ["Method"] = "ExtractVector",                                                     ["RetVectorType"] = "Vector", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector", ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",         ["ElementIndex"] = "1",                                                        ["ValidateIterResult"] = "Helpers.ExtractVector(firstOp, secondOp, ElementIndex, i) != result[i]"}),
        ("SveExtractVectorTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve_ExtractVector_SByte_1",                                                                              ["Isa"] = "Sve",       ["LoadIsa"] = "Sve", ["Method"] = "ExtractVector",                                                     ["RetVectorType"] = "Vector", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector", ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["ElementIndex"] = "1",                                                        ["ValidateIterResult"] = "Helpers.ExtractVector(firstOp, secondOp, ElementIndex, i) != result[i]"}),
        ("SveExtractVectorTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve_ExtractVector_Single_1",                                                                             ["Isa"] = "Sve",       ["LoadIsa"] = "Sve", ["Method"] = "ExtractVector",                                                     ["RetVectorType"] = "Vector", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",        ["ElementIndex"] = "1",                                                        ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.ExtractVector(firstOp, secondOp, ElementIndex, i)) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("SveExtractVectorTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve_ExtractVector_UInt16_1",                                                                             ["Isa"] = "Sve",       ["LoadIsa"] = "Sve", ["Method"] = "ExtractVector",                                                     ["RetVectorType"] = "Vector", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["ElementIndex"] = "1",                                                        ["ValidateIterResult"] = "Helpers.ExtractVector(firstOp, secondOp, ElementIndex, i) != result[i]"}),
        ("SveExtractVectorTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve_ExtractVector_UInt32_1",                                                                             ["Isa"] = "Sve",       ["LoadIsa"] = "Sve", ["Method"] = "ExtractVector",                                                     ["RetVectorType"] = "Vector", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["ElementIndex"] = "1",                                                        ["ValidateIterResult"] = "Helpers.ExtractVector(firstOp, secondOp, ElementIndex, i) != result[i]"}),
        ("SveExtractVectorTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve_ExtractVector_UInt64_1",                                                                             ["Isa"] = "Sve",       ["LoadIsa"] = "Sve", ["Method"] = "ExtractVector",                                                     ["RetVectorType"] = "Vector", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector", ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["ElementIndex"] = "1",                                                        ["ValidateIterResult"] = "Helpers.ExtractVector(firstOp, secondOp, ElementIndex, i) != result[i]"}),

        ("SveFfrTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_Ffr_byte",                                                                                                            ["VectorBaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskByte()"}),
        ("SveFfrTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_Ffr_short",                                                                                                           ["VectorBaseType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt16()"}),
        ("SveFfrTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_Ffr_int",                                                                                                             ["VectorBaseType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()"}),
        ("SveFfrTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_Ffr_long",                                                                                                            ["VectorBaseType"] = "Int64",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()"}),
        ("SveFfrTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_Ffr_sbyte",                                                                                                           ["VectorBaseType"] = "SByte",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskSByte()"}),
        ("SveFfrTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_Ffr_ushort",                                                                                                          ["VectorBaseType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt16()"}),
        ("SveFfrTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_Ffr_uint",                                                                                                            ["VectorBaseType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()"}),
        ("SveFfrTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_Ffr_ulong",                                                                                                           ["VectorBaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()"}),
        
        // ("SveGatherVectorVectorBases.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVector_Bases_float_uint",                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVector",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                           ["ExtendedElementType"] = "Single", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskSingle()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                    ["NextValueBase"] = "TestLibrary.Generator.GetSingle()"}),
        // ("SveGatherVectorVectorBases.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVector_Bases_int_uint",                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVector",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                           ["ExtendedElementType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                    ["NextValueBase"] = "TestLibrary.Generator.GetInt32()"}),
        // ("SveGatherVectorVectorBases.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVector_Bases_uint_uint",                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVector",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                           ["ExtendedElementType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                    ["NextValueBase"] = "TestLibrary.Generator.GetUInt32()"}),
        ("SveGatherVectorVectorBases.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVector_Bases_double_ulong",                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVector",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["ExtendedElementType"] = "Double", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskDouble()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                    ["NextValueBase"] = "TestLibrary.Generator.GetDouble()"}),
        ("SveGatherVectorVectorBases.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVector_Bases_long_ulong",                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVector",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["ExtendedElementType"] = "Int64",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                    ["NextValueBase"] = "TestLibrary.Generator.GetInt64()"}),
        ("SveGatherVectorVectorBases.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVector_Bases_ulong_ulong",                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVector",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["ExtendedElementType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                    ["NextValueBase"] = "TestLibrary.Generator.GetUInt64()"}),
        ("SveGatherVector.template",            new Dictionary<string, string> { ["TestName"] = "Sve_GatherVector_Indices_float_int",                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVector",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                  ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "Single", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskSingle()",      ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",     ["AreOffsets"] = "false"}),
        ("SveGatherVector.template",            new Dictionary<string, string> { ["TestName"] = "Sve_GatherVector_Indices_int_int",                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVector",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",     ["AreOffsets"] = "false"}),
        ("SveGatherVector.template",            new Dictionary<string, string> { ["TestName"] = "Sve_GatherVector_Indices_uint_int",                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVector",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",     ["AreOffsets"] = "false"}),
        ("SveGatherVector.template",            new Dictionary<string, string> { ["TestName"] = "Sve_GatherVector_Indices_float_uint",                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVector",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                  ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "Single", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskSingle()",      ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",    ["AreOffsets"] = "false"}),
        ("SveGatherVector.template",            new Dictionary<string, string> { ["TestName"] = "Sve_GatherVector_Indices_int_uint",                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVector",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",    ["AreOffsets"] = "false"}),
        ("SveGatherVector.template",            new Dictionary<string, string> { ["TestName"] = "Sve_GatherVector_Indices_uint_uint",                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVector",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",    ["AreOffsets"] = "false"}),
        ("SveGatherVector.template",            new Dictionary<string, string> { ["TestName"] = "Sve_GatherVector_Indices_double_long",                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVector",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                  ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "Double", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskDouble()",      ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",     ["AreOffsets"] = "false"}),
        ("SveGatherVector.template",            new Dictionary<string, string> { ["TestName"] = "Sve_GatherVector_Indices_long_long",                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVector",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "Int64",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",     ["AreOffsets"] = "false"}),
        ("SveGatherVector.template",            new Dictionary<string, string> { ["TestName"] = "Sve_GatherVector_Indices_ulong_long",                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVector",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",     ["AreOffsets"] = "false"}),
        ("SveGatherVector.template",            new Dictionary<string, string> { ["TestName"] = "Sve_GatherVector_Indices_double_ulong",                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVector",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                  ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "Double", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskDouble()",      ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",    ["AreOffsets"] = "false"}),
        ("SveGatherVector.template",            new Dictionary<string, string> { ["TestName"] = "Sve_GatherVector_Indices_long_ulong",                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVector",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "Int64",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",    ["AreOffsets"] = "false"}),
        ("SveGatherVector.template",            new Dictionary<string, string> { ["TestName"] = "Sve_GatherVector_Indices_ulong_ulong",                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVector",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",    ["AreOffsets"] = "false"}),

        // ("SveGatherVectorVectorBases.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorByteZeroExtend_Bases_int_uint",                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorByteZeroExtend",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                           ["ExtendedElementType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()"      ["NextValueBase"] = "TestLibrary.Generator.GetInt32()"}),
        // ("SveGatherVectorVectorBases.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorByteZeroExtend_Bases_uint_uint",                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorByteZeroExtend",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                           ["ExtendedElementType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()"      ["NextValueBase"] = "TestLibrary.Generator.GetUInt32()"}),
        ("SveGatherVectorVectorBases.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorByteZeroExtend_Bases_long_ulong",                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorByteZeroExtend",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["ExtendedElementType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueBase"] = "TestLibrary.Generator.GetInt64()"}),
        ("SveGatherVectorVectorBases.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorByteZeroExtend_Bases_ulong_ulong",                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorByteZeroExtend",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["ExtendedElementType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueBase"] = "TestLibrary.Generator.GetUInt64()" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorByteZeroExtend_Indices_int_int",                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorByteZeroExtend",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",     ["AreOffsets"] = "false"}),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorByteZeroExtend_Indices_uint_int",                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorByteZeroExtend",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",     ["AreOffsets"] = "false"}),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorByteZeroExtend_Indices_int_uint",                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorByteZeroExtend",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",    ["AreOffsets"] = "false"}),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorByteZeroExtend_Indices_uint_uint",                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorByteZeroExtend",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",    ["AreOffsets"] = "false"}),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorByteZeroExtend_Indices_long_long",                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorByteZeroExtend",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",     ["AreOffsets"] = "false"}),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorByteZeroExtend_Indices_ulong_long",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorByteZeroExtend",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",     ["AreOffsets"] = "false"}),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorByteZeroExtend_Indices_long_ulong",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorByteZeroExtend",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",    ["AreOffsets"] = "false"}),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorByteZeroExtend_Indices_ulong_ulong",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorByteZeroExtend",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",    ["AreOffsets"] = "false"}),

        // ("SveGatherVectorVectorBases.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt16SignExtend_Bases_int_uint",                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16SignExtend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                           ["ExtendedElementType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()"      ["NextValueBase"] = "TestLibrary.Generator.GetInt32()}),
        // ("SveGatherVectorVectorBases.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt16SignExtend_Bases_uint_uint",                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16SignExtend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                           ["ExtendedElementType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()"      ["NextValueBase"] = "TestLibrary.Generator.GetUInt32()}),
        ("SveGatherVectorVectorBases.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt16SignExtend_Bases_long_ulong",                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16SignExtend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["ExtendedElementType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueBase"] = "TestLibrary.Generator.GetInt64()"}),
        ("SveGatherVectorVectorBases.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt16SignExtend_Bases_ulong_ulong",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16SignExtend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["ExtendedElementType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueBase"] = "TestLibrary.Generator.GetUInt64()"}),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt16SignExtend_Indices_int_int",                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16SignExtend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",     ["AreOffsets"] = "false"}),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt16SignExtend_Indices_uint_int",                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16SignExtend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",     ["AreOffsets"] = "false"}),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt16SignExtend_Indices_int_uint",                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16SignExtend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",    ["AreOffsets"] = "false"}),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt16SignExtend_Indices_uint_uint",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16SignExtend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",    ["AreOffsets"] = "false"}),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt16SignExtend_Indices_long_long",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16SignExtend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",     ["AreOffsets"] = "false"}),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt16SignExtend_Indices_ulong_long",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16SignExtend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",     ["AreOffsets"] = "false"}),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt16SignExtend_Indices_long_ulong",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16SignExtend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",    ["AreOffsets"] = "false"}),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt16SignExtend_Indices_ulong_ulong",                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16SignExtend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",    ["AreOffsets"] = "false"}),

        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt16WithByteOffsetsSignExtend_Offsets_int_int",                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16WithByteOffsetsSignExtend",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",     ["AreOffsets"] = "true"}),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt16WithByteOffsetsSignExtend_Offsets_uint_int",                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16WithByteOffsetsSignExtend",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",     ["AreOffsets"] = "true"}),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt16WithByteOffsetsSignExtend_Offsets_int_uint",                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16WithByteOffsetsSignExtend",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",    ["AreOffsets"] = "true"}),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt16WithByteOffsetsSignExtend_Offsets_uint_uint",                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16WithByteOffsetsSignExtend",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",    ["AreOffsets"] = "true"}),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt16WithByteOffsetsSignExtend_Offsets_long_long",                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16WithByteOffsetsSignExtend",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",     ["AreOffsets"] = "true"}),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt16WithByteOffsetsSignExtend_Offsets_ulong_long",                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16WithByteOffsetsSignExtend",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",     ["AreOffsets"] = "true"}),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt16WithByteOffsetsSignExtend_Offsets_long_ulong",                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16WithByteOffsetsSignExtend",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",    ["AreOffsets"] = "true"}),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt16WithByteOffsetsSignExtend_Offsets_ulong_ulong",                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16WithByteOffsetsSignExtend",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",    ["AreOffsets"] = "true"}),

        ("SveGatherVectorVectorBases.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt32SignExtend_Bases_long_ulong",                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt32SignExtend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["ExtendedElementType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueBase"] = "TestLibrary.Generator.GetInt64()"}),
        ("SveGatherVectorVectorBases.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt32SignExtend_Bases_ulong_ulong",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt32SignExtend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["ExtendedElementType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueBase"] = "TestLibrary.Generator.GetUInt64()"}),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt32SignExtend_Indices_long_long",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt32SignExtend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",      ["AreOffsets"] = "false" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt32SignExtend_Indices_ulong_long",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt32SignExtend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",      ["AreOffsets"] = "false" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt32SignExtend_Indices_long_ulong",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt32SignExtend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",     ["AreOffsets"] = "false" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt32SignExtend_Indices_ulong_ulong",                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt32SignExtend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",     ["AreOffsets"] = "false" }),

        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt32WithByteOffsetsSignExtend_Offsets_long_long",                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt32WithByteOffsetsSignExtend",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",      ["AreOffsets"] = "true" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt32WithByteOffsetsSignExtend_Offsets_ulong_long",                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt32WithByteOffsetsSignExtend",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",      ["AreOffsets"] = "true" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt32WithByteOffsetsSignExtend_Offsets_long_ulong",                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt32WithByteOffsetsSignExtend",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",     ["AreOffsets"] = "true" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt32WithByteOffsetsSignExtend_Offsets_ulong_ulong",                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt32WithByteOffsetsSignExtend",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",     ["AreOffsets"] = "true" }),

        // ("SveGatherVectorVectorBases.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorSByteSignExtend_Bases_int_uint",                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorSByteSignExtend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                           ["ExtendedElementType"] = "SByte",     ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",     ["NextValueBase"] = "TestLibrary.Generator.GetInt32()"}),
        // ("SveGatherVectorVectorBases.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorSByteSignExtend_Bases_uint_uint",                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorSByteSignExtend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                           ["ExtendedElementType"] = "SByte",     ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",     ["NextValueBase"] = "TestLibrary.Generator.GetUInt32()"}),
        ("SveGatherVectorVectorBases.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorSByteSignExtend_Bases_long_ulong",                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorSByteSignExtend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["ExtendedElementType"] = "SByte",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueBase"] = "TestLibrary.Generator.GetInt64()"}),
        ("SveGatherVectorVectorBases.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorSByteSignExtend_Bases_ulong_ulong",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorSByteSignExtend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["ExtendedElementType"] = "SByte",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueBase"] = "TestLibrary.Generator.GetUInt64()"}),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorSByteSignExtend_Indices_int_int",                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorSByteSignExtend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "SByte",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",      ["AreOffsets"] = "false" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorSByteSignExtend_Indices_uint_int",                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorSByteSignExtend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "SByte",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",      ["AreOffsets"] = "false" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorSByteSignExtend_Indices_int_uint",                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorSByteSignExtend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "SByte",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",     ["AreOffsets"] = "false" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorSByteSignExtend_Indices_uint_uint",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorSByteSignExtend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "SByte",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",     ["AreOffsets"] = "false" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorSByteSignExtend_Indices_long_long",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorSByteSignExtend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "SByte",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",      ["AreOffsets"] = "false" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorSByteSignExtend_Indices_ulong_long",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorSByteSignExtend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "SByte",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",      ["AreOffsets"] = "false" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorSByteSignExtend_Indices_long_ulong",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorSByteSignExtend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "SByte",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",     ["AreOffsets"] = "false" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorSByteSignExtend_Indices_ulong_ulong",                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorSByteSignExtend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "SByte",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",     ["AreOffsets"] = "false" }),

        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt16WithByteOffsetsZeroExtend_Offsets_int_int",                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16WithByteOffsetsZeroExtend",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",      ["AreOffsets"] = "true" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt16WithByteOffsetsZeroExtend_Offsets_uint_int",                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16WithByteOffsetsZeroExtend",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",      ["AreOffsets"] = "true" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt16WithByteOffsetsZeroExtend_Offsets_int_uint",                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16WithByteOffsetsZeroExtend",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",     ["AreOffsets"] = "true" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt16WithByteOffsetsZeroExtend_Offsets_uint_uint",                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16WithByteOffsetsZeroExtend",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",     ["AreOffsets"] = "true" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt16WithByteOffsetsZeroExtend_Offsets_long_long",                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16WithByteOffsetsZeroExtend",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",      ["AreOffsets"] = "true" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt16WithByteOffsetsZeroExtend_Offsets_ulong_long",                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16WithByteOffsetsZeroExtend",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",      ["AreOffsets"] = "true" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt16WithByteOffsetsZeroExtend_Offsets_long_ulong",                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16WithByteOffsetsZeroExtend",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",     ["AreOffsets"] = "true" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt16WithByteOffsetsZeroExtend_Offsets_ulong_ulong",                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16WithByteOffsetsZeroExtend",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",     ["AreOffsets"] = "true" }),

        // ("SveGatherVectorVectorBases.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt16ZeroExtend_Bases_int_uint",                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16ZeroExtend",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                           ["ExtendedElementType"] = "UInt16",    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",     ["NextValueBase"] = "TestLibrary.Generator.GetInt32()}),
        // ("SveGatherVectorVectorBases.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt16ZeroExtend_Bases_uint_uint",                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16ZeroExtend",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                           ["ExtendedElementType"] = "UInt16",    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",     ["NextValueBase"] = "TestLibrary.Generator.GetUInt32()"}),
        ("SveGatherVectorVectorBases.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt16ZeroExtend_Bases_long_ulong",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16ZeroExtend",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["ExtendedElementType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueBase"] = "TestLibrary.Generator.GetInt64()"}),
        ("SveGatherVectorVectorBases.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt16ZeroExtend_Bases_ulong_ulong",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16ZeroExtend",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["ExtendedElementType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueBase"] = "TestLibrary.Generator.GetUInt64()"}),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt16ZeroExtend_Indices_int_int",                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16ZeroExtend",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",      ["AreOffsets"] = "false" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt16ZeroExtend_Indices_uint_int",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16ZeroExtend",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",      ["AreOffsets"] = "false" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt16ZeroExtend_Indices_int_uint",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16ZeroExtend",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",     ["AreOffsets"] = "false" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt16ZeroExtend_Indices_uint_uint",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16ZeroExtend",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",     ["AreOffsets"] = "false" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt16ZeroExtend_Indices_long_long",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16ZeroExtend",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",      ["AreOffsets"] = "false" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt16ZeroExtend_Indices_ulong_long",                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16ZeroExtend",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",      ["AreOffsets"] = "false" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt16ZeroExtend_Indices_long_ulong",                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16ZeroExtend",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",     ["AreOffsets"] = "false" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt16ZeroExtend_Indices_ulong_ulong",                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16ZeroExtend",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",     ["AreOffsets"] = "false" }),

        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt32WithByteOffsetsZeroExtend_Offsets_long_long",                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32WithByteOffsetsZeroExtend",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",      ["AreOffsets"] = "true" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt32WithByteOffsetsZeroExtend_Offsets_int_int",                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32WithByteOffsetsZeroExtend",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",      ["AreOffsets"] = "true" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt32WithByteOffsetsZeroExtend_Offsets_ulong_long",                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32WithByteOffsetsZeroExtend",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",      ["AreOffsets"] = "true" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt32WithByteOffsetsZeroExtend_Offsets_uint_int",                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32WithByteOffsetsZeroExtend",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",      ["AreOffsets"] = "true" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt32WithByteOffsetsZeroExtend_Offsets_long_ulong",                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32WithByteOffsetsZeroExtend",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",     ["AreOffsets"] = "true" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt32WithByteOffsetsZeroExtend_Offsets_int_uint",                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32WithByteOffsetsZeroExtend",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",     ["AreOffsets"] = "true" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt32WithByteOffsetsZeroExtend_Offsets_ulong_ulong",                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32WithByteOffsetsZeroExtend",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",     ["AreOffsets"] = "true" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt32WithByteOffsetsZeroExtend_Offsets_uint_uint",                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32WithByteOffsetsZeroExtend",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",     ["AreOffsets"] = "true" }),

        ("SveGatherVectorVectorBases.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt32ZeroExtend_Bases_long_ulong",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32ZeroExtend",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["ExtendedElementType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueBase"] = "TestLibrary.Generator.GetInt64()",}),
        // ("SveGatherVectorVectorBases.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt32ZeroExtend_Bases_int_uint",                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32ZeroExtend",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                           ["ExtendedElementType"] = "UInt32",    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",     ["NextValueBase"] = "TestLibrary.Generator.GetInt32()"}),
        ("SveGatherVectorVectorBases.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt32ZeroExtend_Bases_ulong_ulong",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32ZeroExtend",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["ExtendedElementType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueBase"] = "TestLibrary.Generator.GetUInt64()"}),
        // ("SveGatherVectorVectorBases.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt32ZeroExtend_Bases_uint_uint",                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32ZeroExtend",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                           ["ExtendedElementType"] = "UInt32",    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",     ["NextValueBase"] = "TestLibrary.Generator.GetUInt32()}),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt32ZeroExtend_Indices_long_long",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32ZeroExtend",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",      ["AreOffsets"] = "false" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt32ZeroExtend_Indices_int_int",                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32ZeroExtend",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",      ["AreOffsets"] = "false" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt32ZeroExtend_Indices_ulong_long",                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32ZeroExtend",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",      ["AreOffsets"] = "false" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt32ZeroExtend_Indices_uint_int",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32ZeroExtend",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",      ["AreOffsets"] = "false" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt32ZeroExtend_Indices_long_ulong",                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32ZeroExtend",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",     ["AreOffsets"] = "false" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt32ZeroExtend_Indices_int_uint",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32ZeroExtend",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",     ["AreOffsets"] = "false" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt32ZeroExtend_Indices_ulong_ulong",                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32ZeroExtend",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",     ["AreOffsets"] = "false" }),
        ("SveGatherVector.template",           new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt32ZeroExtend_Indices_uint_uint",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32ZeroExtend",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",     ["AreOffsets"] = "false" }),

        ("SveGatherVectorFirstFaultingVectorBases.template",            new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorFirstFaulting_Bases_double_ulong",                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorFirstFaulting",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["ExtendedElementType"] = "Double", ["GetFfrType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskDouble()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueBase"] = "TestLibrary.Generator.GetDouble()"}),
        ("SveGatherVectorFirstFaultingVectorBases.template",            new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorFirstFaulting_Bases_long_ulong",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorFirstFaulting",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["ExtendedElementType"] = "Int64",  ["GetFfrType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueBase"] = "TestLibrary.Generator.GetInt64()"}),
        ("SveGatherVectorFirstFaultingVectorBases.template",            new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorFirstFaulting_Bases_ulong_ulong",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorFirstFaulting",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["ExtendedElementType"] = "UInt64", ["GetFfrType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueBase"] = "TestLibrary.Generator.GetUInt64()"}),

        ("SveGatherVectorFirstFaulting.template",                       new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorFirstFaulting_Indices_float_int",                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorFirstFaulting",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                  ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "Single",   ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskSingle()",      ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",     ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",                       new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorFirstFaulting_Indices_int_int",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorFirstFaulting",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "Int32",    ["GetFfrType"] = "Int32",       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",     ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",                       new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorFirstFaulting_Indices_uint_int",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorFirstFaulting",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "UInt32",   ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",     ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",                       new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorFirstFaulting_Indices_float_uint",                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorFirstFaulting",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                  ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "Single",   ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskSingle()",      ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",    ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",                       new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorFirstFaulting_Indices_int_uint",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorFirstFaulting",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "Int32",    ["GetFfrType"] = "Int32",       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",    ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",                       new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorFirstFaulting_Indices_uint_uint",                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorFirstFaulting",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "UInt32",   ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",    ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",                       new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorFirstFaulting_Indices_double_long",                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorFirstFaulting",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                  ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "Double",   ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskDouble()",      ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",     ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",                       new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorFirstFaulting_Indices_long_long",                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorFirstFaulting",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "Int64",    ["GetFfrType"] = "Int64",       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",     ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",                       new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorFirstFaulting_Indices_ulong_long",                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorFirstFaulting",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "UInt64",   ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",     ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",                       new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorFirstFaulting_Indices_double_ulong",                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorFirstFaulting",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                  ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "Double",   ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskDouble()",      ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",    ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",                       new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorFirstFaulting_Indices_long_ulong",                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorFirstFaulting",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "Int64",    ["GetFfrType"] = "Int64",       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",    ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",                       new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorFirstFaulting_Indices_ulong_ulong",                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorFirstFaulting",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "UInt64",   ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",    ["AreOffsets"] = "false" }),

        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorByteZeroExtendFirstFaulting_Indices_int_int",                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorByteZeroExtendFirstFaulting",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "Byte",     ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                      ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",    ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorByteZeroExtendFirstFaulting_Indices_int_uint",                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorByteZeroExtendFirstFaulting",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "Byte",     ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                      ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",   ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorByteZeroExtendFirstFaulting_Indices_long_long",                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorByteZeroExtendFirstFaulting",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "Byte",     ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                      ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",    ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorByteZeroExtendFirstFaulting_Indices_long_ulong",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorByteZeroExtendFirstFaulting",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "Byte",     ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                      ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",   ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorByteZeroExtendFirstFaulting_Indices_uint_int",                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorByteZeroExtendFirstFaulting",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "Byte",     ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                      ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",    ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorByteZeroExtendFirstFaulting_Indices_uint_uint",                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorByteZeroExtendFirstFaulting",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "Byte",     ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                      ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",   ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorByteZeroExtendFirstFaulting_Indices_ulong_long",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorByteZeroExtendFirstFaulting",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "Byte",     ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                      ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",    ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorByteZeroExtendFirstFaulting_Indices_ulong_ulong",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorByteZeroExtendFirstFaulting",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "Byte",     ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                      ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",   ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorInt16SignExtendFirstFaulting_Indices_int_int",                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16SignExtendFirstFaulting",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "Int16",    ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",    ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorInt16SignExtendFirstFaulting_Indices_int_uint",                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16SignExtendFirstFaulting",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "Int16",    ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",   ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorInt16SignExtendFirstFaulting_Indices_long_long",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16SignExtendFirstFaulting",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "Int16",    ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",    ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorInt16SignExtendFirstFaulting_Indices_long_ulong",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16SignExtendFirstFaulting",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "Int16",    ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",   ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorInt16SignExtendFirstFaulting_Indices_uint_int",                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16SignExtendFirstFaulting",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "Int16",    ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",    ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorInt16SignExtendFirstFaulting_Indices_uint_uint",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16SignExtendFirstFaulting",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "Int16",    ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",   ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorInt16SignExtendFirstFaulting_Indices_ulong_long",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16SignExtendFirstFaulting",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "Int16",    ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",    ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorInt16SignExtendFirstFaulting_Indices_ulong_ulong",                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16SignExtendFirstFaulting",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "Int16",    ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",   ["AreOffsets"] = "false" }),
        ("SveGatherVectorByteOffsetFirstFaulting.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorInt16WithByteOffsetsSignExtendFirstFaulting_offsets_int_int",                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16WithByteOffsetsSignExtendFirstFaulting",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "Int16",    ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",    ["ConvertFunc"] = "(Int16)"}),
        ("SveGatherVectorByteOffsetFirstFaulting.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorInt16WithByteOffsetsSignExtendFirstFaulting_offsets_int_uint",                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16WithByteOffsetsSignExtendFirstFaulting",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "Int16",    ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",   ["ConvertFunc"] = "(Int16)"}),
        ("SveGatherVectorByteOffsetFirstFaulting.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorInt16WithByteOffsetsSignExtendFirstFaulting_offsets_long_long",                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16WithByteOffsetsSignExtendFirstFaulting",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "Int16",    ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",    ["ConvertFunc"] = "(Int16)"}),
        ("SveGatherVectorByteOffsetFirstFaulting.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorInt16WithByteOffsetsSignExtendFirstFaulting_offsets_long_ulong",                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16WithByteOffsetsSignExtendFirstFaulting",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "Int16",    ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",   ["ConvertFunc"] = "(Int16)"}),
        ("SveGatherVectorByteOffsetFirstFaulting.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorInt16WithByteOffsetsSignExtendFirstFaulting_offsets_uint_int",                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16WithByteOffsetsSignExtendFirstFaulting",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "Int16",    ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",    ["ConvertFunc"] = "(Int16)"}),
        ("SveGatherVectorByteOffsetFirstFaulting.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorInt16WithByteOffsetsSignExtendFirstFaulting_offsets_uint_uint",                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16WithByteOffsetsSignExtendFirstFaulting",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "Int16",    ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",   ["ConvertFunc"] = "(Int16)"}),
        ("SveGatherVectorByteOffsetFirstFaulting.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorInt16WithByteOffsetsSignExtendFirstFaulting_offsets_ulong_long",                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16WithByteOffsetsSignExtendFirstFaulting",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "Int16",    ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",    ["ConvertFunc"] = "(Int16)"}),
        ("SveGatherVectorByteOffsetFirstFaulting.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorInt16WithByteOffsetsSignExtendFirstFaulting_offsets_ulong_ulong",                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16WithByteOffsetsSignExtendFirstFaulting",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "Int16",    ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",   ["ConvertFunc"] = "(Int16)"}),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorInt32SignExtendFirstFaulting_Indices_long_long",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt32SignExtendFirstFaulting",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "Int32",    ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",    ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorInt32SignExtendFirstFaulting_Indices_long_ulong",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt32SignExtendFirstFaulting",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "Int32",    ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",   ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorInt32SignExtendFirstFaulting_Indices_ulong_long",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt32SignExtendFirstFaulting",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "Int32",    ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",    ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorInt32SignExtendFirstFaulting_Indices_ulong_ulong",                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt32SignExtendFirstFaulting",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "Int32",    ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",   ["AreOffsets"] = "false" }),
        ("SveGatherVectorByteOffsetFirstFaulting.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorInt32WithByteOffsetsSignExtendFirstFaulting_offsets_long_long",                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt32WithByteOffsetsSignExtendFirstFaulting",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "Int32",    ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",    ["ConvertFunc"] = "(Int32)"}),
        ("SveGatherVectorByteOffsetFirstFaulting.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorInt32WithByteOffsetsSignExtendFirstFaulting_offsets_long_ulong",                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt32WithByteOffsetsSignExtendFirstFaulting",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "Int32",    ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",   ["ConvertFunc"] = "(Int32)"}),
        ("SveGatherVectorByteOffsetFirstFaulting.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorInt32WithByteOffsetsSignExtendFirstFaulting_offsets_ulong_long",                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt32WithByteOffsetsSignExtendFirstFaulting",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "Int32",    ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",    ["ConvertFunc"] = "(Int32)"}),
        ("SveGatherVectorByteOffsetFirstFaulting.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorInt32WithByteOffsetsSignExtendFirstFaulting_offsets_ulong_ulong",                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt32WithByteOffsetsSignExtendFirstFaulting",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "Int32",    ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",   ["ConvertFunc"] = "(Int32)"}),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorSByteSignExtendFirstFaulting_Indices_int_int",                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorSByteSignExtendFirstFaulting",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "SByte",    ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",    ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorSByteSignExtendFirstFaulting_Indices_int_uint",                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorSByteSignExtendFirstFaulting",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "SByte",    ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",   ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorSByteSignExtendFirstFaulting_Indices_long_long",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorSByteSignExtendFirstFaulting",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "SByte",    ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",    ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorSByteSignExtendFirstFaulting_Indices_long_ulong",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorSByteSignExtendFirstFaulting",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "SByte",    ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",   ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorSByteSignExtendFirstFaulting_Indices_uint_int",                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorSByteSignExtendFirstFaulting",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "SByte",    ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",    ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorSByteSignExtendFirstFaulting_Indices_uint_uint",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorSByteSignExtendFirstFaulting",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "SByte",    ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",   ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorSByteSignExtendFirstFaulting_Indices_ulong_long",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorSByteSignExtendFirstFaulting",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "SByte",    ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",    ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorSByteSignExtendFirstFaulting_Indices_ulong_ulong",                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorSByteSignExtendFirstFaulting",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "SByte",    ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",   ["AreOffsets"] = "false" }),
        ("SveGatherVectorByteOffsetFirstFaulting.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt16WithByteOffsetsZeroExtendFirstFaulting_offsets_int_int",                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16WithByteOffsetsZeroExtendFirstFaulting",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",                                        ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",   ["ConvertFunc"] = "(UInt16)"}),
        ("SveGatherVectorByteOffsetFirstFaulting.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt16WithByteOffsetsZeroExtendFirstFaulting_offsets_int_uint",                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16WithByteOffsetsZeroExtendFirstFaulting",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32",                                       ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",  ["ConvertFunc"] = "(UInt16)"}),
        ("SveGatherVectorByteOffsetFirstFaulting.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt16WithByteOffsetsZeroExtendFirstFaulting_offsets_long_long",                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16WithByteOffsetsZeroExtendFirstFaulting",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",                                        ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",   ["ConvertFunc"] = "(UInt16)"}),
        ("SveGatherVectorByteOffsetFirstFaulting.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt16WithByteOffsetsZeroExtendFirstFaulting_offsets_long_ulong",                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16WithByteOffsetsZeroExtendFirstFaulting",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64",                                       ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",  ["ConvertFunc"] = "(UInt16)"}),
        ("SveGatherVectorByteOffsetFirstFaulting.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt16WithByteOffsetsZeroExtendFirstFaulting_offsets_uint_int",                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16WithByteOffsetsZeroExtendFirstFaulting",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",                                        ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",   ["ConvertFunc"] = "(UInt16)"}),
        ("SveGatherVectorByteOffsetFirstFaulting.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt16WithByteOffsetsZeroExtendFirstFaulting_offsets_uint_uint",                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16WithByteOffsetsZeroExtendFirstFaulting",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32",                                       ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",  ["ConvertFunc"] = "(UInt16)"}),
        ("SveGatherVectorByteOffsetFirstFaulting.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt16WithByteOffsetsZeroExtendFirstFaulting_offsets_ulong_long",                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16WithByteOffsetsZeroExtendFirstFaulting",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",                                        ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",   ["ConvertFunc"] = "(UInt16)"}),
        ("SveGatherVectorByteOffsetFirstFaulting.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt16WithByteOffsetsZeroExtendFirstFaulting_offsets_ulong_ulong",                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16WithByteOffsetsZeroExtendFirstFaulting",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64",                                       ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",  ["ConvertFunc"] = "(UInt16)"}),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt16ZeroExtendFirstFaulting_Indices_int_int",                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16ZeroExtendFirstFaulting",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "UInt16",   ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",    ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt16ZeroExtendFirstFaulting_Indices_int_uint",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16ZeroExtendFirstFaulting",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "UInt16",   ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",   ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt16ZeroExtendFirstFaulting_Indices_long_long",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16ZeroExtendFirstFaulting",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "UInt16",   ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",    ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt16ZeroExtendFirstFaulting_Indices_long_ulong",                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16ZeroExtendFirstFaulting",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "UInt16",   ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",   ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt16ZeroExtendFirstFaulting_Indices_uint_int",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16ZeroExtendFirstFaulting",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "UInt16",   ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",    ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt16ZeroExtendFirstFaulting_Indices_uint_uint",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16ZeroExtendFirstFaulting",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "UInt16",   ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",   ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt16ZeroExtendFirstFaulting_Indices_ulong_long",                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16ZeroExtendFirstFaulting",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "UInt16",   ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",    ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",           new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt16ZeroExtendFirstFaulting_Indices_ulong_ulong",                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16ZeroExtendFirstFaulting",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "UInt16",   ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",   ["AreOffsets"] = "false" }),
        ("SveGatherVectorByteOffsetFirstFaulting.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt32WithByteOffsetsZeroExtendFirstFaulting_offsets_int_int",                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32WithByteOffsetsZeroExtendFirstFaulting",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",                                        ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",   ["ConvertFunc"] = "(UInt32)"}),
        ("SveGatherVectorByteOffsetFirstFaulting.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt32WithByteOffsetsZeroExtendFirstFaulting_offsets_int_uint",                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32WithByteOffsetsZeroExtendFirstFaulting",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32",                                       ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",  ["ConvertFunc"] = "(UInt32)"}),
        ("SveGatherVectorByteOffsetFirstFaulting.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt32WithByteOffsetsZeroExtendFirstFaulting_offsets_long_long",                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32WithByteOffsetsZeroExtendFirstFaulting",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",                                        ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",   ["ConvertFunc"] = "(UInt32)"}),
        ("SveGatherVectorByteOffsetFirstFaulting.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt32WithByteOffsetsZeroExtendFirstFaulting_offsets_long_ulong",                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32WithByteOffsetsZeroExtendFirstFaulting",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64",                                       ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",  ["ConvertFunc"] = "(UInt32)"}),
        ("SveGatherVectorByteOffsetFirstFaulting.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt32WithByteOffsetsZeroExtendFirstFaulting_offsets_uint_int",                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32WithByteOffsetsZeroExtendFirstFaulting",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",                                        ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",   ["ConvertFunc"] = "(UInt32)"}),
        ("SveGatherVectorByteOffsetFirstFaulting.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt32WithByteOffsetsZeroExtendFirstFaulting_offsets_uint_uint",                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32WithByteOffsetsZeroExtendFirstFaulting",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32",                                       ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",  ["ConvertFunc"] = "(UInt32)"}),
        ("SveGatherVectorByteOffsetFirstFaulting.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt32WithByteOffsetsZeroExtendFirstFaulting_offsets_ulong_long",                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32WithByteOffsetsZeroExtendFirstFaulting",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",                                        ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",   ["ConvertFunc"] = "(UInt32)"}),
        ("SveGatherVectorByteOffsetFirstFaulting.template", new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt32WithByteOffsetsZeroExtendFirstFaulting_offsets_ulong_ulong",                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32WithByteOffsetsZeroExtendFirstFaulting",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64",                                       ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",  ["ConvertFunc"] = "(UInt32)"}),
        ("SveGatherVectorFirstFaulting.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt32ZeroExtendFirstFaulting_Indices_int_int",                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32ZeroExtendFirstFaulting",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "UInt32",   ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",    ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt32ZeroExtendFirstFaulting_Indices_int_uint",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32ZeroExtendFirstFaulting",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "UInt32",   ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",   ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt32ZeroExtendFirstFaulting_Indices_long_long",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32ZeroExtendFirstFaulting",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "UInt32",   ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",    ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt32ZeroExtendFirstFaulting_Indices_long_ulong",                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32ZeroExtendFirstFaulting",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "UInt32",   ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",   ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt32ZeroExtendFirstFaulting_Indices_uint_int",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32ZeroExtendFirstFaulting",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "UInt32",   ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",    ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt32ZeroExtendFirstFaulting_Indices_uint_uint",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32ZeroExtendFirstFaulting",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "UInt32",   ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",   ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt32ZeroExtendFirstFaulting_Indices_ulong_long",                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32ZeroExtendFirstFaulting",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "UInt32",   ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",    ["AreOffsets"] = "false" }),
        ("SveGatherVectorFirstFaulting.template",   new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorUInt32ZeroExtendFirstFaulting_Indices_ulong_ulong",                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32ZeroExtendFirstFaulting",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "UInt32",   ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",   ["AreOffsets"] = "false" }),

        ("SveGatherVectorFirstFaultingVectorBases.template", new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorByteZeroExtendFirstFaulting_Bases_long_ulong",                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorByteZeroExtendFirstFaulting",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["ExtendedElementType"] = "Byte",     ["GetFfrType"] = "UInt64",        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                    ["NextValueBase"] = "TestLibrary.Generator.GetInt64()"}),
        ("SveGatherVectorFirstFaultingVectorBases.template", new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorByteZeroExtendFirstFaulting_Bases_ulong_ulong",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorByteZeroExtendFirstFaulting",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["ExtendedElementType"] = "Byte",     ["GetFfrType"] = "UInt64",        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                    ["NextValueBase"] = "TestLibrary.Generator.GetUInt64()"}),
        ("SveGatherVectorFirstFaultingVectorBases.template", new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt16SignExtendFirstFaulting_Bases_long_ulong",                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16SignExtendFirstFaulting",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["ExtendedElementType"] = "Int16",    ["GetFfrType"] = "UInt64",        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                    ["NextValueBase"] = "TestLibrary.Generator.GetInt64()"}),
        ("SveGatherVectorFirstFaultingVectorBases.template", new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorInt16SignExtendFirstFaulting_Bases_ulong_ulong",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorInt16SignExtendFirstFaulting",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["ExtendedElementType"] = "Int16",    ["GetFfrType"] = "UInt64",        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                    ["NextValueBase"] = "TestLibrary.Generator.GetUInt64()"}),
        ("SveGatherVectorFirstFaultingVectorBases.template", new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt16ZeroExtendFirstFaulting_Bases_long_ulong",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16ZeroExtendFirstFaulting",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["ExtendedElementType"] = "UInt16",   ["GetFfrType"] = "UInt64",        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                    ["NextValueBase"] = "TestLibrary.Generator.GetInt64()"}),
        ("SveGatherVectorFirstFaultingVectorBases.template", new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt16ZeroExtendFirstFaulting_Bases_ulong_ulong",                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt16ZeroExtendFirstFaulting",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["ExtendedElementType"] = "UInt16",   ["GetFfrType"] = "UInt64",        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                    ["NextValueBase"] = "TestLibrary.Generator.GetUInt64()"}),
        ("SveGatherVectorFirstFaultingVectorBases.template", new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt32ZeroExtendFirstFaulting_Bases_long_ulong",                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32ZeroExtendFirstFaulting",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["ExtendedElementType"] = "UInt32",   ["GetFfrType"] = "UInt64",        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                    ["NextValueBase"] = "TestLibrary.Generator.GetInt64()"}),
        ("SveGatherVectorFirstFaultingVectorBases.template", new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorUInt32ZeroExtendFirstFaulting_Bases_ulong_ulong",                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorUInt32ZeroExtendFirstFaulting",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["ExtendedElementType"] = "UInt32",   ["GetFfrType"] = "UInt64",        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                    ["NextValueBase"] = "TestLibrary.Generator.GetUInt64()"}),

        ("SveGatherVectorByteOffsetFirstFaulting.template",new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorWithByteOffsetFirstFaulting_float_int",                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorWithByteOffsetFirstFaulting",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                  ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",                                        ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskSingle()",      ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()", ["ConvertFunc"] = "BitConverter.SingleToInt32Bits"}),
        ("SveGatherVectorByteOffsetFirstFaulting.template",new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorWithByteOffsetFirstFaulting_int",                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorWithByteOffsetFirstFaulting",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",                                        ["GetFfrType"] = "Int32",       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()", ["ConvertFunc"] = ""}),
        ("SveGatherVectorByteOffsetFirstFaulting.template",new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorWithByteOffsetFirstFaulting_uint_int",                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorWithByteOffsetFirstFaulting",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",                                        ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()", ["ConvertFunc"] = ""}),
        ("SveGatherVectorByteOffsetFirstFaulting.template",new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorWithByteOffsetFirstFaulting_float_uint",                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorWithByteOffsetFirstFaulting",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                  ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32",                                       ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskSingle()",      ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()", ["ConvertFunc"] = "BitConverter.SingleToInt32Bits"}),
        ("SveGatherVectorByteOffsetFirstFaulting.template",new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorWithByteOffsetFirstFaulting_int_uint",                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorWithByteOffsetFirstFaulting",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32",                                       ["GetFfrType"] = "Int32",       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()", ["ConvertFunc"] = ""}),
        ("SveGatherVectorByteOffsetFirstFaulting.template",new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorWithByteOffsetFirstFaulting_uint",                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorWithByteOffsetFirstFaulting",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32",                                       ["GetFfrType"] = "UInt32",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()", ["ConvertFunc"] = ""}),
        ("SveGatherVectorByteOffsetFirstFaulting.template",new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorWithByteOffsetFirstFaulting_double_long",                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorWithByteOffsetFirstFaulting",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                  ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",                                        ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskDouble()",      ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()", ["ConvertFunc"] = "BitConverter.DoubleToInt64Bits"}),
        ("SveGatherVectorByteOffsetFirstFaulting.template",new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorWithByteOffsetFirstFaulting_long",                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorWithByteOffsetFirstFaulting",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",                                        ["GetFfrType"] = "Int64",       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()", ["ConvertFunc"] = ""}),
        ("SveGatherVectorByteOffsetFirstFaulting.template",new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorWithByteOffsetFirstFaulting_ulong_long",                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorWithByteOffsetFirstFaulting",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",                                        ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()", ["ConvertFunc"] = ""}),
        ("SveGatherVectorByteOffsetFirstFaulting.template",new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorWithByteOffsetFirstFaulting_double_ulong",                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorWithByteOffsetFirstFaulting",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                  ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64",                                       ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskDouble()",      ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()", ["ConvertFunc"] = "BitConverter.DoubleToInt64Bits"}),
        ("SveGatherVectorByteOffsetFirstFaulting.template",new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorWithByteOffsetFirstFaulting_long_ulong",                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorWithByteOffsetFirstFaulting",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64",                                       ["GetFfrType"] = "Int64",       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                     ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()", ["ConvertFunc"] = ""}),
        ("SveGatherVectorByteOffsetFirstFaulting.template",new Dictionary<string, string> { ["TestName"] = "Sve_GatherVectorWithByteOffsetFirstFaulting_ulong",                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorWithByteOffsetFirstFaulting",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64",                                       ["GetFfrType"] = "UInt64",      ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                    ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()", ["ConvertFunc"] = ""}),

        ("SveGatherVectorByteOffsets.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorWithByteOffsets_float_int",                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorWithByteOffsets",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                  ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskSingle()",      ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",       ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",      ["ConvertFunc"] = "BitConverter.SingleToInt32Bits"}),
        ("SveGatherVectorByteOffsets.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorWithByteOffsets_int_int",                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorWithByteOffsets",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",      ["ConvertFunc"] = ""}),
        ("SveGatherVectorByteOffsets.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorWithByteOffsets_uint_int",                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorWithByteOffsets",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["ExtendedElementType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",       ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",      ["ConvertFunc"] = ""}),
        ("SveGatherVectorByteOffsets.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorWithByteOffsets_float_uint",                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorWithByteOffsets",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                  ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskSingle()",      ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",       ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",     ["ConvertFunc"] = "BitConverter.SingleToInt32Bits"}),
        ("SveGatherVectorByteOffsets.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorWithByteOffsets_int_uint",                                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorWithByteOffsets",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",     ["ConvertFunc"] = ""}),
        ("SveGatherVectorByteOffsets.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorWithByteOffsets_uint_uint",                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorWithByteOffsets",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["ExtendedElementType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",       ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",     ["ConvertFunc"] = ""}),
        ("SveGatherVectorByteOffsets.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorWithByteOffsets_double_long",                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorWithByteOffsets",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                  ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskDouble()",      ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",       ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",      ["ConvertFunc"] = "BitConverter.DoubleToInt64Bits"}),
        ("SveGatherVectorByteOffsets.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorWithByteOffsets_long_long",                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorWithByteOffsets",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",        ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",      ["ConvertFunc"] = ""}),
        ("SveGatherVectorByteOffsets.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorWithByteOffsets_ulong_long",                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorWithByteOffsets",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["ExtendedElementType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",       ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",      ["ConvertFunc"] = ""}),
        ("SveGatherVectorByteOffsets.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorWithByteOffsets_double_ulong",                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorWithByteOffsets",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                  ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskDouble()",      ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",       ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",     ["ConvertFunc"] = "BitConverter.DoubleToInt64Bits"}),
        ("SveGatherVectorByteOffsets.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorWithByteOffsets_long_ulong",                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorWithByteOffsets",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",     ["ConvertFunc"] = ""}),
        ("SveGatherVectorByteOffsets.template",new Dictionary<string, string> {["TestName"] = "Sve_GatherVectorWithByteOffsets_ulong_ulong",                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GatherVectorWithByteOffsets",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["ExtendedElementType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",       ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",     ["ConvertFunc"] = ""}),

        ("SveVecReduceToScalarBinOpTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_GetActiveElementCount_byte",                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GetActiveElementCount",                                                                                 ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskByte()",        ["NextValueOp2"] = "Helpers.getMaskByte()",                                                                                       ["ValidateResult"] = "if (Helpers.MaskBothSet(left, right) != result) succeeded = false;",}),
        ("SveVecReduceToScalarBinOpTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_GetActiveElementCount_sbyte",                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GetActiveElementCount",                                                                                 ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskSByte()",       ["NextValueOp2"] = "Helpers.getMaskSByte()",                                                                                      ["ValidateResult"] = "if (Helpers.MaskBothSet(left, right) != result) succeeded = false;",}),
        ("SveVecReduceToScalarBinOpTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_GetActiveElementCount_short",                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GetActiveElementCount",                                                                                 ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt16()",       ["NextValueOp2"] = "Helpers.getMaskInt16()",                                                                                      ["ValidateResult"] = "if (Helpers.MaskBothSet(left, right) != result) succeeded = false;",}),
        ("SveVecReduceToScalarBinOpTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_GetActiveElementCount_int",                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GetActiveElementCount",                                                                                 ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",       ["NextValueOp2"] = "Helpers.getMaskInt32()",                                                                                      ["ValidateResult"] = "if (Helpers.MaskBothSet(left, right) != result) succeeded = false;",}),
        ("SveVecReduceToScalarBinOpTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_GetActiveElementCount_long",                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GetActiveElementCount",                                                                                 ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",       ["NextValueOp2"] = "Helpers.getMaskInt64()",                                                                                      ["ValidateResult"] = "if (Helpers.MaskBothSet(left, right) != result) succeeded = false;",}),
        ("SveVecReduceToScalarBinOpTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_GetActiveElementCount_float",                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GetActiveElementCount",                                                                                 ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskSingle()",      ["NextValueOp2"] = "Helpers.getMaskSingle()",                                                                                     ["ValidateResult"] = "if (Helpers.MaskBothSet(left, right) != result) succeeded = false;",}),
        ("SveVecReduceToScalarBinOpTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_GetActiveElementCount_double",                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GetActiveElementCount",                                                                                 ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskDouble()",      ["NextValueOp2"] = "Helpers.getMaskDouble()",                                                                                     ["ValidateResult"] = "if (Helpers.MaskBothSet(left, right) != result) succeeded = false;",}),
        ("SveVecReduceToScalarBinOpTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_GetActiveElementCount_ushort",                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GetActiveElementCount",                                                                                 ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt16()",      ["NextValueOp2"] = "Helpers.getMaskUInt16()",                                                                                     ["ValidateResult"] = "if (Helpers.MaskBothSet(left, right) != result) succeeded = false;",}),
        ("SveVecReduceToScalarBinOpTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_GetActiveElementCount_uint",                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GetActiveElementCount",                                                                                 ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",      ["NextValueOp2"] = "Helpers.getMaskUInt32()",                                                                                     ["ValidateResult"] = "if (Helpers.MaskBothSet(left, right) != result) succeeded = false;",}),
        ("SveVecReduceToScalarBinOpTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_GetActiveElementCount_ulong",                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "GetActiveElementCount",                                                                                 ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",      ["NextValueOp2"] = "Helpers.getMaskUInt64()",                                                                                     ["ValidateResult"] = "if (Helpers.MaskBothSet(left, right) != result) succeeded = false;",}),

        ("SveMasklessSimpleVecOpTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_LeadingSignCount_byte_sbyte",                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "LeadingSignCount",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.CountLeadingSignBits(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.CountLeadingSignBits(leftOp[i])"}),
        ("SveMasklessSimpleVecOpTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_LeadingSignCount_ushort_short",                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "LeadingSignCount",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.CountLeadingSignBits(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.CountLeadingSignBits(leftOp[i])"}),
        ("SveMasklessSimpleVecOpTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_LeadingSignCount_uint_int",                                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "LeadingSignCount",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.CountLeadingSignBits(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.CountLeadingSignBits(leftOp[i])"}),
        ("SveMasklessSimpleVecOpTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_LeadingSignCount_ulong_long",                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "LeadingSignCount",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                                                       ["ValidateIterResult"] = "((ulong)Helpers.CountLeadingSignBits(firstOp[i])) != result[i]", ["GetIterResult"] = "Helpers.CountLeadingSignBits(leftOp[i])"}),
        ("SveMasklessSimpleVecOpTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_LeadingZeroCount_byte_sbyte",                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "LeadingZeroCount",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.CountLeadingZeroBits(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.CountLeadingZeroBits(leftOp[i])"}),
        ("SveMasklessSimpleVecOpTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_LeadingZeroCount_ushort_short",                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "LeadingZeroCount",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.CountLeadingZeroBits(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.CountLeadingZeroBits(leftOp[i])"}),
        ("SveMasklessSimpleVecOpTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_LeadingZeroCount_uint_int",                                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "LeadingZeroCount",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.CountLeadingZeroBits(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.CountLeadingZeroBits(leftOp[i])"}),
        ("SveMasklessSimpleVecOpTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_LeadingZeroCount_ulong_long",                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "LeadingZeroCount",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                                                       ["ValidateIterResult"] = "((ulong)Helpers.CountLeadingZeroBits(firstOp[i])) != result[i]", ["GetIterResult"] = "Helpers.CountLeadingZeroBits(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_LeadingZeroCount_byte",                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "LeadingZeroCount",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                                                        ["ValidateIterResult"] = "Helpers.CountLeadingZeroBits(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.CountLeadingZeroBits(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_LeadingZeroCount_ushort",                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "LeadingZeroCount",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.CountLeadingZeroBits(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.CountLeadingZeroBits(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_LeadingZeroCount_uint",                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "LeadingZeroCount",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.CountLeadingZeroBits(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.CountLeadingZeroBits(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_LeadingZeroCount_ulong",                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "LeadingZeroCount",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.CountLeadingZeroBits(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.CountLeadingZeroBits(leftOp[i])"}),

        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVector_float",                                                                                ["Isa"] = "Sve",                                    ["Method"] = "LoadVector",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskSingle()",             ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVector_double",                                                                               ["Isa"] = "Sve",                                    ["Method"] = "LoadVector",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                  ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskDouble()",             ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVector_sbyte",                                                                                ["Isa"] = "Sve",                                    ["Method"] = "LoadVector",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                   ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskSByte()",              ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVector_short",                                                                                ["Isa"] = "Sve",                                    ["Method"] = "LoadVector",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                   ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt16()",              ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVector_int",                                                                                  ["Isa"] = "Sve",                                    ["Method"] = "LoadVector",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",              ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVector_long",                                                                                 ["Isa"] = "Sve",                                    ["Method"] = "LoadVector",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",              ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVector_byte",                                                                                 ["Isa"] = "Sve",                                    ["Method"] = "LoadVector",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",                                    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskByte()",               ["NextValueOp2"] = "TestLibrary.Generator.GetByte()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVector_ushort",                                                                               ["Isa"] = "Sve",                                    ["Method"] = "LoadVector",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt16()",             ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVector_uint",                                                                                 ["Isa"] = "Sve",                                    ["Method"] = "LoadVector",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",             ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVector_ulong",                                                                                ["Isa"] = "Sve",                                    ["Method"] = "LoadVector",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",             ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()"}),

        ("SveLoadNonFaultingMaskedUnOpTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorNonFaulting_float",                                                            ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorNonFaulting",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",      ["Op2BaseType"] = "Single",                                                                                          ["LargestVectorSize"] = "64", ["GetFfrType"] = "UInt32",   ["NextValueOp1"] = "Helpers.getMaskSingle()",     ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",  ["Cast"] = "(float*)",     ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorNonFaulting_double",                                                           ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorNonFaulting",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",      ["Op2BaseType"] = "Double",                                                                                          ["LargestVectorSize"] = "64", ["GetFfrType"] = "UInt64",   ["NextValueOp1"] = "Helpers.getMaskDouble()",     ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",  ["Cast"] = "(double*)",    ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorNonFaulting_sbyte",                                                            ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorNonFaulting",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",       ["Op2BaseType"] = "SByte",                                                                                           ["LargestVectorSize"] = "64", ["GetFfrType"] = "SByte",    ["NextValueOp1"] = "Helpers.getMaskSByte()",      ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",   ["Cast"] = "(sbyte*)",     ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorNonFaulting_short",                                                            ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorNonFaulting",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",       ["Op2BaseType"] = "Int16",                                                                                           ["LargestVectorSize"] = "64", ["GetFfrType"] = "Int16",    ["NextValueOp1"] = "Helpers.getMaskInt16()",      ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",   ["Cast"] = "(short*)",     ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorNonFaulting_int",                                                              ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorNonFaulting",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",       ["Op2BaseType"] = "Int32",                                                                                           ["LargestVectorSize"] = "64", ["GetFfrType"] = "Int32",    ["NextValueOp1"] = "Helpers.getMaskInt32()",      ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",   ["Cast"] = "(int*)",       ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorNonFaulting_long",                                                             ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorNonFaulting",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",       ["Op2BaseType"] = "Int64",                                                                                           ["LargestVectorSize"] = "64", ["GetFfrType"] = "Int64",    ["NextValueOp1"] = "Helpers.getMaskInt64()",      ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",   ["Cast"] = "(long*)",      ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorNonFaulting_byte",                                                             ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorNonFaulting",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",        ["Op2BaseType"] = "Byte",                                                                                            ["LargestVectorSize"] = "64", ["GetFfrType"] = "Byte",     ["NextValueOp1"] = "Helpers.getMaskByte()",       ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",    ["Cast"] = "(byte*)",      ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorNonFaulting_ushort",                                                           ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorNonFaulting",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",      ["Op2BaseType"] = "UInt16",                                                                                          ["LargestVectorSize"] = "64", ["GetFfrType"] = "UInt16",   ["NextValueOp1"] = "Helpers.getMaskUInt16()",     ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",  ["Cast"] = "(ushort*)",    ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorNonFaulting_uint",                                                             ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorNonFaulting",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",      ["Op2BaseType"] = "UInt32",                                                                                          ["LargestVectorSize"] = "64", ["GetFfrType"] = "UInt32",   ["NextValueOp1"] = "Helpers.getMaskUInt32()",     ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",  ["Cast"] = "(uint*)",      ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorNonFaulting_ulong",                                                            ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorNonFaulting",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",      ["Op2BaseType"] = "UInt64",                                                                                          ["LargestVectorSize"] = "64", ["GetFfrType"] = "UInt64",   ["NextValueOp1"] = "Helpers.getMaskUInt64()",     ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",  ["Cast"] = "(ulong*)",     ["ValidateIterResult"] = "firstOp[i] != result[i]"}),

        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorByteZeroExtendFirstFaulting_int",                                                                       ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorByteZeroExtendFirstFaulting",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                                                ["Op2BaseType"] = "Byte",                  ["GetFfrType"] = "Int32",                                               ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskInt32()",                                            ["NextValueOp2"] = "TestLibrary.Generator.GetByte()"}),
        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorByteZeroExtendFirstFaulting_long",                                                                      ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorByteZeroExtendFirstFaulting",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                                                ["Op2BaseType"] = "Byte",                  ["GetFfrType"] = "Int64",                                               ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskInt64()",                                            ["NextValueOp2"] = "TestLibrary.Generator.GetByte()"}),
        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorByteZeroExtendFirstFaulting_short",                                                                     ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorByteZeroExtendFirstFaulting",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                                                ["Op2BaseType"] = "Byte",                  ["GetFfrType"] = "Int16",                                               ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskInt16()",                                            ["NextValueOp2"] = "TestLibrary.Generator.GetByte()"}),
        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorByteZeroExtendFirstFaulting_uint",                                                                      ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorByteZeroExtendFirstFaulting",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                                               ["Op2BaseType"] = "Byte",                  ["GetFfrType"] = "UInt32",                                              ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskUInt32()",                                           ["NextValueOp2"] = "TestLibrary.Generator.GetByte()"}),
        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorByteZeroExtendFirstFaulting_ulong",                                                                     ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorByteZeroExtendFirstFaulting",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                                               ["Op2BaseType"] = "Byte",                  ["GetFfrType"] = "UInt64",                                              ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskUInt64()",                                           ["NextValueOp2"] = "TestLibrary.Generator.GetByte()"}),
        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorByteZeroExtendFirstFaulting_ushort",                                                                    ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorByteZeroExtendFirstFaulting",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                                               ["Op2BaseType"] = "Byte",                  ["GetFfrType"] = "UInt16",                                              ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskUInt16()",                                           ["NextValueOp2"] = "TestLibrary.Generator.GetByte()"}),

        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorFirstFaulting_float",                                                                                   ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorFirstFaulting",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",        ["Op2VectorType"] = "Vector",                          ["Op2BaseType"] = "Single",                ["GetFfrType"] = "UInt32",                                              ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskSingle()",                                           ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()"}),
        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorFirstFaulting_double",                                                                                  ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorFirstFaulting",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",        ["Op2VectorType"] = "Vector",                          ["Op2BaseType"] = "Double",                ["GetFfrType"] = "UInt64",                                              ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskDouble()",                                           ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()"}),
        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorFirstFaulting_sbyte",                                                                                   ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorFirstFaulting",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",         ["Op2VectorType"] = "Vector",                          ["Op2BaseType"] = "SByte",                 ["GetFfrType"] = "SByte",                                               ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskSByte()",                                            ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()"}),
        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorFirstFaulting_short",                                                                                   ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorFirstFaulting",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",         ["Op2VectorType"] = "Vector",                          ["Op2BaseType"] = "Int16",                 ["GetFfrType"] = "Int16",                                               ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskInt16()",                                            ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()"}),
        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorFirstFaulting_int",                                                                                     ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorFirstFaulting",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",         ["Op2VectorType"] = "Vector",                          ["Op2BaseType"] = "Int32",                 ["GetFfrType"] = "Int32",                                               ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskInt32()",                                            ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()"}),
        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorFirstFaulting_long",                                                                                    ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorFirstFaulting",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",         ["Op2VectorType"] = "Vector",                          ["Op2BaseType"] = "Int64",                 ["GetFfrType"] = "Int64",                                               ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskInt64()",                                            ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()"}),
        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorFirstFaulting_byte",                                                                                    ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorFirstFaulting",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",          ["Op2VectorType"] = "Vector",                          ["Op2BaseType"] = "Byte",                  ["GetFfrType"] = "Byte",                                                ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskByte()",                                             ["NextValueOp2"] = "TestLibrary.Generator.GetByte()"}),
        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorFirstFaulting_ushort",                                                                                  ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorFirstFaulting",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",        ["Op2VectorType"] = "Vector",                          ["Op2BaseType"] = "UInt16",                ["GetFfrType"] = "UInt16",                                              ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskUInt16()",                                           ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()"}),
        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorFirstFaulting_uint",                                                                                    ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorFirstFaulting",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",        ["Op2VectorType"] = "Vector",                          ["Op2BaseType"] = "UInt32",                ["GetFfrType"] = "UInt32",                                              ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskUInt32()",                                           ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()"}),
        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorFirstFaulting_ulong",                                                                                   ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorFirstFaulting",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",        ["Op2VectorType"] = "Vector",                          ["Op2BaseType"] = "UInt64",                ["GetFfrType"] = "UInt64",                                              ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskUInt64()",                                           ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()"}),

        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorInt16SignExtendFirstFaulting_int",                                                                      ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorInt16SignExtendFirstFaulting",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                                                ["Op2BaseType"] = "Int16",                 ["GetFfrType"] = "Int32",                                               ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskInt32()",                                            ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()"}),
        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorInt16SignExtendFirstFaulting_long",                                                                     ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorInt16SignExtendFirstFaulting",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                                                ["Op2BaseType"] = "Int16",                 ["GetFfrType"] = "Int64",                                               ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskInt64()",                                            ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()"}),
        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorInt16SignExtendFirstFaulting_uint",                                                                     ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorInt16SignExtendFirstFaulting",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                                               ["Op2BaseType"] = "Int16",                 ["GetFfrType"] = "UInt32",                                              ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskUInt32()",                                           ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()"}),
        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorInt16SignExtendFirstFaulting_ulong",                                                                    ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorInt16SignExtendFirstFaulting",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                                               ["Op2BaseType"] = "Int16",                 ["GetFfrType"] = "UInt64",                                              ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskUInt64()",                                           ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()"}),

        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorInt32SignExtendFirstFaulting_long",                                                                     ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorInt32SignExtendFirstFaulting",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                                                ["Op2BaseType"] = "Int32",                 ["GetFfrType"] = "Int64",                                               ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskInt64()",                                            ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()"}),
        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorInt32SignExtendFirstFaulting_ulong",                                                                    ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorInt32SignExtendFirstFaulting",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                                               ["Op2BaseType"] = "Int32",                 ["GetFfrType"] = "UInt64",                                              ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskUInt64()",                                           ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()"}),

        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorSByteSignExtendFirstFaulting_int",                                                                      ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorSByteSignExtendFirstFaulting",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                                                ["Op2BaseType"] = "SByte",                 ["GetFfrType"] = "Int32",                                               ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskInt32()",                                            ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()"}),
        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorSByteSignExtendFirstFaulting_long",                                                                     ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorSByteSignExtendFirstFaulting",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                                                ["Op2BaseType"] = "SByte",                 ["GetFfrType"] = "Int64",                                               ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskInt64()",                                            ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()"}),
        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorSByteSignExtendFirstFaulting_short",                                                                    ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorSByteSignExtendFirstFaulting",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                                                ["Op2BaseType"] = "SByte",                 ["GetFfrType"] = "Int16",                                               ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskInt16()",                                            ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()"}),
        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorSByteSignExtendFirstFaulting_uint",                                                                     ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorSByteSignExtendFirstFaulting",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                                               ["Op2BaseType"] = "SByte",                 ["GetFfrType"] = "UInt32",                                              ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskUInt32()",                                           ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()"}),
        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorSByteSignExtendFirstFaulting_ulong",                                                                    ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorSByteSignExtendFirstFaulting",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                                               ["Op2BaseType"] = "SByte",                 ["GetFfrType"] = "UInt64",                                              ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskUInt64()",                                           ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()"}),
        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorSByteSignExtendFirstFaulting_ushort",                                                                   ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorSByteSignExtendFirstFaulting",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                                               ["Op2BaseType"] = "SByte",                 ["GetFfrType"] = "UInt16",                                              ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskUInt16()",                                           ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()"}),

        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorUInt16ZeroExtendFirstFaulting_int",                                                                     ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorUInt16ZeroExtendFirstFaulting",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                                                ["Op2BaseType"] = "UInt16",                ["GetFfrType"] = "Int32",                                               ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskInt32()",                                            ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()"}),
        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorUInt16ZeroExtendFirstFaulting_long",                                                                    ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorUInt16ZeroExtendFirstFaulting",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                                                ["Op2BaseType"] = "UInt16",                ["GetFfrType"] = "Int64",                                               ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskInt64()",                                            ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()"}),
        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorUInt16ZeroExtendFirstFaulting_uint",                                                                    ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorUInt16ZeroExtendFirstFaulting",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                                               ["Op2BaseType"] = "UInt16",                ["GetFfrType"] = "UInt32",                                              ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskUInt32()",                                           ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()"}),
        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorUInt16ZeroExtendFirstFaulting_ulong",                                                                   ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorUInt16ZeroExtendFirstFaulting",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                                               ["Op2BaseType"] = "UInt16",                ["GetFfrType"] = "UInt64",                                              ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskUInt64()",                                           ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()"}),

        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorUInt32ZeroExtendFirstFaulting_long",                                                                    ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorUInt32ZeroExtendFirstFaulting",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                                                ["Op2BaseType"] = "UInt32",                ["GetFfrType"] = "Int64" ,                                              ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskInt64()",                                            ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()"}),
        ("SveLoadVectorFirstFaultingTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorUInt32ZeroExtendFirstFaulting_ulong",                                                                   ["Isa"] = "Sve",      ["LoadIsa"] = "Sve",                              ["Method"] = "LoadVectorUInt32ZeroExtendFirstFaulting",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                                               ["Op2BaseType"] = "UInt32",                ["GetFfrType"] = "UInt64",                                              ["LargestVectorSize"] = "64",                               ["NextValueOp1"] = "Helpers.getMaskUInt64()",                                           ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()"}),

        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorNonTemporal_float",                                                                     ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorNonTemporal",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                  ["Op2BaseType"] = "Single",                                                   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskSingle()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorNonTemporal_double",                                                                    ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorNonTemporal",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                  ["Op2BaseType"] = "Double",                                                   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskDouble()",  ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorNonTemporal_sbyte",                                                                     ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorNonTemporal",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                   ["Op2BaseType"] = "SByte",                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskSByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorNonTemporal_short",                                                                     ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorNonTemporal",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                   ["Op2BaseType"] = "Int16",                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt16()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorNonTemporal_int",                                                                       ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorNonTemporal",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int32",                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorNonTemporal_long",                                                                      ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorNonTemporal",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int64",                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorNonTemporal_byte",                                                                      ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorNonTemporal",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",                                    ["Op2BaseType"] = "Byte",                                                     ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskByte()",    ["NextValueOp2"] = "TestLibrary.Generator.GetByte()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorNonTemporal_ushort",                                                                    ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorNonTemporal",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                  ["Op2BaseType"] = "UInt16",                                                   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorNonTemporal_uint",                                                                      ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorNonTemporal",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32",                                                   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorNonTemporal_ulong",                                                                     ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorNonTemporal",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt64",                                                   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()"}),

        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVector128AndReplicateToVector_float",                                                         ["Isa"] = "Sve",                                    ["Method"] = "LoadVector128AndReplicateToVector",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                  ["Op2BaseType"] = "Single",                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskSingle()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVector128AndReplicateToVector_double",                                                        ["Isa"] = "Sve",                                    ["Method"] = "LoadVector128AndReplicateToVector",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                  ["Op2BaseType"] = "Double",                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskDouble()",  ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVector128AndReplicateToVector_sbyte",                                                         ["Isa"] = "Sve",                                    ["Method"] = "LoadVector128AndReplicateToVector",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                   ["Op2BaseType"] = "SByte",                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskSByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVector128AndReplicateToVector_short",                                                         ["Isa"] = "Sve",                                    ["Method"] = "LoadVector128AndReplicateToVector",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                   ["Op2BaseType"] = "Int16",                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt16()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVector128AndReplicateToVector_int",                                                           ["Isa"] = "Sve",                                    ["Method"] = "LoadVector128AndReplicateToVector",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int32",                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVector128AndReplicateToVector_long",                                                          ["Isa"] = "Sve",                                    ["Method"] = "LoadVector128AndReplicateToVector",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int64",                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVector128AndReplicateToVector_byte",                                                          ["Isa"] = "Sve",                                    ["Method"] = "LoadVector128AndReplicateToVector",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",                                    ["Op2BaseType"] = "Byte",                                         ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskByte()",    ["NextValueOp2"] = "TestLibrary.Generator.GetByte()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVector128AndReplicateToVector_ushort",                                                        ["Isa"] = "Sve",                                    ["Method"] = "LoadVector128AndReplicateToVector",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                  ["Op2BaseType"] = "UInt16",                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVector128AndReplicateToVector_uint",                                                          ["Isa"] = "Sve",                                    ["Method"] = "LoadVector128AndReplicateToVector",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32",                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVector128AndReplicateToVector_ulong",                                                         ["Isa"] = "Sve",                                    ["Method"] = "LoadVector128AndReplicateToVector",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt64",                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()"}),

        ("SveLoadNonFaultingMaskedUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve_LoadVectorInt16NonFaultingSignExtendToInt32_int",                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "LoadVectorInt16NonFaultingSignExtendToInt32",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["GetFfrType"] = "Int32",         ["Cast"] = "",                                                                            ["ValidateIterResult"] = "firstOp[i] != result[i]",}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve_LoadVectorInt16NonFaultingSignExtendToInt64_long",                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "LoadVectorInt16NonFaultingSignExtendToInt64",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["GetFfrType"] = "Int64",         ["Cast"] = "",                                                                            ["ValidateIterResult"] = "firstOp[i] != result[i]",}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve_LoadVectorInt16NonFaultingSignExtendToUInt32_uint",                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "LoadVectorInt16NonFaultingSignExtendToUInt32",                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["GetFfrType"] = "UInt32",        ["Cast"] = "",                                                                            ["ValidateIterResult"] = "((uint)firstOp[i]) != result[i]",}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve_LoadVectorInt16NonFaultingSignExtendToUInt64_ulong",                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "LoadVectorInt16NonFaultingSignExtendToUInt64",                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["GetFfrType"] = "UInt64",        ["Cast"] = "",                                                                            ["ValidateIterResult"] = "((ulong)firstOp[i]) != result[i]",}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve_LoadVectorInt32NonFaultingSignExtendToInt64_long",                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "LoadVectorInt32NonFaultingSignExtendToInt64",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["GetFfrType"] = "Int64",         ["Cast"] = "",                                                                            ["ValidateIterResult"] = "firstOp[i] != result[i]",}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve_LoadVectorInt32NonFaultingSignExtendToUInt64_ulong",                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "LoadVectorInt32NonFaultingSignExtendToUInt64",                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["GetFfrType"] = "UInt64",        ["Cast"] = "",                                                                            ["ValidateIterResult"] = "((ulong)firstOp[i]) != result[i]",}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve_LoadVectorSByteNonFaultingSignExtendToInt16_short",                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "LoadVectorSByteNonFaultingSignExtendToInt16",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                   ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt16()",   ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["GetFfrType"] = "Int16",         ["Cast"] = "",                                                                            ["ValidateIterResult"] = "firstOp[i] != result[i]",}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve_LoadVectorSByteNonFaultingSignExtendToInt32_int",                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "LoadVectorSByteNonFaultingSignExtendToInt32",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",   ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["GetFfrType"] = "Int32",         ["Cast"] = "",                                                                            ["ValidateIterResult"] = "firstOp[i] != result[i]",}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve_LoadVectorSByteNonFaultingSignExtendToInt64_long",                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "LoadVectorSByteNonFaultingSignExtendToInt64",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",   ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["GetFfrType"] = "Int64",         ["Cast"] = "",                                                                            ["ValidateIterResult"] = "firstOp[i] != result[i]",}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve_LoadVectorSByteNonFaultingSignExtendToUInt16_ushort",                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "LoadVectorSByteNonFaultingSignExtendToUInt16",                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["GetFfrType"] = "UInt16",        ["Cast"] = "",                                                                            ["ValidateIterResult"] = "((ushort)firstOp[i]) != result[i]",}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve_LoadVectorSByteNonFaultingSignExtendToUInt32_uint",                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "LoadVectorSByteNonFaultingSignExtendToUInt32",                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["GetFfrType"] = "UInt32",        ["Cast"] = "",                                                                            ["ValidateIterResult"] = "((uint)firstOp[i]) != result[i]",}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve_LoadVectorSByteNonFaultingSignExtendToUInt64_ulong",                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "LoadVectorSByteNonFaultingSignExtendToUInt64",                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["GetFfrType"] = "UInt64",        ["Cast"] = "",                                                                            ["ValidateIterResult"] = "((ulong)firstOp[i]) != result[i]",}),

        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorInt16SignExtendToInt32",                                                                ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorInt16SignExtendToInt32",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorInt16SignExtendToInt64",                                                                ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorInt16SignExtendToInt64",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorInt16SignExtendToUInt32",                                                               ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorInt16SignExtendToUInt32",                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorInt16SignExtendToUInt64",                                                               ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorInt16SignExtendToUInt64",                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                      ["ValidateIterResult"] = "(ulong)firstOp[i] != result[i]"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorInt32SignExtendToInt64",                                                                ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorInt32SignExtendToInt64",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorInt32SignExtendToUInt64",                                                               ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorInt32SignExtendToUInt64",                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                      ["ValidateIterResult"] = "(ulong)firstOp[i] != result[i]"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorSByteSignExtendToInt16",                                                                ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorSByteSignExtendToInt16",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                   ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt16()",   ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorSByteSignExtendToInt32",                                                                ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorSByteSignExtendToInt32",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",   ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorSByteSignExtendToInt64",                                                                ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorSByteSignExtendToInt64",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",   ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorSByteSignExtendToUInt16",                                                               ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorSByteSignExtendToUInt16",                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorSByteSignExtendToUInt32",                                                               ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorSByteSignExtendToUInt32",                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorSByteSignExtendToUInt64",                                                               ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorSByteSignExtendToUInt64",                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                      ["ValidateIterResult"] = "(ulong)firstOp[i] != result[i]"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorByteZeroExtendToInt16",                                                                 ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorByteZeroExtendToInt16",                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt16()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorByteZeroExtendToInt32",                                                                 ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorByteZeroExtendToInt32",                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorByteZeroExtendToInt64",                                                                 ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorByteZeroExtendToInt64",                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorByteZeroExtendToUInt16",                                                                ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorByteZeroExtendToUInt16",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetByte()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorByteZeroExtendToUInt32",                                                                ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorByteZeroExtendToUInt32",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetByte()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorByteZeroExtendToUInt64",                                                                ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorByteZeroExtendToUInt64",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetByte()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorUInt16ZeroExtendToInt32",                                                               ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorUInt16ZeroExtendToInt32",                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",   ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorUInt16ZeroExtendToInt64",                                                               ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorUInt16ZeroExtendToInt64",                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",   ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorUInt16ZeroExtendToUInt32",                                                              ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorUInt16ZeroExtendToUInt32",                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorUInt16ZeroExtendToUInt64",                                                              ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorUInt16ZeroExtendToUInt64",                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorUInt32ZeroExtendToInt64",                                                               ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorUInt32ZeroExtendToInt64",                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",   ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()"}),
        ("SveLoadVectorMaskedTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorUInt32ZeroExtendToUInt64",                                                              ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorUInt32ZeroExtendToUInt64",                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()"}),

        ("SveLoadNonFaultingMaskedUnOpTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorByteNonFaultingZeroExtendToInt16",                                             ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorByteNonFaultingZeroExtendToInt16",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt16()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",        ["GetFfrType"] = "Int16",    ["Cast"] = "",                                                                    ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorByteNonFaultingZeroExtendToInt32",                                             ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorByteNonFaultingZeroExtendToInt32",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",        ["GetFfrType"] = "Int32",    ["Cast"] = "",                                                                    ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorByteNonFaultingZeroExtendToInt64",                                             ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorByteNonFaultingZeroExtendToInt64",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",        ["GetFfrType"] = "Int64",    ["Cast"] = "",                                                                    ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorByteNonFaultingZeroExtendToUInt16",                                            ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorByteNonFaultingZeroExtendToUInt16",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",        ["GetFfrType"] = "UInt16",   ["Cast"] = "",                                                                    ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorByteNonFaultingZeroExtendToUInt32",                                            ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorByteNonFaultingZeroExtendToUInt32",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",        ["GetFfrType"] = "UInt32",   ["Cast"] = "",                                                                    ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorByteNonFaultingZeroExtendToUInt64",                                            ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorByteNonFaultingZeroExtendToUInt64",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",        ["GetFfrType"] = "UInt64",   ["Cast"] = "",                                                                    ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorUInt16NonFaultingZeroExtendToInt32",                                           ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorUInt16NonFaultingZeroExtendToInt32",                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt32()",   ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",      ["GetFfrType"] = "Int32",    ["Cast"] = "",                                                                    ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorUInt16NonFaultingZeroExtendToInt64",                                           ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorUInt16NonFaultingZeroExtendToInt64",                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",   ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",      ["GetFfrType"] = "Int64",    ["Cast"] = "",                                                                    ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorUInt16NonFaultingZeroExtendToUInt32",                                          ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorUInt16NonFaultingZeroExtendToUInt32",                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",      ["GetFfrType"] = "UInt32",   ["Cast"] = "",                                                                    ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorUInt16NonFaultingZeroExtendToUInt64",                                          ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorUInt16NonFaultingZeroExtendToUInt64",                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",      ["GetFfrType"] = "UInt64",   ["Cast"] = "",                                                                    ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorUInt32NonFaultingZeroExtendToInt64",                                           ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorUInt32NonFaultingZeroExtendToInt64",                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskInt64()",   ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",      ["GetFfrType"] = "Int64",    ["Cast"] = "",                                                                    ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("SveLoadNonFaultingMaskedUnOpTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve_LoadVectorUInt32NonFaultingZeroExtendToUInt64",                                          ["Isa"] = "Sve",                                    ["Method"] = "LoadVectorUInt32NonFaultingZeroExtendToUInt64",                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "Helpers.getMaskUInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",      ["GetFfrType"] = "UInt64",   ["Cast"] = "",                                                                    ["ValidateIterResult"] = "firstOp[i] != result[i]"}),

        ("SveLoad2xVectorAndUnzipTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Load2xVectorAndUnzip_float",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Load2xVectorAndUnzip",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i * 2] || result2[i] != input[i * 2 + 1]"}),
        ("SveLoad2xVectorAndUnzipTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Load2xVectorAndUnzip_double",                                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Load2xVectorAndUnzip",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                  ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i * 2] || result2[i] != input[i * 2 + 1]"}),
        ("SveLoad2xVectorAndUnzipTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Load2xVectorAndUnzip_sbyte",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Load2xVectorAndUnzip",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                   ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                         ["ValidateIterResult"] = "result1[i] != input[i * 2] || result2[i] != input[i * 2 + 1]"}),
        ("SveLoad2xVectorAndUnzipTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Load2xVectorAndUnzip_short",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Load2xVectorAndUnzip",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                   ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                         ["ValidateIterResult"] = "result1[i] != input[i * 2] || result2[i] != input[i * 2 + 1]"}),
        ("SveLoad2xVectorAndUnzipTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Load2xVectorAndUnzip_int",                                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Load2xVectorAndUnzip",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                         ["ValidateIterResult"] = "result1[i] != input[i * 2] || result2[i] != input[i * 2 + 1]"}),
        ("SveLoad2xVectorAndUnzipTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Load2xVectorAndUnzip_long",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Load2xVectorAndUnzip",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                         ["ValidateIterResult"] = "result1[i] != input[i * 2] || result2[i] != input[i * 2 + 1]"}),
        ("SveLoad2xVectorAndUnzipTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Load2xVectorAndUnzip_byte",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Load2xVectorAndUnzip",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",                                    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                          ["ValidateIterResult"] = "result1[i] != input[i * 2] || result2[i] != input[i * 2 + 1]"}),
        ("SveLoad2xVectorAndUnzipTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Load2xVectorAndUnzip_ushort",                                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Load2xVectorAndUnzip",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i * 2] || result2[i] != input[i * 2 + 1]"}),
        ("SveLoad2xVectorAndUnzipTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Load2xVectorAndUnzip_uint",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Load2xVectorAndUnzip",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i * 2] || result2[i] != input[i * 2 + 1]"}),
        ("SveLoad2xVectorAndUnzipTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Load2xVectorAndUnzip_ulong",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Load2xVectorAndUnzip",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i * 2] || result2[i] != input[i * 2 + 1]"}),
        ("SveLoad3xVectorAndUnzipTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Load3xVectorAndUnzip_float",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Load3xVectorAndUnzip",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i * 3] || result2[i] != input[i * 3 + 1] || result3[i] != input[i * 3 + 2]"}),
        ("SveLoad3xVectorAndUnzipTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Load3xVectorAndUnzip_double",                                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Load3xVectorAndUnzip",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                  ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i * 3] || result2[i] != input[i * 3 + 1] || result3[i] != input[i * 3 + 2]"}),
        ("SveLoad3xVectorAndUnzipTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Load3xVectorAndUnzip_sbyte",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Load3xVectorAndUnzip",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                   ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                         ["ValidateIterResult"] = "result1[i] != input[i * 3] || result2[i] != input[i * 3 + 1] || result3[i] != input[i * 3 + 2]"}),
        ("SveLoad3xVectorAndUnzipTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Load3xVectorAndUnzip_short",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Load3xVectorAndUnzip",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                   ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                         ["ValidateIterResult"] = "result1[i] != input[i * 3] || result2[i] != input[i * 3 + 1] || result3[i] != input[i * 3 + 2]"}),
        ("SveLoad3xVectorAndUnzipTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Load3xVectorAndUnzip_int",                                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Load3xVectorAndUnzip",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                         ["ValidateIterResult"] = "result1[i] != input[i * 3] || result2[i] != input[i * 3 + 1] || result3[i] != input[i * 3 + 2]"}),
        ("SveLoad3xVectorAndUnzipTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Load3xVectorAndUnzip_long",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Load3xVectorAndUnzip",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                         ["ValidateIterResult"] = "result1[i] != input[i * 3] || result2[i] != input[i * 3 + 1] || result3[i] != input[i * 3 + 2]"}),
        ("SveLoad3xVectorAndUnzipTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Load3xVectorAndUnzip_byte",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Load3xVectorAndUnzip",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",                                    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                          ["ValidateIterResult"] = "result1[i] != input[i * 3] || result2[i] != input[i * 3 + 1] || result3[i] != input[i * 3 + 2]"}),
        ("SveLoad3xVectorAndUnzipTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Load3xVectorAndUnzip_ushort",                                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Load3xVectorAndUnzip",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i * 3] || result2[i] != input[i * 3 + 1] || result3[i] != input[i * 3 + 2]"}),
        ("SveLoad3xVectorAndUnzipTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Load3xVectorAndUnzip_uint",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Load3xVectorAndUnzip",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i * 3] || result2[i] != input[i * 3 + 1] || result3[i] != input[i * 3 + 2]"}),
        ("SveLoad3xVectorAndUnzipTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Load3xVectorAndUnzip_ulong",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Load3xVectorAndUnzip",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i * 3] || result2[i] != input[i * 3 + 1] || result3[i] != input[i * 3 + 2]"}),
        ("SveLoad4xVectorAndUnzipTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Load4xVectorAndUnzip_float",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Load4xVectorAndUnzip",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i * 4] || result2[i] != input[i * 4 + 1] || result3[i] != input[i * 4 + 2] || result4[i] != input[i * 4 + 3]"}),
        ("SveLoad4xVectorAndUnzipTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Load4xVectorAndUnzip_double",                                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Load4xVectorAndUnzip",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                  ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i * 4] || result2[i] != input[i * 4 + 1] || result3[i] != input[i * 4 + 2] || result4[i] != input[i * 4 + 3]"}),
        ("SveLoad4xVectorAndUnzipTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Load4xVectorAndUnzip_sbyte",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Load4xVectorAndUnzip",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                   ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                         ["ValidateIterResult"] = "result1[i] != input[i * 4] || result2[i] != input[i * 4 + 1] || result3[i] != input[i * 4 + 2] || result4[i] != input[i * 4 + 3]"}),
        ("SveLoad4xVectorAndUnzipTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Load4xVectorAndUnzip_short",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Load4xVectorAndUnzip",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                   ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                         ["ValidateIterResult"] = "result1[i] != input[i * 4] || result2[i] != input[i * 4 + 1] || result3[i] != input[i * 4 + 2] || result4[i] != input[i * 4 + 3]"}),
        ("SveLoad4xVectorAndUnzipTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Load4xVectorAndUnzip_int",                                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Load4xVectorAndUnzip",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                         ["ValidateIterResult"] = "result1[i] != input[i * 4] || result2[i] != input[i * 4 + 1] || result3[i] != input[i * 4 + 2] || result4[i] != input[i * 4 + 3]"}),
        ("SveLoad4xVectorAndUnzipTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Load4xVectorAndUnzip_long",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Load4xVectorAndUnzip",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                         ["ValidateIterResult"] = "result1[i] != input[i * 4] || result2[i] != input[i * 4 + 1] || result3[i] != input[i * 4 + 2] || result4[i] != input[i * 4 + 3]"}),
        ("SveLoad4xVectorAndUnzipTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Load4xVectorAndUnzip_byte",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Load4xVectorAndUnzip",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",                                    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                          ["ValidateIterResult"] = "result1[i] != input[i * 4] || result2[i] != input[i * 4 + 1] || result3[i] != input[i * 4 + 2] || result4[i] != input[i * 4 + 3]"}),
        ("SveLoad4xVectorAndUnzipTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Load4xVectorAndUnzip_ushort",                                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Load4xVectorAndUnzip",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i * 4] || result2[i] != input[i * 4 + 1] || result3[i] != input[i * 4 + 2] || result4[i] != input[i * 4 + 3]"}),
        ("SveLoad4xVectorAndUnzipTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Load4xVectorAndUnzip_uint",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Load4xVectorAndUnzip",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i * 4] || result2[i] != input[i * 4 + 1] || result3[i] != input[i * 4 + 2] || result4[i] != input[i * 4 + 3]"}),
        ("SveLoad4xVectorAndUnzipTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Load4xVectorAndUnzip_ulong",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Load4xVectorAndUnzip",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i * 4] || result2[i] != input[i * 4 + 1] || result3[i] != input[i * 4 + 2] || result4[i] != input[i * 4 + 3]"}),

        ("SveVecBinOpTest.template",                   new Dictionary<string, string> { ["TestName"] = "Sve_Max_float",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Max",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                 ["ValidateIterResult"] = "Helpers.Max(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Max(left[i], right[i])"}),
        ("SveVecBinOpTest.template",                   new Dictionary<string, string> { ["TestName"] = "Sve_Max_double",                                                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Max",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                 ["ValidateIterResult"] = "Helpers.Max(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Max(left[i], right[i])"}),
        ("SveVecBinOpTest.template",                   new Dictionary<string, string> { ["TestName"] = "Sve_Max_sbyte",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Max",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                  ["ValidateIterResult"] = "Helpers.Max(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Max(left[i], right[i])"}),
        ("SveVecBinOpTest.template",                   new Dictionary<string, string> { ["TestName"] = "Sve_Max_short",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Max",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                  ["ValidateIterResult"] = "Helpers.Max(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Max(left[i], right[i])"}),
        ("SveVecBinOpTest.template",                   new Dictionary<string, string> { ["TestName"] = "Sve_Max_int",                                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Max",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                  ["ValidateIterResult"] = "Helpers.Max(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Max(left[i], right[i])"}),
        ("SveVecBinOpTest.template",                   new Dictionary<string, string> { ["TestName"] = "Sve_Max_long",                                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Max",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                  ["ValidateIterResult"] = "Helpers.Max(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Max(left[i], right[i])"}),
        ("SveVecBinOpTest.template",                   new Dictionary<string, string> { ["TestName"] = "Sve_Max_byte",                                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Max",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                   ["ValidateIterResult"] = "Helpers.Max(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Max(left[i], right[i])"}),
        ("SveVecBinOpTest.template",                   new Dictionary<string, string> { ["TestName"] = "Sve_Max_ushort",                                                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Max",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                 ["ValidateIterResult"] = "Helpers.Max(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Max(left[i], right[i])"}),
        ("SveVecBinOpTest.template",                   new Dictionary<string, string> { ["TestName"] = "Sve_Max_uint",                                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Max",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                 ["ValidateIterResult"] = "Helpers.Max(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Max(left[i], right[i])"}),
        ("SveVecBinOpTest.template",                   new Dictionary<string, string> { ["TestName"] = "Sve_Max_ulong",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Max",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                 ["ValidateIterResult"] = "Helpers.Max(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Max(left[i], right[i])"}),

        ("SveVecReduceUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Sve_MaxAcross_float",                                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MaxAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                 ["ValidateReduceOpResult"] = "Helpers.MaxAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Sve_MaxAcross_double",                                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MaxAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                                                 ["ValidateReduceOpResult"] = "Helpers.MaxAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Sve_MaxAcross_sbyte",                                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MaxAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                                                  ["ValidateReduceOpResult"] = "Helpers.MaxAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Sve_MaxAcross_short",                                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MaxAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                  ["ValidateReduceOpResult"] = "Helpers.MaxAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Sve_MaxAcross_int",                                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MaxAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                  ["ValidateReduceOpResult"] = "Helpers.MaxAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Sve_MaxAcross_long",                                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MaxAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                                                  ["ValidateReduceOpResult"] = "Helpers.MaxAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Sve_MaxAcross_byte",                                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MaxAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                                                   ["ValidateReduceOpResult"] = "Helpers.MaxAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Sve_MaxAcross_ushort",                                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MaxAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                                                 ["ValidateReduceOpResult"] = "Helpers.MaxAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Sve_MaxAcross_uint",                                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MaxAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                                 ["ValidateReduceOpResult"] = "Helpers.MaxAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Sve_MaxAcross_ulong",                                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MaxAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                                                 ["ValidateReduceOpResult"] = "Helpers.MaxAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),

        ("SveVecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Sve_MaxNumber_float",                                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MaxNumber",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "Helpers.Max(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Max(left[i], right[i])"}),
        ("SveVecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Sve_MaxNumber_double",                                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MaxNumber",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                       ["ValidateIterResult"] = "Helpers.Max(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Max(left[i], right[i])"}),

        ("SveVecReduceUnOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_MaxNumberAcross_float",                                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MaxNumberAcross",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                 ["ValidateReduceOpResult"] = "Helpers.MaxAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_MaxNumberAcross_double",                                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MaxNumberAcross",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                                                 ["ValidateReduceOpResult"] = "Helpers.MaxAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),

        ("SveVecBinOpTest.template",                   new Dictionary<string, string> { ["TestName"] = "Sve_Min_float",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Min",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                              ["ValidateIterResult"] = "Helpers.Min(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Min(left[i], right[i])"}),
        ("SveVecBinOpTest.template",                   new Dictionary<string, string> { ["TestName"] = "Sve_Min_double",                                                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Min",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                              ["ValidateIterResult"] = "Helpers.Min(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Min(left[i], right[i])"}),
        ("SveVecBinOpTest.template",                   new Dictionary<string, string> { ["TestName"] = "Sve_Min_sbyte",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Min",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                               ["ValidateIterResult"] = "Helpers.Min(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Min(left[i], right[i])"}),
        ("SveVecBinOpTest.template",                   new Dictionary<string, string> { ["TestName"] = "Sve_Min_short",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Min",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                               ["ValidateIterResult"] = "Helpers.Min(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Min(left[i], right[i])"}),
        ("SveVecBinOpTest.template",                   new Dictionary<string, string> { ["TestName"] = "Sve_Min_int",                                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Min",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                               ["ValidateIterResult"] = "Helpers.Min(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Min(left[i], right[i])"}),
        ("SveVecBinOpTest.template",                   new Dictionary<string, string> { ["TestName"] = "Sve_Min_long",                                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Min",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                               ["ValidateIterResult"] = "Helpers.Min(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Min(left[i], right[i])"}),
        ("SveVecBinOpTest.template",                   new Dictionary<string, string> { ["TestName"] = "Sve_Min_byte",                                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Min",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                ["ValidateIterResult"] = "Helpers.Min(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Min(left[i], right[i])"}),
        ("SveVecBinOpTest.template",                   new Dictionary<string, string> { ["TestName"] = "Sve_Min_ushort",                                                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Min",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                              ["ValidateIterResult"] = "Helpers.Min(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Min(left[i], right[i])"}),
        ("SveVecBinOpTest.template",                   new Dictionary<string, string> { ["TestName"] = "Sve_Min_uint",                                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Min",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                              ["ValidateIterResult"] = "Helpers.Min(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Min(left[i], right[i])"}),
        ("SveVecBinOpTest.template",                   new Dictionary<string, string> { ["TestName"] = "Sve_Min_ulong",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Min",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                              ["ValidateIterResult"] = "Helpers.Min(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Min(left[i], right[i])"}),

        ("SveVecReduceUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Sve_MinAcross_float",                                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MinAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                               ["ValidateReduceOpResult"] = "Helpers.MinAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Sve_MinAcross_double",                                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MinAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                                               ["ValidateReduceOpResult"] = "Helpers.MinAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Sve_MinAcross_sbyte",                                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MinAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                                                ["ValidateReduceOpResult"] = "Helpers.MinAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Sve_MinAcross_short",                                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MinAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                ["ValidateReduceOpResult"] = "Helpers.MinAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Sve_MinAcross_int",                                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MinAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                ["ValidateReduceOpResult"] = "Helpers.MinAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Sve_MinAcross_long",                                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MinAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                                                ["ValidateReduceOpResult"] = "Helpers.MinAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Sve_MinAcross_byte",                                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MinAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                                                 ["ValidateReduceOpResult"] = "Helpers.MinAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Sve_MinAcross_ushort",                                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MinAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                                               ["ValidateReduceOpResult"] = "Helpers.MinAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Sve_MinAcross_uint",                                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MinAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                               ["ValidateReduceOpResult"] = "Helpers.MinAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Sve_MinAcross_ulong",                                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MinAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                                               ["ValidateReduceOpResult"] = "Helpers.MinAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),

        ("SveVecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Sve_MinNumber_float",                                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MinNumber",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                               ["ValidateIterResult"] = "Helpers.Min(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Min(left[i], right[i])"}),
        ("SveVecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Sve_MinNumber_double",                                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MinNumber",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                               ["ValidateIterResult"] = "Helpers.Min(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Min(left[i], right[i])"}),

        ("SveVecReduceUnOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_MinNumberAcross_float",                                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MinNumberAcross",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                               ["ValidateReduceOpResult"] = "Helpers.MinAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_MinNumberAcross_double",                                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MinNumberAcross",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                                               ["ValidateReduceOpResult"] = "Helpers.MinAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),

        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Multiply_float",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Multiply",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",       ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                        ["ValidateIterResult"] = "Helpers.Multiply(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Multiply(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Multiply_double",                                                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Multiply",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",       ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                        ["ValidateIterResult"] = "Helpers.Multiply(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Multiply(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Multiply_sbyte",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Multiply",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "(sbyte)TestLibrary.Generator.GetSByte()", ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                         ["ValidateIterResult"] = "Helpers.Multiply(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Multiply(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Multiply_short",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Multiply",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "(short)TestLibrary.Generator.GetInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                         ["ValidateIterResult"] = "Helpers.Multiply(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Multiply(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Multiply_int",                                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Multiply",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                         ["ValidateIterResult"] = "Helpers.Multiply(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Multiply(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Multiply_long",                                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Multiply",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                         ["ValidateIterResult"] = "Helpers.Multiply(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Multiply(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Multiply_byte",                                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Multiply",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "(byte)TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                          ["ValidateIterResult"] = "Helpers.Multiply(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Multiply(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Multiply_ushort",                                                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Multiply",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.Multiply(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Multiply(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Multiply_uint",                                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Multiply",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.Multiply(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Multiply(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Multiply_ulong",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Multiply",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                        ["ValidateIterResult"] = "Helpers.Multiply(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.Multiply(left[i], right[i])"}),

        ("SveVecTernOpTest.template",           new Dictionary<string, string> { ["TestName"] = "Sve_MultiplyAdd_sbyte",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplyAdd",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpTest.template",           new Dictionary<string, string> { ["TestName"] = "Sve_MultiplyAdd_short",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplyAdd",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpTest.template",           new Dictionary<string, string> { ["TestName"] = "Sve_MultiplyAdd_int",                                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplyAdd",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpTest.template",           new Dictionary<string, string> { ["TestName"] = "Sve_MultiplyAdd_long",                                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplyAdd",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                         ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpTest.template",           new Dictionary<string, string> { ["TestName"] = "Sve_MultiplyAdd_byte",                                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplyAdd",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpTest.template",           new Dictionary<string, string> { ["TestName"] = "Sve_MultiplyAdd_ushort",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplyAdd",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpTest.template",           new Dictionary<string, string> { ["TestName"] = "Sve_MultiplyAdd_uint",                                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplyAdd",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpTest.template",           new Dictionary<string, string> { ["TestName"] = "Sve_MultiplyAdd_ulong",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplyAdd",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                        ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[i])", ["ConvertFunc"] = ""}),

        ("SveVecImmTernOpVecTest.template",     new Dictionary<string, string> {["TestName"] = "Sve_MultiplyAddRotateComplex_float_0",                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Single",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm"] = "0", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex(firstOp, secondOp, thirdOp, Imm))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",     new Dictionary<string, string> {["TestName"] = "Sve_MultiplyAddRotateComplex_float_1",                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Single",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm"] = "1", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex(firstOp, secondOp, thirdOp, Imm))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",     new Dictionary<string, string> {["TestName"] = "Sve_MultiplyAddRotateComplex_float_2",                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Single",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm"] = "2", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex(firstOp, secondOp, thirdOp, Imm))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",     new Dictionary<string, string> {["TestName"] = "Sve_MultiplyAddRotateComplex_float_3",                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Single",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm"] = "3", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex(firstOp, secondOp, thirdOp, Imm))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",     new Dictionary<string, string> {["TestName"] = "Sve_MultiplyAddRotateComplex_double_0",                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Double",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",["NextValueOp3"] = "TestLibrary.Generator.GetDouble()", ["NextValueMask"] = "Helpers.getMaskDouble()", ["Imm"] = "0", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex(firstOp, secondOp, thirdOp, Imm))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",     new Dictionary<string, string> {["TestName"] = "Sve_MultiplyAddRotateComplex_double_1",                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Double",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",["NextValueOp3"] = "TestLibrary.Generator.GetDouble()", ["NextValueMask"] = "Helpers.getMaskDouble()", ["Imm"] = "1", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex(firstOp, secondOp, thirdOp, Imm))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",     new Dictionary<string, string> {["TestName"] = "Sve_MultiplyAddRotateComplex_double_2",                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Double",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",["NextValueOp3"] = "TestLibrary.Generator.GetDouble()", ["NextValueMask"] = "Helpers.getMaskDouble()", ["Imm"] = "2", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex(firstOp, secondOp, thirdOp, Imm))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",     new Dictionary<string, string> {["TestName"] = "Sve_MultiplyAddRotateComplex_double_3",                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Double",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",["NextValueOp3"] = "TestLibrary.Generator.GetDouble()", ["NextValueMask"] = "Helpers.getMaskDouble()", ["Imm"] = "3", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex(firstOp, secondOp, thirdOp, Imm))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex(first, second, third, Imm)"}),

        ("SveVecImm2TernOpVecTest.template",    new Dictionary<string, string> {["TestName"] = "Sve_MultiplyAddRotateComplexBySelectedScalar_float_0_0",                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Single",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "0", ["Imm2"] = "0", ["InvalidImm1"] = "2", ["InvalidImm2"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",    new Dictionary<string, string> {["TestName"] = "Sve_MultiplyAddRotateComplexBySelectedScalar_float_0_1",                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Single",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "0", ["Imm2"] = "1", ["InvalidImm1"] = "2", ["InvalidImm2"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",    new Dictionary<string, string> {["TestName"] = "Sve_MultiplyAddRotateComplexBySelectedScalar_float_0_2",                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Single",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "0", ["Imm2"] = "2", ["InvalidImm1"] = "2", ["InvalidImm2"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",    new Dictionary<string, string> {["TestName"] = "Sve_MultiplyAddRotateComplexBySelectedScalar_float_0_3",                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Single",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "0", ["Imm2"] = "3", ["InvalidImm1"] = "2", ["InvalidImm2"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",    new Dictionary<string, string> {["TestName"] = "Sve_MultiplyAddRotateComplexBySelectedScalar_float_1_0",                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Single",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "1", ["Imm2"] = "0", ["InvalidImm1"] = "2", ["InvalidImm2"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",    new Dictionary<string, string> {["TestName"] = "Sve_MultiplyAddRotateComplexBySelectedScalar_float_1_1",                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Single",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "1", ["Imm2"] = "1", ["InvalidImm1"] = "2", ["InvalidImm2"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",    new Dictionary<string, string> {["TestName"] = "Sve_MultiplyAddRotateComplexBySelectedScalar_float_1_2",                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Single",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "1", ["Imm2"] = "2", ["InvalidImm1"] = "2", ["InvalidImm2"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",    new Dictionary<string, string> {["TestName"] = "Sve_MultiplyAddRotateComplexBySelectedScalar_float_1_3",                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Single",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",["NextValueOp3"] = "TestLibrary.Generator.GetSingle()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "1", ["Imm2"] = "3", ["InvalidImm1"] = "2", ["InvalidImm2"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),

        ("SveVecImmBinOpTest.template",    new Dictionary<string, string> {["TestName"] = "Sve_MultiplyBySelectedScalar_float",                                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplyBySelectedScalar",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",   ["Op3VectorType"] = "Vector",   ["Op3BaseType"] = "Single",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",      ["NextValueMask"] = "Helpers.getMaskSingle()",  ["Imm"] = "1", ["InvalidImm"] = "4", ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.Multiply(firstOp[i], secondOp[Imm])) != BitConverter.SingleToInt32Bits(result[i])",["GetIterResult"] = "Helpers.Multiply(firstOp[i], secondOp[Imm])", ["ConvertFunc"] = "BitConverter.SingleToInt32Bits"}),
        ("SveVecImmBinOpTest.template",    new Dictionary<string, string> {["TestName"] = "Sve_MultiplyBySelectedScalar_double",                                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplyBySelectedScalar",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",   ["Op3VectorType"] = "Vector",   ["Op3BaseType"] = "Double",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",      ["NextValueMask"] = "Helpers.getMaskDouble()",  ["Imm"] = "0", ["InvalidImm"] = "2", ["ValidateIterResult"] = "BitConverter.DoubleToInt64Bits(Helpers.Multiply(firstOp[i], secondOp[Imm])) != BitConverter.DoubleToInt64Bits(result[i])",["GetIterResult"] = "Helpers.Multiply(firstOp[i], secondOp[Imm])", ["ConvertFunc"] = "BitConverter.DoubleToInt64Bits"}),

        ("SveVecBinOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_MultiplyExtended_float",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplyExtended",                                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                           ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",       ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                              ["ValidateIterResult"] = "Helpers.MultiplyExtended(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyExtended(left[i], right[i])"}),
        ("SveVecBinOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_MultiplyExtended_double",                                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplyExtended",                                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                           ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",       ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                              ["ValidateIterResult"] = "Helpers.MultiplyExtended(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyExtended(left[i], right[i])"}),

        ("SveVecTernOpTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve_MultiplySubtract_sbyte",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplySubtract",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[i]) != result[i]", ["GetIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve_MultiplySubtract_short",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplySubtract",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[i]) != result[i]", ["GetIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve_MultiplySubtract_int",                                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplySubtract",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[i]) != result[i]", ["GetIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve_MultiplySubtract_long",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplySubtract",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                         ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[i]) != result[i]", ["GetIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve_MultiplySubtract_byte",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplySubtract",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[i]) != result[i]", ["GetIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve_MultiplySubtract_ushort",                                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplySubtract",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[i]) != result[i]", ["GetIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve_MultiplySubtract_uint",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplySubtract",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[i]) != result[i]", ["GetIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[i])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve_MultiplySubtract_ulong",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "MultiplySubtract",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                        ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[i]) != result[i]", ["GetIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[i])", ["ConvertFunc"] = ""}),

        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_Negate_float",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Negate",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                                                                       ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "-TestLibrary.Generator.GetSingle()",                                                                                                                                                     ["ValidateIterResult"] = "-firstOp[i] != result[i]", ["GetIterResult"] = "-leftOp[i]"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_Negate_double",                                                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Negate",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                                                                       ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "-TestLibrary.Generator.GetDouble()",                                                                                                                                                     ["ValidateIterResult"] = "-firstOp[i] != result[i]", ["GetIterResult"] = "-leftOp[i]"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_Negate_sbyte",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Negate",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                                                                        ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "(sbyte)-TestLibrary.Generator.GetSByte()",                                                                                                                                               ["ValidateIterResult"] = "-firstOp[i] != result[i]", ["GetIterResult"] = "(sbyte)-leftOp[i]"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_Negate_short",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Negate",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                                                                        ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "(short)-TestLibrary.Generator.GetInt16()",                                                                                                                                               ["ValidateIterResult"] = "-firstOp[i] != result[i]", ["GetIterResult"] = "(short)-leftOp[i]"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_Negate_int",                                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Negate",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                                                                        ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "-TestLibrary.Generator.GetInt32()",                                                                                                                                                      ["ValidateIterResult"] = "-firstOp[i] != result[i]", ["GetIterResult"] = "(int)-leftOp[i]"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_Negate_long",                                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Negate",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                                                                        ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "-TestLibrary.Generator.GetInt64()",                                                                                                                                                      ["ValidateIterResult"] = "(long)-firstOp[i] != (long)result[i]", ["GetIterResult"] = "(long)-leftOp[i]"}),

        ("SveVecAndScalarOpTest.template",    new Dictionary<string, string> {["TestName"] = "Sve_InsertIntoShiftedVector_float",                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "InsertIntoShiftedVector",                                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.ShiftAndInsert(firstOp, secondOp))",}),
        ("SveVecAndScalarOpTest.template",    new Dictionary<string, string> {["TestName"] = "Sve_InsertIntoShiftedVector_double",                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "InsertIntoShiftedVector",                                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                                                      ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.ShiftAndInsert(firstOp, secondOp))",}),
        ("SveVecAndScalarOpTest.template",    new Dictionary<string, string> {["TestName"] = "Sve_InsertIntoShiftedVector_sbyte",                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "InsertIntoShiftedVector",                                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                                                       ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.ShiftAndInsert(firstOp, secondOp))",}),
        ("SveVecAndScalarOpTest.template",    new Dictionary<string, string> {["TestName"] = "Sve_InsertIntoShiftedVector_short",                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "InsertIntoShiftedVector",                                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                       ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.ShiftAndInsert(firstOp, secondOp))",}),
        ("SveVecAndScalarOpTest.template",    new Dictionary<string, string> {["TestName"] = "Sve_InsertIntoShiftedVector_int",                                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "InsertIntoShiftedVector",                                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.ShiftAndInsert(firstOp, secondOp))",}),
        ("SveVecAndScalarOpTest.template",    new Dictionary<string, string> {["TestName"] = "Sve_InsertIntoShiftedVector_long",                                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "InsertIntoShiftedVector",                                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                                                       ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.ShiftAndInsert(firstOp, secondOp))",}),
        ("SveVecAndScalarOpTest.template",    new Dictionary<string, string> {["TestName"] = "Sve_InsertIntoShiftedVector_byte",                                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "InsertIntoShiftedVector",                                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",                                                                                                ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                                                        ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.ShiftAndInsert(firstOp, secondOp))",}),
        ("SveVecAndScalarOpTest.template",    new Dictionary<string, string> {["TestName"] = "Sve_InsertIntoShiftedVector_ushort",                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "InsertIntoShiftedVector",                                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                                                      ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.ShiftAndInsert(firstOp, secondOp))",}),
        ("SveVecAndScalarOpTest.template",    new Dictionary<string, string> {["TestName"] = "Sve_InsertIntoShiftedVector_uint",                                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "InsertIntoShiftedVector",                                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                                      ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.ShiftAndInsert(firstOp, secondOp))",}),
        ("SveVecAndScalarOpTest.template",    new Dictionary<string, string> {["TestName"] = "Sve_InsertIntoShiftedVector_ulong",                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "InsertIntoShiftedVector",                                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                                                      ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.ShiftAndInsert(firstOp, secondOp))",}),

        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_Not_sbyte",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Not",                                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.Not(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.Not(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_Not_short",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Not",                                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.Not(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.Not(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_Not_int",                                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Not",                                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.Not(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.Not(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_Not_long",                                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Not",                                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                                                                                                            ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.Not(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.Not(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_Not_byte",                                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Not",                                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                                                        ["ValidateIterResult"] = "Helpers.Not(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.Not(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_Not_ushort",                                                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Not",                                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.Not(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.Not(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_Not_uint",                                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Not",                                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.Not(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.Not(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_Not_ulong",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Not",                                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                                                                                                           ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.Not(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.Not(leftOp[i])"}),

        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Or_sbyte",                                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Or",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "(sbyte)TestLibrary.Generator.GetSByte()", ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                         ["ValidateIterResult"] = "Helpers.Or(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.Or(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Or_short",                                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Or",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "(short)TestLibrary.Generator.GetInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                         ["ValidateIterResult"] = "Helpers.Or(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.Or(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Or_int",                                                                                            ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Or",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                         ["ValidateIterResult"] = "Helpers.Or(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.Or(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Or_long",                                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Or",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                         ["ValidateIterResult"] = "Helpers.Or(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.Or(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Or_byte",                                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Or",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "(byte)TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                          ["ValidateIterResult"] = "Helpers.Or(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.Or(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Or_ushort",                                                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Or",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.Or(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.Or(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Or_uint",                                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Or",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.Or(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.Or(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve_Or_ulong",                                                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Or",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                        ["ValidateIterResult"] = "Helpers.Or(left[i], right[i]) != result[i]",        ["GetIterResult"] = "Helpers.Or(left[i], right[i])"}),

        ("SveVecReduceUnOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_OrAcross_sbyte",                                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "OrAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                                                       ["ValidateReduceOpResult"] = "Helpers.OrAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_OrAcross_short",                                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "OrAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                       ["ValidateReduceOpResult"] = "Helpers.OrAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_OrAcross_int",                                                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "OrAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateReduceOpResult"] = "Helpers.OrAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_OrAcross_long",                                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "OrAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                                                       ["ValidateReduceOpResult"] = "Helpers.OrAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_OrAcross_byte",                                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "OrAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                                                        ["ValidateReduceOpResult"] = "Helpers.OrAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_OrAcross_ushort",                                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "OrAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                                                      ["ValidateReduceOpResult"] = "Helpers.OrAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_OrAcross_uint",                                                                                     ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "OrAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                                      ["ValidateReduceOpResult"] = "Helpers.OrAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SveVecReduceUnOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve_OrAcross_ulong",                                                                                    ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "OrAcross",                                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                                                      ["ValidateReduceOpResult"] = "Helpers.OrAcross(firstOp) != result[0]",                                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),

        ("SveMasklessSimpleVecOpTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_PopCount_uint_float",                                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "PopCount",                                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "(uint)Helpers.BitCount(firstOp[i]) != result[i]",   ["GetIterResult"] = "(uint)Helpers.BitCount(leftOp[i])"}),
        ("SveMasklessSimpleVecOpTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_PopCount_ulong_double",                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "PopCount",                                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                                                      ["ValidateIterResult"] = "(ulong)Helpers.BitCount(firstOp[i]) != result[i]",  ["GetIterResult"] = "(ulong)Helpers.BitCount(leftOp[i])"}),
        ("SveMasklessSimpleVecOpTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_PopCount_byte_sbyte",                                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "PopCount",                                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                                                       ["ValidateIterResult"] = "(byte)Helpers.BitCount(firstOp[i]) != result[i]",   ["GetIterResult"] = "(byte)Helpers.BitCount(leftOp[i])"}),
        ("SveMasklessSimpleVecOpTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_PopCount_ushort_short",                                                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "PopCount",                                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                       ["ValidateIterResult"] = "(ushort)Helpers.BitCount(firstOp[i]) != result[i]", ["GetIterResult"] = "(ushort)Helpers.BitCount(leftOp[i])"}),
        ("SveMasklessSimpleVecOpTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_PopCount_uint_int",                                                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "PopCount",                                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateIterResult"] = "(uint)Helpers.BitCount(firstOp[i]) != result[i]",   ["GetIterResult"] = "(uint)Helpers.BitCount(leftOp[i])"}),
        ("SveMasklessSimpleVecOpTest.template", new Dictionary<string, string> { ["TestName"] = "Sve_PopCount_ulong_long",                                                                             ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "PopCount",                                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                                                       ["ValidateIterResult"] = "(ulong)Helpers.BitCount(firstOp[i]) != result[i]",  ["GetIterResult"] = "(ulong)Helpers.BitCount(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_PopCount_byte",                                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "PopCount",                                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                                                        ["ValidateIterResult"] = "Helpers.BitCount(firstOp[i]) != result[i]",         ["GetIterResult"] = "Helpers.BitCount(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_PopCount_ushort",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "PopCount",                                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.BitCount(firstOp[i]) != result[i]",         ["GetIterResult"] = "Helpers.BitCount(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_PopCount_uint",                                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "PopCount",                                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.BitCount(firstOp[i]) != result[i]",         ["GetIterResult"] = "Helpers.BitCount(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_PopCount_ulong",                                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "PopCount",                                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.BitCount(firstOp[i]) != result[i]",         ["GetIterResult"] = "Helpers.BitCount(leftOp[i])"}),
        ("SvePrefetchTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Prefetch16Bit",                                                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Prefetch16Bit",                                                        ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                                                                                                        ["LargestVectorSize"] = "64", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidPrefetch"] = "SvePrefetchType.LoadL2NonTemporal",  ["InvalidPrefetch"] = "(SvePrefetchType)18"}),
        ("SvePrefetchTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Prefetch32Bit",                                                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Prefetch32Bit",                                                        ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                                                                                                        ["LargestVectorSize"] = "64", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidPrefetch"] = "SvePrefetchType.StoreL3Temporal",    ["InvalidPrefetch"] = "(SvePrefetchType)20"}),
        ("SvePrefetchTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Prefetch64Bit",                                                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Prefetch64Bit",                                                        ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                                                                                                        ["LargestVectorSize"] = "64", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidPrefetch"] = "SvePrefetchType.StoreL1NonTemporal", ["InvalidPrefetch"] = "(SvePrefetchType)87"}),
        ("SvePrefetchTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve_Prefetch8Bit",                                                                                      ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "Prefetch8Bit",                                                        ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",                                                                                                                          ["LargestVectorSize"] = "64", ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidPrefetch"] = "SvePrefetchType.LoadL1Temporal",     ["InvalidPrefetch"] = "(SvePrefetchType)100"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_ReverseBits_byte",                                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ReverseBits",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                                                        ["ValidateIterResult"] = "result[i] != Helpers.ReverseElementBits(firstOp[i])",  ["GetIterResult"] = "Helpers.ReverseElementBits(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_ReverseBits_short",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ReverseBits",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                       ["ValidateIterResult"] = "result[i] != Helpers.ReverseElementBits(firstOp[i])",  ["GetIterResult"] = "Helpers.ReverseElementBits(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_ReverseBits_int",                                                                                   ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ReverseBits",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateIterResult"] = "result[i] != Helpers.ReverseElementBits(firstOp[i])",  ["GetIterResult"] = "Helpers.ReverseElementBits(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_ReverseBits_long",                                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ReverseBits",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                                                       ["ValidateIterResult"] = "result[i] != Helpers.ReverseElementBits(firstOp[i])",  ["GetIterResult"] = "Helpers.ReverseElementBits(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_ReverseBits_sbyte",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ReverseBits",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                                                       ["ValidateIterResult"] = "result[i] != Helpers.ReverseElementBits(firstOp[i])",  ["GetIterResult"] = "Helpers.ReverseElementBits(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_ReverseBits_ushort",                                                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ReverseBits",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                                                      ["ValidateIterResult"] = "result[i] != Helpers.ReverseElementBits(firstOp[i])",  ["GetIterResult"] = "Helpers.ReverseElementBits(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_ReverseBits_uint",                                                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ReverseBits",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                                      ["ValidateIterResult"] = "result[i] != Helpers.ReverseElementBits(firstOp[i])",  ["GetIterResult"] = "Helpers.ReverseElementBits(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve_ReverseBits_ulong",                                                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "ReverseBits",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                                                      ["ValidateIterResult"] = "result[i] != Helpers.ReverseElementBits(firstOp[i])",  ["GetIterResult"] = "Helpers.ReverseElementBits(leftOp[i])"}),

        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementBy16BitElementCount_int",                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementBy16BitElementCount",                                                                ["RetBaseType"] = "Int32",                                    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "(Byte)2",  ["Imm2"] = "SveMaskPattern.LargestPowerOf2",    ["InvalidImm"] = "(Byte)0",   ["InvalidImm2"] = "(SveMaskPattern)35",  ["ValidateResult"] = "isUnexpectedResult = (result != Helpers.SubtractSaturate((int)data, (int)(imm1 * Helpers.NumberOfElementsInVectorInt16(imm2))));",}),
        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementBy16BitElementCount_long",                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementBy16BitElementCount",                                                                ["RetBaseType"] = "Int64",                                    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["Imm"] = "(Byte)12", ["Imm2"] = "SveMaskPattern.VectorCount1",       ["InvalidImm"] = "(Byte)19",  ["InvalidImm2"] = "(SveMaskPattern)37",  ["ValidateResult"] = "isUnexpectedResult = (result != Helpers.SubtractSaturate((long)data, (long)(imm1 * Helpers.NumberOfElementsInVectorInt16(imm2))));",}),
        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementBy16BitElementCount_uint",                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementBy16BitElementCount",                                                                ["RetBaseType"] = "UInt32",                                   ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "(Byte)5",  ["Imm2"] = "SveMaskPattern.VectorCount2",       ["InvalidImm"] = "(Byte)25",  ["InvalidImm2"] = "(SveMaskPattern)46",  ["ValidateResult"] = "isUnexpectedResult = (result != Helpers.SubtractSaturate((uint)data, (uint)(imm1 * Helpers.NumberOfElementsInVectorInt16(imm2))));",}),
        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementBy16BitElementCount_ulong",                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementBy16BitElementCount",                                                                ["RetBaseType"] = "UInt64",                                   ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["Imm"] = "(Byte)7",  ["Imm2"] = "SveMaskPattern.VectorCount3",       ["InvalidImm"] = "(Byte)255", ["InvalidImm2"] = "(SveMaskPattern)50",  ["ValidateResult"] = "isUnexpectedResult = (result != Helpers.SubtractSaturate((ulong)data, (ulong)(imm1 * Helpers.NumberOfElementsInVectorInt16(imm2))));",}),
        ("SveVecImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementBy16BitElementCount_vector_short",                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementBy16BitElementCount",                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                   ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "(Byte)10", ["Imm2"] = "SveMaskPattern.VectorCount4",       ["InvalidImm"] = "(Byte)65",  ["InvalidImm2"] = "(SveMaskPattern)90",  ["ValidateIterResult"] = "result[i] != Helpers.SubtractSaturate((short)firstOp[i], (short)(imm1 * Helpers.NumberOfElementsInVectorInt16(imm2)))",}),
        ("SveVecImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementBy16BitElementCount_vector_ushort",                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementBy16BitElementCount",                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                  ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["Imm"] = "(Byte)1",  ["Imm2"] = "SveMaskPattern.VectorCount5",       ["InvalidImm"] = "(Byte)72",  ["InvalidImm2"] = "(SveMaskPattern)35",  ["ValidateIterResult"] = "result[i] != Helpers.SubtractSaturate((ushort)firstOp[i], (ushort)(imm1 * Helpers.NumberOfElementsInVectorInt16(imm2)))",}),

        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementBy32BitElementCount_int",                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementBy32BitElementCount",                                                                ["RetBaseType"] = "Int32",                                    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "(Byte)1",  ["Imm2"] = "SveMaskPattern.VectorCount6",       ["InvalidImm"] = "(Byte)17",  ["InvalidImm2"] = "(SveMaskPattern)32",  ["ValidateResult"] = "isUnexpectedResult = (result != Helpers.SubtractSaturate((int)data, (int)(imm1 * Helpers.NumberOfElementsInVectorInt32(imm2))));",}),
        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementBy32BitElementCount_long",                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementBy32BitElementCount",                                                                ["RetBaseType"] = "Int64",                                    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["Imm"] = "(Byte)2",  ["Imm2"] = "SveMaskPattern.VectorCount7",       ["InvalidImm"] = "(Byte)19",  ["InvalidImm2"] = "(SveMaskPattern)33",  ["ValidateResult"] = "isUnexpectedResult = (result != Helpers.SubtractSaturate((long)data, (long)(imm1 * Helpers.NumberOfElementsInVectorInt32(imm2))));",}),
        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementBy32BitElementCount_uint",                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementBy32BitElementCount",                                                                ["RetBaseType"] = "UInt32",                                   ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "(Byte)3",  ["Imm2"] = "SveMaskPattern.VectorCount8",       ["InvalidImm"] = "(Byte)25",  ["InvalidImm2"] = "(SveMaskPattern)34",  ["ValidateResult"] = "isUnexpectedResult = (result != Helpers.SubtractSaturate((uint)data, (uint)(imm1 * Helpers.NumberOfElementsInVectorInt32(imm2))));",}),
        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementBy32BitElementCount_ulong",                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementBy32BitElementCount",                                                                ["RetBaseType"] = "UInt64",                                   ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["Imm"] = "(Byte)4",  ["Imm2"] = "SveMaskPattern.VectorCount32",      ["InvalidImm"] = "(Byte)26",  ["InvalidImm2"] = "(SveMaskPattern)35",  ["ValidateResult"] = "isUnexpectedResult = (result != Helpers.SubtractSaturate((ulong)data, (ulong)(imm1 * Helpers.NumberOfElementsInVectorInt16(imm2))));",}),
        ("SveVecImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementBy32BitElementCount_vector_int",                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementBy32BitElementCount",                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "(Byte)5",  ["Imm2"] = "SveMaskPattern.VectorCount64",      ["InvalidImm"] = "(Byte)27",  ["InvalidImm2"] = "(SveMaskPattern)36",  ["ValidateIterResult"] = "result[i] != Helpers.SubtractSaturate((int)firstOp[i], (int)(imm1 * Helpers.NumberOfElementsInVectorInt32(imm2)))",}),
        ("SveVecImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementBy32BitElementCount_vector_uint",                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementBy32BitElementCount",                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "(Byte)6",  ["Imm2"] = "SveMaskPattern.VectorCount128",     ["InvalidImm"] = "(Byte)18",  ["InvalidImm2"] = "(SveMaskPattern)37",  ["ValidateIterResult"] = "result[i] != Helpers.SubtractSaturate((uint)firstOp[i], (uint)(imm1 * Helpers.NumberOfElementsInVectorInt32(imm2)))",}),

        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementBy64BitElementCount_int",                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementBy64BitElementCount",                                                                ["RetBaseType"] = "Int32",                                    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "(Byte)7",  ["Imm2"] = "SveMaskPattern.VectorCount256",     ["InvalidImm"] = "(Byte)34",  ["InvalidImm2"] = "(SveMaskPattern)135", ["ValidateResult"] = "isUnexpectedResult = (result != Helpers.SubtractSaturate((int)data, (int)(imm1 * Helpers.NumberOfElementsInVectorInt64(imm2))));",}),
        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementBy64BitElementCount_long",                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementBy64BitElementCount",                                                                ["RetBaseType"] = "Int64",                                    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["Imm"] = "(Byte)8",  ["Imm2"] = "SveMaskPattern.LargestMultipleOf4", ["InvalidImm"] = "(Byte)35",  ["InvalidImm2"] = "(SveMaskPattern)125", ["ValidateResult"] = "isUnexpectedResult = (result != Helpers.SubtractSaturate((long)data, (long)(imm1 * Helpers.NumberOfElementsInVectorInt64(imm2))));",}),
        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementBy64BitElementCount_uint",                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementBy64BitElementCount",                                                                ["RetBaseType"] = "UInt32",                                   ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "(Byte)9",  ["Imm2"] = "SveMaskPattern.LargestMultipleOf3", ["InvalidImm"] = "(Byte)36",  ["InvalidImm2"] = "(SveMaskPattern)115", ["ValidateResult"] = "isUnexpectedResult = (result != Helpers.SubtractSaturate((uint)data, (uint)(imm1 * Helpers.NumberOfElementsInVectorInt64(imm2))));",}),
        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementBy64BitElementCount_ulong",                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementBy64BitElementCount",                                                                ["RetBaseType"] = "UInt64",                                   ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["Imm"] = "(Byte)10", ["Imm2"] = "SveMaskPattern.All",                ["InvalidImm"] = "(Byte)37",  ["InvalidImm2"] = "(SveMaskPattern)145", ["ValidateResult"] = "isUnexpectedResult = (result != Helpers.SubtractSaturate((ulong)data, (ulong)(imm1 * Helpers.NumberOfElementsInVectorInt64(imm2))));",}),
        ("SveVecImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementBy64BitElementCount_vector_long",                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementBy64BitElementCount",                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["Imm"] = "(Byte)11", ["Imm2"] = "SveMaskPattern.VectorCount7",       ["InvalidImm"] = "(Byte)38",  ["InvalidImm2"] = "(SveMaskPattern)155", ["ValidateIterResult"] = "result[i] != Helpers.SubtractSaturate((long)firstOp[i], (long)(imm1 * Helpers.NumberOfElementsInVectorInt64(imm2)))",}),
        ("SveVecImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementBy64BitElementCount_vector_ulong",                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementBy64BitElementCount",                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["Imm"] = "(Byte)12", ["Imm2"] = "SveMaskPattern.LargestPowerOf2",    ["InvalidImm"] = "(Byte)39",  ["InvalidImm2"] = "(SveMaskPattern)165", ["ValidateIterResult"] = "result[i] != Helpers.SubtractSaturate((ulong)firstOp[i], (ulong)(imm1 * Helpers.NumberOfElementsInVectorInt64(imm2)))",}),

        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementBy8BitElementCount_int",                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementBy8BitElementCount",                                                                 ["RetBaseType"] = "Int32",                                    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "(Byte)13", ["Imm2"] = "SveMaskPattern.VectorCount4",       ["InvalidImm"] = "(Byte)89",  ["InvalidImm2"] = "(SveMaskPattern)206", ["ValidateResult"] = "isUnexpectedResult = (result != Helpers.SubtractSaturate((int)data, (int)(imm1 * Helpers.NumberOfElementsInVectorInt8(imm2))));",}),
        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementBy8BitElementCount_long",                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementBy8BitElementCount",                                                                 ["RetBaseType"] = "Int64",                                    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["Imm"] = "(Byte)14", ["Imm2"] = "SveMaskPattern.LargestPowerOf2",    ["InvalidImm"] = "(Byte)0",   ["InvalidImm2"] = "(SveMaskPattern)207", ["ValidateResult"] = "isUnexpectedResult = (result != Helpers.SubtractSaturate((long)data, (long)(imm1 * Helpers.NumberOfElementsInVectorInt8(imm2))));",}),
        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementBy8BitElementCount_uint",                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementBy8BitElementCount",                                                                 ["RetBaseType"] = "UInt32",                                   ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "(Byte)15", ["Imm2"] = "SveMaskPattern.VectorCount6",       ["InvalidImm"] = "(Byte)91",  ["InvalidImm2"] = "(SveMaskPattern)208", ["ValidateResult"] = "isUnexpectedResult = (result != Helpers.SubtractSaturate((uint)data, (uint)(imm1 * Helpers.NumberOfElementsInVectorInt8(imm2))));",}),
        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementBy8BitElementCount_ulong",                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementBy8BitElementCount",                                                                 ["RetBaseType"] = "UInt64",                                   ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["Imm"] = "(Byte)16", ["Imm2"] = "SveMaskPattern.All",                ["InvalidImm"] = "(Byte)92",  ["InvalidImm2"] = "(SveMaskPattern)209", ["ValidateResult"] = "isUnexpectedResult = (result != Helpers.SubtractSaturate((ulong)data, (ulong)(imm1 * Helpers.NumberOfElementsInVectorInt8(imm2))));",}),

        ("SveSaturatingByActiveElementCount.template",new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementByActiveElementCount_int_byte",                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementByActiveElementCount",                                                               ["RetBaseType"] = "Int64",                                    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                         ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "Helpers.getMaskByte()",                                                                                         ["ValidateResult"] = "succeeded = (result == Helpers.SubtractSaturate(left, (int)Helpers.NumberOfActiveElementsInMask(right)));",}),
        ("SveSaturatingByActiveElementCount.template",new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementByActiveElementCount_int_ushort",                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementByActiveElementCount",                                                               ["RetBaseType"] = "Int64",                                    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "Helpers.getMaskUInt16()",                                                                                       ["ValidateResult"] = "succeeded = (result == Helpers.SubtractSaturate(left, (int)Helpers.NumberOfActiveElementsInMask(right)));",}),
        ("SveSaturatingByActiveElementCount.template",new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementByActiveElementCount_int_uint",                                           ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementByActiveElementCount",                                                               ["RetBaseType"] = "Int64",                                    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "Helpers.getMaskUInt32()",                                                                                       ["ValidateResult"] = "succeeded = (result == Helpers.SubtractSaturate(left, (int)Helpers.NumberOfActiveElementsInMask(right)));",}),
        ("SveSaturatingByActiveElementCount.template",new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementByActiveElementCount_int_ulong",                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementByActiveElementCount",                                                               ["RetBaseType"] = "Int64",                                    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "Helpers.getMaskUInt64()",                                                                                       ["ValidateResult"] = "succeeded = (result == Helpers.SubtractSaturate(left, (int)Helpers.NumberOfActiveElementsInMask(right)));",}),
        ("SveSaturatingByActiveElementCount.template",new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementByActiveElementCount_long_byte",                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementByActiveElementCount",                                                               ["RetBaseType"] = "Int64",                                    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                         ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "Helpers.getMaskByte()",                                                                                         ["ValidateResult"] = "succeeded = (result == Helpers.SubtractSaturate(left, (long)Helpers.NumberOfActiveElementsInMask(right)));",}),
        ("SveSaturatingByActiveElementCount.template",new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementByActiveElementCount_long_ushort",                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementByActiveElementCount",                                                               ["RetBaseType"] = "Int64",                                    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "Helpers.getMaskUInt16()",                                                                                       ["ValidateResult"] = "succeeded = (result == Helpers.SubtractSaturate(left, (long)Helpers.NumberOfActiveElementsInMask(right)));",}),
        ("SveSaturatingByActiveElementCount.template",new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementByActiveElementCount_long_uint",                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementByActiveElementCount",                                                               ["RetBaseType"] = "Int64",                                    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "Helpers.getMaskUInt32()",                                                                                       ["ValidateResult"] = "succeeded = (result == Helpers.SubtractSaturate(left, (long)Helpers.NumberOfActiveElementsInMask(right)));",}),
        ("SveSaturatingByActiveElementCount.template",new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementByActiveElementCount_long_ulong",                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementByActiveElementCount",                                                               ["RetBaseType"] = "Int64",                                    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "Helpers.getMaskUInt64()",                                                                                       ["ValidateResult"] = "succeeded = (result == Helpers.SubtractSaturate(left, (long)Helpers.NumberOfActiveElementsInMask(right)));",}),
        ("SveSaturatingByActiveElementCount.template",new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementByActiveElementCount_uint_byte",                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementByActiveElementCount",                                                               ["RetBaseType"] = "UInt64",                                   ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                         ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "Helpers.getMaskByte()",                                                                                         ["ValidateResult"] = "succeeded = (result == Helpers.SubtractSaturate(left, (uint)Helpers.NumberOfActiveElementsInMask(right)));",}),
        ("SveSaturatingByActiveElementCount.template",new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementByActiveElementCount_uint_ushort",                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementByActiveElementCount",                                                               ["RetBaseType"] = "UInt64",                                   ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "Helpers.getMaskUInt16()",                                                                                       ["ValidateResult"] = "succeeded = (result == Helpers.SubtractSaturate(left, (uint)Helpers.NumberOfActiveElementsInMask(right)));",}),
        ("SveSaturatingByActiveElementCount.template",new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementByActiveElementCount_uint_uint",                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementByActiveElementCount",                                                               ["RetBaseType"] = "UInt64",                                   ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "Helpers.getMaskUInt32()",                                                                                       ["ValidateResult"] = "succeeded = (result == Helpers.SubtractSaturate(left, (uint)Helpers.NumberOfActiveElementsInMask(right)));",}),
        ("SveSaturatingByActiveElementCount.template",new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementByActiveElementCount_uint_ulong",                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementByActiveElementCount",                                                               ["RetBaseType"] = "UInt64",                                   ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "Helpers.getMaskUInt64()",                                                                                       ["ValidateResult"] = "succeeded = (result == Helpers.SubtractSaturate(left, (uint)Helpers.NumberOfActiveElementsInMask(right)));",}),
        ("SveSaturatingByActiveElementCount.template",new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementByActiveElementCount_ulong_byte",                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementByActiveElementCount",                                                               ["RetBaseType"] = "UInt64",                                   ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                         ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "Helpers.getMaskByte()",                                                                                         ["ValidateResult"] = "succeeded = (result == Helpers.SubtractSaturate(left, (ulong)Helpers.NumberOfActiveElementsInMask(right)));",}),
        ("SveSaturatingByActiveElementCount.template",new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementByActiveElementCount_ulong_ushort",                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementByActiveElementCount",                                                               ["RetBaseType"] = "UInt64",                                   ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "Helpers.getMaskUInt16()",                                                                                       ["ValidateResult"] = "succeeded = (result == Helpers.SubtractSaturate(left, (ulong)Helpers.NumberOfActiveElementsInMask(right)));",}),
        ("SveSaturatingByActiveElementCount.template",new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementByActiveElementCount_ulong_uint",                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementByActiveElementCount",                                                               ["RetBaseType"] = "UInt64",                                   ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "Helpers.getMaskUInt32()",                                                                                       ["ValidateResult"] = "succeeded = (result == Helpers.SubtractSaturate(left, (ulong)Helpers.NumberOfActiveElementsInMask(right)));",}),
        ("SveSaturatingByActiveElementCount.template",new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementByActiveElementCount_ulong_ulong",                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementByActiveElementCount",                                                               ["RetBaseType"] = "UInt64",                                   ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "Helpers.getMaskUInt64()",                                                                                       ["ValidateResult"] = "succeeded = (result == Helpers.SubtractSaturate(left, (ulong)Helpers.NumberOfActiveElementsInMask(right)));",}),
        ("SveMasklessVecBinOpTest.template",  new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementByActiveElementCount_vector_short",                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementByActiveElementCount",                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "Helpers.getMaskInt16()",                                                                                        ["ValidateIterResult"] = "result[i] != Helpers.SubtractSaturate(left[i], (short)Helpers.NumberOfActiveElementsInMask(right))",          ["GetIterResult"] = "Helpers.SubtractSaturate(left[i], Helpers.NumberOfActiveElementsInMask(right))"}),
        ("SveMasklessVecBinOpTest.template",  new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementByActiveElementCount_vector_int",                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementByActiveElementCount",                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "Helpers.getMaskInt32()",                                                                                        ["ValidateIterResult"] = "result[i] != Helpers.SubtractSaturate(left[i], (int)Helpers.NumberOfActiveElementsInMask(right))",          ["GetIterResult"] = "Helpers.SubtractSaturate(left[i], Helpers.NumberOfActiveElementsInMask(right))"}),
        ("SveMasklessVecBinOpTest.template",  new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementByActiveElementCount_vector_long",                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementByActiveElementCount",                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "Helpers.getMaskInt64()",                                                                                        ["ValidateIterResult"] = "result[i] != Helpers.SubtractSaturate(left[i], (long)Helpers.NumberOfActiveElementsInMask(right))",          ["GetIterResult"] = "Helpers.SubtractSaturate(left[i], Helpers.NumberOfActiveElementsInMask(right))"}),
        ("SveMasklessVecBinOpTest.template",  new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementByActiveElementCount_vector_ushort",                                              ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementByActiveElementCount",                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "Helpers.getMaskUInt16()",                                                                                       ["ValidateIterResult"] = "result[i] != Helpers.SubtractSaturate(left[i], (ushort)Helpers.NumberOfActiveElementsInMask(right))",          ["GetIterResult"] = "Helpers.SubtractSaturate(left[i], Helpers.NumberOfActiveElementsInMask(right))"}),
        ("SveMasklessVecBinOpTest.template",  new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementByActiveElementCount_vector_uint",                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementByActiveElementCount",                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "Helpers.getMaskUInt32()",                                                                                       ["ValidateIterResult"] = "result[i] != Helpers.SubtractSaturate(left[i], (uint)Helpers.NumberOfActiveElementsInMask(right))",          ["GetIterResult"] = "Helpers.SubtractSaturate(left[i], Helpers.NumberOfActiveElementsInMask(right))"}),
        ("SveMasklessVecBinOpTest.template",  new Dictionary<string, string> {["TestName"] = "Sve_SaturatingDecrementByActiveElementCount_vector_ulong",                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingDecrementByActiveElementCount",                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "Helpers.getMaskUInt64()",                                                                                       ["ValidateIterResult"] = "result[i] != Helpers.SubtractSaturate(left[i], (ulong)(Helpers.NumberOfActiveElementsInMask(right)))", ["GetIterResult"] = "Helpers.SubtractSaturate(left[i], (ulong)(Helpers.NumberOfActiveElementsInMask(right)))"}),

        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingIncrementBy16BitElementCount_int",                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingIncrementBy16BitElementCount",                                                                ["RetBaseType"] = "Int32",                                    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "(Byte)15", ["Imm2"] = "SveMaskPattern.VectorCount4",       ["InvalidImm"] = "(Byte)98",  ["InvalidImm2"] = "(SveMaskPattern)241", ["ValidateResult"] = "isUnexpectedResult = (result != Helpers.AddSaturate((int)data, (int)(imm1 * Helpers.NumberOfElementsInVectorInt16(imm2))));",}),
        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingIncrementBy16BitElementCount_long",                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingIncrementBy16BitElementCount",                                                                ["RetBaseType"] = "Int64",                                    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["Imm"] = "(Byte)14", ["Imm2"] = "SveMaskPattern.All",                ["InvalidImm"] = "(Byte)99",  ["InvalidImm2"] = "(SveMaskPattern)242", ["ValidateResult"] = "isUnexpectedResult = (result != Helpers.AddSaturate((long)data, (long)(imm1 * Helpers.NumberOfElementsInVectorInt16(imm2))));",}),
        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingIncrementBy16BitElementCount_uint",                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingIncrementBy16BitElementCount",                                                                ["RetBaseType"] = "UInt32",                                   ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "(Byte)13", ["Imm2"] = "SveMaskPattern.VectorCount256",     ["InvalidImm"] = "(Byte)101", ["InvalidImm2"] = "(SveMaskPattern)243", ["ValidateResult"] = "isUnexpectedResult = (result != Helpers.AddSaturate((uint)data, (uint)(imm1 * Helpers.NumberOfElementsInVectorInt16(imm2))));",}),
        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingIncrementBy16BitElementCount_ulong",                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingIncrementBy16BitElementCount",                                                                ["RetBaseType"] = "UInt64",                                   ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["Imm"] = "(Byte)12", ["Imm2"] = "SveMaskPattern.VectorCount32",      ["InvalidImm"] = "(Byte)118", ["InvalidImm2"] = "(SveMaskPattern)50",  ["ValidateResult"] = "isUnexpectedResult = (result != Helpers.AddSaturate((ulong)data, (ulong)(imm1 * Helpers.NumberOfElementsInVectorInt16(imm2))));",}),
        ("SveVecImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingIncrementBy16BitElementCount_vector_short",                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingIncrementBy16BitElementCount",                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                   ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "(Byte)11", ["Imm2"] = "SveMaskPattern.VectorCount4",       ["InvalidImm"] = "(Byte)118", ["InvalidImm2"] = "(SveMaskPattern)60",  ["ValidateIterResult"] = "result[i] != Helpers.AddSaturate((short)firstOp[i], (short)(imm1 * Helpers.NumberOfElementsInVectorInt16(imm2)))",}),
        ("SveVecImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingIncrementBy16BitElementCount_vector_ushort",                                               ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingIncrementBy16BitElementCount",                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                  ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["Imm"] = "(Byte)10", ["Imm2"] = "SveMaskPattern.VectorCount64",      ["InvalidImm"] = "(Byte)123", ["InvalidImm2"] = "(SveMaskPattern)70",  ["ValidateIterResult"] = "result[i] != Helpers.AddSaturate((ushort)firstOp[i], (ushort)(imm1 * Helpers.NumberOfElementsInVectorInt16(imm2)))",}),

        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingIncrementBy32BitElementCount_int",                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingIncrementBy32BitElementCount",                                                                ["RetBaseType"] = "Int32",                                    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "(Byte)9",  ["Imm2"] = "SveMaskPattern.VectorCount5",       ["InvalidImm"] = "(Byte)201", ["InvalidImm2"] = "(SveMaskPattern)80",  ["ValidateResult"] = "isUnexpectedResult = (result != Helpers.AddSaturate((int)data, (int)(imm1 * Helpers.NumberOfElementsInVectorInt32(imm2))));",}),
        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingIncrementBy32BitElementCount_long",                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingIncrementBy32BitElementCount",                                                                ["RetBaseType"] = "Int64",                                    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["Imm"] = "(Byte)8",  ["Imm2"] = "SveMaskPattern.All",                ["InvalidImm"] = "(Byte)202", ["InvalidImm2"] = "(SveMaskPattern)128",  ["ValidateResult"] = "isUnexpectedResult = (result != Helpers.AddSaturate((long)data, (long)(imm1 * Helpers.NumberOfElementsInVectorInt32(imm2))));",}),
        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingIncrementBy32BitElementCount_uint",                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingIncrementBy32BitElementCount",                                                                ["RetBaseType"] = "UInt32",                                   ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "(Byte)7",  ["Imm2"] = "SveMaskPattern.LargestPowerOf2",    ["InvalidImm"] = "(Byte)207", ["InvalidImm2"] = "(SveMaskPattern)255",  ["ValidateResult"] = "isUnexpectedResult = (result != Helpers.AddSaturate((uint)data, (uint)(imm1 * Helpers.NumberOfElementsInVectorInt32(imm2))));",}),
        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingIncrementBy32BitElementCount_ulong",                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingIncrementBy32BitElementCount",                                                                ["RetBaseType"] = "UInt64",                                   ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["Imm"] = "(Byte)6",  ["Imm2"] = "SveMaskPattern.All",                ["InvalidImm"] = "(Byte)220", ["InvalidImm2"] = "(SveMaskPattern)99",  ["ValidateResult"] = "isUnexpectedResult = (result != Helpers.AddSaturate((ulong)data, (ulong)(imm1 * Helpers.NumberOfElementsInVectorInt32(imm2))));",}),
        ("SveVecImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingIncrementBy32BitElementCount_vector_int",                                                  ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingIncrementBy32BitElementCount",                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "(Byte)5",  ["Imm2"] = "SveMaskPattern.LargestMultipleOf4", ["InvalidImm"] = "(Byte)221", ["InvalidImm2"] = "(SveMaskPattern)76",  ["ValidateIterResult"] = "result[i] != Helpers.AddSaturate((int)firstOp[i], (int)(imm1 * Helpers.NumberOfElementsInVectorInt32(imm2)))",}),
        ("SveVecImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingIncrementBy32BitElementCount_vector_uint",                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingIncrementBy32BitElementCount",                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "(Byte)4",  ["Imm2"] = "SveMaskPattern.LargestMultipleOf3", ["InvalidImm"] = "(Byte)240", ["InvalidImm2"] = "(SveMaskPattern)32",  ["ValidateIterResult"] = "result[i] != Helpers.AddSaturate((uint)firstOp[i], (uint)(imm1 * Helpers.NumberOfElementsInVectorInt32(imm2)))",}),

        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingIncrementBy64BitElementCount_int",                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingIncrementBy64BitElementCount",                                                                ["RetBaseType"] = "Int32",                                    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "(Byte)3",  ["Imm2"] = "SveMaskPattern.VectorCount64",      ["InvalidImm"] = "(Byte)241", ["InvalidImm2"] = "(SveMaskPattern)105", ["ValidateResult"] = "isUnexpectedResult = (result != Helpers.AddSaturate((int)data, (int)(imm1 * Helpers.NumberOfElementsInVectorInt64(imm2))));",}),
        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingIncrementBy64BitElementCount_long",                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingIncrementBy64BitElementCount",                                                                ["RetBaseType"] = "Int64",                                    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["Imm"] = "(Byte)2",  ["Imm2"] = "SveMaskPattern.VectorCount4",       ["InvalidImm"] = "(Byte)255", ["InvalidImm2"] = "(SveMaskPattern)108", ["ValidateResult"] = "isUnexpectedResult = (result != Helpers.AddSaturate((long)data, (long)(imm1 * Helpers.NumberOfElementsInVectorInt64(imm2))));",}),
        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingIncrementBy64BitElementCount_uint",                                                        ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingIncrementBy64BitElementCount",                                                                ["RetBaseType"] = "UInt32",                                   ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "(Byte)1",  ["Imm2"] = "SveMaskPattern.VectorCount6",       ["InvalidImm"] = "(Byte)243", ["InvalidImm2"] = "(SveMaskPattern)109", ["ValidateResult"] = "isUnexpectedResult = (result != Helpers.AddSaturate((uint)data, (uint)(imm1 * Helpers.NumberOfElementsInVectorInt64(imm2))));",}),
        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingIncrementBy64BitElementCount_ulong",                                                       ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingIncrementBy64BitElementCount",                                                                ["RetBaseType"] = "UInt64",                                   ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["Imm"] = "(Byte)2",  ["Imm2"] = "SveMaskPattern.LargestMultipleOf3", ["InvalidImm"] = "(Byte)19",  ["InvalidImm2"] = "(SveMaskPattern)101", ["ValidateResult"] = "isUnexpectedResult = (result != Helpers.AddSaturate((ulong)data, (ulong)(imm1 * Helpers.NumberOfElementsInVectorInt64(imm2))));",}),
        ("SveVecImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingIncrementBy64BitElementCount_vector_long",                                                 ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingIncrementBy64BitElementCount",                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["Imm"] = "(Byte)2",  ["Imm2"] = "SveMaskPattern.LargestPowerOf2",    ["InvalidImm"] = "(Byte)56",  ["InvalidImm2"] = "(SveMaskPattern)109", ["ValidateIterResult"] = "result[i] != Helpers.AddSaturate((long)firstOp[i], (long)(imm1 * Helpers.NumberOfElementsInVectorInt64(imm2)))",}),
        ("SveVecImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingIncrementBy64BitElementCount_vector_ulong",                                                ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingIncrementBy64BitElementCount",                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["Imm"] = "(Byte)2",  ["Imm2"] = "SveMaskPattern.VectorCount8",       ["InvalidImm"] = "(Byte)75",  ["InvalidImm2"] = "(SveMaskPattern)154", ["ValidateIterResult"] = "result[i] != Helpers.AddSaturate((ulong)firstOp[i], (ulong)(imm1 * Helpers.NumberOfElementsInVectorInt64(imm2)))",}),

        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingIncrementBy8BitElementCount_int",                                                          ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingIncrementBy8BitElementCount",                                                                 ["RetBaseType"] = "Int32",                                    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "(Byte)2",  ["Imm2"] = "SveMaskPattern.VectorCount8",       ["InvalidImm"] = "(Byte)100", ["InvalidImm2"] = "(SveMaskPattern)235", ["ValidateResult"] = "isUnexpectedResult = (result != Helpers.AddSaturate((int)data, (int)(imm1 * Helpers.NumberOfElementsInVectorInt8(imm2))));",}),
        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingIncrementBy8BitElementCount_long",                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingIncrementBy8BitElementCount",                                                                 ["RetBaseType"] = "Int64",                                    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["Imm"] = "(Byte)2",  ["Imm2"] = "SveMaskPattern.VectorCount4",       ["InvalidImm"] = "(Byte)99",  ["InvalidImm2"] = "(SveMaskPattern)123", ["ValidateResult"] = "isUnexpectedResult = (result != Helpers.AddSaturate((long)data, (long)(imm1 * Helpers.NumberOfElementsInVectorInt8(imm2))));",}),
        ("ScalarImm2UnOpTest.template",       new Dictionary<string, string> {["TestName"] = "Sve_SaturatingIncrementBy8BitElementCount_uint",                                                         ["Isa"] = "Sve",           ["LoadIsa"] = "Sve",     ["Method"] = "SaturatingIncrementBy8BitElementCount",                                                                 ["RetBaseType"] = "UInt32",                                   ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "SveMaskPattern", ["LargestVectorSize"] = "64",