#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Afterdream
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251124.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='afterdream'
GAME_NAME='Afterdream'

ARCHIVE_BASE_0_NAME='setup_afterdream_v0.1_(67625).exe'
ARCHIVE_BASE_0_MD5='22736bca94a5b4da06fcdd85f490dc6c'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='405972'
ARCHIVE_BASE_0_VERSION='0.1-gog67625'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/afterdream'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_MAIN_FILES='
afterdream_gog.exe'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Roaming/afterdream'

APP_MAIN_EXE='afterdream_gog.exe'

PKG_MAIN_ARCH='32'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
