#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2017 Mopi
set -o errexit

###
# To The Moon
# send your bug reports to contact@dotslashplay.it
###

script_version=20240915.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='to-the-moon'
GAME_NAME='To The Moon'

ARCHIVE_BASE_0_NAME='ToTheMoon_linux_1389114090.sh'
ARCHIVE_BASE_0_MD5='706a5c9467328438d412370ffb1454de'
ARCHIVE_BASE_0_SIZE='93000'
ARCHIVE_BASE_0_VERSION='1.0-humble1'
ARCHIVE_BASE_0_URL='https://www.humblebundle.com/store/to-the-moon'

CONTENT_PATH_DEFAULT='data'
## TODO: Explicit files list should be used instead of globs
CONTENT_GAME_BIN32_PATH="${CONTENT_PATH_DEFAULT}/x86"
CONTENT_GAME_BIN32_FILES='
*'
CONTENT_GAME_BIN64_PATH="${CONTENT_PATH_DEFAULT}/x86_64"
CONTENT_GAME_BIN64_FILES='
*'
CONTENT_GAME_DATA_PATH="${CONTENT_PATH_DEFAULT}/noarch"
CONTENT_GAME_DATA_FILES='
*'
CONTENT_DOC_DATA_PATH="${CONTENT_PATH_DEFAULT}/noarch"
CONTENT_DOC_DATA_FILES='
*.txt'

APP_MAIN_EXE_BIN32='ToTheMoon.bin.x86'
APP_MAIN_EXE_BIN64='ToTheMoon.bin.x86_64'
APP_MAIN_ICON='noarch/ToTheMoon.png'
## TODO: Check if the default prefix type could be used
APP_MAIN_PREFIX_TYPE='none'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN64_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN32_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
## TODO: Complete the dependencies list
PKG_BIN_DEPENDENCIES_LIBRARIES='
libasound_module_conf_pulse.so
libfreetype.so.6
libGL.so.1
libSDL2-2.0.so.0'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build package

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
