// This file is part of ICU4X. For terms of use, please see the file
// called LICENSE at the top level of the ICU4X source tree
// (online at: https://github.com/unicode-org/icu4x/blob/main/LICENSE ).

//! Data obtained from [`calendrical_calculations`].

use super::PackedEastAsianTraditionalYearData;

pub const STARTING_YEAR: i32 = 1912;

#[rustfmt::skip]
#[allow(clippy::unwrap_used)] // const
pub const DATA: &[PackedEastAsianTraditionalYearData] = {
    use calendrical_calculations::gregorian::fixed_from_gregorian as gregorian;
    let l = true; // long
    let s = false; // short
    &[
        PackedEastAsianTraditionalYearData::new(1912, [l, s, l, s, s, l, s, s, l, l, s, l, s], None, gregorian(1912, 2, 18)),
        PackedEastAsianTraditionalYearData::new(1913, [l, l, s, l, s, s, l, s, s, l, s, l, s], None, gregorian(1913, 2, 6)),
        PackedEastAsianTraditionalYearData::new(1914, [l, l, s, l, l, s, s, l, s, l, s, s, l], Some(6), gregorian(1914, 1, 26)),
        PackedEastAsianTraditionalYearData::new(1915, [l, s, l, l, s, l, s, l, s, l, s, l, s], None, gregorian(1915, 2, 14)),
        PackedEastAsianTraditionalYearData::new(1916, [s, l, s, l, s, l, l, s, l, s, l, s, s], None, gregorian(1916, 2, 4)),
        PackedEastAsianTraditionalYearData::new(1917, [l, s, s, l, s, l, l, s, l, l, s, l, s], Some(3), gregorian(1917, 1, 23)),
        PackedEastAsianTraditionalYearData::new(1918, [l, s, s, l, s, l, s, l, l, l, s, l, s], None, gregorian(1918, 2, 11)),
        PackedEastAsianTraditionalYearData::new(1919, [s, l, s, s, l, s, l, s, l, l, s, l, l], Some(8), gregorian(1919, 2, 1)),
        PackedEastAsianTraditionalYearData::new(1920, [s, l, s, s, l, s, s, l, l, s, l, l, s], None, gregorian(1920, 2, 20)),
        PackedEastAsianTraditionalYearData::new(1921, [l, s, l, s, s, l, s, s, l, s, l, l, s], None, gregorian(1921, 2, 8)),
        PackedEastAsianTraditionalYearData::new(1922, [l, s, l, l, s, s, l, s, s, l, s, l, l], Some(6), gregorian(1922, 1, 28)),
        PackedEastAsianTraditionalYearData::new(1923, [s, l, l, s, l, s, l, s, l, s, s, l, s], None, gregorian(1923, 2, 16)),
        PackedEastAsianTraditionalYearData::new(1924, [l, s, l, s, l, l, s, l, s, l, s, s, s], None, gregorian(1924, 2, 5)),
        PackedEastAsianTraditionalYearData::new(1925, [l, s, l, l, s, l, s, l, l, s, l, s, l], Some(5), gregorian(1925, 1, 24)),
        PackedEastAsianTraditionalYearData::new(1926, [s, s, l, s, l, s, l, l, s, l, l, s, s], None, gregorian(1926, 2, 13)),
        PackedEastAsianTraditionalYearData::new(1927, [l, s, s, l, s, l, s, l, l, s, l, l, s], None, gregorian(1927, 2, 2)),
        PackedEastAsianTraditionalYearData::new(1928, [s, l, s, s, l, s, s, l, l, s, l, l, l], Some(3), gregorian(1928, 1, 23)),
        PackedEastAsianTraditionalYearData::new(1929, [s, l, s, s, l, s, s, l, s, l, l, l, s], None, gregorian(1929, 2, 10)),
        PackedEastAsianTraditionalYearData::new(1930, [s, l, l, s, s, l, s, s, l, s, l, l, s], Some(7), gregorian(1930, 1, 30)),
        PackedEastAsianTraditionalYearData::new(1931, [l, l, l, s, s, l, s, s, l, s, l, s, s], None, gregorian(1931, 2, 17)),
        PackedEastAsianTraditionalYearData::new(1932, [l, l, l, s, l, s, l, s, s, l, s, l, s], None, gregorian(1932, 2, 6)),
        PackedEastAsianTraditionalYearData::new(1933, [s, l, l, s, l, l, s, l, s, l, s, s, l], Some(6), gregorian(1933, 1, 26)),
        PackedEastAsianTraditionalYearData::new(1934, [s, l, s, l, l, s, l, l, s, l, s, l, s], None, gregorian(1934, 2, 14)),
        PackedEastAsianTraditionalYearData::new(1935, [s, s, l, s, l, s, l, l, s, l, l, s, s], None, gregorian(1935, 2, 4)),
        PackedEastAsianTraditionalYearData::new(1936, [l, s, s, l, s, l, s, l, s, l, l, l, s], Some(4), gregorian(1936, 1, 24)),
        PackedEastAsianTraditionalYearData::new(1937, [l, s, s, l, s, s, l, s, l, l, l, s, s], None, gregorian(1937, 2, 11)),
        PackedEastAsianTraditionalYearData::new(1938, [l, l, s, s, l, s, s, l, s, l, l, s, l], Some(8), gregorian(1938, 1, 31)),
        PackedEastAsianTraditionalYearData::new(1939, [l, l, s, s, l, s, s, l, s, l, s, l, s], None, gregorian(1939, 2, 19)),
        PackedEastAsianTraditionalYearData::new(1940, [l, l, s, l, s, l, s, s, l, s, l, s, s], None, gregorian(1940, 2, 8)),
        PackedEastAsianTraditionalYearData::new(1941, [l, l, s, l, l, s, l, s, s, l, s, l, s], Some(7), gregorian(1941, 1, 27)),
        PackedEastAsianTraditionalYearData::new(1942, [l, s, l, l, s, l, l, s, l, s, s, l, s], None, gregorian(1942, 2, 15)),
        PackedEastAsianTraditionalYearData::new(1943, [s, l, s, l, s, l, l, s, l, l, s, l, s], None, gregorian(1943, 2, 5)),
        PackedEastAsianTraditionalYearData::new(1944, [s, s, l, s, l, s, l, s, l, l, s, l, l], Some(5), gregorian(1944, 1, 26)),
        PackedEastAsianTraditionalYearData::new(1945, [s, s, l, s, s, l, s, l, l, l, s, l, s], None, gregorian(1945, 2, 13)),
        PackedEastAsianTraditionalYearData::new(1946, [l, s, s, l, s, s, l, s, l, l, s, l, s], None, gregorian(1946, 2, 2)),
        PackedEastAsianTraditionalYearData::new(1947, [l, l, s, s, l, s, s, l, s, l, s, l, l], Some(3), gregorian(1947, 1, 22)),
        PackedEastAsianTraditionalYearData::new(1948, [l, s, l, s, l, s, s, l, s, l, s, l, s], None, gregorian(1948, 2, 10)),
        PackedEastAsianTraditionalYearData::new(1949, [l, l, s, l, s, l, s, s, l, s, l, s, l], Some(8), gregorian(1949, 1, 29)),
        PackedEastAsianTraditionalYearData::new(1950, [l, s, l, l, s, l, s, s, l, s, l, s, s], None, gregorian(1950, 2, 17)),
        PackedEastAsianTraditionalYearData::new(1951, [l, s, l, l, s, l, s, l, s, l, s, l, s], None, gregorian(1951, 2, 6)),
        PackedEastAsianTraditionalYearData::new(1952, [s, l, s, l, s, l, l, s, l, s, l, s, l], Some(6), gregorian(1952, 1, 27)),
        PackedEastAsianTraditionalYearData::new(1953, [s, l, s, s, l, l, s, l, l, s, l, l, s], None, gregorian(1953, 2, 14)),
        PackedEastAsianTraditionalYearData::new(1954, [s, s, l, s, s, l, s, l, l, s, l, l, s], None, gregorian(1954, 2, 4)),
        PackedEastAsianTraditionalYearData::new(1955, [l, s, s, l, s, s, l, s, l, s, l, l, l], Some(4), gregorian(1955, 1, 24)),
        PackedEastAsianTraditionalYearData::new(1956, [s, l, s, l, s, s, l, s, l, s, l, l, s], None, gregorian(1956, 2, 12)),
        PackedEastAsianTraditionalYearData::new(1957, [l, s, l, s, l, s, s, l, s, l, s, l, l], Some(9), gregorian(1957, 1, 31)),
        PackedEastAsianTraditionalYearData::new(1958, [s, l, l, s, l, s, s, l, s, l, s, l, s], None, gregorian(1958, 2, 19)),
        PackedEastAsianTraditionalYearData::new(1959, [s, l, l, s, l, s, l, s, l, s, l, s, s], None, gregorian(1959, 2, 8)),
        PackedEastAsianTraditionalYearData::new(1960, [l, s, l, s, l, l, s, l, s, l, s, l, s], Some(7), gregorian(1960, 1, 28)),
        PackedEastAsianTraditionalYearData::new(1961, [l, s, l, s, l, s, l, l, s, l, s, l, s], None, gregorian(1961, 2, 15)),
        PackedEastAsianTraditionalYearData::new(1962, [s, l, s, s, l, s, l, l, s, l, l, s, s], None, gregorian(1962, 2, 5)),
        PackedEastAsianTraditionalYearData::new(1963, [l, s, l, s, s, l, s, l, s, l, l, l, s], Some(5), gregorian(1963, 1, 25)),
        PackedEastAsianTraditionalYearData::new(1964, [l, s, l, s, s, l, s, l, s, l, l, l, s], None, gregorian(1964, 2, 13)),
        PackedEastAsianTraditionalYearData::new(1965, [s, l, s, l, s, s, l, s, s, l, l, l, s], None, gregorian(1965, 2, 2)),
        PackedEastAsianTraditionalYearData::new(1966, [s, l, l, s, l, s, s, l, s, s, l, l, s], Some(4), gregorian(1966, 1, 22)),
        PackedEastAsianTraditionalYearData::new(1967, [l, l, s, l, l, s, s, l, s, l, s, l, s], None, gregorian(1967, 2, 9)),
        PackedEastAsianTraditionalYearData::new(1968, [s, l, l, s, l, s, l, s, l, s, l, s, l], Some(8), gregorian(1968, 1, 30)),
        PackedEastAsianTraditionalYearData::new(1969, [s, l, s, l, s, l, l, s, l, s, l, s, s], None, gregorian(1969, 2, 17)),
        PackedEastAsianTraditionalYearData::new(1970, [l, s, s, l, l, s, l, s, l, l, s, l, s], None, gregorian(1970, 2, 6)),
        PackedEastAsianTraditionalYearData::new(1971, [s, l, s, s, l, s, l, s, l, l, l, s, l], Some(6), gregorian(1971, 1, 27)),
        PackedEastAsianTraditionalYearData::new(1972, [s, l, s, s, l, s, l, s, l, l, l, s, s], None, gregorian(1972, 2, 15)),
        PackedEastAsianTraditionalYearData::new(1973, [l, s, l, s, s, l, s, s, l, l, l, s, s], None, gregorian(1973, 2, 3)),
        PackedEastAsianTraditionalYearData::new(1974, [l, l, s, l, s, s, l, s, s, l, l, s, l], Some(5), gregorian(1974, 1, 23)),
        PackedEastAsianTraditionalYearData::new(1975, [l, l, s, l, s, s, l, s, s, l, s, l, s], None, gregorian(1975, 2, 11)),
        PackedEastAsianTraditionalYearData::new(1976, [l, l, s, l, s, l, s, l, s, l, s, s, l], Some(9), gregorian(1976, 1, 31)),
        PackedEastAsianTraditionalYearData::new(1977, [l, s, l, l, s, l, s, l, s, l, s, s, s], None, gregorian(1977, 2, 18)),
        PackedEastAsianTraditionalYearData::new(1978, [l, l, s, l, s, l, l, s, l, s, l, s, s], None, gregorian(1978, 2, 7)),
        PackedEastAsianTraditionalYearData::new(1979, [l, s, s, l, s, l, l, s, l, l, s, l, s], Some(7), gregorian(1979, 1, 28)),
        PackedEastAsianTraditionalYearData::new(1980, [l, s, s, l, s, l, s, l, l, s, l, l, s], None, gregorian(1980, 2, 16)),
        PackedEastAsianTraditionalYearData::new(1981, [s, l, s, s, l, s, s, l, l, s, l, l, s], None, gregorian(1981, 2, 5)),
        PackedEastAsianTraditionalYearData::new(1982, [l, s, l, s, s, l, s, s, l, l, s, l, l], Some(5), gregorian(1982, 1, 25)),
        PackedEastAsianTraditionalYearData::new(1983, [l, s, l, s, s, l, s, s, l, s, l, l, s], None, gregorian(1983, 2, 13)),
        PackedEastAsianTraditionalYearData::new(1984, [l, s, l, l, s, s, l, s, s, l, s, l, l], Some(11), gregorian(1984, 2, 2)),
        PackedEastAsianTraditionalYearData::new(1985, [s, l, l, s, l, s, l, s, s, l, s, l, s], None, gregorian(1985, 2, 20)),
        PackedEastAsianTraditionalYearData::new(1986, [s, l, l, s, l, l, s, l, s, l, s, s, s], None, gregorian(1986, 2, 9)),
        PackedEastAsianTraditionalYearData::new(1987, [l, s, l, l, s, l, s, l, l, s, l, s, l], Some(7), gregorian(1987, 1, 29)),
        PackedEastAsianTraditionalYearData::new(1988, [s, s, l, s, l, s, l, l, s, l, l, s, s], None, gregorian(1988, 2, 18)),
        PackedEastAsianTraditionalYearData::new(1989, [l, s, s, l, s, l, s, l, l, s, l, l, s], None, gregorian(1989, 2, 6)),
        PackedEastAsianTraditionalYearData::new(1990, [s, l, s, s, l, s, s, l, l, s, l, l, l], Some(6), gregorian(1990, 1, 27)),
        PackedEastAsianTraditionalYearData::new(1991, [s, l, s, s, l, s, s, l, s, l, l, l, s], None, gregorian(1991, 2, 15)),
        PackedEastAsianTraditionalYearData::new(1992, [s, l, l, s, s, l, s, s, l, s, l, l, s], None, gregorian(1992, 2, 4)),
        PackedEastAsianTraditionalYearData::new(1993, [s, l, l, s, l, s, l, s, s, l, s, l, s], Some(4), gregorian(1993, 1, 23)),
        PackedEastAsianTraditionalYearData::new(1994, [l, l, l, s, l, s, l, s, s, l, s, l, s], None, gregorian(1994, 2, 10)),
        PackedEastAsianTraditionalYearData::new(1995, [s, l, l, s, l, l, s, l, s, l, s, s, l], Some(9), gregorian(1995, 1, 31)),
        PackedEastAsianTraditionalYearData::new(1996, [s, l, s, l, l, s, l, s, l, l, s, l, s], None, gregorian(1996, 2, 19)),
        PackedEastAsianTraditionalYearData::new(1997, [s, s, l, s, l, s, l, l, s, l, l, s, s], None, gregorian(1997, 2, 8)),
        PackedEastAsianTraditionalYearData::new(1998, [l, s, s, l, s, s, l, l, s, l, l, l, s], Some(6), gregorian(1998, 1, 28)),
        PackedEastAsianTraditionalYearData::new(1999, [l, s, s, l, s, s, l, s, l, l, l, s, s], None, gregorian(1999, 2, 16)),
        PackedEastAsianTraditionalYearData::new(2000, [l, l, s, s, l, s, s, l, s, l, l, s, s], None, gregorian(2000, 2, 5)),
        PackedEastAsianTraditionalYearData::new(2001, [l, l, l, s, s, l, s, s, l, s, l, s, l], Some(5), gregorian(2001, 1, 24)),
        PackedEastAsianTraditionalYearData::new(2002, [l, l, s, l, s, l, s, s, l, s, l, s, s], None, gregorian(2002, 2, 12)),
        PackedEastAsianTraditionalYearData::new(2003, [l, l, s, l, l, s, l, s, s, l, s, l, s], None, gregorian(2003, 2, 1)),
        PackedEastAsianTraditionalYearData::new(2004, [s, l, s, l, l, s, l, s, l, s, l, s, l], Some(3), gregorian(2004, 1, 22)),
        PackedEastAsianTraditionalYearData::new(2005, [s, l, s, l, s, l, l, s, l, l, s, s, s], None, gregorian(2005, 2, 9)),
        PackedEastAsianTraditionalYearData::new(2006, [l, s, l, s, l, s, l, s, l, l, s, l, l], Some(8), gregorian(2006, 1, 29)),
        PackedEastAsianTraditionalYearData::new(2007, [s, s, l, s, s, l, s, l, l, l, s, l, s], None, gregorian(2007, 2, 18)),
        PackedEastAsianTraditionalYearData::new(2008, [l, s, s, l, s, s, l, s, l, l, s, l, s], None, gregorian(2008, 2, 7)),
        PackedEastAsianTraditionalYearData::new(2009, [l, l, s, s, l, s, s, l, s, l, s, l, l], Some(6), gregorian(2009, 1, 26)),
        PackedEastAsianTraditionalYearData::new(2010, [l, s, l, s, l, s, s, l, s, l, s, l, s], None, gregorian(2010, 2, 14)),
        PackedEastAsianTraditionalYearData::new(2011, [l, s, l, l, s, l, s, s, l, s, l, s, s], None, gregorian(2011, 2, 3)),
        PackedEastAsianTraditionalYearData::new(2012, [l, s, l, l, l, s, l, s, s, l, s, l, s], Some(4), gregorian(2012, 1, 23)),
        PackedEastAsianTraditionalYearData::new(2013, [l, s, l, l, s, l, s, l, s, l, s, l, s], None, gregorian(2013, 2, 10)),
        PackedEastAsianTraditionalYearData::new(2014, [s, l, s, l, s, l, s, l, l, s, l, s, l], Some(10), gregorian(2014, 1, 31)),
        PackedEastAsianTraditionalYearData::new(2015, [s, l, s, s, l, s, l, l, l, s, l, s, s], None, gregorian(2015, 2, 19)),
        PackedEastAsianTraditionalYearData::new(2016, [l, s, l, s, s, l, s, l, l, s, l, l, s], None, gregorian(2016, 2, 8)),
        PackedEastAsianTraditionalYearData::new(2017, [s, l, s, l, s, s, l, s, l, s, l, l, l], Some(6), gregorian(2017, 1, 28)),
        PackedEastAsianTraditionalYearData::new(2018, [s, l, s, l, s, s, l, s, l, s, l, l, s], None, gregorian(2018, 2, 16)),
        PackedEastAsianTraditionalYearData::new(2019, [l, s, l, s, l, s, s, l, s, l, s, l, s], None, gregorian(2019, 2, 5)),
        PackedEastAsianTraditionalYearData::new(2020, [l, s, l, l, s, l, s, s, l, s, l, s, l], Some(5), gregorian(2020, 1, 25)),
        PackedEastAsianTraditionalYearData::new(2021, [s, l, l, s, l, s, l, s, l, s, l, s, s], None, gregorian(2021, 2, 12)),
        PackedEastAsianTraditionalYearData::new(2022, [l, s, l, s, l, l, s, l, s, l, s, l, s], None, gregorian(2022, 2, 1)),
        PackedEastAsianTraditionalYearData::new(2023, [s, l, s, l, s, l, s, l, l, s, l, s, l], Some(3), gregorian(2023, 1, 22)),
        PackedEastAsianTraditionalYearData::new(2024, [s, l, s, s, l, s, l, l, s, l, l, s, s], None, gregorian(2024, 2, 10)),
        PackedEastAsianTraditionalYearData::new(2025, [l, s, l, s, s, l, s, l, s, l, l, l, s], Some(7), gregorian(2025, 1, 29)),
        PackedEastAsianTraditionalYearData::new(2026, [l, s, l, s, s, l, s, l, s, l, l, l, s], None, gregorian(2026, 2, 17)),
        PackedEastAsianTraditionalYearData::new(2027, [s, l, s, l, s, s, l, s, s, l, l, l, s], None, gregorian(2027, 2, 7)),
        PackedEastAsianTraditionalYearData::new(2028, [s, l, l, s, l, s, s, l, s, s, l, l, s], Some(6), gregorian(2028, 1, 27)),
        PackedEastAsianTraditionalYearData::new(2029, [l, l, s, l, l, s, s, l, s, s, l, l, s], None, gregorian(2029, 2, 13)),
        PackedEastAsianTraditionalYearData::new(2030, [s, l, s, l, l, s, l, s, l, s, l, s, s], None, gregorian(2030, 2, 3)),
        PackedEastAsianTraditionalYearData::new(2031, [l, s, l, s, l, s, l, l, s, l, s, l, s], Some(4), gregorian(2031, 1, 23)),
        PackedEastAsianTraditionalYearData::new(2032, [l, s, s, l, s, l, l, s, l, l, s, l, s], None, gregorian(2032, 2, 11)),
        PackedEastAsianTraditionalYearData::new(2033, [s, l, s, s, l, s, l, s, l, l, l, s, l], Some(12), gregorian(2033, 1, 31)),
        PackedEastAsianTraditionalYearData::new(2034, [s, l, s, s, l, s, l, s, l, l, l, s, s], None, gregorian(2034, 2, 19)),
        PackedEastAsianTraditionalYearData::new(2035, [l, s, l, s, s, l, s, s, l, l, s, l, s], None, gregorian(2035, 2, 8)),
        PackedEastAsianTraditionalYearData::new(2036, [l, l, s, l, s, s, l, s, s, l, l, s, l], Some(7), gregorian(2036, 1, 28)),
        PackedEastAsianTraditionalYearData::new(2037, [l, l, s, l, s, s, l, s, s, l, s, l, s], None, gregorian(2037, 2, 15)),
        PackedEastAsianTraditionalYearData::new(2038, [l, l, s, l, s, l, s, l, s, s, l, s, s], None, gregorian(2038, 2, 4)),
        PackedEastAsianTraditionalYearData::new(2039, [l, l, s, l, l, s, l, s, l, s, l, s, s], Some(6), gregorian(2039, 1, 24)),
        PackedEastAsianTraditionalYearData::new(2040, [l, s, l, l, s, l, l, s, l, s, l, s, s], None, gregorian(2040, 2, 12)),
        PackedEastAsianTraditionalYearData::new(2041, [l, s, s, l, s, l, l, s, l, l, s, l, s], None, gregorian(2041, 2, 1)),
        PackedEastAsianTraditionalYearData::new(2042, [s, l, s, s, l, s, l, s, l, l, s, l, l], Some(3), gregorian(2042, 1, 22)),
        PackedEastAsianTraditionalYearData::new(2043, [s, l, s, s, l, s, s, l, l, s, l, l, s], None, gregorian(2043, 2, 10)),
        PackedEastAsianTraditionalYearData::new(2044, [l, s, l, s, s, l, s, s, l, s, l, l, l], Some(8), gregorian(2044, 1, 30)),
        PackedEastAsianTraditionalYearData::new(2045, [l, s, l, s, s, l, s, s, l, s, l, l, s], None, gregorian(2045, 2, 17)),
        PackedEastAsianTraditionalYearData::new(2046, [l, s, l, l, s, s, l, s, s, l, s, l, s], None, gregorian(2046, 2, 6)),
        PackedEastAsianTraditionalYearData::new(2047, [l, s, l, l, s, l, s, l, s, s, l, s, l], Some(6), gregorian(2047, 1, 26)),
        PackedEastAsianTraditionalYearData::new(2048, [s, l, l, s, l, l, s, l, s, l, s, s, s], None, gregorian(2048, 2, 14)),
        PackedEastAsianTraditionalYearData::new(2049, [l, s, l, s, l, l, s, l, l, s, l, s, s], None, gregorian(2049, 2, 2)),
        PackedEastAsianTraditionalYearData::new(2050, [l, s, s, l, s, l, s, l, l, s, l, l, s], Some(4), gregorian(2050, 1, 23)),
        PackedEastAsianTraditionalYearData::new(2051, [l, s, s, l, s, l, s, l, s, l, l, l, s], None, gregorian(2051, 2, 11)),
        PackedEastAsianTraditionalYearData::new(2052, [s, l, s, s, l, s, s, l, l, s, l, l, l], Some(9), gregorian(2052, 2, 1)),
        PackedEastAsianTraditionalYearData::new(2053, [s, l, s, s, l, s, s, l, s, l, l, l, s], None, gregorian(2053, 2, 19)),
        PackedEastAsianTraditionalYearData::new(2054, [s, l, l, s, s, l, s, s, l, s, l, l, s], None, gregorian(2054, 2, 8)),
        PackedEastAsianTraditionalYearData::new(2055, [s, l, l, s, l, s, l, s, s, l, s, l, s], Some(7), gregorian(2055, 1, 28)),
        PackedEastAsianTraditionalYearData::new(2056, [l, l, l, s, l, s, l, s, s, l, s, l, s], None, gregorian(2056, 2, 15)),
        PackedEastAsianTraditionalYearData::new(2057, [s, l, l, s, l, s, l, l, s, s, l, s, s], None, gregorian(2057, 2, 4)),
        PackedEastAsianTraditionalYearData::new(2058, [l, s, l, s, l, l, s, l, s, l, l, s, s], Some(5), gregorian(2058, 1, 24)),
        PackedEastAsianTraditionalYearData::new(2059, [l, s, l, s, l, s, l, l, s, l, l, s, s], None, gregorian(2059, 2, 12)),
        PackedEastAsianTraditionalYearData::new(2060, [l, s, s, l, s, s, l, l, s, l, l, l, s], None, gregorian(2060, 2, 2)),
        PackedEastAsianTraditionalYearData::new(2061, [s, l, s, s, l, s, s, l, s, l, l, l, s], Some(4), gregorian(2061, 1, 22)),
        PackedEastAsianTraditionalYearData::new(2062, [l, l, s, s, l, s, s, l, s, l, l, s, s], None, gregorian(2062, 2, 9)),
        PackedEastAsianTraditionalYearData::new(2063, [l, l, s, l, s, l, s, s, l, s, l, s, l], Some(8), gregorian(2063, 1, 29)),
        PackedEastAsianTraditionalYearData::new(2064, [l, l, s, l, s, l, s, s, l, s, l, s, s], None, gregorian(2064, 2, 17)),
        PackedEastAsianTraditionalYearData::new(2065, [l, l, s, l, l, s, l, s, s, l, s, l, s], None, gregorian(2065, 2, 5)),
        PackedEastAsianTraditionalYearData::new(2066, [s, l, s, l, l, s, l, s, l, s, l, s, l], Some(6), gregorian(2066, 1, 26)),
        PackedEastAsianTraditionalYearData::new(2067, [s, l, s, l, s, l, l, s, l, s, l, s, s], None, gregorian(2067, 2, 14)),
        PackedEastAsianTraditionalYearData::new(2068, [l, s, l, s, l, s, l, s, l, l, s, l, s], None, gregorian(2068, 2, 3)),
        PackedEastAsianTraditionalYearData::new(2069, [l, s, s, l, s, s, l, s, l, l, l, s, l], Some(5), gregorian(2069, 1, 23)),
        PackedEastAsianTraditionalYearData::new(2070, [l, s, s, l, s, s, l, s, l, l, s, l, s], None, gregorian(2070, 2, 11)),
        PackedEastAsianTraditionalYearData::new(2071, [l, l, s, s, l, s, s, l, s, l, s, l, l], Some(9), gregorian(2071, 1, 31)),
        PackedEastAsianTraditionalYearData::new(2072, [l, s, l, s, l, s, s, l, s, l, s, l, s], None, gregorian(2072, 2, 19)),
        PackedEastAsianTraditionalYearData::new(2073, [l, s, l, l, s, l, s, s, l, s, l, s, s], None, gregorian(2073, 2, 7)),
        PackedEastAsianTraditionalYearData::new(2074, [l, s, l, l, s, l, s, l, s, l, s, l, s], Some(7), gregorian(2074, 1, 27)),
        PackedEastAsianTraditionalYearData::new(2075, [l, s, l, s, l, l, s, l, s, l, s, l, s], None, gregorian(2075, 2, 15)),
        PackedEastAsianTraditionalYearData::new(2076, [s, l, s, l, s, l, s, l, l, s, l, s, s], None, gregorian(2076, 2, 5)),
        PackedEastAsianTraditionalYearData::new(2077, [l, s, l, s, s, l, s, l, l, l, s, l, s], Some(5), gregorian(2077, 1, 24)),
        PackedEastAsianTraditionalYearData::new(2078, [l, s, l, s, s, l, s, l, l, s, l, l, s], None, gregorian(2078, 2, 12)),
        PackedEastAsianTraditionalYearData::new(2079, [s, l, s, l, s, s, l, s, l, s, l, l, s], None, gregorian(2079, 2, 2)),
        PackedEastAsianTraditionalYearData::new(2080, [l, s, l, s, l, s, s, l, s, l, s, l, l], Some(4), gregorian(2080, 1, 22)),
        PackedEastAsianTraditionalYearData::new(2081, [l, s, l, s, l, s, s, l, s, s, l, l, s], None, gregorian(2081, 2, 9)),
        PackedEastAsianTraditionalYearData::new(2082, [s, l, l, l, s, l, s, s, l, s, l, s, l], Some(8), gregorian(2082, 1, 29)),
        PackedEastAsianTraditionalYearData::new(2083, [s, l, l, s, l, s, l, s, l, s, l, s, s], None, gregorian(2083, 2, 17)),
        PackedEastAsianTraditionalYearData::new(2084, [l, s, l, s, l, l, s, l, s, l, s, l, s], None, gregorian(2084, 2, 6)),
        PackedEastAsianTraditionalYearData::new(2085, [s, l, s, s, l, l, s, l, l, s, l, s, l], Some(6), gregorian(2085, 1, 26)),
        PackedEastAsianTraditionalYearData::new(2086, [s, l, s, s, l, s, l, l, s, l, l, s, s], None, gregorian(2086, 2, 14)),
        PackedEastAsianTraditionalYearData::new(2087, [l, s, l, s, s, l, s, l, s, l, l, l, s], None, gregorian(2087, 2, 3)),
        PackedEastAsianTraditionalYearData::new(2088, [s, l, s, l, s, s, l, s, s, l, l, l, l], Some(5), gregorian(2088, 1, 24)),
        PackedEastAsianTraditionalYearData::new(2089, [s, l, s, l, s, s, l, s, s, l, l, s, s], None, gregorian(2089, 2, 11)),
        PackedEastAsianTraditionalYearData::new(2090, [l, l, l, s, l, s, s, l, s, s, l, l, s], Some(9), gregorian(2090, 1, 30)),
        PackedEastAsianTraditionalYearData::new(2091, [l, l, s, l, s, l, s, l, s, s, l, l, s], None, gregorian(2091, 2, 18)),
        PackedEastAsianTraditionalYearData::new(2092, [s, l, s, l, l, s, l, s, l, s, l, s, s], None, gregorian(2092, 2, 8)),
        PackedEastAsianTraditionalYearData::new(2093, [l, s, l, s, l, s, l, l, s, l, s, l, s], Some(7), gregorian(2093, 1, 27)),
        PackedEastAsianTraditionalYearData::new(2094, [l, s, s, l, s, l, l, s, l, l, s, l, s], None, gregorian(2094, 2, 15)),
        PackedEastAsianTraditionalYearData::new(2095, [s, l, s, s, l, s, l, s, l, l, l, s, s], None, gregorian(2095, 2, 5)),
        PackedEastAsianTraditionalYearData::new(2096, [l, s, l, s, s, l, s, l, s, l, l, s, l], Some(5), gregorian(2096, 1, 25)),
        PackedEastAsianTraditionalYearData::new(2097, [l, s, l, s, s, l, s, s, l, l, s, l, s], None, gregorian(2097, 2, 12)),
        PackedEastAsianTraditionalYearData::new(2098, [l, l, s, l, s, s, l, s, s, l, l, s, s], None, gregorian(2098, 2, 1)),
        PackedEastAsianTraditionalYearData::new(2099, [l, l, l, s, l, s, s, l, s, s, l, s, l], Some(4), gregorian(2099, 1, 21)),
        PackedEastAsianTraditionalYearData::new(2100, [l, l, s, l, s, l, s, l, s, s, l, s, s], None, gregorian(2100, 2, 9)),
        // Extra two years of correct data because the simple calculation lines up at the beginning of 2103
        PackedEastAsianTraditionalYearData::new(2101, [l, l, s, l, l, s, l, s, l, s, l, s, s], Some(8), gregorian(2101, 1, 29)),
        PackedEastAsianTraditionalYearData::new(2102, [l, s, l, l, s, l, s, l, l, s, l, s, s], None, gregorian(2102, 2, 17)),
    ]
};

#[test]
fn test_against_calendrical_calculations() {
    use calendrical_calculations::chinese_based::Dangi;
    for (i, &data) in DATA.iter().enumerate() {
        assert_eq!(
            data,
            super::EastAsianTraditionalYearData::calendrical_calculations::<Dangi>(
                STARTING_YEAR + i as i32
            )
            .packed
        );
    }
}
