/* pathjumpop.hh
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2012-2019 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef PATHJUMPOP_HH
#define PATHJUMPOP_HH

#include "wdefines.h"
#include "functionproto.h"
#include <string>
#include <list>

class PathJumpOp : public FunctionProto
{
public:
    PathJumpOp();
    ~PathJumpOp();
    PathJumpOp( const PathJumpOp &other );
    PathJumpOp &operator=( const PathJumpOp &other );
    
    PathJumpOp *duplicate() const;
    virtual bool isName(const char *);
    virtual const char *getName();
    
    using FunctionProto::run;
    int run( WPUContext*, ActionMessage* );
    virtual const char *getDescription();
    virtual bool save(Datei*);
    virtual int configure();

    typedef enum {
        SHOW_BY_TIME = 0,
        SHOW_BY_FILTER,
        SHOW_BY_PROGRAM
    } initial_tab_t;

    void setInitialTab( initial_tab_t v );

    static const char *name;
private:
    // Infos to save
    initial_tab_t m_initial_tab = SHOW_BY_TIME;
};

#endif
