/*  pcfutil.h

    FreeType font driver for pcf fonts

  Copyright 2000-2001 by
  Francesco Zappa Nardelli

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/


#ifndef __PCFUTIL_H__
#define __PCFUTIL_H__


#include <ft2build.h>


  static void
  BitOrderInvert( unsigned char*  buf,
                  int             nbytes);

  static void
  TwoByteSwap( unsigned char*  buf,
               int             nbytes);

  static void
  FourByteSwap( unsigned char*  buf,
                int             nbytes);

  static int
  RepadBitmap( char*           pSrc,
               char*           pDst,
               unsigned int    srcPad,
               unsigned int    dstPad,
               int             width,
               int             height);

#endif /* __PCFUTIL_H__ */


/* END */
