Introduction to Concurrent Programming in C
===========================================

The book *Introduction to Concurrent Programming in C* is aimed at readers who are proficient with
normal (sequential) programming, but that do not yet have (much) experience with concurrent
programming. As such, the book starts by higlighting the fundamental differences between the
sequential and the concurrent execution models. At first glance, it seems easy to extend a
sequential program into a concurrent program, we just have to add a thread or two! However, it turns
out that the simple decision to allow multiple threads expose many subtle details of both the
compiler and the hardware that are normally hidden from view.

After a thorough description of the execution model, the book moves on to introduce synchronization
primitives (semaphores, locks, and condition variables) and details how they can be used to write
correct concurrent programs. The book focuses on building a correct mental model of how programs
execute in a concurrent system, one that can be later used to reason about whether or not some
program is correct. As such, the book focuses more on an informal model that can be used as a tool,
rather than formal proofs.

To help the reader build such a model, the book relies heavily on visualizations in
[Progvis](md:../Progvis). Both in examples to illustrate the concepts, but also for exercises. The
exercises are furthermore constructed so that it is possible to use Progvis' *model checker* to
verify solutions to the problems.


Download the book
-----------------

The book is freely available under a Creative Commons license below (built nightly):

- [**The book**](https://storm-lang.org/progvis-book/book.pdf)
- [**Examples and exercises**](https://storm-lang.org/progvis-book/source.zip)


Source code
-----------

The source code for the book is also freely available below.

- Primary source: [GitLab at Linköping University](https://gitlab.liu.se/filst04/concurrency-book)
- Mirror (Git access only, no Web UI available): `git clone git://storm-lang.org/concurrency-book.git`


Contact
-------

If you have questions or suggestions related to the book, contact either:
- [filip.stromback@liu.se](mailto:filip.stromback@liu.se)
- [info@storm-lang.org](mailto:info@storm-lang.org)
