/* Public domain. */

#ifndef CALTIMEDATE_H
#define CALTIMEDATE_H

#include "gccattributes.h"
#include "tai.h"

struct caldate
{
  long year ;
  int month ;
  int day ;
} ;

extern unsigned int caldate_fmt (char *, struct caldate const *) ;
extern unsigned int caldate_scan (char const *, struct caldate *) ;

extern void caldate_frommjd (struct caldate *, long, int *, int *) ;
extern long caldate_mjd (struct caldate const *) gccattr_pure ;
extern void caldate_normalize (struct caldate *) ;

extern void caldate_easter (struct caldate *) ;

struct caltime {
  struct caldate date ;
  int hour ;
  int minute ;
  int second ;
  long offset ;
} ;

extern unsigned int caltime_fmt (char *, struct caltime const *) ;
extern unsigned int caltime_scan (char const *, struct caltime *) ;
extern void caltime_tai (struct caltime const *, struct tai *) ;
extern void caltime_utc (struct caltime *, struct tai const *, int *, int *) ;

extern int leapsecs_init (void) ;
extern int leapsecs_readf_r (char const *, struct tai **) ;
extern int leapsecs_read_r (struct tai **) ;
extern int leapsecs_read (void) ;
extern void leapsecs_add (struct tai *, int) ;
extern int leapsecs_sub (struct tai *) ;

#endif
