from __future__ import print_function
from _mock import _Mock

release = __import__('IPython.core.release', fromlist=['release'])
usage = __import__('IPython.core.usage', fromlist=['usage'])
warn = __import__('IPython.utils.warn', fromlist=['warn'])


absolute_import = _Mock()

addflag = _Mock()

aliases = _Mock()

base_aliases = _Mock()

base_flags = _Mock()

boolean_flag = _Mock()

catch_config_error = _Mock()

check_for_old_config = _Mock()

classic_config = _Mock()

flags = _Mock()

frontend_flags = _Mock()

get_ipython_dir = _Mock()

launch_new_instance = _Mock()

load_default_config = _Mock()

logging = _Mock()

os = _Mock()

shell_aliases = _Mock()

shell_flags = _Mock()

sys = _Mock()

_examples = '\nipython --matplotlib       # enable matplotlib integration\nipython --matploltib=qt    # enable matplotlib integration with qt4 backend\n\nipython --log-level=DEBUG  # set logging to DEBUG\nipython --profile=foo      # start with profile foo\n\nipython qtconsole          # start the qtconsole GUI application\nipython help qtconsole     # show the help for the qtconsole subcmd\n\nipython console            # start the terminal-based console application\nipython help console       # show the help for the console subcmd\n\nipython notebook           # start the IPython notebook\nipython help notebook      # show the help for the notebook subcmd\n\nipython profile create foo # create profile foo w/ default config files\nipython help profile       # show the help for the profile subcmd\n\nipython locate             # print the path to the IPython directory\nipython locate profile foo # print the path to the directory for profile `foo`\n\nipython nbconvert           # convert notebooks to/from other formats\n'

class BaseIPythonApplication(_Mock):
  pass
  _in_init_profile_dir = False

class Bool(_Mock):
  pass
  default_value = False
  info_text = 'a boolean'

class Config(_Mock):
  pass


class ConfigFileNotFound(_Mock):
  pass


class CrashHandler(_Mock):
  pass
  message_template = "Oops, {app_name} crashed. We do our best to make it stable, but...\n\nA crash report was automatically generated with the following information:\n  - A verbatim copy of the crash traceback.\n  - A copy of your input history during this session.\n  - Data on your current {app_name} configuration.\n\nIt was left in the file named:\n\t'{crash_report_fname}'\nIf you can email this file to the developers, the information in it will help\nthem in understanding and correcting the problem.\n\nYou can mail it to: {contact_name} at {contact_email}\nwith the subject '{app_name} Crash Report'.\n\nIf you want to do it now, the following command will work (under Unix):\nmail -s '{app_name} Crash Report' {contact_email} < {crash_report_fname}\n\nTo ensure accurate tracking of this issue, please file a report about it at:\n{bug_tracker}\n"
  section_sep = '\n\n***************************************************************************\n\n'

class Dict(_Mock):
  pass
  info_text = 'any value'

class HistoryManager(_Mock):
  pass


class IPAppCrashHandler(_Mock):
  pass
  message_template = "Oops, {app_name} crashed. We do our best to make it stable, but...\n\nA crash report was automatically generated with the following information:\n  - A verbatim copy of the crash traceback.\n  - A copy of your input history during this session.\n  - Data on your current {app_name} configuration.\n\nIt was left in the file named:\n\t'{crash_report_fname}'\nIf you can email this file to the developers, the information in it will help\nthem in understanding and correcting the problem.\n\nYou can mail it to: {contact_name} at {contact_email}\nwith the subject '{app_name} Crash Report'.\n\nIf you want to do it now, the following command will work (under Unix):\nmail -s '{app_name} Crash Report' {contact_email} < {crash_report_fname}\n\nTo ensure accurate tracking of this issue, please file a report about it at:\n{bug_tracker}\n"
  section_sep = '\n\n***************************************************************************\n\n'

class IPCompleter(_Mock):
  pass


class InteractiveShellApp(_Mock):
  pass


class List(_Mock):
  pass
  info_text = 'any value'

class LocateIPythonApp(_Mock):
  pass
  _in_init_profile_dir = False
  description = 'print the path to the IPython dir'

class PlainTextFormatter(_Mock):
  pass


class ProfileDir(_Mock):
  pass


class PromptManager(_Mock):
  pass


class PyFileConfigLoader(_Mock):
  pass


class ScriptMagics(_Mock):
  pass
  registered = True

class TerminalIPythonApp(_Mock):
  pass
  _in_init_profile_dir = False
  description = "=========\n IPython\n=========\n\nTools for Interactive Computing in Python\n=========================================\n\n    A Python shell with automatic history (input and output), dynamic object\n    introspection, easier configuration, command completion, access to the\n    system shell and more.  IPython can also be embedded in running programs.\n\n\nUsage\n\n    ipython [subcommand] [options] [-c cmd | -m mod | file] [--] [arg] ...\n\n    If invoked with no options, it executes the file and exits, passing the\n    remaining arguments to the script, just as if you had specified the same\n    command with python. You may need to specify `--` before args to be passed\n    to the script, to prevent IPython from attempting to parse them. If you\n    specify the option `-i` before the filename, it will enter an interactive\n    IPython session after running the script, rather than exiting. Files ending\n    in .py will be treated as normal Python, but files ending in .ipy can\n    contain special IPython syntax (magic commands, shell expansions, etc.).\n\n    Almost all configuration in IPython is available via the command-line. Do\n    `ipython --help-all` to see all available options.  For persistent\n    configuration, look into your `ipython_config.py` configuration file for\n    details.\n\n    This file is typically installed in the `IPYTHONDIR` directory, and there\n    is a separate configuration directory for each profile. The default profile\n    directory will be located in $IPYTHONDIR/profile_default. For Linux users,\n    IPYTHONDIR defaults to `$HOME/.config/ipython`, and for other Unix systems\n    to `$HOME/.ipython`.  For Windows users, $HOME resolves to C:\\Documents\n    and Settings\\YourUserName in most instances.\n\n    To initialize a profile with the default configuration file, do::\n\n      $> ipython profile create\n\n    and start editing `IPYTHONDIR/profile_default/ipython_config.py`\n\n    In IPython's documentation, we will refer to this directory as\n    `IPYTHONDIR`, you can change its default location by creating an\n    environment variable with this name and setting it to the desired path.\n\n    For more information, see the manual available in HTML and PDF in your\n    installation, or online at http://ipython.org/documentation.html.\n"
  examples = '\nipython --matplotlib       # enable matplotlib integration\nipython --matploltib=qt    # enable matplotlib integration with qt4 backend\n\nipython --log-level=DEBUG  # set logging to DEBUG\nipython --profile=foo      # start with profile foo\n\nipython qtconsole          # start the qtconsole GUI application\nipython help qtconsole     # show the help for the qtconsole subcmd\n\nipython console            # start the terminal-based console application\nipython help console       # show the help for the console subcmd\n\nipython notebook           # start the IPython notebook\nipython help notebook      # show the help for the notebook subcmd\n\nipython profile create foo # create profile foo w/ default config files\nipython help profile       # show the help for the profile subcmd\n\nipython locate             # print the path to the IPython directory\nipython locate profile foo # print the path to the directory for profile `foo`\n\nipython nbconvert           # convert notebooks to/from other formats\n'
  name = u'ipython'

class TerminalInteractiveShell(_Mock):
  pass
  default_user_namespaces = True

