/*
 * Decompiled with CFR 0.152.
 */
package app.authkit.test;

import app.hex.Hex;
import glguerin.authkit.Authorization;
import glguerin.authkit.Privilege;
import glguerin.authkit.UnauthorizedException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.Enumeration;

public abstract class AuthTest {
    public void testAuth(Authorization authorization, String string, String[] stringArray) {
        boolean bl = "true".equalsIgnoreCase(System.getProperty(string, "true"));
        int n = 0;
        while (n < stringArray.length) {
            try {
                this.testAuthOne(authorization, bl, stringArray[n]);
            }
            catch (UnauthorizedException unauthorizedException) {
                AuthTest.explain(unauthorizedException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                AuthTest.explain(illegalArgumentException);
            }
            ++n;
        }
        AuthTest.tell("");
        this.tellGranted("..granted: ", authorization);
        AuthTest.tell("");
    }

    public void testAuthOne(Authorization authorization, boolean bl, String string) {
    }

    public static Authorization makeAuth(String string) {
        String string2;
        if (string == null || string.length() == 0) {
            string = "authkit.imp";
        }
        if ((string2 = System.getProperty(string)) == null || string2.length() == 0) {
            string2 = "glguerin.authkit.imp.plain.DenyAllAuthorization";
        }
        try {
            return (Authorization)Class.forName(string2).newInstance();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            AuthTest.explain(throwable);
            return null;
        }
    }

    protected void tellGranted(String string, Authorization authorization) {
        Enumeration enumeration = authorization.getPastGrantedPrivileges();
        while (enumeration.hasMoreElements()) {
            this.tellPrivilege(string, (Privilege)enumeration.nextElement(), authorization);
        }
    }

    protected void tellPrivilege(String string, Privilege privilege, Authorization authorization) {
        AuthTest.tell(this.formatPrivilege(string, privilege, authorization));
    }

    protected String formatPrivilege(String string, Privilege privilege, Authorization authorization) {
        StringBuffer stringBuffer = new StringBuffer(string).append(privilege);
        if (authorization != null) {
            Date date = authorization.getPastGrantedDate(privilege, 1);
            if (date != null) {
                stringBuffer.append(" at ").append(date);
            }
            stringBuffer.append(" -- ").append(authorization.isAvailable(privilege));
        }
        return stringBuffer.toString();
    }

    protected void tellWhich(Authorization authorization) {
        AuthTest.tell("..Auth-ID: " + this.getWhich(authorization));
    }

    protected String getWhich(Authorization authorization) {
        String string = authorization.getPublicIdentifier();
        if (string.length() != 0) {
            return string;
        }
        authorization.isAvailable(Privilege.EMPTY);
        return authorization.getPublicIdentifier();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void resession(Authorization authorization, String string) {
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(string);
        this.resession(authorization, fileInputStream);
        Object var6_4 = null;
        if (fileInputStream == null) return;
        try {
            ((InputStream)fileInputStream).close();
            return;
        }
        catch (IOException iOException) {
            AuthTest.explain(iOException);
        }
        return;
        {
            catch (IOException iOException) {
                AuthTest.explain(iOException);
                Object var6_5 = null;
                if (fileInputStream == null) return;
                try {
                    ((InputStream)fileInputStream).close();
                    return;
                }
                catch (IOException iOException2) {
                    AuthTest.explain(iOException2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (fileInputStream == null) throw throwable;
            try {
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                AuthTest.explain(iOException);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void resession(Authorization var1_1, InputStream var2_2) throws IOException {
        block5: {
            var3_3 = new byte[var1_1.getSecretLength()];
            try {
                var4_4 = var2_2.read(var3_3);
                if (var4_4 != var3_3.length) {
                    throw new IOException("Wrong number of bytes: " + var4_4 + " of " + var3_3.length);
                }
                var1_1.attach(var3_3);
                var6_5 = null;
                var7_7 = 0;
                ** while (var7_7 < var3_3.length)
            }
            catch (Throwable var5_9) {
                var6_6 = null;
                var7_8 = 0;
                ** while (var7_8 < var3_3.length)
            }
lbl-1000:
            // 1 sources

            {
                var3_3[var7_7] = 0;
                ++var7_7;
                continue;
lbl14:
                // 1 sources

                break block5;
            }
lbl-1000:
            // 1 sources

            {
                var3_3[var7_8] = 0;
                ++var7_8;
                continue;
            }
lbl23:
            // 1 sources

            throw var5_9;
        }
    }

    protected void putHexTo(String string, byte[] byArray) {
        this.putHexTo(string, "# -- ", "  ", byArray, byArray.length);
    }

    protected void putHexTo(String string, String string2, String string3, byte[] byArray, int n) {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(string, true));
            this.putHexTo(printStream, string2, string3, byArray, n);
            printStream.close();
        }
        catch (IOException iOException) {
            AuthTest.explain(iOException);
        }
    }

    protected void putHexTo(PrintStream printStream, String string, String string2, byte[] byArray, int n) {
        int n2;
        if (string != null) {
            printStream.println(string);
        }
        if (n < 0 || n > byArray.length) {
            n = byArray.length;
        }
        int n3 = n2 = 16;
        int n4 = 0;
        while (n > 0) {
            if (n < n2) {
                n3 = n;
            }
            this.hexLine(printStream, string2, byArray, n4, n3);
            n4 += n2;
            n -= n2;
        }
    }

    protected void hexLine(PrintStream printStream, String string, byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(3);
        printStream.print(string);
        int n3 = 0;
        while (n2 > 0) {
            stringBuffer.setLength(0);
            Hex.appendHex(stringBuffer, 0xFF & byArray[n], 2);
            stringBuffer.reverse();
            stringBuffer.append(' ');
            if ((++n3 & 3) == 0) {
                stringBuffer.append(' ');
            }
            printStream.print(stringBuffer.toString());
            --n2;
            ++n;
        }
        printStream.println();
    }

    public static void tell(String string) {
        System.out.println(string);
    }

    public static void explain(String string) {
        System.out.flush();
        System.err.println(string);
    }

    public static void explain(Throwable throwable) {
        throwable.printStackTrace(System.err);
    }
}

