MODULE ADMM_TAPENADE_INTERFACE
  IMPLICIT NONE
  INTERFACE PUSHPOINTER8
      SUBROUTINE PUSHPOINTER8(pp) BIND(c, name='pushPointer8')
        USE ISO_C_BINDING
        TYPE(C_PTR), VALUE :: pp
      END SUBROUTINE PUSHPOINTER8
  END INTERFACE PUSHPOINTER8

  INTERFACE POPPOINTER8
      SUBROUTINE POPPOINTER8(pp) BIND(c, name='popPointer8')
        USE ISO_C_BINDING
        TYPE(C_PTR) :: pp
      END SUBROUTINE POPPOINTER8
  END INTERFACE POPPOINTER8

  INTERFACE ADMM_REGISTERSHADOWED
      SUBROUTINE ADMM_REGISTERSHADOWED(base, obase, size, baseb, obaseb&
&       , sizeb, nbelem) BIND(c, name='ADMM_registerShadowed')
        USE ISO_C_BINDING
        TYPE(C_PTR), VALUE :: base, obase
        TYPE(C_PTR), VALUE :: baseb, obaseb
        INTEGER, VALUE :: size, sizeb
        INTEGER, VALUE :: nbelem
      END SUBROUTINE ADMM_REGISTERSHADOWED
  END INTERFACE ADMM_REGISTERSHADOWED

  INTERFACE ADMM_REGISTER
      SUBROUTINE ADMM_REGISTER(base, obase, size, nbelem) BIND(c, name=&
&     'ADMM_register')
        USE ISO_C_BINDING
        TYPE(C_PTR), VALUE :: base, obase
        INTEGER, VALUE :: size
        INTEGER, VALUE :: nbelem
      END SUBROUTINE ADMM_REGISTER
  END INTERFACE ADMM_REGISTER

  INTERFACE ADMM_UNREGISTERSHADOWED
      SUBROUTINE ADMM_UNREGISTERSHADOWED(base, baseb, nbelem) BIND(c, &
&     name='ADMM_unregisterShadowed')
        USE ISO_C_BINDING
        TYPE(C_PTR), VALUE :: base, baseb
        INTEGER :: nbelem
      END SUBROUTINE ADMM_UNREGISTERSHADOWED
  END INTERFACE ADMM_UNREGISTERSHADOWED

  INTERFACE ADMM_UNREGISTER
      SUBROUTINE ADMM_UNREGISTER(base, nbelem) BIND(c, name=&
&     'ADMM_unregister')
        USE ISO_C_BINDING
        TYPE(C_PTR), VALUE :: base
        INTEGER :: nbelem
      END SUBROUTINE ADMM_UNREGISTER
  END INTERFACE ADMM_UNREGISTER

  INTERFACE ADMM_REBASESHADOWED
      SUBROUTINE ADMM_REBASESHADOWED(base, baseb) BIND(c, name=&
&     'ADMM_rebaseShadowed')
        USE ISO_C_BINDING
        TYPE(C_PTR) :: base, baseb
      END SUBROUTINE ADMM_REBASESHADOWED
  END INTERFACE ADMM_REBASESHADOWED

  INTERFACE ADMM_REBASE
      SUBROUTINE ADMM_REBASE(base) BIND(c, name='ADMM_rebase')
        USE ISO_C_BINDING
        TYPE(C_PTR) :: base
      END SUBROUTINE ADMM_REBASE
  END INTERFACE ADMM_REBASE

END MODULE ADMM_TAPENADE_INTERFACE

