
#line 1 "ragel/i18n/pt.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t docstring_content_type_start;
  size_t docstring_content_type_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 254 "ragel/i18n/pt.c.rl"


/** Data **/

#line 89 "ext/gherkin_lexer_pt/gherkin_lexer_pt.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 12, 1, 13, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 1, 22, 1, 23, 2, 1, 18, 
	2, 4, 5, 2, 13, 0, 2, 14, 
	15, 2, 17, 0, 2, 17, 2, 2, 
	17, 16, 2, 17, 19, 2, 18, 6, 
	2, 18, 7, 2, 18, 8, 2, 18, 
	9, 2, 18, 10, 2, 18, 16, 2, 
	20, 21, 2, 22, 0, 2, 22, 2, 
	2, 22, 16, 2, 22, 19, 3, 3, 
	14, 15, 3, 5, 14, 15, 3, 11, 
	14, 15, 3, 12, 14, 15, 3, 13, 
	14, 15, 3, 14, 15, 18, 3, 17, 
	0, 11, 3, 17, 14, 15, 4, 1, 
	14, 15, 18, 4, 4, 5, 14, 15, 
	4, 17, 0, 14, 15, 5, 17, 0, 
	11, 14, 15
};

static const short _lexer_key_offsets[] = {
	0, 0, 17, 18, 19, 35, 36, 37, 
	39, 41, 46, 51, 56, 61, 65, 69, 
	71, 72, 73, 74, 75, 76, 77, 78, 
	79, 80, 81, 82, 83, 84, 85, 86, 
	87, 89, 91, 96, 103, 108, 111, 112, 
	113, 114, 115, 116, 117, 119, 120, 121, 
	122, 123, 124, 125, 126, 127, 128, 139, 
	141, 143, 145, 147, 149, 151, 153, 155, 
	157, 159, 161, 163, 165, 167, 171, 173, 
	175, 177, 179, 181, 183, 186, 188, 190, 
	192, 194, 196, 198, 200, 216, 218, 219, 
	221, 223, 224, 225, 226, 227, 228, 230, 
	231, 232, 233, 234, 235, 236, 237, 238, 
	239, 240, 241, 242, 243, 244, 245, 246, 
	247, 248, 249, 263, 265, 267, 269, 271, 
	273, 275, 277, 279, 281, 283, 285, 287, 
	289, 291, 293, 296, 298, 300, 302, 304, 
	306, 308, 311, 313, 315, 317, 319, 321, 
	323, 325, 327, 330, 332, 334, 336, 338, 
	340, 342, 345, 348, 351, 353, 356, 358, 
	360, 362, 364, 366, 368, 370, 372, 374, 
	376, 378, 380, 382, 384, 386, 388, 390, 
	392, 394, 396, 398, 399, 400, 401, 402, 
	403, 404, 405, 406, 407, 408, 412, 413, 
	415, 416, 417, 418, 419, 420, 421, 422, 
	423, 424, 425, 426, 427, 428, 429, 431, 
	432, 433, 434, 435, 436, 437, 438, 439, 
	440, 448, 450, 452, 454, 456, 458, 460, 
	462, 465, 467, 469, 471, 473, 475, 477, 
	479, 481, 483, 485, 487, 489, 491, 493, 
	495, 497, 499, 501, 503, 505, 506, 507, 
	509, 510, 511, 512, 513, 514, 515, 516, 
	517, 518, 519, 520, 521, 522, 523, 537, 
	539, 541, 543, 545, 547, 549, 551, 553, 
	555, 557, 559, 561, 563, 565, 567, 570, 
	572, 574, 576, 578, 580, 582, 585, 587, 
	589, 591, 593, 595, 597, 599, 601, 604, 
	606, 608, 610, 612, 615, 617, 620, 623, 
	625, 627, 629, 631, 633, 636, 638, 640, 
	642, 644, 646, 648, 650, 652, 654, 656, 
	658, 660, 662, 664, 666, 668, 670, 672, 
	674, 676, 678, 680, 684, 686, 689, 691, 
	693, 695, 697, 699, 701, 703, 705, 707, 
	709, 711, 713, 715, 717, 719, 721, 723, 
	725, 727, 729, 731, 733, 735, 737, 739, 
	741, 743, 745, 747, 749, 751, 753, 754, 
	755, 756, 757, 758, 759, 763, 769, 772, 
	774, 780, 796, 798, 801, 803, 805, 807, 
	809, 813, 815, 817, 819, 821, 823, 825, 
	827, 829, 831, 833, 835, 837, 839, 841, 
	843, 845, 847, 849, 851, 854, 856, 858, 
	860, 862, 864, 866, 868, 870, 872, 874, 
	876, 878, 880, 882, 884, 886, 888, 890, 
	892, 894, 896, 898, 900, 902, 904, 907, 
	909, 911, 913, 915, 917, 919, 921, 923, 
	925, 927, 929, 931, 934, 936, 938, 940, 
	942, 944, 946, 948, 950, 953, 955, 957, 
	959, 961, 963, 965, 967, 969, 971, 973, 
	974, 976, 977, 978, 979, 980, 983, 984, 
	985, 986, 987, 988, 989, 990, 991, 992, 
	1006, 1008, 1010, 1012, 1014, 1016, 1018, 1020, 
	1022, 1024, 1026, 1028, 1030, 1032, 1034, 1036, 
	1040, 1042, 1044, 1046, 1048, 1050, 1052, 1055, 
	1057, 1059, 1061, 1063, 1065, 1067, 1069, 1071, 
	1074, 1076, 1078, 1080, 1082, 1085, 1087, 1089, 
	1091, 1093, 1095, 1097, 1099, 1101, 1103, 1105, 
	1107, 1109, 1111, 1114, 1116, 1119, 1122, 1124, 
	1126, 1128, 1130, 1132, 1135, 1137, 1139, 1141, 
	1143, 1145, 1147, 1149, 1151, 1153, 1155, 1157, 
	1159, 1161, 1163, 1165, 1167, 1169, 1171, 1173, 
	1175, 1177, 1179, 1181, 1183, 1185, 1189, 1191, 
	1194, 1196, 1198, 1200, 1202, 1204, 1206, 1208, 
	1210, 1212, 1214, 1216, 1218, 1220, 1222, 1225, 
	1227, 1229, 1232, 1234, 1236, 1238, 1240, 1242, 
	1244, 1246, 1248, 1250, 1252, 1254, 1256, 1258, 
	1260, 1262, 1264, 1265, 1266, 1267, 1268, 1269
};

static const char _lexer_trans_keys[] = {
	-17, 10, 32, 34, 35, 37, 42, 64, 
	67, 68, 69, 70, 77, 81, 124, 9, 
	13, -69, -65, 10, 32, 34, 35, 37, 
	42, 64, 67, 68, 69, 70, 77, 81, 
	124, 9, 13, 34, 34, 10, 13, 10, 
	13, 10, 32, 34, 9, 13, 10, 32, 
	34, 9, 13, 10, 32, 34, 9, 13, 
	10, 32, 34, 9, 13, 10, 32, 9, 
	13, 10, 32, 9, 13, 10, 13, 10, 
	95, 70, 69, 65, 84, 85, 82, 69, 
	95, 69, 78, 68, 95, 37, 32, 10, 
	13, 10, 13, 13, 32, 64, 9, 10, 
	9, 10, 13, 32, 64, 11, 12, 10, 
	32, 64, 9, 13, 97, 101, 111, 114, 
	97, 99, 116, 101, 114, -61, 105, -83, 
	115, 116, 105, 99, 97, 58, 10, 10, 
	10, 32, 35, 37, 64, 67, 68, 69, 
	70, 9, 13, 10, 95, 10, 70, 10, 
	69, 10, 65, 10, 84, 10, 85, 10, 
	82, 10, 69, 10, 95, 10, 69, 10, 
	78, 10, 68, 10, 95, 10, 37, 10, 
	97, 101, 111, 10, 114, 10, 97, 10, 
	99, 10, 116, 10, 101, 10, 114, -61, 
	10, 105, -83, 10, 10, 115, 10, 116, 
	10, 105, 10, 99, 10, 97, 10, 58, 
	10, 32, 34, 35, 37, 42, 64, 67, 
	68, 69, 70, 77, 81, 124, 9, 13, 
	97, 101, 100, 97, 111, 32, 115, 108, 
	105, 110, 101, 97, -61, 99, -89, -61, 
	-93, 111, 32, 100, 111, 32, 67, 101, 
	110, -61, -95, 114, 105, 111, 58, 10, 
	10, 10, 32, 35, 37, 42, 64, 67, 
	68, 69, 70, 77, 81, 9, 13, 10, 
	95, 10, 70, 10, 69, 10, 65, 10, 
	84, 10, 85, 10, 82, 10, 69, 10, 
	95, 10, 69, 10, 78, 10, 68, 10, 
	95, 10, 37, 10, 32, 10, 97, 101, 
	10, 114, 10, 97, 10, 99, 10, 116, 
	10, 101, 10, 114, -61, 10, 105, -83, 
	10, 10, 115, 10, 116, 10, 105, 10, 
	99, 10, 97, 10, 58, 10, 110, -61, 
	10, 97, -95, 10, 10, 114, 10, 105, 
	10, 111, 10, 97, 10, 100, 10, 97, 
	111, 10, 32, 115, 10, 32, 110, 10, 
	116, -61, 10, 97, -93, 10, 10, 111, 
	10, 117, 10, 110, 10, 99, 10, 105, 
	10, 111, 10, 110, 10, 97, 10, 108, 
	10, 105, 10, 100, 10, 97, 10, 100, 
	10, 101, 10, 97, 10, 115, 10, 117, 
	10, 97, 10, 110, 10, 100, 97, 111, 
	32, 100, 111, 32, 67, 101, 110, 97, 
	32, 110, 115, 120, 116, -61, 97, -93, 
	111, 113, 117, 101, 109, 97, 32, 100, 
	111, 32, 67, 101, 110, -61, 97, 101, 
	109, 112, 108, 111, 115, 58, 10, 10, 
	10, 32, 35, 67, 70, 124, 9, 13, 
	10, 97, 10, 114, 10, 97, 10, 99, 
	10, 116, 10, 101, 10, 114, -61, 10, 
	105, -83, 10, 10, 115, 10, 116, 10, 
	105, 10, 99, 10, 97, 10, 58, 10, 
	117, 10, 110, 10, 99, 10, 105, 10, 
	111, 10, 110, 10, 97, 10, 108, 10, 
	105, 10, 100, 10, 97, 10, 100, 10, 
	101, 117, 110, 99, 100, 105, 111, 110, 
	97, 108, 105, 100, 97, 100, 101, 111, 
	58, 10, 10, 10, 32, 35, 37, 42, 
	64, 67, 68, 69, 70, 77, 81, 9, 
	13, 10, 95, 10, 70, 10, 69, 10, 
	65, 10, 84, 10, 85, 10, 82, 10, 
	69, 10, 95, 10, 69, 10, 78, 10, 
	68, 10, 95, 10, 37, 10, 32, 10, 
	97, 101, 10, 114, 10, 97, 10, 99, 
	10, 116, 10, 101, 10, 114, -61, 10, 
	105, -83, 10, 10, 115, 10, 116, 10, 
	105, 10, 99, 10, 97, 10, 58, 10, 
	110, -61, 10, 97, -95, 10, 10, 114, 
	10, 105, 10, 111, 10, 97, 101, 10, 
	100, 10, 97, 111, 10, 32, 115, 10, 
	108, 10, 105, 10, 110, 10, 101, 10, 
	97, -61, 10, 99, -89, 10, -61, 10, 
	-93, 10, 10, 111, 10, 32, 10, 100, 
	10, 111, 10, 32, 10, 67, 10, 101, 
	10, 110, -61, 10, 10, 97, 10, 111, 
	10, 32, 10, 100, 10, 111, 10, 32, 
	10, 67, 10, 101, 10, 110, 10, 97, 
	10, 32, 110, 115, 10, 116, -61, 10, 
	97, -93, 10, 10, 111, 10, 113, 10, 
	117, 10, 101, 10, 109, 10, 97, 10, 
	32, 10, 100, 10, 111, 10, 32, 10, 
	67, 10, 101, 10, 117, 10, 110, 10, 
	99, 10, 105, 10, 111, 10, 110, 10, 
	97, 10, 108, 10, 105, 10, 100, 10, 
	97, 10, 100, 10, 101, 10, 97, 10, 
	115, 10, 117, 10, 97, 10, 110, 10, 
	100, 97, 115, 117, 97, 110, 100, 32, 
	124, 9, 13, 10, 32, 92, 124, 9, 
	13, 10, 92, 124, 10, 92, 10, 32, 
	92, 124, 9, 13, 10, 32, 34, 35, 
	37, 42, 64, 67, 68, 69, 70, 77, 
	81, 124, 9, 13, 10, 110, -61, 10, 
	97, -95, 10, 10, 114, 10, 105, 10, 
	111, 10, 32, 58, 115, 10, 100, 10, 
	101, 10, 32, 10, 70, 10, 117, 10, 
	110, 10, 100, 10, 111, 10, 110, 10, 
	116, 10, 101, 10, 120, 10, 116, 10, 
	101, 10, 108, 10, 105, 10, 110, 10, 
	101, 10, 97, -61, 10, 99, -89, 10, 
	-61, 10, -93, 10, 10, 111, 10, 32, 
	10, 100, 10, 111, 10, 32, 10, 67, 
	10, 101, 10, 110, -61, 10, -95, 10, 
	10, 114, 10, 105, 10, 97, 10, 111, 
	10, 32, 10, 100, 10, 111, 10, 32, 
	10, 67, 10, 101, 10, 110, 10, 97, 
	10, 115, 120, 10, 113, 10, 117, 10, 
	101, 10, 109, 10, 97, 10, 32, 10, 
	100, 10, 111, 10, 32, 10, 67, 10, 
	101, 10, 110, -61, 10, 97, 10, 101, 
	10, 109, 10, 112, 10, 108, 10, 111, 
	10, 115, 10, 117, 10, 110, 10, 99, 
	100, 10, 105, 10, 111, 10, 110, 10, 
	97, 10, 108, 10, 105, 10, 100, 10, 
	97, 10, 100, 10, 101, 110, -61, 97, 
	-95, 114, 105, 111, 32, 58, 115, 100, 
	101, 32, 70, 117, 110, 100, 10, 10, 
	10, 32, 35, 37, 42, 64, 67, 68, 
	69, 70, 77, 81, 9, 13, 10, 95, 
	10, 70, 10, 69, 10, 65, 10, 84, 
	10, 85, 10, 82, 10, 69, 10, 95, 
	10, 69, 10, 78, 10, 68, 10, 95, 
	10, 37, 10, 32, 10, 97, 101, 111, 
	10, 114, 10, 97, 10, 99, 10, 116, 
	10, 101, 10, 114, -61, 10, 105, -83, 
	10, 10, 115, 10, 116, 10, 105, 10, 
	99, 10, 97, 10, 58, 10, 110, -61, 
	10, 97, -95, 10, 10, 114, 10, 105, 
	10, 111, 10, 32, 58, 10, 100, 10, 
	101, 10, 32, 10, 70, 10, 117, 10, 
	110, 10, 100, 10, 111, 10, 110, 10, 
	116, 10, 101, 10, 120, 10, 116, 10, 
	97, 101, 10, 100, 10, 97, 111, 10, 
	32, 115, 10, 108, 10, 105, 10, 110, 
	10, 101, 10, 97, -61, 10, 99, -89, 
	10, -61, 10, -93, 10, 10, 111, 10, 
	32, 10, 100, 10, 111, 10, 32, 10, 
	67, 10, 101, 10, 110, -61, 10, -95, 
	10, 10, 114, 10, 105, 10, 97, 10, 
	111, 10, 32, 10, 100, 10, 111, 10, 
	32, 10, 67, 10, 101, 10, 110, 10, 
	97, 10, 32, 110, 115, 10, 116, -61, 
	10, 97, -93, 10, 10, 111, 10, 113, 
	10, 117, 10, 101, 10, 109, 10, 97, 
	10, 32, 10, 100, 10, 111, 10, 32, 
	10, 67, 10, 101, 10, 110, -61, 10, 
	97, 10, 117, 10, 110, 10, 99, 100, 
	10, 105, 10, 111, 10, 110, 10, 97, 
	10, 108, 10, 105, 10, 100, 10, 97, 
	10, 100, 10, 101, 10, 97, 10, 115, 
	10, 117, 10, 97, 10, 110, 10, 100, 
	110, 116, 101, 120, 116, 0
};

static const char _lexer_single_lengths[] = {
	0, 15, 1, 1, 14, 1, 1, 2, 
	2, 3, 3, 3, 3, 2, 2, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	2, 2, 3, 5, 3, 3, 1, 1, 
	1, 1, 1, 1, 2, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 9, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 4, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 14, 2, 1, 2, 
	2, 1, 1, 1, 1, 1, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 12, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 3, 3, 3, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 4, 1, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	6, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 1, 1, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 12, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 3, 2, 3, 3, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 4, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 1, 1, 
	1, 1, 1, 1, 2, 4, 3, 2, 
	4, 14, 2, 3, 2, 2, 2, 2, 
	4, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 1, 
	2, 1, 1, 1, 1, 3, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 12, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 4, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 3, 3, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 4, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 1, 1, 1, 1, 1, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 1, 0, 0, 0, 
	0, 1, 1, 1, 1, 1, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 1, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 1, 0, 0, 
	1, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 17, 19, 21, 37, 39, 41, 
	44, 47, 52, 57, 62, 67, 71, 75, 
	78, 80, 82, 84, 86, 88, 90, 92, 
	94, 96, 98, 100, 102, 104, 106, 108, 
	110, 113, 116, 121, 128, 133, 137, 139, 
	141, 143, 145, 147, 149, 152, 154, 156, 
	158, 160, 162, 164, 166, 168, 170, 181, 
	184, 187, 190, 193, 196, 199, 202, 205, 
	208, 211, 214, 217, 220, 223, 228, 231, 
	234, 237, 240, 243, 246, 250, 253, 256, 
	259, 262, 265, 268, 271, 287, 290, 292, 
	295, 298, 300, 302, 304, 306, 308, 311, 
	313, 315, 317, 319, 321, 323, 325, 327, 
	329, 331, 333, 335, 337, 339, 341, 343, 
	345, 347, 349, 363, 366, 369, 372, 375, 
	378, 381, 384, 387, 390, 393, 396, 399, 
	402, 405, 408, 412, 415, 418, 421, 424, 
	427, 430, 434, 437, 440, 443, 446, 449, 
	452, 455, 458, 462, 465, 468, 471, 474, 
	477, 480, 484, 488, 492, 495, 499, 502, 
	505, 508, 511, 514, 517, 520, 523, 526, 
	529, 532, 535, 538, 541, 544, 547, 550, 
	553, 556, 559, 562, 564, 566, 568, 570, 
	572, 574, 576, 578, 580, 582, 587, 589, 
	592, 594, 596, 598, 600, 602, 604, 606, 
	608, 610, 612, 614, 616, 618, 620, 623, 
	625, 627, 629, 631, 633, 635, 637, 639, 
	641, 649, 652, 655, 658, 661, 664, 667, 
	670, 674, 677, 680, 683, 686, 689, 692, 
	695, 698, 701, 704, 707, 710, 713, 716, 
	719, 722, 725, 728, 731, 734, 736, 738, 
	741, 743, 745, 747, 749, 751, 753, 755, 
	757, 759, 761, 763, 765, 767, 769, 783, 
	786, 789, 792, 795, 798, 801, 804, 807, 
	810, 813, 816, 819, 822, 825, 828, 832, 
	835, 838, 841, 844, 847, 850, 854, 857, 
	860, 863, 866, 869, 872, 875, 878, 882, 
	885, 888, 891, 894, 898, 901, 905, 909, 
	912, 915, 918, 921, 924, 928, 931, 934, 
	937, 940, 943, 946, 949, 952, 955, 958, 
	961, 964, 967, 970, 973, 976, 979, 982, 
	985, 988, 991, 994, 999, 1002, 1006, 1009, 
	1012, 1015, 1018, 1021, 1024, 1027, 1030, 1033, 
	1036, 1039, 1042, 1045, 1048, 1051, 1054, 1057, 
	1060, 1063, 1066, 1069, 1072, 1075, 1078, 1081, 
	1084, 1087, 1090, 1093, 1096, 1099, 1102, 1104, 
	1106, 1108, 1110, 1112, 1114, 1118, 1124, 1128, 
	1131, 1137, 1153, 1156, 1160, 1163, 1166, 1169, 
	1172, 1177, 1180, 1183, 1186, 1189, 1192, 1195, 
	1198, 1201, 1204, 1207, 1210, 1213, 1216, 1219, 
	1222, 1225, 1228, 1231, 1234, 1238, 1241, 1244, 
	1247, 1250, 1253, 1256, 1259, 1262, 1265, 1268, 
	1271, 1274, 1277, 1280, 1283, 1286, 1289, 1292, 
	1295, 1298, 1301, 1304, 1307, 1310, 1313, 1317, 
	1320, 1323, 1326, 1329, 1332, 1335, 1338, 1341, 
	1344, 1347, 1350, 1353, 1357, 1360, 1363, 1366, 
	1369, 1372, 1375, 1378, 1381, 1385, 1388, 1391, 
	1394, 1397, 1400, 1403, 1406, 1409, 1412, 1415, 
	1417, 1420, 1422, 1424, 1426, 1428, 1432, 1434, 
	1436, 1438, 1440, 1442, 1444, 1446, 1448, 1450, 
	1464, 1467, 1470, 1473, 1476, 1479, 1482, 1485, 
	1488, 1491, 1494, 1497, 1500, 1503, 1506, 1509, 
	1514, 1517, 1520, 1523, 1526, 1529, 1532, 1536, 
	1539, 1542, 1545, 1548, 1551, 1554, 1557, 1560, 
	1564, 1567, 1570, 1573, 1576, 1580, 1583, 1586, 
	1589, 1592, 1595, 1598, 1601, 1604, 1607, 1610, 
	1613, 1616, 1619, 1623, 1626, 1630, 1634, 1637, 
	1640, 1643, 1646, 1649, 1653, 1656, 1659, 1662, 
	1665, 1668, 1671, 1674, 1677, 1680, 1683, 1686, 
	1689, 1692, 1695, 1698, 1701, 1704, 1707, 1710, 
	1713, 1716, 1719, 1722, 1725, 1728, 1733, 1736, 
	1740, 1743, 1746, 1749, 1752, 1755, 1758, 1761, 
	1764, 1767, 1770, 1773, 1776, 1779, 1782, 1786, 
	1789, 1792, 1796, 1799, 1802, 1805, 1808, 1811, 
	1814, 1817, 1820, 1823, 1826, 1829, 1832, 1835, 
	1838, 1841, 1844, 1846, 1848, 1850, 1852, 1854
};

static const short _lexer_trans_targs[] = {
	2, 4, 4, 5, 15, 17, 31, 34, 
	37, 85, 189, 245, 366, 368, 372, 4, 
	0, 3, 0, 4, 0, 4, 4, 5, 
	15, 17, 31, 34, 37, 85, 189, 245, 
	366, 368, 372, 4, 0, 6, 0, 7, 
	0, 9, 8, 8, 9, 8, 8, 10, 
	10, 11, 10, 10, 10, 10, 11, 10, 
	10, 10, 10, 12, 10, 10, 10, 10, 
	13, 10, 10, 4, 14, 14, 0, 4, 
	14, 14, 0, 4, 16, 15, 4, 0, 
	18, 0, 19, 0, 20, 0, 21, 0, 
	22, 0, 23, 0, 24, 0, 25, 0, 
	26, 0, 27, 0, 28, 0, 29, 0, 
	30, 0, 607, 0, 32, 0, 4, 16, 
	33, 4, 16, 33, 0, 0, 0, 0, 
	35, 36, 4, 36, 36, 34, 35, 35, 
	4, 36, 34, 36, 0, 38, 463, 602, 
	0, 39, 0, 40, 0, 41, 0, 42, 
	0, 43, 0, 44, 0, 45, 46, 0, 
	46, 0, 47, 0, 48, 0, 49, 0, 
	50, 0, 51, 0, 52, 0, 54, 53, 
	54, 53, 54, 54, 4, 55, 4, 69, 
	398, 430, 450, 54, 53, 54, 56, 53, 
	54, 57, 53, 54, 58, 53, 54, 59, 
	53, 54, 60, 53, 54, 61, 53, 54, 
	62, 53, 54, 63, 53, 54, 64, 53, 
	54, 65, 53, 54, 66, 53, 54, 67, 
	53, 54, 68, 53, 54, 4, 53, 54, 
	70, 378, 393, 53, 54, 71, 53, 54, 
	72, 53, 54, 73, 53, 54, 74, 53, 
	54, 75, 53, 54, 76, 53, 77, 54, 
	78, 53, 78, 54, 53, 54, 79, 53, 
	54, 80, 53, 54, 81, 53, 54, 82, 
	53, 54, 83, 53, 54, 84, 53, 4, 
	4, 5, 15, 17, 31, 34, 37, 85, 
	189, 245, 366, 368, 372, 4, 0, 86, 
	89, 0, 87, 0, 88, 88, 0, 32, 
	31, 0, 90, 0, 91, 0, 92, 0, 
	93, 0, 94, 0, 95, 179, 0, 96, 
	0, 97, 0, 98, 0, 99, 0, 100, 
	0, 101, 0, 102, 0, 103, 0, 104, 
	0, 105, 0, 106, 0, 107, 0, 108, 
	0, 109, 0, 110, 0, 111, 0, 112, 
	0, 114, 113, 114, 113, 114, 114, 4, 
	115, 129, 4, 130, 151, 155, 160, 173, 
	175, 114, 113, 114, 116, 113, 114, 117, 
	113, 114, 118, 113, 114, 119, 113, 114, 
	120, 113, 114, 121, 113, 114, 122, 113, 
	114, 123, 113, 114, 124, 113, 114, 125, 
	113, 114, 126, 113, 114, 127, 113, 114, 
	128, 113, 114, 4, 113, 114, 84, 113, 
	114, 131, 145, 113, 114, 132, 113, 114, 
	133, 113, 114, 134, 113, 114, 135, 113, 
	114, 136, 113, 114, 137, 113, 138, 114, 
	139, 113, 139, 114, 113, 114, 140, 113, 
	114, 141, 113, 114, 142, 113, 114, 143, 
	113, 114, 144, 113, 114, 84, 113, 114, 
	146, 113, 147, 114, 148, 113, 148, 114, 
	113, 114, 149, 113, 114, 150, 113, 114, 
	144, 113, 114, 152, 113, 114, 153, 113, 
	114, 154, 154, 113, 114, 84, 129, 113, 
	114, 84, 156, 113, 114, 157, 113, 158, 
	114, 159, 113, 159, 114, 113, 114, 129, 
	113, 114, 161, 113, 114, 162, 113, 114, 
	163, 113, 114, 164, 113, 114, 165, 113, 
	114, 166, 113, 114, 167, 113, 114, 168, 
	113, 114, 169, 113, 114, 170, 113, 114, 
	171, 113, 114, 172, 113, 114, 144, 113, 
	114, 174, 113, 114, 129, 113, 114, 176, 
	113, 114, 177, 113, 114, 178, 113, 114, 
	159, 113, 180, 0, 181, 0, 182, 0, 
	183, 0, 184, 0, 185, 0, 186, 0, 
	187, 0, 188, 0, 108, 0, 32, 190, 
	194, 207, 0, 191, 0, 192, 193, 0, 
	193, 0, 31, 0, 195, 0, 196, 0, 
	197, 0, 198, 0, 199, 0, 200, 0, 
	201, 0, 202, 0, 203, 0, 204, 0, 
	205, 0, 206, 0, 107, 108, 0, 208, 
	0, 209, 0, 210, 0, 211, 0, 212, 
	0, 213, 0, 214, 0, 216, 215, 216, 
	215, 216, 216, 4, 217, 232, 4, 216, 
	215, 216, 218, 215, 216, 219, 215, 216, 
	220, 215, 216, 221, 215, 216, 222, 215, 
	216, 223, 215, 216, 224, 215, 225, 216, 
	226, 215, 226, 216, 215, 216, 227, 215, 
	216, 228, 215, 216, 229, 215, 216, 230, 
	215, 216, 231, 215, 216, 84, 215, 216, 
	233, 215, 216, 234, 215, 216, 235, 215, 
	216, 236, 215, 216, 237, 215, 216, 238, 
	215, 216, 239, 215, 216, 240, 215, 216, 
	241, 215, 216, 242, 215, 216, 243, 215, 
	216, 244, 215, 216, 231, 215, 246, 0, 
	247, 0, 248, 258, 0, 249, 0, 250, 
	0, 251, 0, 252, 0, 253, 0, 254, 
	0, 255, 0, 256, 0, 257, 0, 51, 
	0, 259, 0, 260, 0, 262, 261, 262, 
	261, 262, 262, 4, 263, 277, 4, 278, 
	299, 331, 347, 360, 362, 262, 261, 262, 
	264, 261, 262, 265, 261, 262, 266, 261, 
	262, 267, 261, 262, 268, 261, 262, 269, 
	261, 262, 270, 261, 262, 271, 261, 262, 
	272, 261, 262, 273, 261, 262, 274, 261, 
	262, 275, 261, 262, 276, 261, 262, 4, 
	261, 262, 84, 261, 262, 279, 293, 261, 
	262, 280, 261, 262, 281, 261, 262, 282, 
	261, 262, 283, 261, 262, 284, 261, 262, 
	285, 261, 286, 262, 287, 261, 287, 262, 
	261, 262, 288, 261, 262, 289, 261, 262, 
	290, 261, 262, 291, 261, 262, 292, 261, 
	262, 84, 261, 262, 294, 261, 295, 262, 
	296, 261, 296, 262, 261, 262, 297, 261, 
	262, 298, 261, 262, 292, 261, 262, 300, 
	303, 261, 262, 301, 261, 262, 302, 302, 
	261, 262, 84, 277, 261, 262, 304, 261, 
	262, 305, 261, 262, 306, 261, 262, 307, 
	261, 262, 308, 261, 309, 262, 321, 261, 
	310, 262, 261, 311, 262, 261, 312, 262, 
	261, 262, 313, 261, 262, 314, 261, 262, 
	315, 261, 262, 316, 261, 262, 317, 261, 
	262, 318, 261, 262, 319, 261, 262, 320, 
	261, 295, 262, 261, 262, 322, 261, 262, 
	323, 261, 262, 324, 261, 262, 325, 261, 
	262, 326, 261, 262, 327, 261, 262, 328, 
	261, 262, 329, 261, 262, 330, 261, 262, 
	296, 261, 262, 84, 332, 336, 261, 262, 
	333, 261, 334, 262, 335, 261, 335, 262, 
	261, 262, 277, 261, 262, 337, 261, 262, 
	338, 261, 262, 339, 261, 262, 340, 261, 
	262, 341, 261, 262, 342, 261, 262, 343, 
	261, 262, 344, 261, 262, 345, 261, 262, 
	346, 261, 262, 293, 261, 262, 348, 261, 
	262, 349, 261, 262, 350, 261, 262, 351, 
	261, 262, 352, 261, 262, 353, 261, 262, 
	354, 261, 262, 355, 261, 262, 356, 261, 
	262, 357, 261, 262, 358, 261, 262, 359, 
	261, 262, 292, 261, 262, 361, 261, 262, 
	277, 261, 262, 363, 261, 262, 364, 261, 
	262, 365, 261, 262, 335, 261, 367, 0, 
	31, 0, 369, 0, 370, 0, 371, 0, 
	193, 0, 372, 373, 372, 0, 377, 376, 
	375, 373, 376, 374, 0, 375, 373, 374, 
	0, 375, 374, 377, 376, 375, 373, 376, 
	374, 377, 377, 5, 15, 17, 31, 34, 
	37, 85, 189, 245, 366, 368, 372, 377, 
	0, 54, 379, 53, 380, 54, 381, 53, 
	381, 54, 53, 54, 382, 53, 54, 383, 
	53, 54, 384, 53, 54, 385, 84, 83, 
	53, 54, 386, 53, 54, 387, 53, 54, 
	388, 53, 54, 389, 53, 54, 390, 53, 
	54, 391, 53, 54, 392, 53, 54, 83, 
	53, 54, 394, 53, 54, 395, 53, 54, 
	396, 53, 54, 397, 53, 54, 392, 53, 
	54, 399, 53, 54, 400, 53, 54, 401, 
	53, 54, 402, 53, 54, 403, 53, 54, 
	404, 53, 405, 54, 420, 53, 406, 54, 
	53, 407, 54, 53, 408, 54, 53, 54, 
	409, 53, 54, 410, 53, 54, 411, 53, 
	54, 412, 53, 54, 413, 53, 54, 414, 
	53, 54, 415, 53, 54, 416, 53, 417, 
	54, 53, 418, 54, 53, 54, 419, 53, 
	54, 392, 53, 54, 421, 53, 54, 422, 
	53, 54, 423, 53, 54, 424, 53, 54, 
	425, 53, 54, 426, 53, 54, 427, 53, 
	54, 428, 53, 54, 429, 53, 54, 418, 
	53, 54, 431, 444, 53, 54, 432, 53, 
	54, 433, 53, 54, 434, 53, 54, 435, 
	53, 54, 436, 53, 54, 437, 53, 54, 
	438, 53, 54, 439, 53, 54, 440, 53, 
	54, 441, 53, 54, 442, 53, 54, 443, 
	53, 417, 54, 418, 53, 54, 445, 53, 
	54, 446, 53, 54, 447, 53, 54, 448, 
	53, 54, 449, 53, 54, 83, 53, 54, 
	451, 53, 54, 452, 53, 54, 453, 392, 
	53, 54, 454, 53, 54, 455, 53, 54, 
	456, 53, 54, 457, 53, 54, 458, 53, 
	54, 459, 53, 54, 460, 53, 54, 461, 
	53, 54, 462, 53, 54, 83, 53, 464, 
	0, 465, 466, 0, 466, 0, 467, 0, 
	468, 0, 469, 0, 470, 477, 213, 0, 
	471, 0, 472, 0, 473, 0, 474, 0, 
	475, 0, 476, 0, 258, 0, 479, 478, 
	479, 478, 479, 479, 4, 480, 494, 4, 
	495, 530, 565, 583, 596, 598, 479, 478, 
	479, 481, 478, 479, 482, 478, 479, 483, 
	478, 479, 484, 478, 479, 485, 478, 479, 
	486, 478, 479, 487, 478, 479, 488, 478, 
	479, 489, 478, 479, 490, 478, 479, 491, 
	478, 479, 492, 478, 479, 493, 478, 479, 
	4, 478, 479, 84, 478, 479, 496, 510, 
	525, 478, 479, 497, 478, 479, 498, 478, 
	479, 499, 478, 479, 500, 478, 479, 501, 
	478, 479, 502, 478, 503, 479, 504, 478, 
	504, 479, 478, 479, 505, 478, 479, 506, 
	478, 479, 507, 478, 479, 508, 478, 479, 
	509, 478, 479, 84, 478, 479, 511, 478, 
	512, 479, 513, 478, 513, 479, 478, 479, 
	514, 478, 479, 515, 478, 479, 516, 478, 
	479, 517, 84, 478, 479, 518, 478, 479, 
	519, 478, 479, 520, 478, 479, 521, 478, 
	479, 522, 478, 479, 523, 478, 479, 524, 
	478, 479, 509, 478, 479, 526, 478, 479, 
	527, 478, 479, 528, 478, 479, 529, 478, 
	479, 524, 478, 479, 531, 534, 478, 479, 
	532, 478, 479, 533, 533, 478, 479, 84, 
	494, 478, 479, 535, 478, 479, 536, 478, 
	479, 537, 478, 479, 538, 478, 479, 539, 
	478, 540, 479, 555, 478, 541, 479, 478, 
	542, 479, 478, 543, 479, 478, 479, 544, 
	478, 479, 545, 478, 479, 546, 478, 479, 
	547, 478, 479, 548, 478, 479, 549, 478, 
	479, 550, 478, 479, 551, 478, 552, 479, 
	478, 553, 479, 478, 479, 554, 478, 479, 
	524, 478, 479, 556, 478, 479, 557, 478, 
	479, 558, 478, 479, 559, 478, 479, 560, 
	478, 479, 561, 478, 479, 562, 478, 479, 
	563, 478, 479, 564, 478, 479, 553, 478, 
	479, 84, 566, 570, 478, 479, 567, 478, 
	568, 479, 569, 478, 569, 479, 478, 479, 
	494, 478, 479, 571, 478, 479, 572, 478, 
	479, 573, 478, 479, 574, 478, 479, 575, 
	478, 479, 576, 478, 479, 577, 478, 479, 
	578, 478, 479, 579, 478, 479, 580, 478, 
	479, 581, 478, 479, 582, 478, 552, 479, 
	553, 478, 479, 584, 478, 479, 585, 478, 
	479, 586, 524, 478, 479, 587, 478, 479, 
	588, 478, 479, 589, 478, 479, 590, 478, 
	479, 591, 478, 479, 592, 478, 479, 593, 
	478, 479, 594, 478, 479, 595, 478, 479, 
	509, 478, 479, 597, 478, 479, 494, 478, 
	479, 599, 478, 479, 600, 478, 479, 601, 
	478, 479, 569, 478, 603, 0, 604, 0, 
	605, 0, 606, 0, 258, 0, 0, 0
};

static const unsigned char _lexer_trans_actions[] = {
	0, 54, 0, 5, 1, 0, 29, 1, 
	29, 29, 29, 29, 29, 29, 35, 0, 
	43, 0, 43, 0, 43, 54, 0, 5, 
	1, 0, 29, 1, 29, 29, 29, 29, 
	29, 29, 35, 0, 43, 0, 43, 0, 
	43, 139, 48, 9, 106, 11, 0, 134, 
	45, 45, 45, 3, 122, 33, 33, 33, 
	0, 122, 33, 33, 33, 0, 122, 33, 
	0, 33, 0, 102, 7, 7, 43, 54, 
	0, 0, 43, 114, 25, 0, 54, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 149, 126, 
	57, 110, 23, 0, 43, 43, 43, 43, 
	0, 27, 118, 27, 27, 51, 27, 0, 
	54, 0, 1, 0, 43, 0, 0, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 144, 57, 
	54, 0, 54, 0, 69, 33, 69, 84, 
	84, 84, 84, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 13, 0, 54, 
	0, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 13, 0, 130, 
	31, 60, 57, 31, 63, 57, 63, 63, 
	63, 63, 63, 63, 66, 31, 43, 0, 
	0, 43, 0, 43, 0, 0, 43, 0, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 144, 57, 54, 0, 54, 0, 78, 
	33, 84, 78, 84, 84, 84, 84, 84, 
	84, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 19, 0, 54, 19, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 19, 0, 54, 
	0, 0, 0, 54, 0, 0, 0, 54, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 19, 0, 0, 
	54, 19, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 0, 54, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 0, 
	0, 0, 43, 0, 43, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 144, 57, 54, 
	0, 54, 0, 81, 84, 84, 81, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 21, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 43, 
	0, 43, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 144, 57, 54, 
	0, 54, 0, 72, 33, 84, 72, 84, 
	84, 84, 84, 84, 84, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 15, 
	0, 54, 15, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 0, 54, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 15, 0, 54, 0, 0, 0, 54, 
	0, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 15, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 15, 0, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 0, 54, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 0, 0, 43, 54, 37, 
	37, 87, 37, 37, 43, 0, 39, 0, 
	43, 0, 0, 54, 0, 0, 39, 0, 
	0, 54, 0, 93, 90, 41, 96, 90, 
	96, 96, 96, 96, 96, 96, 99, 0, 
	43, 54, 0, 0, 0, 54, 0, 0, 
	0, 54, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 13, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	43, 0, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 144, 57, 
	54, 0, 54, 0, 75, 33, 84, 75, 
	84, 84, 84, 84, 84, 84, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	17, 0, 54, 17, 0, 54, 0, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	0, 54, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 17, 0, 54, 0, 0, 
	0, 54, 0, 0, 0, 54, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 17, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 17, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 17, 0, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 0, 54, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 0
};

static const unsigned char _lexer_eof_actions[] = {
	0, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43
};

static const int lexer_start = 1;
static const int lexer_first_final = 607;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 258 "ragel/i18n/pt.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  /* Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters */
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}
static void 
store_docstring_content(VALUE listener, 
          int start_col, 
          const char *type_at, size_t type_length,
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);
  VALUE con_type = ENCODED_STR_NEW(type_at, type_length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con_type, rb_intern("strip!"), 0);
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 3, con_type, con, INT2FIX(current_line));
}
static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->docstring_content_type_start = 0;
  lexer->docstring_content_type_end = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1315 "ext/gherkin_lexer_pt/gherkin_lexer_pt.c"
	{
	cs = lexer_start;
	}

#line 425 "ragel/i18n/pt.c.rl"
    
#line 1322 "ext/gherkin_lexer_pt/gherkin_lexer_pt.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 83 "ragel/i18n/pt.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 89 "ragel/i18n/pt.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 93 "ragel/i18n/pt.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 98 "ragel/i18n/pt.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));
    int type_len = LEN(docstring_content_type_start, PTR_TO(docstring_content_type_end));

    if (len < 0) len = 0;
    if (type_len < 0) len = 0;

    store_docstring_content(listener, lexer->start_col, PTR_TO(docstring_content_type_start), type_len, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "ragel/i18n/pt.c.rl"
	{ 
    MARK(docstring_content_type_start, p);
  }
	break;
	case 5:
#line 112 "ragel/i18n/pt.c.rl"
	{ 
    MARK(docstring_content_type_end, p);
  }
	break;
	case 6:
#line 116 "ragel/i18n/pt.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 7:
#line 120 "ragel/i18n/pt.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 8:
#line 124 "ragel/i18n/pt.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 9:
#line 128 "ragel/i18n/pt.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 10:
#line 132 "ragel/i18n/pt.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 11:
#line 136 "ragel/i18n/pt.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 12:
#line 143 "ragel/i18n/pt.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 13:
#line 148 "ragel/i18n/pt.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 14:
#line 153 "ragel/i18n/pt.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 15:
#line 158 "ragel/i18n/pt.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 16:
#line 162 "ragel/i18n/pt.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 17:
#line 168 "ragel/i18n/pt.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 18:
#line 175 "ragel/i18n/pt.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 19:
#line 179 "ragel/i18n/pt.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 20:
#line 185 "ragel/i18n/pt.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 21:
#line 189 "ragel/i18n/pt.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 22:
#line 203 "ragel/i18n/pt.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 23:
#line 207 "ragel/i18n/pt.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1612 "ext/gherkin_lexer_pt/gherkin_lexer_pt.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 23:
#line 207 "ragel/i18n/pt.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1675 "ext/gherkin_lexer_pt/gherkin_lexer_pt.c"
		}
	}
	}

	_out: {}
	}

#line 426 "ragel/i18n/pt.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    /* Reset lexer by re-initializing the whole thing */
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_pt()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Pt", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

