### WARNING: This file is auto-generated by our OpenAPI spec. Do not
### edit it manually.

require_relative '../../resource_includes/response_helper'

module Asana
  module Resources
    class TasksBase < Resource

      def self.inherited(base)
        Registry.register(base)
      end

      class << self
        # Set dependencies for a task
        #
        # task_gid - [str]  (required) The task to operate on.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to POST
        def add_dependencies_for_task(client, task_gid: required("task_gid"), options: {}, **data)
          path = "/tasks/{task_gid}/addDependencies"
          path["{task_gid}"] = task_gid
          parse(client.post(path, body: data, options: options)).first
        end

        # Set dependents for a task
        #
        # task_gid - [str]  (required) The task to operate on.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to POST
        def add_dependents_for_task(client, task_gid: required("task_gid"), options: {}, **data)
          path = "/tasks/{task_gid}/addDependents"
          path["{task_gid}"] = task_gid
          Collection.new(parse(client.post(path, body: data, options: options)), type: Task, client: client)
        end

        # Add followers to a task
        #
        # task_gid - [str]  (required) The task to operate on.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to POST
        def add_followers_for_task(client, task_gid: required("task_gid"), options: {}, **data)
          path = "/tasks/{task_gid}/addFollowers"
          path["{task_gid}"] = task_gid
          parse(client.post(path, body: data, options: options)).first
        end

        # Add a project to a task
        #
        # task_gid - [str]  (required) The task to operate on.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to POST
        def add_project_for_task(client, task_gid: required("task_gid"), options: {}, **data)
          path = "/tasks/{task_gid}/addProject"
          path["{task_gid}"] = task_gid
          parse(client.post(path, body: data, options: options)).first
        end

        # Add a tag to a task
        #
        # task_gid - [str]  (required) The task to operate on.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to POST
        def add_tag_for_task(client, task_gid: required("task_gid"), options: {}, **data)
          path = "/tasks/{task_gid}/addTag"
          path["{task_gid}"] = task_gid
          parse(client.post(path, body: data, options: options)).first
        end

        # Create a subtask
        #
        # task_gid - [str]  (required) The task to operate on.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to POST
        def create_subtask_for_task(client, task_gid: required("task_gid"), options: {}, **data)
          path = "/tasks/{task_gid}/subtasks"
          path["{task_gid}"] = task_gid
          Task.new(parse(client.post(path, body: data, options: options)).first, client: client)
        end

        # Create a task
        #

        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to POST
        def create_task(client, options: {}, **data)
          path = "/tasks"
          Task.new(parse(client.post(path, body: data, options: options)).first, client: client)
        end

        # Delete a task
        #
        # task_gid - [str]  (required) The task to operate on.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        def delete_task(client, task_gid: required("task_gid"), options: {})
          path = "/tasks/{task_gid}"
          path["{task_gid}"] = task_gid
          parse(client.delete(path, options: options)).first
        end

        # Duplicate a task
        #
        # task_gid - [str]  (required) The task to operate on.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to POST
        def duplicate_task(client, task_gid: required("task_gid"), options: {}, **data)
          path = "/tasks/{task_gid}/duplicate"
          path["{task_gid}"] = task_gid
          Job.new(parse(client.post(path, body: data, options: options)).first, client: client)
        end

        # Get dependencies from a task
        #
        # task_gid - [str]  (required) The task to operate on.
        # options - [Hash] the request I/O options
        # > offset - [str]  Offset token. An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results. 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
        # > limit - [int]  Results per page. The number of objects to return per page. The value must be between 1 and 100.
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        def get_dependencies_for_task(client, task_gid: required("task_gid"), options: {})
          path = "/tasks/{task_gid}/dependencies"
          path["{task_gid}"] = task_gid
          Collection.new(parse(client.get(path, options: options)), type: Task, client: client)
        end

        # Get dependents from a task
        #
        # task_gid - [str]  (required) The task to operate on.
        # options - [Hash] the request I/O options
        # > offset - [str]  Offset token. An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results. 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
        # > limit - [int]  Results per page. The number of objects to return per page. The value must be between 1 and 100.
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        def get_dependents_for_task(client, task_gid: required("task_gid"), options: {})
          path = "/tasks/{task_gid}/dependents"
          path["{task_gid}"] = task_gid
          Collection.new(parse(client.get(path, options: options)), type: Task, client: client)
        end

        # Get subtasks from a task
        #
        # task_gid - [str]  (required) The task to operate on.
        # options - [Hash] the request I/O options
        # > offset - [str]  Offset token. An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results. 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
        # > limit - [int]  Results per page. The number of objects to return per page. The value must be between 1 and 100.
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        def get_subtasks_for_task(client, task_gid: required("task_gid"), options: {})
          path = "/tasks/{task_gid}/subtasks"
          path["{task_gid}"] = task_gid
          Collection.new(parse(client.get(path, options: options)), type: Task, client: client)
        end

        # Get a task
        #
        # task_gid - [str]  (required) The task to operate on.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        def get_task(client, task_gid: required("task_gid"), options: {})
          path = "/tasks/{task_gid}"
          path["{task_gid}"] = task_gid
          Task.new(parse(client.get(path, options: options)).first, client: client)
        end

        # Get multiple tasks
        #

        # assignee - [str]  The assignee to filter tasks on. *Note: If you specify `assignee`, you must also specify the `workspace` to filter on.*
        # project - [str]  The project to filter tasks on.
        # section - [str]  The section to filter tasks on. *Note: Currently, this is only supported in board views.*
        # workspace - [str]  The workspace to filter tasks on. *Note: If you specify `workspace`, you must also specify the `assignee` to filter on.*
        # completed_since - [datetime]  Only return tasks that are either incomplete or that have been completed since this time.
        # modified_since - [datetime]  Only return tasks that have been modified since the given time.  *Note: A task is considered “modified” if any of its properties change, or associations between it and other objects are modified (e.g.  a task being added to a project). A task is not considered modified just because another object it is associated with (e.g. a subtask) is modified. Actions that count as modifying the task include assigning, renaming, completing, and adding stories.*
        # options - [Hash] the request I/O options
        # > offset - [str]  Offset token. An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results. 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
        # > limit - [int]  Results per page. The number of objects to return per page. The value must be between 1 and 100.
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        def get_tasks(client, assignee: nil, project: nil, section: nil, workspace: nil, completed_since: nil, modified_since: nil, options: {})
          path = "/tasks"
          params = { assignee: assignee, project: project, section: section, workspace: workspace, completed_since: completed_since, modified_since: modified_since }.reject { |_,v| v.nil? || Array(v).empty? }
          Collection.new(parse(client.get(path, params: params, options: options)), type: Task, client: client)
        end

        # Get tasks from a project
        #
        # project_gid - [str]  (required) Globally unique identifier for the project.
        # options - [Hash] the request I/O options
        # > offset - [str]  Offset token. An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results. 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
        # > limit - [int]  Results per page. The number of objects to return per page. The value must be between 1 and 100.
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        def get_tasks_for_project(client, project_gid: required("project_gid"), options: {})
          path = "/projects/{project_gid}/tasks"
          path["{project_gid}"] = project_gid
          Collection.new(parse(client.get(path, options: options)), type: Task, client: client)
        end

        # Get tasks from a section
        #
        # section_gid - [str]  (required) The globally unique identifier for the section.
        # options - [Hash] the request I/O options
        # > offset - [str]  Offset token. An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results. 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
        # > limit - [int]  Results per page. The number of objects to return per page. The value must be between 1 and 100.
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        def get_tasks_for_section(client, section_gid: required("section_gid"), options: {})
          path = "/sections/{section_gid}/tasks"
          path["{section_gid}"] = section_gid
          Collection.new(parse(client.get(path, options: options)), type: Task, client: client)
        end

        # Get tasks from a tag
        #
        # tag_gid - [str]  (required) Globally unique identifier for the tag.
        # options - [Hash] the request I/O options
        # > offset - [str]  Offset token. An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results. 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
        # > limit - [int]  Results per page. The number of objects to return per page. The value must be between 1 and 100.
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        def get_tasks_for_tag(client, tag_gid: required("tag_gid"), options: {})
          path = "/tags/{tag_gid}/tasks"
          path["{tag_gid}"] = tag_gid
          Collection.new(parse(client.get(path, options: options)), type: Task, client: client)
        end

        # Get tasks from a user task list
        #
        # user_task_list_gid - [str]  (required) Globally unique identifier for the user task list.
        # completed_since - [str]  Only return tasks that are either incomplete or that have been completed since this time. Accepts a date-time string or the keyword *now*. 
        # options - [Hash] the request I/O options
        # > offset - [str]  Offset token. An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results. 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
        # > limit - [int]  Results per page. The number of objects to return per page. The value must be between 1 and 100.
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        def get_tasks_for_user_task_list(client, user_task_list_gid: required("user_task_list_gid"), completed_since: nil, options: {})
          path = "/user_task_lists/{user_task_list_gid}/tasks"
          path["{user_task_list_gid}"] = user_task_list_gid
          params = { completed_since: completed_since }.reject { |_,v| v.nil? || Array(v).empty? }
          Collection.new(parse(client.get(path, params: params, options: options)), type: Task, client: client)
        end

        # Unlink dependencies from a task
        #
        # task_gid - [str]  (required) The task to operate on.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to POST
        def remove_dependencies_for_task(client, task_gid: required("task_gid"), options: {}, **data)
          path = "/tasks/{task_gid}/removeDependencies"
          path["{task_gid}"] = task_gid
          Collection.new(parse(client.post(path, body: data, options: options)), type: Resource, client: client)
        end

        # Unlink dependents from a task
        #
        # task_gid - [str]  (required) The task to operate on.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to POST
        def remove_dependents_for_task(client, task_gid: required("task_gid"), options: {}, **data)
          path = "/tasks/{task_gid}/removeDependents"
          path["{task_gid}"] = task_gid
          Collection.new(parse(client.post(path, body: data, options: options)), type: Resource, client: client)
        end

        # Remove followers from a task
        #
        # task_gid - [str]  (required) The task to operate on.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to POST
        def remove_follower_for_task(client, task_gid: required("task_gid"), options: {}, **data)
          path = "/tasks/{task_gid}/removeFollowers"
          path["{task_gid}"] = task_gid
          parse(client.post(path, body: data, options: options)).first
        end

        # Remove a project from a task
        #
        # task_gid - [str]  (required) The task to operate on.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to POST
        def remove_project_for_task(client, task_gid: required("task_gid"), options: {}, **data)
          path = "/tasks/{task_gid}/removeProject"
          path["{task_gid}"] = task_gid
          parse(client.post(path, body: data, options: options)).first
        end

        # Remove a tag from a task
        #
        # task_gid - [str]  (required) The task to operate on.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to POST
        def remove_tag_for_task(client, task_gid: required("task_gid"), options: {}, **data)
          path = "/tasks/{task_gid}/removeTag"
          path["{task_gid}"] = task_gid
          parse(client.post(path, body: data, options: options)).first
        end

        # Search tasks in a workspace
        #
        # workspace_gid - [str]  (required) Globally unique identifier for the workspace or organization.
        # text - [str]  Performs full-text search on both task name and description
        # resource_subtype - [str]  Filters results by the task's resource_subtype
        # assignee_any - [str]  Comma-separated list of user identifiers
        # assignee_not - [str]  Comma-separated list of user identifiers
        # assignee_status - [str]  One of `inbox`, `today`, `upcoming`, or `later`
        # portfolios_any - [str]  Comma-separated list of portfolio IDs
        # projects_any - [str]  Comma-separated list of project IDs
        # projects_not - [str]  Comma-separated list of project IDs
        # projects_all - [str]  Comma-separated list of project IDs
        # sections_any - [str]  Comma-separated list of section or column IDs
        # sections_not - [str]  Comma-separated list of section or column IDs
        # sections_all - [str]  Comma-separated list of section or column IDs
        # tags_any - [str]  Comma-separated list of tag IDs
        # tags_not - [str]  Comma-separated list of tag IDs
        # tags_all - [str]  Comma-separated list of tag IDs
        # teams_any - [str]  Comma-separated list of team IDs
        # followers_any - [str]  Comma-separated list of user identifiers
        # followers_not - [str]  Comma-separated list of user identifiers
        # created_by_any - [str]  Comma-separated list of user identifiers
        # created_by_not - [str]  Comma-separated list of user identifiers
        # assigned_by_any - [str]  Comma-separated list of user identifiers
        # assigned_by_not - [str]  Comma-separated list of user identifiers
        # liked_by_any - [str]  Comma-separated list of user identifiers
        # liked_by_not - [str]  Comma-separated list of user identifiers
        # commented_on_by_any - [str]  Comma-separated list of user identifiers
        # commented_on_by_not - [str]  Comma-separated list of user identifiers
        # due_on_before - [date]  ISO 8601 date string
        # due_on_after - [date]  ISO 8601 date string
        # due_on - [date]  ISO 8601 date string or `null`
        # due_at_before - [datetime]  ISO 8601 datetime string
        # due_at_after - [datetime]  ISO 8601 datetime string
        # start_on_before - [date]  ISO 8601 date string
        # start_on_after - [date]  ISO 8601 date string
        # start_on - [date]  ISO 8601 date string or `null`
        # created_on_before - [date]  ISO 8601 date string
        # created_on_after - [date]  ISO 8601 date string
        # created_on - [date]  ISO 8601 date string or `null`
        # created_at_before - [datetime]  ISO 8601 datetime string
        # created_at_after - [datetime]  ISO 8601 datetime string
        # completed_on_before - [date]  ISO 8601 date string
        # completed_on_after - [date]  ISO 8601 date string
        # completed_on - [date]  ISO 8601 date string or `null`
        # completed_at_before - [datetime]  ISO 8601 datetime string
        # completed_at_after - [datetime]  ISO 8601 datetime string
        # modified_on_before - [date]  ISO 8601 date string
        # modified_on_after - [date]  ISO 8601 date string
        # modified_on - [date]  ISO 8601 date string or `null`
        # modified_at_before - [datetime]  ISO 8601 datetime string
        # modified_at_after - [datetime]  ISO 8601 datetime string
        # is_blocking - [bool]  Filter to incomplete tasks with dependents
        # is_blocked - [bool]  Filter to tasks with incomplete dependencies
        # has_attachment - [bool]  Filter to tasks with attachments
        # completed - [bool]  Filter to completed tasks
        # is_subtask - [bool]  Filter to subtasks
        # sort_by - [str]  One of `due_date`, `created_at`, `completed_at`, `likes`, or `modified_at`, defaults to `modified_at`
        # sort_ascending - [bool]  Default `false`
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        def search_tasks_for_workspace(client, workspace_gid: required("workspace_gid"), text: nil, resource_subtype: nil, assignee_any: nil, assignee_not: nil, assignee_status: nil, portfolios_any: nil, projects_any: nil, projects_not: nil, projects_all: nil, sections_any: nil, sections_not: nil, sections_all: nil, tags_any: nil, tags_not: nil, tags_all: nil, teams_any: nil, followers_any: nil, followers_not: nil, created_by_any: nil, created_by_not: nil, assigned_by_any: nil, assigned_by_not: nil, liked_by_any: nil, liked_by_not: nil, commented_on_by_any: nil, commented_on_by_not: nil, due_on_before: nil, due_on_after: nil, due_on: nil, due_at_before: nil, due_at_after: nil, start_on_before: nil, start_on_after: nil, start_on: nil, created_on_before: nil, created_on_after: nil, created_on: nil, created_at_before: nil, created_at_after: nil, completed_on_before: nil, completed_on_after: nil, completed_on: nil, completed_at_before: nil, completed_at_after: nil, modified_on_before: nil, modified_on_after: nil, modified_on: nil, modified_at_before: nil, modified_at_after: nil, is_blocking: nil, is_blocked: nil, has_attachment: nil, completed: nil, is_subtask: nil, sort_by: nil, sort_ascending: nil, options: {})
          path = "/workspaces/{workspace_gid}/tasks/search"
          path["{workspace_gid}"] = workspace_gid
          params = { text: text, resource_subtype: resource_subtype, "assignee.any": assignee_any, "assignee.not": assignee_not, assignee_status: assignee_status, "portfolios.any": portfolios_any, "projects.any": projects_any, "projects.not": projects_not, "projects.all": projects_all, "sections.any": sections_any, "sections.not": sections_not, "sections.all": sections_all, "tags.any": tags_any, "tags.not": tags_not, "tags.all": tags_all, "teams.any": teams_any, "followers.any": followers_any, "followers.not": followers_not, "created_by.any": created_by_any, "created_by.not": created_by_not, "assigned_by.any": assigned_by_any, "assigned_by.not": assigned_by_not, "liked_by.any": liked_by_any, "liked_by.not": liked_by_not, "commented_on_by.any": commented_on_by_any, "commented_on_by.not": commented_on_by_not, due_on_before: due_on_before, due_on_after: due_on_after, due_on: due_on, due_at_before: due_at_before, due_at_after: due_at_after, start_on_before: start_on_before, start_on_after: start_on_after, start_on: start_on, created_on_before: created_on_before, created_on_after: created_on_after, created_on: created_on, created_at_before: created_at_before, created_at_after: created_at_after, completed_on_before: completed_on_before, completed_on_after: completed_on_after, completed_on: completed_on, completed_at_before: completed_at_before, completed_at_after: completed_at_after, modified_on_before: modified_on_before, modified_on_after: modified_on_after, modified_on: modified_on, modified_at_before: modified_at_before, modified_at_after: modified_at_after, is_blocking: is_blocking, is_blocked: is_blocked, has_attachment: has_attachment, completed: completed, is_subtask: is_subtask, sort_by: sort_by, sort_ascending: sort_ascending }.reject { |_,v| v.nil? || Array(v).empty? }
          Collection.new(parse(client.get(path, params: params, options: options)), type: Task, client: client)
        end

        # Set the parent of a task
        #
        # task_gid - [str]  (required) The task to operate on.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to POST
        def set_parent_for_task(client, task_gid: required("task_gid"), options: {}, **data)
          path = "/tasks/{task_gid}/setParent"
          path["{task_gid}"] = task_gid
          Task.new(parse(client.post(path, body: data, options: options)).first, client: client)
        end

        # Update a task
        #
        # task_gid - [str]  (required) The task to operate on.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to PUT
        def update_task(client, task_gid: required("task_gid"), options: {}, **data)
          path = "/tasks/{task_gid}"
          path["{task_gid}"] = task_gid
          Task.new(parse(client.put(path, body: data, options: options)).first, client: client)
        end

      end
    end
  end
end
