import { Arr } from '@ephox/katamari';

import { DieFn, NextFn } from '../pipe/Pipe';
import { Step } from './Step';
import { TestLogs } from './TestLogs';

export const compose = <A, B, C> (sab: Step<A, B>, sbc: Step<B, C>): Step<A, C> =>
  // don't Pipe them - assume that the base actions have already been piped
  ({
    runStep: (a: A, next: NextFn<C>, die: DieFn, logs: TestLogs): void =>
      sab.runStep(a, (b: B, blogs) => sbc.runStep(b, next, die, blogs), die, logs)
  });

/*
Code partly generated in GHCi:

:m + Data.List
:m + Control.Monad
putStrLn $ intercalate " |\n" $ (\n -> (\x -> "[" ++ x ++ ", Step<A" ++ (show n) ++ ", T>]") $ intercalate ", " $ (\m -> "Step<A" ++ (show m) ++ ", A" ++ (show (m + 1)) ++ ">") <$> [1..n-1]) <$> [1..100]
 */
/* eslint-disable max-len */
export const sequence =
  <A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31, A32, A33, A34, A35, A36, A37, A38, A39, A40, A41, A42, A43, A44, A45, A46, A47, A48, A49, A50, A51, A52, A53, A54, A55, A56, A57, A58, A59, A60, A61, A62, A63, A64, A65, A66, A67, A68, A69, A70, A71, A72, A73, A74, A75, A76, A77, A78, A79, A80, A81, A82, A83, A84, A85, A86, A87, A88, A89, A90, A91, A92, A93, A94, A95, A96, A97, A98, A99, A100, T>
  (steps:
  [] |
  [Step<A1, T>] |
  [Step<A1, A2>, Step<A2, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, A71>, Step<A71, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, A71>, Step<A71, A72>, Step<A72, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, A71>, Step<A71, A72>, Step<A72, A73>, Step<A73, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, A71>, Step<A71, A72>, Step<A72, A73>, Step<A73, A74>, Step<A74, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, A71>, Step<A71, A72>, Step<A72, A73>, Step<A73, A74>, Step<A74, A75>, Step<A75, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, A71>, Step<A71, A72>, Step<A72, A73>, Step<A73, A74>, Step<A74, A75>, Step<A75, A76>, Step<A76, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, A71>, Step<A71, A72>, Step<A72, A73>, Step<A73, A74>, Step<A74, A75>, Step<A75, A76>, Step<A76, A77>, Step<A77, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, A71>, Step<A71, A72>, Step<A72, A73>, Step<A73, A74>, Step<A74, A75>, Step<A75, A76>, Step<A76, A77>, Step<A77, A78>, Step<A78, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, A71>, Step<A71, A72>, Step<A72, A73>, Step<A73, A74>, Step<A74, A75>, Step<A75, A76>, Step<A76, A77>, Step<A77, A78>, Step<A78, A79>, Step<A79, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, A71>, Step<A71, A72>, Step<A72, A73>, Step<A73, A74>, Step<A74, A75>, Step<A75, A76>, Step<A76, A77>, Step<A77, A78>, Step<A78, A79>, Step<A79, A80>, Step<A80, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, A71>, Step<A71, A72>, Step<A72, A73>, Step<A73, A74>, Step<A74, A75>, Step<A75, A76>, Step<A76, A77>, Step<A77, A78>, Step<A78, A79>, Step<A79, A80>, Step<A80, A81>, Step<A81, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, A71>, Step<A71, A72>, Step<A72, A73>, Step<A73, A74>, Step<A74, A75>, Step<A75, A76>, Step<A76, A77>, Step<A77, A78>, Step<A78, A79>, Step<A79, A80>, Step<A80, A81>, Step<A81, A82>, Step<A82, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, A71>, Step<A71, A72>, Step<A72, A73>, Step<A73, A74>, Step<A74, A75>, Step<A75, A76>, Step<A76, A77>, Step<A77, A78>, Step<A78, A79>, Step<A79, A80>, Step<A80, A81>, Step<A81, A82>, Step<A82, A83>, Step<A83, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, A71>, Step<A71, A72>, Step<A72, A73>, Step<A73, A74>, Step<A74, A75>, Step<A75, A76>, Step<A76, A77>, Step<A77, A78>, Step<A78, A79>, Step<A79, A80>, Step<A80, A81>, Step<A81, A82>, Step<A82, A83>, Step<A83, A84>, Step<A84, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, A71>, Step<A71, A72>, Step<A72, A73>, Step<A73, A74>, Step<A74, A75>, Step<A75, A76>, Step<A76, A77>, Step<A77, A78>, Step<A78, A79>, Step<A79, A80>, Step<A80, A81>, Step<A81, A82>, Step<A82, A83>, Step<A83, A84>, Step<A84, A85>, Step<A85, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, A71>, Step<A71, A72>, Step<A72, A73>, Step<A73, A74>, Step<A74, A75>, Step<A75, A76>, Step<A76, A77>, Step<A77, A78>, Step<A78, A79>, Step<A79, A80>, Step<A80, A81>, Step<A81, A82>, Step<A82, A83>, Step<A83, A84>, Step<A84, A85>, Step<A85, A86>, Step<A86, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, A71>, Step<A71, A72>, Step<A72, A73>, Step<A73, A74>, Step<A74, A75>, Step<A75, A76>, Step<A76, A77>, Step<A77, A78>, Step<A78, A79>, Step<A79, A80>, Step<A80, A81>, Step<A81, A82>, Step<A82, A83>, Step<A83, A84>, Step<A84, A85>, Step<A85, A86>, Step<A86, A87>, Step<A87, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, A71>, Step<A71, A72>, Step<A72, A73>, Step<A73, A74>, Step<A74, A75>, Step<A75, A76>, Step<A76, A77>, Step<A77, A78>, Step<A78, A79>, Step<A79, A80>, Step<A80, A81>, Step<A81, A82>, Step<A82, A83>, Step<A83, A84>, Step<A84, A85>, Step<A85, A86>, Step<A86, A87>, Step<A87, A88>, Step<A88, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, A71>, Step<A71, A72>, Step<A72, A73>, Step<A73, A74>, Step<A74, A75>, Step<A75, A76>, Step<A76, A77>, Step<A77, A78>, Step<A78, A79>, Step<A79, A80>, Step<A80, A81>, Step<A81, A82>, Step<A82, A83>, Step<A83, A84>, Step<A84, A85>, Step<A85, A86>, Step<A86, A87>, Step<A87, A88>, Step<A88, A89>, Step<A89, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, A71>, Step<A71, A72>, Step<A72, A73>, Step<A73, A74>, Step<A74, A75>, Step<A75, A76>, Step<A76, A77>, Step<A77, A78>, Step<A78, A79>, Step<A79, A80>, Step<A80, A81>, Step<A81, A82>, Step<A82, A83>, Step<A83, A84>, Step<A84, A85>, Step<A85, A86>, Step<A86, A87>, Step<A87, A88>, Step<A88, A89>, Step<A89, A90>, Step<A90, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, A71>, Step<A71, A72>, Step<A72, A73>, Step<A73, A74>, Step<A74, A75>, Step<A75, A76>, Step<A76, A77>, Step<A77, A78>, Step<A78, A79>, Step<A79, A80>, Step<A80, A81>, Step<A81, A82>, Step<A82, A83>, Step<A83, A84>, Step<A84, A85>, Step<A85, A86>, Step<A86, A87>, Step<A87, A88>, Step<A88, A89>, Step<A89, A90>, Step<A90, A91>, Step<A91, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, A71>, Step<A71, A72>, Step<A72, A73>, Step<A73, A74>, Step<A74, A75>, Step<A75, A76>, Step<A76, A77>, Step<A77, A78>, Step<A78, A79>, Step<A79, A80>, Step<A80, A81>, Step<A81, A82>, Step<A82, A83>, Step<A83, A84>, Step<A84, A85>, Step<A85, A86>, Step<A86, A87>, Step<A87, A88>, Step<A88, A89>, Step<A89, A90>, Step<A90, A91>, Step<A91, A92>, Step<A92, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, A71>, Step<A71, A72>, Step<A72, A73>, Step<A73, A74>, Step<A74, A75>, Step<A75, A76>, Step<A76, A77>, Step<A77, A78>, Step<A78, A79>, Step<A79, A80>, Step<A80, A81>, Step<A81, A82>, Step<A82, A83>, Step<A83, A84>, Step<A84, A85>, Step<A85, A86>, Step<A86, A87>, Step<A87, A88>, Step<A88, A89>, Step<A89, A90>, Step<A90, A91>, Step<A91, A92>, Step<A92, A93>, Step<A93, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, A71>, Step<A71, A72>, Step<A72, A73>, Step<A73, A74>, Step<A74, A75>, Step<A75, A76>, Step<A76, A77>, Step<A77, A78>, Step<A78, A79>, Step<A79, A80>, Step<A80, A81>, Step<A81, A82>, Step<A82, A83>, Step<A83, A84>, Step<A84, A85>, Step<A85, A86>, Step<A86, A87>, Step<A87, A88>, Step<A88, A89>, Step<A89, A90>, Step<A90, A91>, Step<A91, A92>, Step<A92, A93>, Step<A93, A94>, Step<A94, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, A71>, Step<A71, A72>, Step<A72, A73>, Step<A73, A74>, Step<A74, A75>, Step<A75, A76>, Step<A76, A77>, Step<A77, A78>, Step<A78, A79>, Step<A79, A80>, Step<A80, A81>, Step<A81, A82>, Step<A82, A83>, Step<A83, A84>, Step<A84, A85>, Step<A85, A86>, Step<A86, A87>, Step<A87, A88>, Step<A88, A89>, Step<A89, A90>, Step<A90, A91>, Step<A91, A92>, Step<A92, A93>, Step<A93, A94>, Step<A94, A95>, Step<A95, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, A71>, Step<A71, A72>, Step<A72, A73>, Step<A73, A74>, Step<A74, A75>, Step<A75, A76>, Step<A76, A77>, Step<A77, A78>, Step<A78, A79>, Step<A79, A80>, Step<A80, A81>, Step<A81, A82>, Step<A82, A83>, Step<A83, A84>, Step<A84, A85>, Step<A85, A86>, Step<A86, A87>, Step<A87, A88>, Step<A88, A89>, Step<A89, A90>, Step<A90, A91>, Step<A91, A92>, Step<A92, A93>, Step<A93, A94>, Step<A94, A95>, Step<A95, A96>, Step<A96, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, A71>, Step<A71, A72>, Step<A72, A73>, Step<A73, A74>, Step<A74, A75>, Step<A75, A76>, Step<A76, A77>, Step<A77, A78>, Step<A78, A79>, Step<A79, A80>, Step<A80, A81>, Step<A81, A82>, Step<A82, A83>, Step<A83, A84>, Step<A84, A85>, Step<A85, A86>, Step<A86, A87>, Step<A87, A88>, Step<A88, A89>, Step<A89, A90>, Step<A90, A91>, Step<A91, A92>, Step<A92, A93>, Step<A93, A94>, Step<A94, A95>, Step<A95, A96>, Step<A96, A97>, Step<A97, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, A71>, Step<A71, A72>, Step<A72, A73>, Step<A73, A74>, Step<A74, A75>, Step<A75, A76>, Step<A76, A77>, Step<A77, A78>, Step<A78, A79>, Step<A79, A80>, Step<A80, A81>, Step<A81, A82>, Step<A82, A83>, Step<A83, A84>, Step<A84, A85>, Step<A85, A86>, Step<A86, A87>, Step<A87, A88>, Step<A88, A89>, Step<A89, A90>, Step<A90, A91>, Step<A91, A92>, Step<A92, A93>, Step<A93, A94>, Step<A94, A95>, Step<A95, A96>, Step<A96, A97>, Step<A97, A98>, Step<A98, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, A71>, Step<A71, A72>, Step<A72, A73>, Step<A73, A74>, Step<A74, A75>, Step<A75, A76>, Step<A76, A77>, Step<A77, A78>, Step<A78, A79>, Step<A79, A80>, Step<A80, A81>, Step<A81, A82>, Step<A82, A83>, Step<A83, A84>, Step<A84, A85>, Step<A85, A86>, Step<A86, A87>, Step<A87, A88>, Step<A88, A89>, Step<A89, A90>, Step<A90, A91>, Step<A91, A92>, Step<A92, A93>, Step<A93, A94>, Step<A94, A95>, Step<A95, A96>, Step<A96, A97>, Step<A97, A98>, Step<A98, A99>, Step<A99, T>] |
  [Step<A1, A2>, Step<A2, A3>, Step<A3, A4>, Step<A4, A5>, Step<A5, A6>, Step<A6, A7>, Step<A7, A8>, Step<A8, A9>, Step<A9, A10>, Step<A10, A11>, Step<A11, A12>, Step<A12, A13>, Step<A13, A14>, Step<A14, A15>, Step<A15, A16>, Step<A16, A17>, Step<A17, A18>, Step<A18, A19>, Step<A19, A20>, Step<A20, A21>, Step<A21, A22>, Step<A22, A23>, Step<A23, A24>, Step<A24, A25>, Step<A25, A26>, Step<A26, A27>, Step<A27, A28>, Step<A28, A29>, Step<A29, A30>, Step<A30, A31>, Step<A31, A32>, Step<A32, A33>, Step<A33, A34>, Step<A34, A35>, Step<A35, A36>, Step<A36, A37>, Step<A37, A38>, Step<A38, A39>, Step<A39, A40>, Step<A40, A41>, Step<A41, A42>, Step<A42, A43>, Step<A43, A44>, Step<A44, A45>, Step<A45, A46>, Step<A46, A47>, Step<A47, A48>, Step<A48, A49>, Step<A49, A50>, Step<A50, A51>, Step<A51, A52>, Step<A52, A53>, Step<A53, A54>, Step<A54, A55>, Step<A55, A56>, Step<A56, A57>, Step<A57, A58>, Step<A58, A59>, Step<A59, A60>, Step<A60, A61>, Step<A61, A62>, Step<A62, A63>, Step<A63, A64>, Step<A64, A65>, Step<A65, A66>, Step<A66, A67>, Step<A67, A68>, Step<A68, A69>, Step<A69, A70>, Step<A70, A71>, Step<A71, A72>, Step<A72, A73>, Step<A73, A74>, Step<A74, A75>, Step<A75, A76>, Step<A76, A77>, Step<A77, A78>, Step<A78, A79>, Step<A79, A80>, Step<A80, A81>, Step<A81, A82>, Step<A82, A83>, Step<A83, A84>, Step<A84, A85>, Step<A85, A86>, Step<A86, A87>, Step<A87, A88>, Step<A88, A89>, Step<A89, A90>, Step<A90, A91>, Step<A91, A92>, Step<A92, A93>, Step<A93, A94>, Step<A94, A95>, Step<A95, A96>, Step<A96, A97>, Step<A97, A98>, Step<A98, A99>, Step<A99, A100>, Step<A100, T>]
  ): Step<A1, T> => {
    const s = steps as Step<any, any>[];
    return sequenceUnsafe(s);
  };
/* eslint-enable max-len */

export const sequenceSame = <T> (steps: Step<T, T>[]): Step<T, T> =>
  sequenceUnsafe(steps);

export const sequenceUnsafe = (steps: Step<any, any>[]): Step<any, any> =>
  steps.length === 0 ? Step.pass : Arr.foldl(steps, (acc, step) => compose(acc, step), Step.pass);
