#!/usr/bin/perl
# generates variable listings for DSSSL and XSL stylesheets
# usage: vargen.pl [-d] [-x] > outfile
# -d creates DSSSL output (default), -x creates XSLT output


# this list holds all reference types, plus the in-text citation types
my @types = ("INTEXT", "INTEXTSQ", "AUTHORONLY", "AUTHORONLYSQ", "YEARONLY", "ABST", "ADVS", "ART", "BILL", "BOOK", "CASE", "CHAP", "COMP", "CONF", "CTLG", "DATA", "ELEC", "GEN", "HEAR", "ICOMM", "INPR", "JFULL", "JOUR", "MAP", "MGZN", "MPCT", "MUSIC", "NEWS", "PAMP", "PAT", "PCOMM", "RPRT", "SER", "SLIDE", "SOUND", "STAT", "THES", "UNBILL", "UNPB", "VIDEO");

# this list holds all citation/reference part styles
my @styles = ("ALLALISTSTYLE", "AUTHORLISTSTYLE", "EDITORLISTSTYLE", "SEDITORLISTSTYLE", "ALLALISTALTERNATESTYLE", "AUTHORLISTALTERNATESTYLE", "EDITORLISTALTERNATESTYLE", "SEDITORLISTALTERNATESTYLE", "ALLALISTAUTHORNAMESNAMEFIRSTINITIALSTYLE", "AUTHORLISTAUTHORNAMESNAMEFIRSTINITIALSTYLE", "EDITORLISTAUTHORNAMESNAMEFIRSTINITIALSTYLE", "SEDITORLISTAUTHORNAMESNAMEFIRSTINITIALSTYLE", "ALLALISTAUTHORNAMESNAMEOTHERINITIALSTYLE", "AUTHORLISTAUTHORNAMESNAMEOTHERINITIALSTYLE", "EDITORLISTAUTHORNAMESNAMEOTHERINITIALSTYLE", "SEDITORLISTAUTHORNAMESNAMEOTHERINITIALSTYLE", "PUBDATESTYLE", "PUBDATESECSTYLE", "PUBDATEALLSTYLE", "TITLESTYLE", "BOOKTITLESTYLE", "SERIESTITLESTYLE", "ALLTITLESTYLE", "JOURNALNAMESTYLE", "VOLUMESTYLE", "ISSUESTYLE", "PAGESSTYLE", "PUBLISHERSTYLE", "PUBPLACESTYLE", "SERIALSTYLE", "ADDRESSSTYLE", "URLSTYLE", "USERDEF1STYLE", "USERDEF2STYLE", "USERDEF3STYLE", "USERDEF4STYLE", "USERDEF5STYLE", "TYPEOFWORKSTYLE", "AREASTYLE", "OSTYPESTYLE", "DEGREESTYLE","RUNNINGTIMESTYLE", "CLASSCODEINTLSTYLE", "CLASSCODEUSSTYLE", "SENDEREMAILSTYLE", "RECIPIENTEMAILSTYLE",  "MEDIATYPESTYLE", "NUMVOLUMESSTYLE", "EDITIONSTYLE", "COMPUTERSTYLE", "CONFERENCELOCATIONSTYLE", "REGISTRYNUMSTYLE", "CLASSIFICATIONSTYLE", "SECTIONSTYLE", "PAMPHLETNUMSTYLE", "CHAPTERNUMSTYLE", "NOTESSTYLE", "ABSTRACTSTYLE", "LINK1STYLE", "LINK2STYLE", "LINK3STYLE", "LINK4STYLE", "REFNUMBERSTYLE", "PAGESPAGERANGESTYLE", "ALLALISTABBREVIATEFIRSTSTYLE", "ALLALISTABBREVIATESUBSEQSTYLE", "AUTHORLISTABBREVIATEFIRSTSTYLE", "EDITORLISTABBREVIATEFIRSTSTYLE", "SEDITORLISTABBREVIATEFIRSTSTYLE", "AUTHORLISTABBREVIATESUBSEQSTYLE", "EDITORLISTABBREVIATESUBSEQSTYLE", "SEDITORLISTABBREVIATESUBSEQSTYLE");


# see whether we shall create a DSSSL (default) or an XSLT file
my $sheet = "dsl";

foreach $arg (@ARGV) {
    if ($arg eq "-d") {
	$sheet = "dsl";
    }
    elsif ($arg eq "-x") {
	$sheet = "xsl";
    }
}

# DSSSL output
if ($sheet eq "dsl") {
    print ";;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n;; refdb-specific variables for DSSSL stylesheets\n\n;; This file is created by the vargen.pl script. If anything is wrong, don't edit this file, fix the script instead\n\n";

    foreach $type_item (@types) {
	foreach $style_item (@styles) {
	    print "(define $type_item$style_item \"none\")\n";
	}
	print "\n";
    }

    print "\n;; need this list to access the command-line variables with a\n;; string holding the name\n\n(define refdb-styleparams\n  (list\n";

    foreach $type_item (@types) {
	foreach $style_item (@styles) {
	    print "   (cons \'$type_item$style_item $type_item$style_item)\n";
	}
	print "\n";
    }

    print "))\n";
}

# XSLT output
else {
    print "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n                version=\"1.0\">\n\n<!-- This file is created by the vargen.pl script. If anything is wrong, don't edit this file, fix the script instead -->\n\n";

    print "<xsl:variable name=\"REFNUMBERSTYLE\">NONE</xsl:variable>\n\n";

    foreach $type_item (@types) {
	foreach $style_item (@styles) {
	    print "<xsl:variable name=\"$type_item$style_item\">NONE</xsl:variable>\n";
	}
	print "\n";
    }
    print "</xsl:stylesheet>\n";
}

