% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compilerCheck.R
\name{compilerCheck}
\alias{compilerCheck}
\title{Check for Minimal (g++) Compiler Version}
\usage{
compilerCheck(minVersion = package_version("4.6.0"))
}
\arguments{
\item{minVersion}{An object of type \code{package_version}, with a default
of version 4.6.0}
}
\value{
A boolean value is returned, indicating if the minimal version is
 being met
}
\description{
Helper function to establish minimal compiler versions, currently limited
only to \code{g++} which (particularly for older RHEL/CentOS releases) is
too far behind current C++11 standards required for some packages.
}
\details{
This function looks up \code{g++} (as well as optional values in the
\code{CXX} and \code{CXX1X} environment variables) in the \code{PATH}.  For
all values found, the output of \code{g++ -v} is analyzed for the version
string, which is then compared to the given minimal version.
}
\author{
Dirk Eddelbuettel
}

