# Announce: Rakudo compiler, Release #148 (2021.07)

On behalf of the Rakudo development team, I’m very happy to announce the
July 2021 release of Rakudo #148. Rakudo is an implementation of
the Raku[^1] language.

The source tarball for this release is available from
<https://rakudo.org/files/rakudo>.
Pre-compiled archives will be available shortly.

New in 2021.07:

  + Additions:
    + Make `cmp` routine work properly on `Iterator`, `Seq`, `Uni`, native arrays and empty `List`s
      [efb3116a][f3ff0621][76714ca4][39ba8884]
    + Add the `ACCEPTS(Uni)` method on `Uni` candidate [6b6459f3]
    + Implement `last` and `next` with a value for `6.e` language revision
      [402ea056][2542a0ac][a5d81353][0761d4b2][47ebc86c][a2faac4b]
      [e777fc4f][4f190875][21576423]
    + Properly support nearly all HTML5 entities in Pod `E<>` formatting code [910179d7]
    + Allow `Ctrl-C` to stop entry in REPL  [cf7b4f18]
    + Add `⩶` and `⩵` as Unicode synonyms for `===` and `==` [eab780f3]
  + Deprecations:
    + Deprecate the `status` method on `Proc` in place of `exitcode` and `signal` methods
      [249fdba2][2fd458cc]
  + Build System:
    + Tidy and improve cleanup rules [e771bd8a]
    + Support creating an MSI installer [4e93b84e]
  + Changes:
    + Allow `add` method on `IO::Path` to take multiple values (e.g. `"foo".IO.add(<bar baz>)`) [b4d33982]
  + Efficiency:
    + Optimize calls to `map` [a8f144cc][38626c68]
    + Optimize loops without phasers for one and two arguments case [265888ce]
    + Make for / map with 2+ arguments up to 2x as fast [4c417f31][4f5fb9e6][bfa6b295]
    + Make `List cmp List` about 25% faster [50bd1717]
    + Reduce overhead of loops with phasers by at least 5% [5ecc8308][7a1b729b]
    + Make the `grep(Callable)` method about 3% faster [52ffc125][bb09bbb8][71f6bada]
  + Fixes:
    + Fix `rakuw.exe` to be a non-console app [57885f66]
    + Fix CURI probing and installation edge case issue on Windows [2839cef6][d668d992]
    + Clean up sockets created by `IO::Socket::INET.new` on error [bee5c7af][271f17b0]
    + Fix freezes caused by concurrently produced iterators
      [8eae05b9][2d396ae7][6e66c2e5][24b0df8a]
    + Fix `unimatch` for non-base properties [0a1256af]
  + Internal:
    + Implement support for `moar::hllincludes` config variable [a96bfdc2][552f2810]
    + Fix binary release `set-env.*` scripts with space in path [a4a46e3c]
    + `Rakudo::Iterator::UnendingValue` no longer a `PredictiveIterator` [917d674b]
    + Separate `Rakudo::Iterator::IntRange` into two classes [03aef65c]
    + `PredictiveIterator` provides own `push-until-lazy` [7cf3927d]
    + Various internal fixes and improvements
      [5976e30e][bdc5092f][1bd0411c][f2959ad5][ddc7c9ff][9c69b7d5]
      [941349d0][eae82f09][2efe4302][7f5f60e8][22f78f4e][9bf1e1c2]


The following people contributed to this release:

Elizabeth Mattijsen, Vadim Belman, Will "Coke" Coleda, Oleksandr Kyriukhin,
Stefan Seifert, Daniel Green, Patrick Böker, raydiak, Juan Julián Merelo Guervós,
Michal Bozon, Michael Ruigrok, Ben Davies, Christian Bartolomäus,
Daniel Sockwell, Patrick Spek, Stoned Elipot, Jimmy Zhuo, Mustafa Aydın,
Nguyễn Gia Phong, Nicholas Clark, Nick Logan, jubilatious1

This release implements 6.c and 6.d versions of the Raku specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2021 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

If you would like to contribute or get more information, visit
<https://raku.org>, <https://rakudo.org/community>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #raku on Libera.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Raku development: <https://donate.perlfoundation.org/>
(put “Raku Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#149), is tentatively scheduled for 2021-07-23.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <https://raku.org/>
