#ifndef STAN_LANG_GENERATOR_GENERATE_VERSION_COMMENT_HPP
#define STAN_LANG_GENERATOR_GENERATE_VERSION_COMMENT_HPP

#include <stan/version.hpp>
#include <stan/lang/ast.hpp>
#include <stan/lang/generator/constants.hpp>
#include <ostream>

namespace stan {
namespace lang {

/**
 * Generate a comment indicating which version of Stan generated
 * the model code to the specified stream.
 *
 * @param[in,out] o stream for generating
 */
void generate_version_comment(std::ostream& o) {
  o << "// Code generated by Stan version " << stan::MAJOR_VERSION << "."
    << stan::MINOR_VERSION << "." << stan::PATCH_VERSION << EOL2;
}

}  // namespace lang
}  // namespace stan
#endif
