% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{transactions}
\alias{dbBegin,SQLiteConnection-method}
\alias{dbCommit,SQLiteConnection-method}
\alias{dbRollback,SQLiteConnection-method}
\alias{transactions}
\title{SQLite transaction management.}
\usage{
\S4method{dbBegin}{SQLiteConnection}(conn, name = NULL)

\S4method{dbCommit}{SQLiteConnection}(conn, name = NULL)

\S4method{dbRollback}{SQLiteConnection}(conn, name = NULL)
}
\arguments{
\item{conn}{a \code{\linkS4class{SQLiteConnection}} object, produced by
\code{\link[DBI]{dbConnect}}}

\item{name}{Supply a name to use a named savepoint. This allows you to
nest multiple transaction}
}
\value{
A boolean, indicating success or failure.
}
\description{
By default, SQLite is in auto-commit mode. \code{dbBegin} starts
a SQLite transaction and turns auto-commit off. \code{dbCommit} and
\code{dbRollback} commit and rollback the transaction, respectively and turn
auto-commit on.
}
\examples{
con <- dbConnect(SQLite(), ":memory:")
dbWriteTable(con, "arrests", datasets::USArrests)
dbGetQuery(con, "select count(*) from arrests")

dbBegin(con)
rs <- dbSendQuery(con, "DELETE from arrests WHERE Murder > 1")
dbGetRowsAffected(rs)
dbClearResult(rs)

dbGetQuery(con, "select count(*) from arrests")

dbRollback(con)
dbGetQuery(con, "select count(*) from arrests")[1, ]

dbBegin(con)
rs <- dbSendQuery(con, "DELETE FROM arrests WHERE Murder > 5")
dbClearResult(rs)
dbCommit(con)
dbGetQuery(con, "SELECT count(*) FROM arrests")[1, ]

# Named savepoints can be nested --------------------------------------------
dbBegin(con, "a")
dbBegin(con, "b")
dbRollback(con, "b")
dbCommit(con, "a")

dbDisconnect(con)
}

